package jwst.DAD.Scanning;

import robocode.*;
import robocode.util.Utils;

import jwst.Enemies.*;
import jwst.DAD.utils.*;

/***************************************************************************************************
 * This scanner's main purpose is to utilize the fact that the most that a robot can move in a
 * turn is PI/4 radians. That is to say, the greatest angle that they could have moved was 
 * 45 degrees.
 * 
 * @author Jared Wong
 * @author Shawn Thomas
 * @period Period 2
 * @date June 10th, 2009
 * 
 * Credit: http://robowiki.net/w/index.php?title=Radar#Technical_Information
 * Credit: Dookious v1.58. Used for 1v1
 ***************************************************************************************************/
public class Scanner 
{
    
    //max angle radar can turn in a click
    private static final double MaxTurnAngle = Math.PI / 4;
    
    private AdvancedRobot robot;
    
    /**
     * a constructor where you pass the advanced robot to use the scanner
     * @param robot - pass the AdvancedRobot which uses this scanner
     */
    public Scanner(robocode.AdvancedRobot robot)
    {
        this.robot = robot;
    }
    
    /**
     * this is the initial run of the scanner
     */
    public void run()
    {
        if(robot.getRadarTurnRemainingRadians() == 0.0)
            robot.setTurnRadarRightRadians(MaxTurnAngle);
    }

    /**
     * given a ScannedRobotEvent this method "lock" locks onto the target passed
     * @param e - ScannedRobotEvent to be passed to this method
     */
    public void lock(ScannedRobotEvent e)
    {
        //finds amount past the scanned robot the radar is
        double radarBearingOffset = 
            Utils.normalRelativeAngle(robot.getRadarHeadingRadians() - 
                (e.getBearingRadians() + robot.getHeadingRadians()));
        
        robot.setTurnRadarLeftRadians(radarBearingOffset +
            //the turn is past the scanned robot and pi/8 more
            //the pi/8 more allows the radar to be at its biggest angle
            //without loss of speed/ticks/turns due the fact that
            //a radar may only turn pi/4 per tick/turn in one direction
            //no more. no less.
            (DADUtils.sign(radarBearingOffset) * (MaxTurnAngle / 2)));
    }
}
