package apv;

import java.awt.geom.Point2D;
import java.util.Vector;
import robocode.util.*;
import robocode.*;

/**
 * MyClass - a class by (your name here)
 */
public class MovSim {
	
	private double systemMaxTurnRate = Math.toRadians(10.0);
	private double systemMaxVelocity = 8.0;
	private double maxBraking = 2.0;
	private double maxAcceleration = 1.0;
	
	private Vector bullets = new Vector();
	private Vector shots = new Vector();
	private double lastBearing = 0;
	
	public double defaultMaxTurnRate = 10.0;
	public double defaultMaxVelocity = 8.0;
	
	public boolean goodmovement = true;
	public MovSimStat[] futureMovement = null;
	
	public MovSim() {};
		
	public void initialize() { bullets.clear(); goodmovement = true;  futureMovement = null; }
	
	public MovSimStat[] futurePos(int steps, AdvancedRobot b) { return futurePos(steps, b, defaultMaxVelocity, defaultMaxTurnRate); }
		
	public MovSimStat[] futurePos(int steps, AdvancedRobot b, double maxVel, double maxTurnRate) {
		return futurePos(steps, b.getX(), b.getY(), b.getVelocity(), maxVel, b.getHeadingRadians(), b.getDistanceRemaining(), b.getTurnRemainingRadians(), maxTurnRate, b.getBattleFieldWidth(), b.getBattleFieldHeight());
	}
	
	public void addBullets(double time, double ex, double ey, double x, double y, double power) {
		//remove bullets
		int i=0; 
		while (i<bullets.size()) {
			MovSimStat p = (MovSimStat) bullets.get(i); 
			//if (p.currX(time) < 0 || p.currY(time) < 0 || p.currX(time) > 1000 || p.currY(time) > 1000) 
			if (Point2D.distance(p.x,p.y,p.currX(time),p.currY(time)) > Point2D.distance(p.x,p.y,x,y)) bullets.remove(i); else i++; 
		} 
		//add new bullets
		//direct shot
		bullets.add(new MovSimStat(ex,ey,20-3*power,Math.atan2(x-ex,y-ey)+lastBearing,0,time));
		//bullets.add(new MovSimStat(ex,ey,20-3*power,Math.atan2(x-ex,y-ey)-lastBearing,0,time));
		
		//other shots
	}
	
	public double checkMovement(double time, int steps, AdvancedRobot b, double nextX, double nextY, boolean update) {
		//find the movement parameters
		double dir = 1; 
		double lastMove = 0; 
		double bestA = 0;
		if ((lastMove=Math.atan(Math.tan((bestA=normalRelativeAngle(Math.atan2(nextX-b.getX(),nextY-b.getY()) - b.getHeadingRadians()))))) != bestA) {
				dir = -1.0; bestA = lastMove;
		}	
		double bestD = dir * Point2D.distance(nextX,nextY,b.getX(),b.getY()); 
		//bestA has the turn angle, bestD has the distance remaining
		//build the future movement
		MovSimStat[] fm = futurePos(steps, b.getX(), b.getY(), b.getVelocity(), defaultMaxVelocity, b.getHeadingRadians(), bestD, bestA, defaultMaxTurnRate, b.getBattleFieldWidth(), b.getBattleFieldHeight());
		//check for collisions
		double damage = checkForCollitions(fm,time,steps);
		if (update) {
			if (damage > 0) goodmovement = false; else goodmovement = true;
			futureMovement = fm;
		}
		return damage;
	}
	
	public void onHitByBullet(AdvancedRobot bot) {
		MovSimStat bb = null;
		double lowd = Double.POSITIVE_INFINITY;
		for(int i= 0; i<bullets.size(); i++) {
			MovSimStat b = (MovSimStat) bullets.get(i);
			if (Point2D.distance(b.currX(bot.getTime()),b.currY(bot.getTime()),bot.getX(),bot.getY()) < lowd) {
				lowd = Point2D.distance(b.currX(bot.getTime()),b.currY(bot.getTime()),bot.getX(),bot.getY());
				bb = b;
			}
		}
		if (bb != null)  {
			double realangle = Math.atan2(bot.getX()-bb.x,bot.getY()-bb.y);
			lastBearing = 0.7 * lastBearing + 0.3 * Math.abs(normalRelativeAngle(realangle-bb.h));
		}
		
		
	}
	
	private MovSimStat[] futurePos(int steps, double x, double y, double velocity, double maxVelocity, double heading, double distanceRemaining, double angleToTurn, double maxTurnRate, double battleFieldW, double battleFieldH) {
		//maxTurnRate in degrees
		MovSimStat[] pos = new MovSimStat[steps];
		double acceleration = 0;
		boolean slowingDown = false;
		double moveDirection;
	
		maxTurnRate = Math.toRadians(maxTurnRate);
		if (distanceRemaining == 0) moveDirection = 0; else if (distanceRemaining < 0.0) moveDirection = -1; else moveDirection = 1;
		
		//heading, accel, velocity, distance
		for (int i=0; i<steps; i++) {
			//heading
			double lastHeading = heading;
			double turnRate = Math.min(maxTurnRate, ((0.4 + 0.6 * (1.0 - (Math.abs(velocity) / systemMaxVelocity))) * systemMaxTurnRate));
			if (angleToTurn > 0.0) {
	    		if (angleToTurn < turnRate) { heading += angleToTurn; angleToTurn = 0.0; } 
				else { heading += turnRate; angleToTurn -= turnRate; }
			} else if (angleToTurn < 0.0) {
	    		if (angleToTurn > -turnRate) { heading += angleToTurn; angleToTurn = 0.0; } 
				else { heading -= turnRate;	angleToTurn += turnRate; }
			}
			heading = Utils.normalAbsoluteAngle(heading);
			//movement
			if (distanceRemaining != 0.0 || velocity != 0.0) { 
				//lastX = x; lastY = y;
				if (!slowingDown && moveDirection == 0) {
					slowingDown = true;
					if (velocity > 0.0) moveDirection = 1;
					else if (velocity < 0.0) moveDirection = -1;
					else moveDirection = 0;
			    }
			    double desiredDistanceRemaining = distanceRemaining;
	    		if (slowingDown) {
					if (moveDirection == 1 && distanceRemaining < 0.0) desiredDistanceRemaining = 0.0;
					else if (moveDirection == -1 && distanceRemaining > 1.0) desiredDistanceRemaining = 0.0;
			    }
	    		double slowDownVelocity	= (double) (int) (maxBraking / 2.0 * ((Math.sqrt(4.0 * Math.abs(desiredDistanceRemaining)+ 1.0)) - 1.0));
		    	if (moveDirection == -1) slowDownVelocity = -slowDownVelocity;
		    	if (!slowingDown) {
					if (moveDirection == 1) {
		    			if (velocity < 0.0) acceleration = maxBraking;
			    		else acceleration = maxAcceleration;
				    	if (velocity + acceleration > slowDownVelocity) slowingDown = true;
					} else if (moveDirection == -1) {
				    	if (velocity > 0.0) acceleration = -maxBraking;
		    			else acceleration = -maxAcceleration;
		    			if (velocity + acceleration < slowDownVelocity)	slowingDown = true;
					}
			    }
	    		if (slowingDown) {
					if (distanceRemaining != 0.0 && Math.abs(velocity) <= maxBraking && Math.abs(distanceRemaining) <= maxBraking) slowDownVelocity = distanceRemaining;
					double perfectAccel = slowDownVelocity - velocity;
					if (perfectAccel > maxBraking) perfectAccel = maxBraking;
					else if (perfectAccel < -maxBraking) perfectAccel = -maxBraking;
					acceleration = perfectAccel;
		    	}
			    if (velocity > maxVelocity || velocity < -maxVelocity) acceleration = 0.0;
		    	velocity += acceleration;
			    if (velocity > maxVelocity)	velocity -= Math.min(maxBraking, velocity - maxVelocity);
		    	if (velocity < -maxVelocity) velocity += Math.min(maxBraking, -velocity - maxVelocity);
		    	double dx = velocity * Math.sin(heading); double dy = velocity * Math.cos(heading);
			    x += dx; y += dy;
			    //boolean updateBounds = false;
	    		//if (dx != 0.0 || dy != 0.0) updateBounds = true;
			    if (slowingDown && velocity == 0.0) { distanceRemaining = 0.0; moveDirection = 0; slowingDown = false; acceleration = 0.0; }
			    //if (updateBounds) updateBoundingBox();
	    		distanceRemaining -= velocity;
				if (x<18 || y<18 || x>battleFieldW-18 || y>battleFieldH-18) {
					distanceRemaining = 0;
					angleToTurn = 0;
					velocity = 0;
					moveDirection = 0;
					x = Math.max(18,Math.min(battleFieldW-18,x));
					y = Math.max(18,Math.min(battleFieldH-18,y));
				}
			}
			//add position
			pos[i] = new MovSimStat(x,y,velocity,heading,Utils.normalRelativeAngle(heading-lastHeading));
		}
		return pos;		
	}
	
	private double checkForCollitions(MovSimStat[] fm, double time, int steps) {
		double damage = 0;
		for (int i=0; i<bullets.size(); i++) {
			MovSimStat b = (MovSimStat) bullets.get(i);
			boolean hit = false;
			int st = 0;
			while (!hit && st<steps) {
				if (Point2D.distance(fm[st].x,fm[st].y,b.currX(time+st),b.currY(time+st)) <= 50) {
					damage += (20-b.v)/3 * 4 + Math.max((20-b.v)/3 - 1, 0) * 2;
					hit = true;
				}
				st++;
			}
		}
		return damage;
	}
	
	private double normalRelativeAngle(double angle) { return ((angle + 5*Math.PI) % (2*Math.PI)) - Math.PI; }
	
}
