package simonton.guns.singleTick;

import java.util.*;

import simonton.utils.*;

/**
 * @author Eric
 * 
 */
public class SingleTickPatternMatcher {
	private HashMap<Pattern, byte[]> frequencies = new HashMap<Pattern, byte[]>();
	private int[] ties;
	private int numTies;
	private int numSteps;

	public SingleTickPatternMatcher(int numSteps) {
		this.numSteps = numSteps;
		ties = new int[numSteps];
	}

	public void record(int nextTick, Pattern pattern) {

		pattern = size(pattern);
		byte[] freq;
		do {
			freq = frequencies.get(pattern);
			if (freq == null) {
				freq = new byte[numSteps];
				frequencies.put(pattern, freq);
			}
//			for (int i = numSteps; --i >= 0; ) {
//				freq[i] = (byte) (freq[i] * .8 + .5);
//			}
//			++freq[nextTick];
			if (freq[nextTick] == Byte.MAX_VALUE) {
				for (int i = numSteps; --i >= 0;) {
					if (freq[i] <= 0) {
						freq[i] = Byte.MIN_VALUE;
					} else {
						freq[i] += Byte.MIN_VALUE;
					}
				}
			}
			++freq[nextTick];
			

			if (pattern.length == 0) {
				return;
			}

			pattern = shorten(pattern);
		} while (true);
	}
public static int tieStats;
	public int predictTickAfter(Pattern pattern, int defaultNext, int modForbid) {

		pattern = size(pattern);
		byte[] freq;
		do {
			freq = frequencies.get(pattern);
			if (freq != null) {
				int iVal;
				int bestVal = -1;
				for (int i = numSteps; --i >= 0;) {
					if (modForbid < 0 || i % modForbid != 0) {
						iVal = freq[i];
						if (iVal == bestVal) {
							ties[numTies++] = i;
						} else if (iVal > bestVal) {
							bestVal = iVal;
							numTies = 1;
							ties[0] = i;
						}
					}
				}
				if (bestVal == freq[defaultNext]) {
					return defaultNext;
				}
				++tieStats;
				return ties[(int) (Math.random() * numTies)];
			}

			if (pattern.length == 0) {
				return defaultNext;
			}
			pattern = shorten(pattern);
		} while (true);
	}

	public void printStats() {
		System.out.println(frequencies.size());
	}

	private Pattern size(Pattern pattern) {

		if (pattern.length > 20) {
			return pattern.subPattern((short) (pattern.length / 5 * 5));
		} /*
			 * else if (pattern.length > 10) { return pattern.subPattern((short)
			 * (pattern.length / 2 * 2)); }
			 */
		return pattern;
	}

	private Pattern shorten(Pattern pattern) {

		if (pattern.length > 20) {
			return pattern.subPattern((short) (pattern.length - 5));
		} /*
			 * else if (pattern.length > 10) { return pattern.subPattern((short)
			 * (pattern.length - 2)); }
			 */
		return pattern.subPattern((short) (pattern.length - 1));
	}
}
