package zyx.nano;

import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class EscherichiaColi extends AdvancedRobot {
  public static double tx_ = 400;
  public static double ty_ = 300;
  private static double Sq(double x) { return x * x; }
  public void run() {
    setAdjustGunForRobotTurn(true);
    setAdjustRadarForGunTurn(true);
    setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
  }
  public void onScannedRobot(ScannedRobotEvent event) {
    double bearing;
    double x;
    double y;
    double move_angle = Utils.normalRelativeAngle(Math.atan2(tx_ - (x = getX()), ty_ - (y = getY())) - (bearing = getHeadingRadians()));
    /* Radar */
    setTurnRadarRightRadians(Utils.normalRelativeAngle((bearing += event.getBearingRadians()) - getRadarHeadingRadians()) * 1.9);
    /* Movement */
    if ( Sq(x - tx_) + Sq(y - ty_) < 1000 ) {
      tx_ = Math.random() * 720 + 40;
      ty_ = Math.random() * 520 + 40;
    }
    setTurnRightRadians(Math.atan(Math.tan(move_angle)));
    setAhead(move_angle == getTurnRemainingRadians() ? 100 : -100);
    /* Targeting */
    double e;
    setTurnGunRightRadians(Utils.normalRelativeAngle(bearing + 
        (Math.random() - 0.5) * Math.min(1.4545454545454545454545454545455, e = event.getEnergy())
        - getGunHeadingRadians()));
    if ( getEnergy() > 3 || e == 0 ) setFire(e);
  }
}
