package mld;
import robocode.*;
import java.awt.Color;
import robocode.util.Utils;

//  LittleBlackBook - a robot by Michael Dorgan
 
// --------------------------------------------------------------------------------------------------------------------------------------------
// Revision 6/14/09 ver 1.0
// A Guess Factor without learning / 3 movement type bot.
// It invents a new gun type - SGF: String Guess Factor.
// Should be very competitive.  Will do all other bots in next version.
//
// Revision 6/17/09 ver 1.1
// New tables from automated process.  Allows me to pick between 2 different good values now.  1/2 fixed stop'n'go creep, but now cannot hit 
// disabled bots.  We'll see how this goes.
//
// Revision 6/18/09 ver 1.2
// Fixed most of my lost points while retaining a bunch of new points.  Fixed an asin on my bullet ratio.
// Should be the best bot in the nano 1v1 rumble now. 
// CodeSize: 248
//
// Revision 6/20/09 ver 1.3
// Redid a few problem bot numbers.  Added 4x the bins to give 2 mode shots against dual mode opponents.  Nice gain.  Found a bunch of bytes
// here and there by preloading some constants and using the 'move mode' byte as the 0-39 distance aim.  Added 0 energy 0 lead code to kill
// enemies at the end of the match (very minor gain.)  Almost enough space to roll average the velocity for a nice win.
// Codesize: 247
//
// Revision 6/21/09 ver 1.4
// Found another 12+ bytes!!!  Used that space to create a rolling average to defeat stop'n'gos.  Redid a few nano #, but
// alos added 1st pass of micros.  Still a few bytes left and I may go to multi-firepower instead of average velocities.
// Codesize:246
//
// Revision 6/26/09 ver 1.52
// Found even more space.  Now have multi-firepower, mutli movement code with rolling averages.  Tables tuned!  
// This is a transition checkin as I have a new idea for next that allows distance control as well.
// Codesize:248
//
// Revision 6/28/09 ver 1.53
// More table revisions - smarter about 2.0 firepower now.
// Code size:248
//
// Revision 12/12/09 ver 1.54
// More table revisions - Updates of bots changed over time.  Redid some problem bots.
// Code size:249
//
// Revision 12/12/09 ver 1.55
// More table revisions - Tested in correct robocode version to remove surprises.  Micros not done yet.
// Code size:249
//
// Revision 12/22/09 ver 1.56
// More table revisions - Added missing nanos/micros.  Tuned better against higher end bots.
// Code size:249
//
// Revision 1/13/10 ver 1.59
// Tons of table revisions.  Should be a 80+APS Nano bot now.
// Code size:249
//
// Revision 1/15/10 ver 1.60
// Found quite a few more bytes today.  Put them to awesome use.  I now have nearly perfect dodge code!!!  OSCO mode
// just became godlike on straight linear aiming bots.  Redid the distance controller to be more accurate and smaller!
// Revisited the average velocity code for a few bytes.  Are you kidding me?  2 bytes left over?!?  Will need some
// tuning passes to fix a few bots that will be broke after such a large update.
// Code size:247
//
// Revision 1/17/10 ver 1.61
// Just table revisions this time for the most part to fix bots that got broken.  Will be a nice strength increase.
// Code size:247
//
// Revision 1/19/10 ver 1.62
// Bunch more bot table revisions.  Should add another APS or so in each division.
// Code size:247
//
// Revision 1/21/10 ver 1.63
// Bunch more bot table revisions.  Found 7 more bytes.  Will use them in version 1.70
// Code size:240
//
// Revision 1/26/10 ver 1.64
// Bunch more bot table revisions.  Added stop n go.
// Code size:248
//
// Revision 1/28/10 ver 1.65
// Bunch more bot table revisions.  Concentrated on toughest Nanos.
// Code size:248
//
// Revision 1/30/10 ver 1.66
// A few tables, but fixed wall sticking death by freeing a few bytes and re-using them.  Musashi trick stop'n'go for generic test.
// Code size:249
//
// Revision 2/09/10 ver 1.67
// Added minis and retuned everything for distance.  Some bots will be broken.
// Code size:249
//
// Revision 2/10/10 ver 1.68
// Rolled back bad bots and kept good ones.
// Code size:249
//
// Revision 2/10/10 ver 1.69
// Table updates for some small gains.
// Code size:249
//
// Revision 2/12/10 ver 1.69b
// Couple nanos updated - trying initial movement vs slightly worse dodging and worse wall clinging tradeoff.
// Code size:249
//
// Revision 2/12/10 ver 1.69c
// Turning off initial movement to save space.
// Code size:243
//
// Revision 6/05/11 ver 1.69d
// Added missing bots
// Code size:243
//
// Revision 6/08/11 ver 1.69e
// Tuning
// Code size:243
//
// --------------------------------------------------------------------------------------------------------------------------------------------

public class LittleBlackBook extends AdvancedRobot 
{
	static final String END_OVERFLOW_BUFFER = "" + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0;
  // tunable constants
  // for movement
	private final static double DEG_TO_RAD = Math.PI / 180;
	private final static double RAD_TO_DEG = 180 / Math.PI;
		
  private final static double MOVE_DISTANCE       = 1;
  private final static double NON_RAND            = 0.15;
  private final static double PREFERRED_RANGE     = 160.0; // Keep this around the bin size to allow multiple GFs
  private final static double CLOSE_FCT           = 450 * MOVE_DISTANCE;

  private final static double    MOVE_RANGE_VAL 	  = RAD_TO_DEG; // keep as large as possible to avoid accidental 0 compares below (32767 is max)

  private final static char   OSCO			 	  = (char)MOVE_RANGE_VAL;
  private final static char   STRA			 	  = (char)0;
  private final static char   RND1			 	  = (char)(MOVE_RANGE_VAL * 0.45);

  private final static char   RN10			 	  = (char)(MOVE_RANGE_VAL * 0.10);
  private final static char   RN15			 	  = (char)(MOVE_RANGE_VAL * 0.15);
  private final static char   RN20			 	  = (char)(MOVE_RANGE_VAL * 0.20);
  private final static char   RN30			 	  = (char)(MOVE_RANGE_VAL * 0.30);
  private final static char   RN35			 	  = (char)(MOVE_RANGE_VAL * 0.35);
  private final static char   RN40			 	  = (char)(MOVE_RANGE_VAL * 0.40);
  private final static char   RN50			 	  = (char)(MOVE_RANGE_VAL * 0.50);
  private final static char   RN55			 	  = (char)(MOVE_RANGE_VAL * 0.55);
  private final static char   RN60			 	  = (char)(MOVE_RANGE_VAL * 0.60);
  private final static char   RN65			 	  = (char)(MOVE_RANGE_VAL * 0.65);
  private final static char   RN70			 	  = (char)(MOVE_RANGE_VAL * 0.70);
  private final static char   RN80			 	  = (char)(MOVE_RANGE_VAL * 0.80);
  private final static char   RN90			 	  = (char)(MOVE_RANGE_VAL * 0.90);
  private final static char   RN95			 	  = (char)(MOVE_RANGE_VAL * 0.95);

  private final static char   MV00			 	  = (char)(0 / MOVE_DISTANCE);
  private final static char   MV05			 	  = (char)(13 / MOVE_DISTANCE);
  private final static char   MV10			 	  = (char)(25 / MOVE_DISTANCE);
  private final static char   MV15			 	  = (char)(38 / MOVE_DISTANCE);
  private final static char   MV25			 	  = (char)(59 / MOVE_DISTANCE);
  private final static char   MUSA			 	  = (char)(55 / MOVE_DISTANCE);
  private final static char   MV30			 	  = (char)(72 / MOVE_DISTANCE);
  private final static char   MV99			 	  = (char)(357 / MOVE_DISTANCE);
  private final static char   MMAX			 	  = (char)(4000 / MOVE_DISTANCE);

  private final static char   M360			 	  = (char)(360 / MOVE_DISTANCE);
  private final static char   M240			 	  = (char)(240 / MOVE_DISTANCE);
  private final static char   M200			 	  = (char)(200 / MOVE_DISTANCE);
  private final static char   M150			 	  = (char)(150 / MOVE_DISTANCE);
  private final static char   M120			 	  = (char)(120 / MOVE_DISTANCE);
  private final static char   M090			 	  = (char)(90 / MOVE_DISTANCE);
  private final static char   M060			 	  = (char)(60 / MOVE_DISTANCE);
  private final static char   M000			 	  = (char)(0 / MOVE_DISTANCE);

  // for gun
//  private final static double BULLET_SPEED        = 20.0 - 3 * BULLET_POWER; 
  private final static double GF_BULLET_FACTOR20  = 0.6082; // arcsin(8 / 14)
  private final static double GF_BULLET_FACTOR25  = 0.6944; // arcsin(8 / 12.5)
  private final static double GF_BULLET_FACTOR30  = 0.814333; // arcsin(8 / 11)


//  private final static double K         		  = (GF_BULLET_FACTOR25/50.0d);// / 50.0d;
  private final static double K         		  = (GF_BULLET_FACTOR25*RAD_TO_DEG/50.0d);// / 50.0d;
  private final static double A2B = K * (GF_BULLET_FACTOR30 / GF_BULLET_FACTOR25); // is about 1.173
  private final static int    MAX_NAME_LEN        = 40; // 38
  private final static int    GF_BIN_SIZE         = 20;

  private final static char   FP30				  = (char)(3.0 * RAD_TO_DEG);
  private final static char   FP29				  = (char)(2.9 * RAD_TO_DEG);
  private final static char   FP25				  = (char)(2.5 * RAD_TO_DEG);
  private final static char   FP20				  = (char)(2.0 * RAD_TO_DEG);
  private final static char   FP15				  = (char)(1.5 * RAD_TO_DEG);
  private final static char   FP10				  = (char)(1.0 * RAD_TO_DEG);
  private final static char   FP05				  = (char)(0.5 * RAD_TO_DEG);
  private final static char   FP01				  = (char)0;

  private final static char Am99 = (char)(-50 * K + 0.5);//FFD8
  private final static char Am96 = (char)(-48 * K + 0.5);//FFDA
  private final static char Am92 = (char)(-46 * K + 0.5);//FFDB
  private final static char Am88 = (char)(-44 * K + 0.5);//FFDD
  private final static char Am84 = (char)(-42 * K + 0.5);//FFDF
  private final static char Am80 = (char)(-40 * K + 0.5);//FFE0
  private final static char Am76 = (char)(-38 * K + 0.5);//FFE2
  private final static char Am72 = (char)(-36 * K + 0.5);//FFE3
  private final static char Am68 = (char)(-34 * K + 0.5);//FFE5
  private final static char Am64 = (char)(-32 * K + 0.5);//FFE7
  private final static char Am60 = (char)(-30 * K + 0.5);//FFE8
  private final static char Am56 = (char)(-28 * K + 0.5);//FFEA
  private final static char Am52 = (char)(-26 * K + 0.5);//FFEB
  private final static char Am48 = (char)(-24 * K + 0.5);//FFED
  private final static char Am44 = (char)(-22 * K + 0.5);//FFEE
  private final static char Am40 = (char)(-20 * K + 0.5);//FFF0
  private final static char Am36 = (char)(-18 * K + 0.5);//FFF2
  private final static char Am32 = (char)(-16 * K + 0.5);//FFF3
  private final static char Am28 = (char)(-14 * K + 0.5);//FFF5
  private final static char Am24 = (char)(-12 * K + 0.5);//FFF6
  private final static char Am20 = (char)(-10 * K + 0.5);//FFF8
  private final static char Am16 = (char)(-8 * K + 0.5);//FFFA
  private final static char Am12 = (char)(-6 * K + 0.5);//FFFB
  private final static char Am08 = (char)(-4 * K + 0.5);//FFFD
  private final static char Am04 = (char)(-2 * K + 0.5);//FFFE
  private final static char Ap00 = (char)0;				// 0
  private final static char Ap04 = (char)(2 * K + 0.5); // 2
  private final static char Ap08 = (char)(4 * K + 0.5); // 3
  private final static char Ap12 = (char)(6 * K + 0.5); // 5 
  private final static char Ap16 = (char)(8 * K + 0.5); // 6
  private final static char Ap20 = (char)(10 * K + 0.5); // 8
  private final static char Ap24 = (char)(12 * K + 0.5); // 10
  private final static char Ap28 = (char)(14 * K + 0.5); // 11
  private final static char Ap32 = (char)(16 * K + 0.5); // 13
  private final static char Ap36 = (char)(18 * K + 0.5); // 14
  private final static char Ap40 = (char)(20 * K + 0.5); // 16
  private final static char Ap44 = (char)(22 * K + 0.5); // 18
  private final static char Ap48 = (char)(24 * K + 0.5); // 19
  private final static char Ap52 = (char)(26 * K + 0.5); // 21
  private final static char Ap56 = (char)(28 * K + 0.5); // 22
  private final static char Ap60 = (char)(30 * K + 0.5); // 24
  private final static char Ap64 = (char)(32 * K + 0.5); // 25
  private final static char Ap68 = (char)(34 * K + 0.5); // 27
  private final static char Ap72 = (char)(36 * K + 0.5); // 29
  private final static char Ap76 = (char)(38 * K + 0.5); // 30
  private final static char Ap80 = (char)(40 * K + 0.5); // 32
  private final static char Ap84 = (char)(42 * K + 0.5); // 33
  private final static char Ap88 = (char)(44 * K + 0.5); // 35
  private final static char Ap92 = (char)(46 * K + 0.5); // 37
  private final static char Ap96 = (char)(48 * K + 0.5); // 38
  private final static char Ap99 = (char)(50 * K + 0.5); // 40


  private final static char Bm99 = (char)(-50 * A2B + 0.5);//D1
  private final static char Bm96 = (char)(-48 * A2B + 0.5);//D3
  private final static char Bm92 = (char)(-46 * A2B + 0.5);//D5
  private final static char Bm88 = (char)(-44 * A2B + 0.5);//D7
  private final static char Bm84 = (char)(-42 * A2B + 0.5);//D9
  private final static char Bm80 = (char)(-40 * A2B + 0.5);//DB
  private final static char Bm76 = (char)(-38 * A2B + 0.5);//DD
  private final static char Bm72 = (char)(-36 * A2B + 0.5);//DE
  private final static char Bm68 = (char)(-34 * A2B + 0.5);//E0
  private final static char Bm64 = (char)(-32 * A2B + 0.5);//E2
  private final static char Bm60 = (char)(-30 * A2B + 0.5);//E4
  private final static char Bm56 = (char)(-28 * A2B + 0.5);//E6
  private final static char Bm52 = (char)(-26 * A2B + 0.5);//E8
  private final static char Bm48 = (char)(-24 * A2B + 0.5);//EA
  private final static char Bm44 = (char)(-22 * A2B + 0.5);//EB
  private final static char Bm40 = (char)(-20 * A2B + 0.5);//ED
  private final static char Bm36 = (char)(-18 * A2B + 0.5);//EF
  private final static char Bm32 = (char)(-16 * A2B + 0.5);//F1
  private final static char Bm28 = (char)(-14 * A2B + 0.5);//F3
  private final static char Bm24 = (char)(-12 * A2B + 0.5);//F5
  private final static char Bm20 = (char)(-10 * A2B + 0.5);//F7
  private final static char Bm16 = (char)(-8 * A2B + 0.5); //F9
  private final static char Bm12 = (char)(-6 * A2B + 0.5); //FA
  private final static char Bm08 = (char)(-4 * A2B + 0.5); //FC
  private final static char Bm04 = (char)(-2 * A2B + 0.5); //FE
  private final static char Bp00 = (char)(0 * A2B);
  private final static char Bp04 = (char)(2 * A2B + 0.5);  //2
  private final static char Bp08 = (char)(4 * A2B + 0.5);  //4
  private final static char Bp12 = (char)(6 * A2B + 0.5);  //6
  private final static char Bp16 = (char)(8 * A2B + 0.5);  //7
  private final static char Bp20 = (char)(10 * A2B + 0.5); 
  private final static char Bp24 = (char)(12 * A2B + 0.5);
  private final static char Bp28 = (char)(14 * A2B + 0.5);
  private final static char Bp32 = (char)(16 * A2B + 0.5);
  private final static char Bp36 = (char)(18 * A2B + 0.5);
  private final static char Bp40 = (char)(20 * A2B + 0.5); //19
  private final static char Bp44 = (char)(22 * A2B + 0.5); //21
  private final static char Bp48 = (char)(24 * A2B + 0.5); //22
  private final static char Bp52 = (char)(26 * A2B + 0.5);
  private final static char Bp56 = (char)(28 * A2B + 0.5);
  private final static char Bp60 = (char)(30 * A2B + 0.5); //28
  private final static char Bp64 = (char)(32 * A2B + 0.5);
  private final static char Bp68 = (char)(34 * A2B + 0.5);
  private final static char Bp72 = (char)(36 * A2B + 0.5); //34
  private final static char Bp76 = (char)(38 * A2B + 0.5); //35
  private final static char Bp80 = (char)(40 * A2B + 0.5); //37
  private final static char Bp84 = (char)(42 * A2B + 0.5); //39
  private final static char Bp88 = (char)(44 * A2B + 0.5); //41
  private final static char Bp92 = (char)(46 * A2B + 0.5); //43
  private final static char Bp96 = (char)(48 * A2B + 0.5); //45
  private final static char Bp99 = (char)(50 * A2B + 0.5); //47

	private final static char A000 = (char)(0 * MOVE_DISTANCE / 1);
	private final static char A005 = (char)(5 * MOVE_DISTANCE / 1);
	private final static char A010 = (char)(10 * MOVE_DISTANCE / 1);
	private final static char A015 = (char)(15 * MOVE_DISTANCE / 1);
	private final static char A020 = (char)(20 * MOVE_DISTANCE / 1);
	private final static char A030 = (char)(30 * MOVE_DISTANCE / 1);
	private final static char A040 = (char)(40 * MOVE_DISTANCE / 1);
	private final static char A050 = (char)(50 * MOVE_DISTANCE / 1);
	private final static char A060 = (char)(60 * MOVE_DISTANCE / 1);
	private final static char A070 = (char)(70 * MOVE_DISTANCE / 1);
	private final static char A080 = (char)(80 * MOVE_DISTANCE / 1);
	private final static char A090 = (char)(90 * MOVE_DISTANCE / 1);
	private final static char AM05 = (char)((360-5) * MOVE_DISTANCE / 1);
	private final static char AM10 = (char)(350 * MOVE_DISTANCE / 1);
	private final static char AM15 = (char)(345 * MOVE_DISTANCE / 1);
	private final static char AM20 = (char)(340 * MOVE_DISTANCE / 1);
	private final static char AM30 = (char)(330 * MOVE_DISTANCE / 1);
	private final static char AM40 = (char)(320 * MOVE_DISTANCE / 1);
	private final static char AM50 = (char)(310 * MOVE_DISTANCE / 1);
	private final static char AM60 = (char)(300 * MOVE_DISTANCE / 1);
	private final static char AM70 = (char)(290 * MOVE_DISTANCE / 1);
	private final static char AM80 = (char)(280 * MOVE_DISTANCE / 1);
	private final static char AM90 = (char)(270 * MOVE_DISTANCE / 1);

	private final static char ARCL = (char)(32000);
	private final static char ARCC = (char)(34000);
		    
  // Persistant vars
  private static double     enemyEnergy;
  private static double		moveDir             = MOVE_DISTANCE;
  private static double     avgVelocity;

  /**
   * Bot run method.
   */
 	public void run() 
	{
    	// helps targeting accuracy against stationary bots, hurts against advanced and bullet catchers
//    	setAdjustGunForRobotTurn(true);
/*
		out.println(NameList.length() + " " + MoveTypeList.length() + " " + MoveRangeDistanceList.length() + " "  + MoveDistanceList.length() + " "  + FirePowerList.length() + " "  + DesiredAngleList.length() + " "  + AimList.length());
		out.println((short)FirePowerList.charAt(0));
				for(int i=11761; i<NameList.length(); i+=40)
		{
			out.println(i + ":" + ("" + NameList.charAt(i-1) + NameList.charAt(i) + NameList.charAt(i+1) + NameList.charAt(i+2) + NameList.charAt(i+3) + NameList.charAt(i+4) + NameList.charAt(i+5)) + " " + (short)AimList.charAt(i) + "," + (short)AimList.charAt(i+1) + "," + (short)AimList.charAt(i+2) + "," + (short)AimList.charAt(i+3) + "," + (short)AimList.charAt(i+4));
			out.println((short)AimList.charAt(i) + " " + (short)AimList.charAt(i+1) + " " + (short)AimList.charAt(i+2) + " " + (short)AimList.charAt(i+3) + " " + (short)AimList.charAt(i+4) + " " + (short)AimList.charAt(i+5) + " " + (short)AimList.charAt(i+6) + " " + (short)AimList.charAt(i+7) + " " + (short)AimList.charAt(i+8) + " " + (short)AimList.charAt(i+9) + " " + (short)AimList.charAt(i+10)
			 + " " + (short)AimList.charAt(i+11) + " " + (short)AimList.charAt(i+12) + " " + (short)AimList.charAt(i+13) + " " + (short)AimList.charAt(i+14) + " " + (short)AimList.charAt(i+15) + " " + (short)AimList.charAt(i+16) + " " + (short)AimList.charAt(i+17) + " " + (short)AimList.charAt(i+18) + " " + (short)AimList.charAt(i+19) + " " + (short)AimList.charAt(i+20)
			+ " " + (short)AimList.charAt(i+21) + " " + (short)AimList.charAt(i+22) + " " + (short)AimList.charAt(i+23) + " " + (short)AimList.charAt(i+24) + " " + (short)AimList.charAt(i+25) + " " + (short)AimList.charAt(i+26) + " " + (short)AimList.charAt(i+27) + " " + (short)AimList.charAt(i+28) + " " + (short)AimList.charAt(i+29) + " " + (short)AimList.charAt(i+30)
			+ " " + (short)AimList.charAt(i+31) + " " + (short)AimList.charAt(i+32) + " " + (short)AimList.charAt(i+33) + " " + (short)AimList.charAt(i+34) + " " + (short)AimList.charAt(i+35) + " " + (short)AimList.charAt(i+36) + " " + (short)AimList.charAt(i+37) + " " + (short)AimList.charAt(i+38) + " " + (short)AimList.charAt(i+39) + " " + (short)AimList.charAt(i+40));
		}
*/			

		// Dodge/Move immediately.  Didn't help
//		enemyEnergy = 101;

    	// start our infinite radar loop
		turnRadarRightRadians(Double.POSITIVE_INFINITY);
  	}

  	/**
  	* Scan handler.
   	* This is where it all happens.
   	*/ 
  	public void onScannedRobot(ScannedRobotEvent e) {
    	// register vars, should be the most commonly used - first is our index into every string.  Basically, go into the string based on distance
		int index = NameList.indexOf(e.getName().split(" ")[0])+((int)(e.getDistance())/(GF_BIN_SIZE));
		// 2nd most used value cached to reg
		double r2 = e.getBearingRadians();

//		out.println((int)(e.getDistance())/GF_BIN_SIZE);
//		if(index<MAX_NAME_LEN) index=MAX_NAME_LEN;
//		out.println(NameList.substring(index-(int)(e.getDistance())/GF_BIN_SIZE,index-1));
//		out.println(e.getName().split(" ")[0]);
//		out.println((int)MoveTypeList.charAt(index) + " " + AimList.charAt(index)*Math.PI/ 180.0 + " " + MoveDistanceList.charAt(index)/20.0 + " " + (int)DesiredAngleList.charAt(index) + " " + (int)FirePowerList.charAt(index) * Math.PI / 180.0);
		
    	// radar scan
    	setTurnRadarLeftRadians(getRadarTurnRemaining());

		// Some incredibly silly and complex code.  We need to only dodge if the change in energy is between 0.1 and 3.0.  A basic if is expensive. So
		// We cast to char (which makes negative numbers go huge positive as chars are unsigned) then compare against this wrapped value.  We reverse this
		// so that 0 is ignored in the compare and are forced to use floor to change -(0.1 - 0.9) to -1 (otherwise it changes them to 0 which I find strange.)
		
//		out.println((short)((char)(enemyEnergy - 1.09 - e.getEnergy())) + " " + (enemyEnergy - e.getEnergy()));

		if( (char) ((enemyEnergy - 1  - (enemyEnergy = e.getEnergy()))) <= 2)
//		if( (char) ((enemyEnergy - 1.09  - (enemyEnergy = e.getEnergy()))) < 2)
		//		if( (char) ((enemyEnergy - 1  - (enemyEnergy = e.getEnergy()))) <= 2) // This version doesn't catch 0.1 bullets and counts 3.9 drops, but is 2 bytes smaller.
//		if((char)Math.floor(-enemyEnergy  + (enemyEnergy = e.getEnergy())) >= 65535-3)
//    	if (enemyEnergy > (enemyEnergy = e.getEnergy()))
		{
			// MoveDir is our base, smallest movement amount.  Multiply by 1/-1 based on which way we choose to move this dodge cycle
			// Then multiply this amount by some random amount from our distancelist char.  Allows no random up to nearly total random movement based on the tables
//  		setAhead((moveDir *= Math.signum( Math.toDegrees(Math.random()) - MoveTypeList.charAt(index)) ) * (Math.random() + Math.toRadians(MoveDistanceList.charAt(index)))); //6*6.0

 			setAhead((moveDir *= Math.signum( Math.toDegrees(Math.random()) - MoveTypeList.charAt(index))) * (MoveRangeDistanceList.charAt(index) * Math.random() + MoveDistanceList.charAt(index))); 
    	}

		// Fire based on this distance's firepower.
//		if(getGunTurnRemaining() == 0)
		setFire(Math.toRadians(FirePowerList.charAt(index)));
		
    	// turn perpendicular with range control.  The table describes the approach angle to use.
//    	setTurnRightRadians(Math.cos(r2 - Math.toRadians( DesiredAngleList.charAt(index) * Math.signum(getVelocity()))));
    	setTurnRightRadians(Math.cos(r2 - Math.toRadians( DesiredAngleList.charAt(index) * moveDir)));

		// If I can get the precision up a bit, I can use this version instead for 4 bytes savings.
//    	setTurnRightRadians(r2 - DesiredAngleList.charAt(index) / moveDir);
    
    	// rd has enemy relative bearing
    	r2 += getHeadingRadians();

//		out.println(avgVelocity);

// 		This version would do averaged angular velocity segmenting for 1 more byte (and 1Meg of tables!)
//		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(r2 - getGunHeadingRadians() + 
//			Math.toRadians((short)AimList.charAt(index + 40 * (int)((avgVelocity = (int)(avgVelocity*0.60 + e.getVelocity())) * Math.sin(e.getHeadingRadians() - r2)) )) ));//* 
			
		// We can afford to segment around 80ish pixels, with 2 velocity increments without going over budget - 80, 160, 240, 320, 400+ at -8,-6,-4,-2,0,2,4,6,8
		// Or 40ish pixels with segmenting at -8, -4, 0, 4, 8 which will not be accurate enough.
			
		// And the aimer.  Start with pointing at target.  Factor in a value from -1 to 1 modified by bullet speed.  Factor in which direction
		// this bot has been traveling for the last 10ish tics and then factor his lateral heading which may be included into a table later.
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(r2 - getGunHeadingRadians() + 
			Math.toRadians((short)AimList.charAt(index)) * 
			Math.signum(avgVelocity = (int)(avgVelocity*0.60 + e.getVelocity())) *
			Math.sin(e.getHeadingRadians() - r2) ));
	}
  
  	/**
   	* Hit a wall, reverse direction and start moving immediately.
   	*/
  	public void onHitWall(HitWallEvent e) 
	{
		// Do the direction switch next tic to prevent wall vibration death.
    	setAhead((moveDir = -moveDir)/0);
  	}
// Bots we know about
	private static final String NameList =
"default_fail_case                        " +
"ad.last.Bottom 1.0                      " +
"ags.micro.Carpet 1.1                    " +
"ahf.Acero 1.0                           " +
"ahf.NanoAndrew .4                       " +
"amk.Punbot.Punbot 0.01                  " +
"ap.Frederick 1.1                        " +
"apv.MicroAspid 1.8                      " +
"apv.NanoLauLectrik 1.0                  " +
"apv.NanoLauLectrikTheCannibal 1.1       " +
"arthord.KostyaTszyu Beta2               " +
"arthord.MannyPacquiao Beta              " +
"arthord.micro.Apoptygma 0.4             " +
"arthord.micro.Muffin 0.6.1              " +
"arthord.NanoSatan Mu                    " +
"arthord.NanoSatanMelee Beta             " +
"ary.micro.Weak 1.2                      " +
"ary.nano.AceSurf 1.2                    " +
"ary.nano.ColorNanoP 1.1                 " +
"as.xbots 1.0                            " +
"awesomeness.Elite 1.0                   " +
"baal.nano.N 1.42                        " +
"banshee.micro.Nexus6 0.3.0              " +
"bayen.nano.Squirrel 0.2                 " +
"bayen.UbaMicro 1.4                      " +
"bayen.UbaRamLT 1.0                      " +
"bbo.RamboT 0.3                          " +
"bons.NanoStalker 1.2                    " +
"bp.Kuma 1.0                             " +
"braaropolis.Abot 1.0                    " +
"bvh.micro.Freya 0.3                     " +
"bvh.micro.Svadilfari 0.2                " +
"bzdp.BoxCar 2.0                         " +
"bzdp.Pansy 2.1                          " +
"caimano.Furia_Ceca 0.22                 " +
"chase.c.Wristwatch 1.0                  " +
"chase.o.Orbit 0.1                       " +
"chickenfuego.UrChicken2 1.0             " +
"cjk.Merkava 0.1.1                       " +
"cjm.Charo 1.1                           " +
"codemojo.nano.Woot 1.0                  " +
"cx.micro.Blur 0.2                       " +
"cx.micro.Smoke 0.96                     " +
"cx.micro.Spark 0.6                      " +
"cx.nano.Smog 2.6                        " +
"davidalves.net.DuelistMicro 1.22        " +
"davidalves.net.DuelistMicroMkII 1.1     " +
"davidalves.net.DuelistNano 1.0          " +
"demetrix.nano.Neutrino 0.27             " +
"demetrix.nano.SledgeHammer 0.22         " +
"dft.Freddie 1.32                        " +
"dft.Guppy 1.0                           " +
"dggp.haiku.gpBot_0 1.1                  " +
"djdjdj.NanoSkunk10 1.0                  " +
"dks.MicroDanMK2 1.0                     " +
"DM.Mijit .3                             " +
"dmp.micro.Aurora 1.41                   " +
"dmp.nano.Eve 3.41                       " +
"donjezza.Jezza 1.0                      " + 
"donjezza.Muncho 1.0                     " +
"drd.DreadKnoght 0.9                     " + 
"dsw.StaticD 1.0                         " +
"dukie.Ambassador 1.0                    " +
"dummy.micro.HummingBird 2.14            " +
"dummy.micro.Sparrow 2.5                 " +
"dz.GalbaMicro 0.11                      " +
"dz.MostlyHarmlessNano 2.1               " +
"dz.OthoMicro 0.12                       " +
"el.JumpShoot 0.2                        " +
"el33t.EL33tGangstarr2 2.0               " +
"elloco.Flower 0.1r1                     " +
"elvbot.ElverionBot 0.3                  " +
"evd.X1 0.01                             " +
"fcr.First 1.0                           " +
"Fenix.FenixTrack 1.0                    " +
"fm.claire 1.7                           " +
"fm.mammillarias 1.3                     " +
"fullsail.SweetTea 1.1                   " +
"germ.TheMind .2                         " +
"gh.micro.Grinnik 0.7                    " +
"gh.micro.GrubbmThree 0.9                " +
"gh.nano.Grofvuil 0.2                    " +
"gio.RealGioBot 1.0                      " +
"gu.MicroScoob 1.3                       " +
"ins.MobyNano 0.8                        " +
"jab.micro.Sanguijuela 0.8               " +
"jam.micro.RaikoMicro 1.44               " +
"janm.Jammy 1.0                          " +
"japs.Serenity 1.0                       " +
"jaw.KarenCain 0.11                      " +
"jaw.Mouse 0.11                          " +
"jcw.ArcherOne 1.0                       " +
"jep.nano.Hawkwing 0.4.1                 " +
"jep.nano.Hotspur 0.1                    " +
"jgap.JGAP12584 1.0                      " +
"jgap.JGAP130166 1.0                     " +
"jgap.JGAP23423 1.0                      " +
"jgap.JGAP6139 1.0                       " +
"jgap.JGAP7247_2 1.0                     " +
"jgap.JGAP7958 1.0                       " +
"jk.micro.Toorkild 0.1.1                 " +
"joe.ADinosaur 1.0                       " +
"jp.SineWall 1.0                         " +
"js.PinBall 1.6                          " +
"jsal.Jsalbot 1.0                        " +
"jt.SpearmintCT Alpha                    " +
"kawigi.f.FhqwhgadsMicro 1.0             " +
"kawigi.micro.Shiz 1.1                   " +
"kawigi.nano.FunkyChicken 1.1            " +
"kawigi.nano.ThnikkaBot 0.9              " +
"kawigi.sbf.FloodMicro 1.5               " +
"kawigi.sbf.FloodNano 1.2                " +
"kc.micro.Needle 0.101                   " +
"kc.micro.Thorn 1.142                    " +
"kc.micro.WaveShark 0.3                  " +
"kc.nano.Splinter 1.2                    " +
"kinsen.nano.Hoplomachy 1.6              " +
"kinsen.nano.Quarrelet 1.0               " +
"kinsen.nano.Senticous 1.0               " +
"kjc.etc.Dharok 1.0                      " +
"kjc.Karaykan 1.0                        " +
"kjc.MailManX 2.0                        " +
"kurios.DOSexe .9                        " +
"leb.ShootAnArrow 0.1                    " +
"lechu.Lechu 1.1                         " +
"lion.Kresnanano 1.0                     " +
"lk.nano.Avesnar 1.1                     " +
"lrem.micro.FalseProphet Alpha           " +
"lrem.micro.MoggFanatic 0.2              " +
"lw.LuthersTest 0.1                      " +
"m3thos.Eva00 1.1                        " +
"marcinek.TopGun 1.3                     " +
"mbro.BelajarBot 0.0.3                   " +
"mbro.Detektor3 0.1.1                    " +
"mc.Messapia 0.1.8                       " +
"mld.DustBunny 3.8                       " +
"mld.Infinity 2.2                        " +
"mld.Moebius 2.9.3                       " +
"mld.Tide 1.2                            " +
"mld.Wisdom 1.0                          " +
"mme.NikeEnhanced 2.0                    " +
"mrm.MightyMoose .2                      " +
"myl.micro.Avipes 1.00                   " +
"myl.micro.NekoNinja 1.30                " +
"myl.micro.Predator 1.50                 " +
"myl.micro.Troodon 1.10                  " +
"myl.nano.Graviton 1.10                  " +
"myl.nano.Kakuru 1.20                    " +
"myl.nano.KomoriNinja 1.1                " +
"mz.Adept 2.65                           " +
"mz.AdeptBSB 1.03                        " +
"mz.Movement 1.8                         " +
"mz.NanoDeath 2.56                       " +
"mz.NanoGod 2.02                         " +
"nanoskank.NanoSkank 1.0                 " +
"nat.micro.NP 1.34                       " + 
"nat.micro.Reepicheep 0.1a               " + 
"nat.nano.Ocnirp 1.73                    " + 
"nat.nano.OcnirpPM 1.0                   " + 
"nat.nano.OcnirpSNG 1.0b                 " +
"ndn.DyslexicMonkey 1.1                  " +
"nexus.Prototype 1.0                     " +
"nova.Snow 1.0                           " +
"ntc.Cannon 1.12test                     " + 
"ntc.Knowledge 1.1                       " +
"ntc.Plains 0.9                          " +
"ntw.Sigsys 1.6                          " +
"ntc.Swim 0.9                            " + 
"nz.jdc.micro.HedgehogGF 1.3             " +
"nz.jdc.micro.HedgehogP 1.2              " +
"nz.jdc.nano.NeophytePattern 1.0         " +
"nz.jdc.nano.NeophytePRAL 1.2            " +
"nz.jdc.nano.NeophyteSRAL 1.2            " +
"oog.melee.Capulet 0.1                   " +
"oog.melee.CapuletDroid 1.0              " +
"oog.melee.Mercutio 1.0                  " +
"oog.melee.StarLight 0.1                 " +
"oog.micro.MagicD3 0.41                  " +
"oog.micro.Maui 1.1                      " +
"oog.micro.SavantMicro 1.0               " +
"oog.nano.Fuatisha 1.0                   " +
"oog.nano.MagicD2 2.4                    " +
"oog.nano.SavantVS 1.1                   " +
"oog.nano.SavantWS 1.1                   " +
"pa.Improved 1.1                         " +
"pak.Dargon 1.0b                         " +
"pak.JakeTheTestingRobot .1b             " +
"paolord.TheHulk 1.0                     " +
"pb.Oscillator 1.0                       " +
"pez.micro.Aristocles 0.3.7              " +
"pez.nano.Icarus 0.3                     " +
"pez.nano.LittleEvilBrother 0.1          " +
"pfvicm.Sobieski 7.2.3b                  " +
"ph.micro.Pikeman 0.4.5                  " +
"PkKillers.PkAssassin 1.0                " +
"pmc.SniperBot 1.0                       " +
"projectx.ProjectNano 2.0                " +
"projectx.TestNano 1.0                   " +
"pulsar.Nanis 0.3                        " +
"pulsar.PulsarNano 0.2.4                 " +
"quietus.Invader 0.1                     " +
"quietus.NarrowRadar 0.1                 " +
"radnor.DoctorBob 1.42                   " +
"ratosh.nano.Debo 1.36                   " +
"ratosh.Nobo 0.21                        " +
"ratosh.Wesco 1.4                        " +
"rcp.Kuramatron 1.0                      " +
"repositorio.NanoStep 1.0                " +
"robo.PartsBot 1.0                       " +
"robar.haiku.Spike 1.0                   " +
"robar.micro.Gladius 1.15                " +
"robar.micro.Kirbyi 1.0                  " +
"robar.micro.Topaz 0.25                  " +
"robar.nano.Assertive 0.3                " +
"robar.nano.BlackWidow 1.3               " +
"robar.nano.Breeze 0.3                   " +
"robar.nano.Mosquito 1.1                 " +
"robar.nano.MosquitoPM 1.0               " +
"robar.nano.Prestige 1.0                 " +
"robar.nano.Pugio 1.49                   " +
"robar.nano.Scytodes 0.3                 " +
"robar.nano.Vespa 0.95                   " +
"rsim.micro.uCatcher 0.1                 " +
"ruc.nano.Zealot 0.2                     " +
"ry.LightningBug 1.0                     " +
"ry.Worst 1.0                            " +
"rz.Artist 0.2                           " +
"rz.GlowBlow 2.31                        " +
"rz.HawkOnFire 0.1                       " +
"rz.SmallDevil 1.502                     " +
"sam.Samspin 1.0                         " +
"sgp.nano.FurryLeech 1.0                 " +
"sgp.ShiningBeetle 1.1                   " +
"sgp.SleepingGoat 1.1                    " +
"simonton.GFNano_D 3.1b                  " +
"simonton.micro.GFMicro 1.0              " +
"simonton.micro.WeeklongObsession 3.4.1  " +
"simonton.nano.WeekendObsession_S 1.7    " +
"spinnercat.haiku.Refrigerator 1.1       " +
"spinnercat.CopyKat 1.2.3                " +
"spinnercat.Kitten 1.4                   " +
"spinnercat.Limit .01                    " +
"stelo.FretNano 1.1                      " +
"stelo.MatchupMicro 1.2                  " +
"stelo.MirrorMicro 1.1                   " +
"stelo.MirrorNano 1.4                    " +
"stelo.MoojukNano 1.2                    " +
"stelo.PatternRobot 1.0                  " +
"stelo.PianistNano 1.3                   " +
"stelo.SteloTestNano 1.0                 " +
"stelo.UnfoolableNano 1.0                " +
"stelo.UntouchableNano 1.4               " +
"step.NanoBidu 1.0                       " +
"step.nanoPri 1.0                        " +
"strider.Festis 1.2.1                    " +
"strider.Mer 1.1.0                       " +
"sul.Bicephal 1.2                        " +
"sul.BlueBot 1.0                         " +
"sul.NanoR2 1.32                         " +
"sul.Pinkbot 1.1                         " +
"stuff.Vlad 0.1                          " +
"timmit.nano.TimCat 0.13                 " +
"timmit.nano.TimDog 0.33                 " +
"tlp.ThreeLeggedPig 1                    " +
"tobe.calypso.Calypso 4.1                " +
"tornyil.bottomup.BottomUp 1.05          " +
"toz.Gnome 1.1                           " +
"trab.nano.AinippeNano 1.3               " +
"usa.nano.Nemo 2.0                       " +
"vft.Hrist 1.0                           " +
"vft.Valkyrie 1.0                        " +
"voidious.micro.Jen 1.11                 " +
"wiki.nano.DevilFISH 1.0                 " +
"wiki.nano.RaikoNano 1.1                 " +
"winamp32.micro.MicroMacro 1.0           " +
"yarghard.Y101 1.0                       " +
"yk.JahMicro 1.0                         " +
"zch.David 0.21                          " +
"zch.Hirkan 0.11                         " +
"zyx.micro.Ant 1.1                       " +
"zyx.nano.Ant 1.1                        " +
"zyx.nano.EscherichiaColi 1.0            " +
"zyx.nano.RedBull 1.0                    " +

"ahf.r2d2.R2d2 0.86                      " + 
"AIR.iRobot 1.0                          " + 
"amk.ChumbaMini 0.2                      " + 
"amk.jointstrike.JointStrike 0.2         " + 
"apv.Aspid 1.7                           " + 
"apv.AspidReloaded 0.6                   " + 
"ar.QuantumChromodynamics 1.2.1          " + 
"ary.mini.Nimi 1.0                       " + 
"banshee.mini.Nexus6 0.2.0               " + 
"bbo.TheRoof 1.4.3                       " + 
"bvh.hdr.Hodur 0.4                       " + 
"bvh.mini.Fenrir 0.39                    " + 
"bvh.mini.Freya 0.55                     " + 
"bvh.mini.Mjolnir 0.3                    " + 
"bvh.mini.Wodan 0.50                     " + 
"cf.mini.Chiva 1.0                       " + 
"ch.rhj.rbc.RHJ1 1.0                     " + 
"chase.pm.Pytko 1.0                      " + 
"cjk.Merkava 0.2.0                       " + 
"cjk.Merkava 0.3.0                       " + 
"cjm.Che 1.2                             " + 
"cx.mini.BlackSwans 0.60                 " + 
"cx.mini.Cigaret 1.31                    " + 
"cx.mini.Nimrod 0.55                     " + 
"davidalves.net.DuelistMini 1.1          " + 
"dcs.Eater_of_Worlds_Mini 1.0            " + 
"dft.Cyprus 3.0                          " + 
"dmsr.MiniR101 0.6                       " + 
"dummy.mini.Parakeet 2.40                " + 
"dvogon.GangBang 1.0                     " + 
"dz.GalbaMini 0.121                      " + 
"dz.OthoMini 0.15                        " + 
"eat.HumblePieLite 1.0                   " + 
"el.Attackr 0.1                          " + 
"eld.Hmm 1.0                             " + 
"fala.robocode.FalaRobot 1.0             " + 
"florent.small.LittleAngel 1.8           " + 
"fullsail.TimbotNoPrediction 1.0         " + 
"fw.Number1 1.0b                         " + 
"geep.mini.GPBotA 1.0                    " + 
"geep.mini.GPBotB 1.1                    " + 
"gh.mini.Gruwel 0.9                      " + 
"gio.RealGioBot 1.0                      " + 
"goblin.Bender 2.4                       " + 
"jam.mini.Raiko 0.43                     " + 
"japs.Sjonniebot 0.9.1                   " + 
"jekl.mini.BlackPearl .91                " + 
"jk.mini.CunobelinDC 0.4CT               " + 
"kanishk.Fr0z3n 1.1                      " + 
"kawigi.mini.Coriantumr 1.1              " + 
"kawigi.mini.Fhqwhgads 1.1               " + 
"kawigi.sbf.Barracuda 1.0                " + 
"kawigi.sbf.FloodMini 1.4                " + 
"kawigi.sbf.Teancum 1.3                  " + 
"kc.mini.Vyper 0.311                     " + 
"kcn.percept.PerceptBot 2.3              " + 
"krillr.mini.JointStrike 2.0.0           " + 
"m3thos.mini.Eva01 0.5.5                 " + 
"marksteam.Phoenix 1.0                   " + 
"mbh.Mbh 0.1                             " + 
"mbro.BelajarBot 0.0.3                   " + 
"mdouet.BotKicker 2.0                    " + 
"mladjo.AIR 0.7                          " + 
"mladjo.Grrrrr 0.9                       " + 
"mladjo.Startko 1.0                      " + 
"mwj.A1176183 1.0                        " + 
"nic.SnippetBot 1.0                      " + 
"nkn.mini.Jskr0 0.1                      " + 
"ntc.Evader 1.2                          " + 
"ntw.Sighup 1.5                          " + 
"oa.weak.BotherBot 0.1                   " + 
"oa.weak.FlyMk1 0.1                      " + 
"oog.mini.MagestyOfColors 0.1            " + 
"pak.Dargon .2c                          " + 
"pe.mini.SandboxMini 1.2                 " + 
"pe.minimelee.SandboxMiniMelee 1.1       " + 
"pez.mini.ChironexFleckeri 0.5           " + 
"pez.mini.Gouldingi 1.5                  " + 
"pez.mini.Pugilist 2.4.18                " + 
"pez.mini.Tityus 0.9.1                   " + 
"pez.mini.VertiLeach 0.4.0               " + 
"ph.mini.Archer 0.6.6                    " + 
"pkdeken.Paladin 1.0                     " + 
"radnor.RamRod 1.0                       " + 
"rsim.mini.BulletCatcher 0.4             " + 
"rz.Apollon 0.23                         " + 
"rz.GlowBlowAPM 1.0                      " + 
"rz.GlowBlowMelee 1.4                    " + 
"simonton.mini.WeeksOnEnd 1.10.4         " + 
"skm.PateranBotlock2 1.0                 " + 
"skm.Ryubot 1.0                          " + 
"sng.arco.Arco 0.0                       " + 
"stelo.Lifestealer 1.0                   " + 
"stelo.MatchupMini 1.1                   " + 
"stf.PanzerGeneral 0.1                   " + 
"synnalagma.test.MiniNeural 1.1          " + 
"timmit.mini.TimVA 0.43                  " + 
"tobe.mini.Charon 0.9                    " + 
"tornyil.Lajcsi2.Lajcsi2sm 1.0           " + 
"vft.Valkyrie 1.0                        " + 
"voidious.mini.Komarious 1.88            " + 
"wiki.mini.BlackDestroyer 0.9.0          " + 
"wiki.mini.GouldingiHT 1.0               " + 
"wiki.mini.Griffon 0.1                   " + 
"wiki.mini.Sedan 1.0                     " + 
"wit.Deep7 2.0                           " + 
"yk.JahRoslav 1.1                        " +
"WhoAmI.WhoAmI 1.00                      " +

"oog.nano.Caligula 1.15                  " +
"buba.Archivist 0.1                      " +
"buba.Buba 0.3                           " +
"cs.ExclusionNano 1.1                    " +
"eskimo.micro.Echo 0.1                   " +
"exauge.LemonDrop 1.6.130                " +
"gwah.GBotMarkIV 1.0                     " +
"gwah.GerryBotMkII 1.5.1                 " +
"hapiel.Spiral 0.1                       " +
"jf.Dodger 1.1                           " +
"mym.EdgeStalker 1.0                     " +
"NG.LegatusLegionis 1.2                  " + 
"povik.nano.Smilee 0.2.1                 " +
"rampancy.micro.Epiphron 1.0             " +
"SuperSample.SuperCrazy 1.0              " +
"timmit.micro.TimXJ 0.22                 " +
"exauge.GateKeeper 1.1.121g              " +
"exauge.Leopard 1.1.019                  " +
"ayk.WallHugger 1.0                      " +


END_OVERFLOW_BUFFER;


static final String LEAD_DEFAULT  =      "\u0028\u0028\u0028\u0028\u0028\u0020\u0010\u0000\ufff0\uffe8\u0020\u0010\u0000\ufff0\uffe8\u0020\u0010\u0000\ufff0\uffe8\u0020\u0010\u0000\ufff0\uffe8\u0020\u0010\u0000\ufff0\uffe8\u0020\u0010\u0000\ufff0\uffe8\u0020\u0010\u0000\ufff0\uffe8";
static final String LEAD_NONE     =      "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000";

	private static final String AimList = // Lead values per range
//                               Distance:    20    40    60    80    100   120   140   160   180   200   220   240   260   280   300   320   340   360   380   400   420   440   460   480   500   520   540   560   580   600   620   640   660   680   700   720   740   760   780   800    
/*default_fail_case                    */  ' ' + LEAD_DEFAULT + 
/*ad.last.Bottom 1.0                    */ LEAD_NONE +
/*ags.micro.Carpet 1.1                  */ "\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*ahf.Acero 1.0                         */ "\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0020\u0020\u0020\u0020\u0028\u0028\u0028\u0028\u0028\u0028\u0028\u0028\u0028\u0028\u0028\u0028\u0020\u0000\u0000\u0000\u0020\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*ahf.NanoAndrew .4                     */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000" +
/*amk.Punbot.Punbot 0.01                */ LEAD_NONE +
/*ap.Frederick 1.1                      */ "\u0012\u0012\u0012\u0012\u0012\u0012\u0019\u0002\u0023\u0002\u001b\u0002\u001b\u0002\u001b\u0002\u001b\u0002\u001b\u0002\u001b\u0002\u001b\u001b\ufffd\u001b\ufffd\u001b\ufffd\ufffd\ufffd\ufffd\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5" +
/*apv.MicroAspid 1.8                    */ "\u0000\u0000\u0000\u0000\ufff5\u0015\u0018\u0015\u0012\u001e\u0018\u001b\u0015\u0020\u0012\u0003\u0000\u001e\n\u0000\u000e\ufff5\ufff6\u000e\u0018\uffee\u0000\uffe8\u0012\u0006\u0003\u0000\ufff2\ufff6\u000b\u0000\u0000\u0000\ufff5\u0006" +
/*apv.NanoLauLectrik 1.0                */ "\u0000\u0000\u0000\u0003\n\u0018\u0000\u0006\u001e\u001e\u001e\u001e\u001b\u0000\u000b\n\u001b\u000e\u0015\u0012\u0012\uffee\u0000\u0000\u0000\ufff5\u000e\u0000\u0000\ufff6\ufffd\u0000\u0000\u0003\u0006\u0000\u0000\u0000\u0000\u0000" +
/*apv.NanoLauLectrikTheCannibal 1.1     */ "\u0020\u0020\u0025\u0025\u002f\u002f\u0028\u0028\u0028\u0026\u0026\u0026\u0026\u0026\u0026\u0026\u0026\u0026\u0026\u0023\u0023\u0023\u0023\u0023\n\n\n\n\n\n\n\n\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000" +
/*arthord.KostyaTszyu Beta2             */ "\u0000\u0000\u0006\ufffd\u000b\ufffd\u0015\u0015\u0003\u0018\u0012\u0003\u001b\u000b\u0018\u0018\u0006\u0020\ufff6\u0000\ufffd\u0012\ufff6\u000b\u0006\ufffd\u0000\u0012\ufffd\n\ufff5\ufffd\u0000\u000e\u0000\n\u0000\ufffd\u0000\u0000" +
/*arthord.MannyPacquiao Beta            */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0000" +
/*arthord.micro.Apoptygma 0.4           */ "\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*arthord.micro.Muffin 0.6.1            */ "\u0000\u0000\u0000\u000b\u0004\u0011\u001c\u0023\u0023\u0023\u001e\u001e\u001e\u001e\u001e\u001e\u001e\ufff5\u0018\u0006\u0018\u001b\u0020\u0000\u0000\u000e\u0003\ufffd\u0020\u0003\uffeb\u0003\u000b\ufffa\ufff5\uffee\ufff2\ufffd\u0000\u0000" +
/*arthord.NanoSatan Mu                  */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*arthord.NanoSatanMelee Beta           */ LEAD_NONE +
/*ary.micro.Weak 1.2                    */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0000" +
/*ary.nano.AceSurf 1.2                  */ "\u0003\n\u0003\n\u0003\n\u0003\n\ufffe\ufffe\u0020\ufffe\u0020\ufffe\u0020\ufffe\ufff6\ufff6\ufffa\ufffa\ufffd\u0000\u0000\u0000\u0000\ufff5\u0000\u000b\ufff5\u0000\ufffa\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*ary.nano.ColorNanoP 1.1               */ "\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\u0011\u0011\u0011\u0011\u0011\u0011\u0011\u0000" +
/*as.xbots 1.0                          */ "\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0009\u0009\u0009\u0009\u0009\u0009\u0009\u0006\u0000\u0000\u0000\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\r\r\r\r\r\r\r\r\u0000\u0000\u0000\u0000\u0000" +  
/*awesomeness.Elite 1.0                 */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\uffe8\uffe8\uffe8\uffe8\uffe8\uffe8\uffe8\uffe8\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000" +
/*baal.nano.N 1.42                      */ "\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000" +
/*banshee.micro.Nexus6 0.3.0            */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0007\u0007\u0006\u0006\u0007\u0007\u0006\u0000" +
/*bayen.nano.Squirrel 0.2               */ "\u001e\ufff7\u001e\ufff7\u001e\ufff7\u001e\ufff7\u0025\ufff7\u0025\ufff7\u0027\ufff7\u0027\ufff7\u0029\ufff7\u0029\ufff7\u0029\u0000\u0029\u0000\ufffe\ufffe\ufffe\ufffe\ufffe\ufffe\ufffe\ufffe\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*bayen.UbaMicro 1.4                    */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\u0000" +
/*bayen.UbaRamLT 1.0                    */ "\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\u0011\u0011\u0011\u0011\u0011\u0011\u0011\u0000" +
/*bbo.RamboT 0.3                        */ "\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*bons.NanoStalker 1.2                  */ "\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004" +         
/*bp.Kuma 1.0                           */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000" +
/*braaropolis.Abot 1.0                  */ "\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\uffef\uffef\uffef\uffef\uffef\uffef\uffef\u0000" +
/*bvh.micro.Freya 0.3                   */ "\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000" +
/*bvh.micro.Svadilfari 0.2              */ "\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*bzdp.BoxCar 2.0                       */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e" +
/*bzbp.Pansy 2.1                        */ "\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*caimano.Furia_Ceca 0.22               */ "\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0000" +
/*chase.c.Wristwatch 1.0                */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000" +
/*chase.o.Orbit 0.1                     */ "\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*chickenfuego.UrChicken2 1.0           */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*cjk.Merkava 0.1.1                     */ "\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000" +
/*cjm.Charo 1.1                         */ "\u0000\u0000\u0000\u0000\u001b\ufffd\u0015\u0003\u001e\u0020\u001b\u0020\u0020\u0020\u001e\n\u0020\u0021\u0000\u0020\u000b\u000b\u001e\uffe8\u0020\ufff5\ufff5\u0012\u0015\u0006\uffeb\u0015\ufff2\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*codemojo.nano.Woot 1.0                */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*cx.micro.Blur 0.2                     */ "\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0002\u0002\u0002\u0002\ufffd\ufffd\ufffd\ufffd\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000" +
/*cx.micro.Smoke 0.96                   */ "\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u001e\u0015\u0015\u001e\u001e\u001e\u0015\u001e\u0015\u001e\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*cx.micro.Spark 0.6                    */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\u0000" +
/*cx.nano.Smog 2.6                      */ "\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\u000e\u000e\ufff2\u0010\uffee\n\ufff6\ufff5\ufff5\u0010\u0010\u0010\u0010\u0010\u0008\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\u0000" +
/*davidalves.net.DuelistMicro 1.22      */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\ufffa\ufffa\ufff9\ufff9\ufffa\ufffa\ufff9\ufff9\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000" +
/*davidalves.net.DuelistMicroMkII 1.1   */ "\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\uffee\uffee\uffee\uffee\uffee\uffee\uffee\uffee\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0000" +
/*davidalves.net.DuelistNano 1.0        */ "\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0000" +
/*demetrix.nano.Neutrino 0.27           */ "\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\n\n\n\n\n\n\n\n\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000" +
/*demetrix.nano.SledgeHammer 0.22       */ "\u0025\u0025\u0025\u0025\u0025\u0025\u0013\u0013\u0013\u0013\u0013\u0011\u0011\u000f\u000f\r\r\u000b\u000b\u0009\u0009\u0009\u0007\u0006\u0013\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\u0000" +
/*dft.Freddie 1.32                      */ "\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\u0000" +
/*dft.Guppy 1.0                         */ "\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000" +  
/*dggp.haiku.gpBot_0 1.1                */ "\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0000" +
/*djdjdj.NanoSkunk10 1.0                */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0026\u0026\u0026\u0026\u0026\u0016\u0016\u0016\u0016\u0016\u0016\u000e\u000e\u000e\u000e\u000e\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\n\n\n\n\n\n\n\u0000" +
/*dks.MicroDanMK2 1.0                   */ "\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*DM.Mijit .3                           */ "\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0012\u001b\u0012\u001b\n\u0012\n\u0012\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*dmp.micro.Aurora 1.41                 */ "\u001d\u001d\u001d\u001d\u000b\u001d\u000b\u0021\u000b\u0021\u000b\u0021\u000b\u0021\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000" +
/*dmp.nano.Eve 3.41                     */ "\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000" +
/*donjezza.Jezza 1.0                    */ LEAD_NONE +
/*donjezza.Muncho 1.0                   */ LEAD_NONE +
/*drd.DreadKnoght 0.9                   */ LEAD_NONE +
/*dsw.StaticD 1.0                       */ "\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000" +
/*dukie.Ambassador 1.0                  */ "\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\n\n\n\n\n\n\n\n\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000" +
/*dummy.micro.HummingBird 2.14          */ "\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\uffee\uffee\uffee\uffee\uffee\uffee\uffee\uffee\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +   
/*dummy.micro.Sparrow 2.5               */ "\u0000\u0000\u0003\u000e\u000b\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u001e\u001e\u001e\u0015\u0015\u000b\u0018\n\u000e\u0012\u000e\u0012\u000e\u0012\u0015\n\u0018\u0018\ufff5\u0000\ufff2\u000b\u000e\u0003\u0000" +
/*dz.GalbaMicro 0.11                    */ "\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0000" +
/*dz.MostlyHarmlessNano 2.1             */ "\n\n\n\n\n\n\n\n\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*dz.OthoMicro 0.12                     */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\n\n\n\n\n\n\n\n\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000" +
/*el.JumpShoot 0.2                      */ LEAD_NONE +
/*el33t.EL33tGangstarr2 2.0             */ "\u0000\u0000\u0000\u0012\u0018\u0018\u0018\u001e\u001e\u001e\u001e\u001b\u001b\u001b\u001b\u001b\u0018\u0018\u0018\u0018\u0018\u0018\u0015\u0015\u0015\u0012\u0012\u0012\u0012\u0012\u0012\ufff2\u0006\ufff5\ufff5\u0000\u0000\u0000\u0000\u0000" +
/*elloco.Flower 0.1r1                   */ "\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0000" +
/*elvbot.ElverionBot 0.3                */ "\u0028\u0028\u0028\u0028\u0028\u0028\u0028\u0028\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0010\u0010\u0010\u0010\u0010\u0010\u0010\u0010\u0008\u0008\u0008\u0008\u0008\u0008\u0008\u0000" +
/*evd.X1 0.01                           */ "\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*fcr.First 1.0                         */ "\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\uffee\uffee\uffee\uffee\uffee\uffeb\uffeb\uffeb\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\u0000" +
/*Fenix.FenixTrack 1.0                  */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*fm.claire 1.7                         */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\ufffc\ufffc\ufffc\ufffd\ufffc\ufffc\ufffc\u0000" +
/*fm.mammillarias 1.3                   */ "\u0000\u0000\u0000\u0015\u001b\u001b\u001e\u001e\u001e\u001e\u001e\u001b\u001b\u001b\u001b\u0018\u0012\u0015\uffeb\uffee\uffee\ufff2\ufff5\ufff6\ufff6\ufffa\ufffa\ufffd\ufffd\u0000\u0000\u0000\u0000\u0003\u0000\u0003\u0006\u0006\u0000\u0000" +
/*fullsail.SweetTea 1.1                 */ "\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000" +
/*germ.TheMind .2                       */ "\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0000" +
/*gh.micro.Grinnik 0.7                  */ "\u0000\u0000\u0000\u0000\u0003\u001b\u0012\ufff5\ufff2\ufff2\u000b\u000b\u000b\u0013\u000b\u0013\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\n\n\n\n\n\n\n\n\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*gh.micro.GrubbmThree 0.9              */ "\u0025\u0025\u0025\u0025\u0025\u0025\u0013\u0013\u0013\u0013\u0013\u0011\u0011\u000f\u000f\r\r\u000b\u000b\u0009\u0009\u0009\u0007\u0006\u0013\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\u0000" +
/*gh.nano.Grofvuil 0.2                  */ "\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u001d\u0015\u001d\u0015\u001d\u0015\u001d\u0005\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*gio.RealGioBot 1.0                    */ "\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000" +
/*gu.MicroScoob 1.3                     */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\uffe5\uffe5\uffe5\uffe5\uffe5\uffe5\uffe5\u0000" +
/*ins.MobyNano 0.8                      */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*jab.micro.Sanguijuela 0.8             */ "\u0025\u0025\u0025\u0025\u0025\u0025\u0013\u0013\u0013\u0013\u0013\u0011\u0011\u000f\u000f\r\r\u000b\u000b\u0009\u0009\u0009\u0007\u0006\u0013\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\u0000" +
/*jam.micro.RaikoMicro 1.44             */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*janm.Jammy 1.0                        */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0000" +
/*japs.Serenity 1.0                     */ "\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000" +
/*jaw.KarenCain 0.11                    */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000" +
/*jaw.Mouse 0.11                        */ "\u0025\u0025\u0025\u0025\u0025\u0025\u0025\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\r\r\r\r\r\r\r\r\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0000" +
/*jcw.ArcherOne 1.0                     */ LEAD_NONE +
/*jep.nano.Hawkwing 0.4.1               */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*jep.nano.Hotspur 0.1                  */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0000" +
/*jgap.JGAP12584 1.0                    */ "\u0029\u0029\u0029\u0029\u0029\u0029\u0029\u0029\u0029\u0029\u0029\u0029\u0029\u0029\u0029\u0029\u0029\u0029\u0029\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0000" +
/*jgap.JGAP130166 1.0                   */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0000" +
/*jgap.JGAP23423 1.0                    */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\u0000" +
/*jgap.JGAP6139 1.0                     */ "\r\r\r\r\r\r\r\r\u0025\u0025\u0025\u0025\u0025\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003" + 
/*jgap.JGAP7247_2 1.0                   */ "\r\r\r\r\r\r\r\r\r\u0000\r\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0015\u0015\u0015\u0018\u0015\u0015\u0015\u0015\u0000\u0000\u0000\u0015\u0000\u0000\u0000\u0003\u0003" +
/*jgap.JGAP7958 1.0                     */ "\u0000\u0000\u0000\u0018\u0000\u0000\u0018\uffee\u0020\u0000\u0020\u0020\u0020\u0020\u0020\u0018\u0000\ufffd\u0000\ufffd\u0000\u0000\u0000\u0003\u0000\u0000\u0003\ufffd\u0003\u0003\u0015\uffee\u0000\n\u0000\u0000\u0000\u0000\ufff6\u0000" +
/*jk.micro.Toorkild 0.1.1               */ "\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*joe.ADinosaur 1.0                     */ "\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*jp.SineWall 1.0                       */ "\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0015\u0015\u0020\u0020\u0015\u0015\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0000" +
/*js.PinBall 1.6                        */ "\r\r\r\r\r\r\r\r\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0018\u0018\u0015\u0015\u0015\u0015\u0015\u0015\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000" +
/*jsal.Jsalbot 1.0                      */ "\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*jt.SpearmintCT Alpha                  */ "\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0000" +
/*kawigi.f.FhqwhgadsMicro 1.0           */ "\u0000\u0000\u0003\n\u0006\n\n\u0015\u001e\u001e\u001e\u0006\u000e\u0020\u0020\u0020\ufffd\u0020\u0020\u001e\ufff6\u0012\n\u001e\u000e\u0000\uffe5\u0018\uffee\u0018\uffeb\u000b\u001e\u0000\u0000\uffe8\ufff6\u0000\u0000\u0000" +
/*kawigi.micro.Shiz 1.1                 */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\n\n\n\n\n\n\n\n\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*kawigi.nano.FunkyChicken 1.1          */ "\u0011\u0011\u0011\u0011\u0011\u0011\u0011\u0011\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000" +
/*kawigi.nano.ThnikkaBot 0.9            */ "\u000b\u000b\u000b\u000b\r\r\u0011\u0011\r\r\r\r\r\u0011\u0011\u0011\u0011\u0011\u0011\u0015\u0015\u0015\u0011\u0011\r\r\r\r\r\r\r\r\u000b\u000b\u000b\u000b\u000b\n\n\u0000" +
/*kawigi.sbf.FloodMicro 1.5             */ "\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffe8\uffe8\uffe8\uffe8\uffe8\uffe8\uffe8\uffe8\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0000" +
/*kawigi.sbf.FloodNano 1.2              */ "\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*kc.micro.Needle 0.101                 */ "\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\n\u0020\n\u0020\u0010\u0020\u0010\u0020\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0000" +
/*kc.micro.Thorn 1.142                  */ "\u0000\u0000\u0000\u0000\ufffa\u0003\n\u0006\u0020\u0020\u0020\u0020\u001b\u000b\u0020\u0020\r\r\u0018\u000b\u000b\ufffa\ufff2\ufff2\u000b\u001e\u001b\ufff2\u0003\u0015\u0000\u0006\u000e\u0000\u0000\u0000\u000e\u0000\u0000\u0000" +
/*kc.micro.WaveShark 0.3                */ "\u0000\u0000\u0000\ufffd\ufffa\u0006\u0000\u000e\ufffd\u0012\u0020\ufff6\u001b\u0012\u0020\u0020\u0020\u0020\u000b\u001e\u000e\u0020\u000e\u0018\uffe2\u000e\u0006\u0015\ufff2\u0012\uffeb\uffeb\u0000\u0000\u000b\ufff2\u0000\u0000\u0000\u0000" +
/*kc.nano.Splinter 1.2                  */ "\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000" +
/*kinsen.nano.Hoplomachy 1.6            */ "\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0011\u0025\u0011\u0020\u0011\u0020\u0011\u0020\u0011\u0020\u0011\u0020\u0011\u0020\u0011\u0020\u0011\u0025\u0011\u0025\u0011\u0025\u0011\u0025\u0011\u0025\u0011\u0025\u0011\u0025\u0011" +
/*kinsen.nano.Quarrelet 1.0             */ "\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufffd\ufffc\ufffc\ufffc\ufffd\ufffc\ufffc\ufffc\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*kinsen.nano.Senticous 1.0             */ "\u0000\u0000\u0012\u0000\u0015\u001e\u000b\u0018\u0012\u0015\u0018\u0018\u0018\u0018\u0018\u0018\u0015\uffee\u0000\u0018\u0018\ufffa\ufff6\u0003\uffee\ufff5\u0006\ufffa\ufff5\u0000\ufffa\ufffa\u0003\u0000\u000b\ufffd\u0000\u0000\u0000\u0000" +
/*kjc.etc.Dharok 1.0                    */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000" +
/*kjc.Karaykan 1.0                      */ "\u0020\u0000\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0000\u0020\u0000\u0020\u0000\u0020\u0000\u0020\u0000\u0000\u0000\u0020\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*kjc.MailManX 2.0                      */ "\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*kurios.DOSexe .9                      */ "\u0029\u0029\u0029\u0029\u0029\u0029\u0029\u0029\u0004\u0004\u0004\u0004\u0000\u0000\u0000\u0000\u0000\u0000\u0004\u0004\u0004\u0004\u0004\u0004\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*leb.ShootAnArrow 0.1                  */ "\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0000" +
/*lechu.Lechu 1.1                       */ "\ufff2\u000e\ufff2\u000e\ufff2\u000e\ufff2\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u000e\ufff2\ufff2\ufff2\u000e\ufff2\ufff2\u0000" +
/*lion.Kresnanano 1.0                   */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0029\u0029\u0029\u0029\u0029\u0025\u0025\u0025\u0004\ufffc\u0004\ufff5\u000b\u000b\u0004\u0000\u0000\u0020\u0007\u0007\uffe0\uffe4\uffe8\u0000" +
/*lk.nano.Avesnar 1.1                   */ "\u0000\u0000\u0000\n\u001b\u001b\u001e\u001e\u0020\u0000\u0020\u0020\u0020\u0020\u0020\u0020\u001e\u0020\u0020\u001e\u001b\u001e\u001b\u0018\u001b\u0018\u0018\u0015\ufffa\u0018\u0018\ufff2\ufff6\u0012\u000e\ufffd\u0000\n\u0000\u0003" +
/*lrem.micro.FalseProphet Alpha         */ "\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*lrem.micro.MoggFanatic 0.2            */ "\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0011\u0011\u0011\u0011\u0011\u0011\u0011\u0011\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*lw.LuthersTest 0.1                    */ LEAD_NONE +
/*m3thos.Eva00 1.1                      */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0000" +
/*marcinek.TopGun 1.3                   */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0015\u0015\u0015\u0015\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*mbro.BelajarBot 0.0.3                 */ "\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\r\r\r\r\r\r\r\u0000" +
/*mbro.Detektor3 0.1.1                  */ "\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000" +
/*mc.Messapia 0.1.8                     */ LEAD_NONE +
/*mld.DustBunny 3.8                     */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0016\u0016\u0016\u0006\u0006\u0006\u0006\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0000" +
/*mld.Infinity 2.2                      */ "\u0000\u0000\u0000\u0000\u0000\u0000\u001e\u000b\n\u0003\u0003\n\u0003\u0006\n\n\u000b\u000b\u000b\u000e\u000b\u000e\u000e\u0012\u000b\u0012\u000e\u000b\u000e\u000e\u000e\n\ufffd\ufffa\n\n\u0012\n\u0003\u0003" +
/*mld.Moebius 2.9.3                     */ "\u0000\u0000\u0000\u0003\u0006\ufff6\u000b\u001e\u001e\u001e\u001e\u001e\ufff5\ufff6\u0015\u001b\u001e\ufff2\ufff2\u0018\ufffd\ufffd\u0003\u0000\ufffd\u0003\u0003\u0000\u0003\uffeb\ufffd\ufff6\uffeb\ufffa\ufff6\ufff6\ufffd\u0000\u0000\u0000" +
/*mld.Tide 1.2                          */ "\u0025\u0025\u0025\u0025\u0025\u0025\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*mld.Wisdom 1.0                        */ "\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0011\u0011\u0011\u0011\u0011\u0011\u0011\u0000" +
/*mme.NikeEnhanced 2.0                  */ "\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0000" +
/*mrm.MightyMoose .2                    */ "\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*myl.micro.Avipes 1.00                 */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0023\u001e\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*myl.micro.NekoNinja 1.30              */ "\u0000\u0000\u0000\u0000\u0000\u001b\u0003\u000b\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u000e\u0012\u0012\n\u000e\u0018\u0015\u0003\u0015\u0000\u0003\u0003\u0000\uffeb\u0006\ufff2\u0015\u0006\u0003\u0003\u0000\u0000" +
/*myl.micro.Predator 1.50               */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000" +
/*myl.micro.Troodon 1.10                */ "\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u0000" +
/*myl.nano.Graviton 1.10                */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0000" +
/*myl.nano.Kakuru 1.20                  */ "\u0003\u0003\u0003\u0023\u0023\u0023\u0023\u0023\u0023\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0000" +
/*myl.nano.KomoriNinja 1.1              */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\"\u0020\u001e\u001c\u001a\u0018\u0016\u0015\u0013\u0011\u000f\r\u000b\u0011\u0011\u0011\u0011\r\r\r\r\r\r\r\r\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\u0000" +
/*mz.Adept 2.65                         */ "\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\u0000" +
/*mz.AdeptBSB 1.03                      */ "\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\u0000" +
/*mz.Movement 1.8                       */ "\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*mz.NanoDeath 2.56                     */ "\u0025\u0025\u0025\u0025\u0025\u0025\u0013\u0013\u0013\u0013\u0013\u0011\u0011\u000f\u000f\r\r\u000b\u000b\u0009\u0009\u0009\u0007\u0006\u0013\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\u0000" +//"\u0025\u0025\u0025\u0025\u0025\u0025\u0013\u0013\u0013\u0013\u0013\u0011\u0011\u000f\u000f\r\r\u000b\u000b\u0009\u0009\u0009\u0007\u0006\u0013\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\u0000" +
/*mz.NanoGod 2.02                       */ "\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0000" +
/*nanoskank.NanoSkank 1.0               */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\n\n\n\n\n\n\n\n\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +               
/*nat.micro.NP 1.34                     */ "\u0000\u0010\u0020\u0000\u0010\u0020\u0000\u0010\u0020\u0000\u0010\u0020\u0010\u0000\u0010\u0000\u0010\u0020\u0000\u0010\u0020\u0000\u0010\u0020\u0000\u0010\u0020\u0000\u0010\u0020\u0000\u0010\u0020\u0000\u0010\u0020\u0000\u0010\u0020\u0000" +
/*nat.micro.Reepicheep 0.1a             */ "\u0013\u0013\u0013\u0013\u0013\u0013\u0013\u0013\u000f\u000f\uffed\u000f\u000f\u000f\u000f\u000f\u000f\u000f\u000f\u000f\u000f\u000f\u000f\u0013\u0013\u0013\u0013\u0013\u0013\u0013\u0013\u0013\u0013\u0013\u0013\u0013\u0013\u0013\u0013\u0000" +
/*nat.nano.Ocnirp 1.73                  */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*nat.nano.OcnirpPM 1.0                 */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0000\u0000\u001e\u001e\u001e\u001e\u001e\u001e\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*nat.nano.OcnirpSNG 1.0b               */ "\u0000\u0000\u0000\u0003\u0015\u001b\u0018\ufff2\u000e\u001e\u001e\u001e\u000e\u001e\u000e\u001b\u0003\u0000\uffeb\u0006\u0000\ufff5\ufffd\u0006\u0000\u000b\u001e\uffe8\n\u000e\u0000\u000b\n\u0003\u0000\u0000\u0000\u0000\u0000\u0000" +
/*ndn.DyslexicMonkey 1.1                */ "\u001c\u001c\u001c\u001c\u001c\u001c\u0013\u0009\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0000" +
/*nexus.Prototype 1.0                   */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\r\r\r\r\r\r\r\r\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\u0000" +
/*nova.Snow 1.0                         */ "\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\uffee\uffee\uffee\uffee\uffee\uffee\uffee\u0000" +
/*ntc.Cannon 1.12test                   */ "\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u001e\ufffd\u0013\ufffd\u0013\ufffd\u0013\ufffd\u0013\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*ntc.Knowledge 1.1                     */ "\u000b\u000b\u000b\u000b\u000b\n\n\u0021\n\u0021\n\u0021\n\n\n\n\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u000e\u0011\u0011\u0011\u0011\u0011\u0011\u0011\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0000" +
/*ntc.Plains 0.9                        */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u000e\u0012\u000e\n\u000e\u000b\u000b\u000b\u0012\u0000\ufff6\ufffd\u0000\u0003\u0006\n\uffeb\u0003\ufffd\uffee\u0000\u0000\u0000\u0000" +	 
/*ntw.Sigsys 1.6                        */ "\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\u0000" +
/*ntc.Swim 0.9                          */ "\u0000\u0000\u0015\u0023\u0023\u0015\u0008\u0023\u0000\u0015\u0000\u0015\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0000\u0015\u0000\u0015\u001e\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffa\ufffa\ufffa\u0000" +
/*nz.jdc.micro.HedgehogGF 1.3           */ "\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\u000e\u0011\u0011\u0011\u000e\u0011\u0011\u0000" +
/*nz.jdc.micro.HedgehogP 1.2            */ "\u001b\u001b\u001b\u001b\u001b\u000b\u0020\u000b\u0020\u000b\u0000\u000b\u0020\u0000\u000b\u0020\u0000\u000b\u0020\u0020\u0000\u000b\u0020\ufffa\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0000" +
/*nz.jdc.nano.NeophytePattern 1.0       */ "\u0000\u0000\u0000\ufffd\ufffa\ufff6\ufff5\u0003\u0020\ufffa\u0020\ufff6\ufff5\u001e\u0020\ufff6\u000e\u001e\u0000\ufffd\u0000\u0000\u0015\ufffd\ufff5\ufff2\uffee\uffe5\ufff5\u0000\u0003\uffe5\u0006\u0000\uffee\u0000\u0003\u0000\u0000\u0000" +
/*nz.jdc.nano.NeophytePRAL 1.2          */ "\u0000\u0000\u0000\ufffd\u000e\n\u001e\u0003\u0020\ufffa\ufff6\ufff6\ufff5\u001e\u001e\ufff6\uffee\u0020\uffe8\ufffd\ufffd\u0000\u0003\u0003\u0003\u0003\u0003\u0003\ufffd\ufffd\ufffa\u0000\u0000\ufffd\ufff6\u0000\uffe5\u0000\u0000\u0000" +           
/*nz.jdc.nano.NeophyteSRAL 1.2          */ "\u001e\u001e\u001e\u001e\u001e\u001e\ufffa\u001e\ufffa\u001e\ufffa\u001e\ufffa\u001e\ufffa\u001e\ufffa\u001e\ufffa\u001e\ufffa\u001e\ufffa\u001e\ufffa\u001e\u001e\u001e\u001e\u001e\u001e\u001e\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000" +
/*oog.melee.Capulet 0.1                 */ "\r\r\r\r\r\r\r\r\u0000\u0010\u0000\u0010\u0000\u0010\u0000\u0010\u0010\u0018\u0010\u0018\u0010\u0018\u0010\u0018\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0000" +
/*oog.melee.CapuletDroid 1.0            */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000" +
/*oog.melee.Mercutio 1.0                */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0000\u001e\u0000\u001e\u0000\u001e\u0000\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012" +
/*oog.melee.StarLight 0.1               */ "\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0000\n\u0000\n\u0000\n\u0000\u0028\u0021\u0021\u0021\u0021\u0021\u0021\u0021\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u0000" +
/*oog.micro.MagicD3 0.41                */ "\u0010\u0010\u0010\u0010\u0010\u0010\u0010\u0010\ufff8\u0010\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000" +
/*oog.micro.Maui 1.1                    */ "\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u0000\u001d\u0000\u001d\u0000\u001d\u0000\u001d\u0000\u001d\u0000\u001d\u0000\u001d\u0000\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000" +
/*oog.micro.SavantMicro 0.31            */ "\u0020\u0020\u0020\u0020\u0008\u0008\u0020\u0010\u0000\u0010\u0020\u0000\u0010\u0020\u0000\u0010\u0020\u0000\u0010\u0020\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*oog.nano.Fuatisha 1.0                 */ "\u0000\u0000\u0000\ufffd\u0006\r\r\u0011\u000e\u0000\u0020\r\u0000\u001e\u001b\u001b\ufff2\r\r\r\r\r\r\r\r\r\ufff2\u0003\u0000\ufff2\ufffd\uffe0\ufff5\uffe2\ufff6\u0000\u0000\u0000\ufff5\u0000" +
/*oog.MagicD2 2.4                       */ "\n\n\n\n\n\n\n\n\u0019\u0019\u0019\u0019\u0019\u0019\u0019\u0019\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000" +
/*oog.nano.SavantVS 1.1                 */ "\u0009\uffef\u0009\uffef\u0009\uffef\u0009\uffef\u0025\uffef\u0000\u0023\u0011\u0018\u0000\u0000\u0000\u0000\u0016\u0000\u000b\u0000\u000b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*oog.nano.SavantWS 1.1                 */ "\u0009\uffef\u0009\uffef\u0009\uffef\u0025\uffef\u0013\u0023\u0000\u0023\u0011\u0018\u0000\u0000\u0000\u0000\u0016\u0000\u000b\u0000\u000b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*pa.Improved 1.1                       */ "\r\r\r\r\r\r\r\r\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*pak.Dargon 1.0b                       */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000" +
/*pak.JakeTheTestingRobot .1b           */ "\u0011\u0011\u0011\u0011\u0011\u0011\u0011\u0011\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*paolord.TheHulk 1.0                   */ "\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*pb.Oscillator 1.0                     */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0000" +
/*pez.micro.Aristocles 0.3.7            */ "\u0000\u0000\u0000\u0000\u0000\u0006\u001e\u001e\u0012\u001e\u001e\u0003\u000e\u001e\u0020\u0020\u000b\u0020\ufffa\u0006\u0018\u001e\u0020\u001b\u001e\u001e\u0000\ufff6\u0000\u0012\ufff6\ufff2\uffe2\u001b\ufff5\u0000\u0000\u0000\u0000\u0000" + 
/*pez.nano.Icarus 0.3                   */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000" +
/*pez.nano.LittleEvilBrother 0.1        */ "\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*pfvicm.Sobieski 7.2.3b                */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000" +
/*ph.micro.Pikeman 0.4.5                */ "\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007" +                  
/*PkKillers.PkAssassin 1.0              */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0000" +
/*pmc.SniperBot 1.0                     */ "\u0008\u0000\u0008\u0000\u0008\u0000\u0008\u0000\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\u0008\u0008\u0008\u0008\u0008\u0008\u0008\u0000" +
/*projectx.ProjectNano 2.0              */ "\u000b\u000b\u000b\u000b\r\ufff3\u0011\uffef\r\ufff3\r\ufff3\r\uffef\u0011\u0011\u0011\u0011\u0011\u0015\u0015\u0015\u0011\u0011\r\r\r\r\r\r\r\r\u000b\u000b\u000b\u000b\u000b\n\n\u0000" +
/*projectx.TestNano 1.0                 */ "\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*pulsar.Nanis 0.3                      */ "\u0004\u0004\u0004\u0029\u0029\u0004\ufff5\u0029\ufff5\u0029\ufff5\u0029\ufff5\u0029\ufff5\u0029\u0000\u0029\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*pulsar.PulsarNano 0.2.4               */ "\u0020\u0020\u0020\u0020\u0020\u0020\u0020\n\u0029\n\u0029\n\u0015\u0020\u0015\u0020\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*quietus.Invader 0.1                   */ "\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0006\ufff6\ufffb\ufff6\ufffb\ufff6\ufffb\ufff6\ufffb\u0003\u0006\u0002\u0000\u0002\u0000\u0002\u0002\u0000\u0002\u0002\u0000\u0000\u0000\u0000\u0000\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000" +
/*quietus.NarrowRadar 0.1               */ LEAD_NONE +
/*radnor.DoctorBob 1.42                 */ "\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\ufffb\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*ratosh.nano.Debo 1.36                 */ "\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\uffef\uffef\uffef\uffef\uffef\uffef\uffef\u0000" +
/*ratosh.Nobo 0.21                      */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\uffe8\uffe8\uffe8\uffe8\uffe8\uffe8\uffe8\uffe8\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000" +
/*ratosh.Wesco 1.4                      */ "\u0000\u0000\u0000\u0015\u0006\u000b\u0012\u0015\n\u000e\u0012\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u001e\u0020\u0020\u0020\u000b\u0020\u0012\u0006\u0006\ufffd\u000e\u0003\ufffd\u0018\u0018\u0012\u0018\u0018\u0018\u0000" + 
/*rcp.Kuramatron 1.0                    */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*repositorio.NanoStep 1.0              */ "\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\n\n\n\n\n\n\n\u0000" +
/*robo.PartsBot 1.0                     */ "\u0018\u0018\u0018\u0009\u0009\r\ufff1\u000f\ufff1\u000f\ufff5\u0008\u0005\u0005\u0002\u0002\ufffd\ufffd\ufffd\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*robar.haiku.Spike 1.0                 */ "\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\u0000" +
/*robar.micro.Gladius 1.15              */ "\u0011\u0011\u0011\u0011\u0011\u0011\u0011\u0011\u0020\u0020\u0020\u0020\u0020\u001b\u001b\u001b\uffee\uffee\uffee\uffee\uffee\uffee\uffee\uffee\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000" +
/*robar.micro.Kirbyi 1.0                */ "\u0000\u0000\u000b\u0000\u0015\u0000\u0000\u001b\n\u0000\u001b\u0018\u0000\ufff5\u000b\ufffa\u001b\u000b\ufff2\u0012\ufffd\u0000\ufff5\u0000\u0018\u0000\ufffd\ufffd\ufffd\u0000\ufffa\u000b\ufffa\ufffa\ufff5\u0006\u0000\u0003\u0000\u0000" +
/*robar.micro.Topaz 0.25                */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u000b\ufff5\u000b\ufff5\u000b\u000b\ufff5\ufff5\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*robar.nano.Assertive 0.3              */ "\u001c\u001c\u001c\u001c\u0018\ufff8\u0000\u0018\u0008\u0018\u0000\u0000\u001d\ufff8\u0000\u0018\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\u0000" +
/*robar.nano.BlackWidow 1.3             */ "\u0000\u0000\u0000\u0006\ufffa\u001e\ufff2\u000b\ufff5\u0020\u0020\u0020\u000b\ufff5\u001b\u001b\ufffa\uffee\u000b\u0000\u000b\n\u000b\u000b\u000b\u000b\u000b\u0006\uffeb\ufffd\ufff2\uffee\u0000\u0000\ufff6\u000b\u0000\u0000\u0000\u0000" +
/*robar.nano.Breeze 0.3                 */ "\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000" +
/*robar.nano.Mosquito 1.1               */ "\u0023\u0023\u0013\u0013\u0013\u001c\ufffc\u0023\ufffc\u0023\ufffc\u0023\u0023\u0023\u0023\u0023\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\u0000" +
/*robar.nano.MosquitoPM 1.0             */ "\u0000\u0000\u0000\ufffd\ufffa\n\n\u0003\u001e\ufffd\u0020\u0020\u0002\u001e\ufff6\ufffa\u0015\u0000\ufffa\u000e\u0000\u0000\u0000\ufff5\uffeb\u0000\u0000\n\uffe8\ufffd\u000e\u0003\ufffd\ufffd\ufff5\ufff6\u0000\u0003\u0000\u0000" +
/*robar.nano.Prestige 1.0               */ "\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*robar.nano.Pugio 1.49                 */ "\u0000\u001d\u0000\u001d\u0000\u001d\u0000\u001d\u0000\u001e\ufff8\u001d\ufff8\u001e\u0000\u001e\u0000\u0012\u0000\u0012\u0012\u0012\u0012\u0012\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\u0000" +
/*robar.nano.Scytodes 0.3               */ "\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\u0000" +
/*robar.nano.Vespa 0.95                 */ "\u0000\u0000\u0000\u0006\u0006\u0003\u000b\u0012\u0012\u0012\u0018\u0015\u0015\u0015\u0015\u000e\u0015\n\u000e\ufff2\u0018\u000e\u0012\u000b\u000b\uffeb\ufff2\u000e\ufff5\u0015\uffeb\ufff6\u000e\ufff2\ufff2\u0000\ufff6\u000e\u0000\u0000" +
/*rsim.micro.uCatcher 0.1               */ LEAD_NONE +
/*ruc.nano.Zealot 0.2                   */ "\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0000" +
/*ry.LightningBug 1.0                   */ "\u0003\u0003\u0003\u001e\u0003\u001e\u0003\u001e\u0003\u001e\u0003\u001e\u0003\u001e\u0003\u001e\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000" +
/*ry.Worst 1.0                          */ LEAD_NONE +
/*rz.Artist 0.2                         */ "\u0000\u0000\u0000\u000b\u0018\u000e\u000b\u000b\u0006\u001b\u0003\u0006\u000b\u0012\u0012\n\u001b\u001e\u0023\u0023\u0012\u0018\u0003\u0023\u0020\u000b\u0023\ufff6\uffe5\ufffa\u001e\u0020\u001e\uffe5\u0000\ufff6\u0000\u0000\u0000\u0000" +
/*rz.GlowBlow 2.31                      */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0000" +
/*rz.HawkOnFire 0.1                     */ "\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u002b\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0000" + 
/*rz.SmallDevil 1.502                   */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000" +
/*sam.Samspin 1.0                       */ "\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\r\r\r\r\r\r\r\r\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\u0000" +
/*sgp.nano.FurryLeech 1.0               */ "\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\u0000" +
/*sgp.ShiningBeetle 1.1                 */ "\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000" +
/*sgp.SleepingGoat 1.1                  */ "\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\r\r\r\u000b\u000b\u000b\u000b\u000b\u000b\u001b\u000b\u001b\u000b\u001b\u000b\u001b\ufffa\ufffa\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0000" +
/*simonton.GFNano_D 3.1b                */ "\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\u0000" +
/*simonton.micro.GFMicro 1.0            */ "\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\n\n\n\n\n\n\n\n\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0000" +
/*simonton.micro.WeeklongObsession 3.4.1*/ "\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\r\r\r\r\ufff3\ufff3\ufff3\ufff3\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\u0000" +
/*simonton.nano.WeekendObsession_S 1.7  */ "\u0010\u0010\u0013\u0013\u0013\u0013\u0013\u0013\u0010\u0010\u0010\u0010\r\r\r\r\r\r\r\r\r\r\r\r\r\r\u0000\u0000\r\r\u0000\u0000\u0000\u0000\u0000\u0008\u0000\u0000\u0000\u0000" +
/*spinnercat.haiku.Refrigerator 1.1     */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0004\u0003\u0003\u0003\u0004\u0003\u0003\u0000" +
/*spinnercat.CopyKat 1.2.3              */ "\u0028\u0028\u0028\u0028\u0028\u0020\u0020\u0018\u0020\u0018\u0010\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0018\u0018\u0018\u0018\u0018\u0018\u0010\u0010\u0010\u0010\u0010\u0010\u0010\u0010\u0008\u0008\u0008\u0008\u0008\u0008\u0008\u0000" +
/*spinnercat.Kitten 1.4                 */ "\u0028\u0028\u0028\u0028\u0028\u0028\u0028\u0028\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0010\u0010\u0010\u0010\u0010\u0010\u0010\u0010\u0008\u0008\u0008\u0008\u0008\u0008\u0008\u0000" +
/*spinnercat.Limit .01                  */ LEAD_NONE +
/*stelo.FretNano 1.1                    */ "\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0000\u0000\u0020\u0020\u0000\u0000" +
/*stelo.MatchupMicro 1.2                */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0000" +
/*stelo.MirrorMicro 1.1                 */ "\u0028\u0028\u0028\u0028\u0028\u0028\u0028\u0028\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0010\u0010\u0010\u0010\u0010\u0010\u0010\u0010\u0008\u0008\u0008\u0008\u0008\u0008\u0008\u0000" +
/*stelo.MirrorNano 1.4                  */ "\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u0008\u0008\u0008\u0008\u0008\u0008\u0008\u0008\u0008\u0008\u0008\u0008\u0008\u0008\u0008\u0008\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*stelo.MoojukNano 1.2                  */ "\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0000\u0000\u0000\u0020\u0000\u0000\u0000\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000" +
/*stelo.PatternRobot 1.0                */ LEAD_NONE +
/*stelo.PianistNano 1.3                 */ "\u0000\u0000\u001e\u001e\u001e\u0012\u0010\u0008\u0008\u0008\u0010\u0010\u0016\u0010\n\u0006\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\ufffa\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*stelo.SteloTestNano 1.0               */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\u0000" +
/*stelo.UnfoolableNano 1.0              */ "\u0000\u0000\u0000\u0012\u001e\u000b\u001e\u0020\u0020\u0020\ufffd\ufffa\ufff6\ufff6\ufff6\ufff6\ufff6\u0015\ufffd\u0012\u0000\u0003\u0003\u0006\n\u0006\u0000\uffeb\u0000\ufffd\uffee\u0000\u0000\ufffa\ufff2\ufffa\u0000\u0000\u0000\u0000" +
/*stelo.UntouchableNano 1.4             */ "\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0000" +
/*step.NanoBidu 1.0                     */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000" +
/*step.nanoPri 1.0                      */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\"\"\"\"\"\"\"\"\u001c\u001c\u001c\u001c\u0009\u0009\u0009\u0009\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000" +
/*strider.Festis 1.2.1                  */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +  
/*strider.Mer 1.1.0                     */ "\u0000\u0000\u000b\u0015\u0000\u001b\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001b\u001b\u001b\u0018\uffe8\uffeb\uffee\uffee\ufff2\ufff2\ufff5\ufff5\ufff6\ufff6\ufffa\ufffd\ufffd\u0000\u0000\u0000\u0000\u0000\u0003\u0003\u0003\u0003\u0000" +
/*sul.Bicephal 1.2                      */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\"\"\"\"\"\"\"\"\u001c\u000f\u000f\u000f\u000f\u000f\u0009\u0009\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000" +
/*sul.BlueBot 1.0                       */ "\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\n\n\n\n\n\n\n\u0000" +
/*sul.NanoR2 1.32                       */ "\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\ufff6\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\ufffd\ufffc\ufffd\ufffc\ufffc\ufffc\ufffc\ufffc\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000" +
/*sul.Pinkbot 1.1                       */ "\r\r\r\r\r\r\r\r\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000" +
/*stuff.Vlad 0.1                        */ "\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\r\u0020\u0020\u0020\u0020\u0020\u0020\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0008\u0008\u0008\u0008\u0008\u0008\u0008\u0000" +
/*timmit.nano.TimCat 0.13               */ "\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*timmit.nano.TimDog 0.33               */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000" +
/*tlp.ThreeLeggedPig 1                  */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*tobe.calypso.Calypso 4.1              */ "\u0000\u0000\u0006\u0000\ufffd\u0018\u0000\u0015\u001e\u001e\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u001e\u0020\u0020\u0020\ufffa\u001e\ufff5\ufff6\ufff2\ufff6\u0000\u0000\u0000\u0000\ufff2\ufffa\u0000\u0000\u0003\u0000\u0000\u0000" +
/*tornyil.bottomup.BottomUp 1.05        */ "\u0000\u0000\u0000\u0012\u0000\u0018\u0003\u0015\u0000\u0020\u0018\u0020\u0015\u0003\u0006\u000b\u0015\n\u0012\n\n\n\u0000\u0015\uffe8\u0000\ufff6\ufffd\ufffa\n\ufffd\uffe5\ufff2\uffe8\n\ufffd\u000e\u0000\u0000\u0000" +
/*toz.Gnome 1.1                         */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\r\r\r\r\r\r\r\r\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\u0000" +
/*trab.nano.AinippeNano 1.3             */ "\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000" +
/*usa.nano.Nemo 2.0                     */ "\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000" +
/*vft.Hrist 1.0                         */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0000\u0000\n\n\n\n\n\n\n\n\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0000" +
/*vft.Valkyrie 1.0                      */ "\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0000" +
/*voidious.micro.Jen 1.11               */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u000b\u000b\u000b\u000b\u001b\u000b\u001b\u000b\u001b\u000b\u001b\u000b\u001b\u000b\u001b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0000" +
/*wiki.nano.DevilFISH 1.0               */ "\r\r\r\r\u0016\u0016\u0016\u0016\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0011\u0011\u0011\u0011\u0011\u0011\u0011\u0011\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\uffeb\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0000" +
/*wiki.nano.RaikoNano 1.1               */ "\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0000" +
/*winamp32.micro.MicroMacro 1.0         */ "\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u001d\u0025\u0025\u0025\u0025\u0025\u0025\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0000" +
/*yarghard.Y101 1.0                     */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0025\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*yk.JahMicro 1.0                       */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\ufff9\u000b\u000b\u000b\u000b\u000b\u000b\u000b\u0000" +
/*zch.David 0.21                        */ "\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0006\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*zch.Hirkan 0.11                       */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0012\u0012\u0012\u0012\u0012\u0012\u0012\u0012\uffee\uffee\uffee\uffee\uffee\uffee\uffee\u0000" +
/*zyx.micro.Ant 1.1                     */ "\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\ufff2\r\r\r\r\r\r\r\r\r\r\r\r\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufff3\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0000" +
/*zyx.nano.Ant 1.1                      */ "\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0015\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u0018\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u000e\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\ufff5\u0000" +
/*zyx.nano.EscherichiaColi 1.0          */ "\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\n\n\n\n\n\n\n\u0000" +
/*zyx.nano.RedBull 1.0                  */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\ufffc\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +

/*ahf.r2d2.R2d2 0.86                    */ "\u0000\u0000\u0000\u0000\u001b\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0023\u0020\u0000\u001b\u000e\u001e\u001e\ufffd\uffee\u0023\ufff6\u0000\u0000\u0000\u0000\u0000" +
/*AIR.iRobot 1.0                        */ "\u0000\u0000\u0000\u0000\u0000\u000e\u000e\u0000\u0018\u001e\u0020\u0020\u0020\u0020\u0020\u000b\ufffd\u0023\u0003\u000b\u001e\u001b\n\u0006\ufff6\ufff6\u000e\u0015\u0006\u0000\u0003\ufff2\u0000\n\u0003\n\u0000\u0018\u0000\u0000" +
/*amk.ChumbaMini 0.2                    */ "\u0000\u0000\u0000\u0000\u001b\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0018\u0023\u0020\u0020\u0020\u0020\u0020\u0015\n\u0012\u000b\u001b\u000b\u0023\u0018\u0006\u0012\u0000\u001e\uffe5\u001b\u0000\u001b\u0000\u0000\u0000\u0000\u0000" +
/*amk.jointstrike.JointStrike 0.2       */ "\u0000\u0000\u0000\u0000\u000b\u000e\u0003\n\u0015\u0012\u0018\u0003\u0018\u0000\u0000\u0003\u0000\u0003\u0000\u0000\u0006\u0000\u0006\u0000\u0000\u0000\n\n\u0000\ufffa\u0000\u0000\uffee\ufff6\u0000\u0000\u0003\u0000\u0000\uffe8" +
/*apv.Aspid 1.7                         */ "\u0000\u0000\u0000\u0000\u000b\u001e\u0018\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0023\u000b\u0020\u001e\u0012\u000b\uffee\u000b\u000b\u000e\uffe8\ufff2\ufffd\u000b\u0000\uffee\u000b\ufffa\u0000\ufff6\u0000\u0000\n\u0000\u0000\u0000" +
/*apv.AspidReloaded 0.6                 */ "\u0000\u0006\u0000\u000e\u000b\u0012\u0018\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0023\u0020\u0018\u000b\u0015\n\ufff5\u0015\u0006\u000b\u0006\u0003\u0000\uffeb\uffeb\ufff2\u0000\ufff2\ufff2\ufff2\u001b\u0000\u0000\uffeb\u0000\u0000" +
/*ar.QuantumChromodynamics 1.2.1        */ "\u0000\u0000\u0000\n\u0000\u0000\u0015\u0003\n\u0000\u0000\u0006\u000b\u0006\ufffd\u0006\u0000\ufffd\u0006\u0006\u001e\u000b\u0012\n\ufff5\u001b\u0012\uffe5\u0000\u0000\ufffd\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*ary.mini.Nimi 1.0                     */ "\u0000\u0000\u0000\u0000\u0006\u0006\u001e\u001b\u0006\ufffd\u001e\n\u0020\u0020\n\u0020\u0012\u0003\u0020\u001e\ufffd\u001e\n\u0015\uffe5\uffe2\u0012\uffe8\u0000\uffe5\uffe8\u0015\ufff6\uffe8\uffee\ufffa\u0003\u0015\u0000\u0000" +
/*banshee.mini.Nexus6 0.2.0             */ "\u0000\u0000\u0000\u0000\u0012\u0018\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u001e\u001e\u001e\u001e\u001e\u001e\u001b\u001b\u001e\u001b\u0018\uffeb\u001b\u0015\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*bbo.TheRoof 1.4.3                     */ "\u0000\u0000\u0000\u0000\n\u0015\u0006\n\u000e\u000e\u0015\u000b\u0018\u0018\u001b\u0018\u001b\u001b\u0012\u001b\u0012\u001b\u000e\u0018\u0012\u000e\u0015\u0015\u0018\u0018\u0015\u000b\u0012\u000e\u001b\u0012\u0006\u0018\u0012\u001b" +
/*bvh.hdr.Hodur 0.4                     */ "\u0000\u0000\u0000\u0018\u001b\u001b\u001e\u001b\u001b\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u001e\u001e\u001e\u0018\u0015\u0000\u0018\u0015\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*bvh.mini.Fenrir 0.39                  */ "\u0000\u0000\u0000\u0000\u000b\u0018\u001e\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u000b\ufffa\ufff6\ufff6\u0003\ufff5\ufffd\u0003\u0012\u0000\u0000\uffee\u0000\ufff2\ufff6\ufff2\u0000\u0000\u0000\u0000\u001e\uffee\u0000" +
/*bvh.mini.Freya 0.55                   */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0012\n\uffeb\u001e\u001e\u0020\u001b\u001b\u001b\u0018\u0018\u0018\u000e\u0000\u0003\u0003\u0006\u0000\u0000\u0003\ufff2\u0003\u0000\n\uffee\n\ufff5\ufffa\ufff5\u0000\u0000\u0000\u0000" +
/*bvh.mini.Mjolnir 0.3                  */ "\u0000\u0000\u0000\u000e\u0015\u001e\u001e\u0020\u001e\u0020\u0020\u0020\u0020\u0023\u001e\u001e\u0020\ufffd\u0000\u001e\u001b\u0000\u0003\ufffa\uffe8\ufffd\u0000\ufff5\u0000\n\u0003\u0000\u0000\u0000\u0000\n\u0000\u0000\u0000\u0000" +
/*bvh.mini.Wodan 0.50                   */ "\u0000\u0000\u0000\ufffa\u0000\ufffd\ufffd\ufffa\u001e\u0020\u0020\u0020\u0020\u0020\u0023\u0020\u0020\u0023\u0020\ufffd\u0015\n\u0000\ufffd\u0000\u0018\uffe8\u001b\uffe8\u0020\u000e\ufff6\u0006\u0000\ufff6\u0000\u0000\u0000\u0000\u0000" +
/*cf.mini.Chiva 1.0                     */ "\u0000\u0000\u0000\u000b\u0000\u0000\u0003\u0003\u0000\ufffa\u001e\u0000\u001e\u001e\u000b\u0020\u000e\u000e\u000e\u0012\u001b\u001e\u001e\u0015\u0000\u0023\u001e\u0018\u001e\uffe5\u000e\uffeb\u0018\u0015\u0003\ufff2\uffe5\u001b\u0000\u0000" +
/*ch.rhj.rbc.RHJ1 1.0                   */ "\u0000\u0000\u0000\u0000\u0006\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\u0006\u0000\u0003\u0003\ufffd\ufffd\u000b\u0003\n\n\u000b\ufffd\u0003\u0003\u0000" +
/*chase.pm.Pytko 1.0                    */ "\u0000\u0000\u0000\u000b\u0000\ufffa\u0006\ufffd\u0003\u0015\u0018\u0020\u0012\u0012\u0006\n\u0006\u0003\n\u0000\n\n\ufffd\u000e\u0003\uffe2\u001b\ufffa\u0000\u0015\u000e\u0000\u0012\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*cjk.Merkava 0.2.0                     */ "\u0000\u0000\u0000\u000e\u0015\u001b\u0015\u0018\u001e\u0012\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u000b\n\u001b\u0003\ufff6\u001b\u000b\uffeb\ufffa\ufffd\u0000\u0003\ufffd\n\u0000\ufff5\ufff5\uffee\uffee\u0003\u0000\u0000" +
/*cjk.Merkava 0.3.0                     */ "\u0000\u0000\u0000\u000e\u001b\u001b\u0018\u001b\u0000\u0015\u0020\u001b\u0023\u001e\u0023\n\u0023\n\u000b\u000e\u000b\u000e\u000e\u000b\u000e\u000e\u000e\u001e\u0006\u000b\u000e\ufff5\n\n\u0000\u0000\u000b\ufffd\u0003\u0003" +
/*cjm.Che 1.2                           */ "\u0000\u0000\u0000\u0000\u0018\u0018\ufff6\u0018\u001b\u0020\u0015\u0020\u0020\u0003\u0020\u0018\u0018\ufffd\u0018\u000b\u000e\u0015\u0020\uffeb\u0000\u0000\uffeb\u0000\ufffd\u0006\u0000\ufff2\ufff6\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*cx.mini.BlackSwans 0.60               */ "\u0000\u0000\u0000\u0000\u0000\n\ufff6\u000b\u0000\u0018\u0015\u001b\u0015\u0018\u001e\u000b\u001b\u001b\u001e\u001e\u0000\u0020\u0018\u001e\u001b\u0000\u000b\ufffd\ufffd\u000b\uffeb\ufff6\uffeb\u000b\ufffd\u0000\u0003\u0003\u0000\u0000" +
/*cx.mini.Cigaret 1.31                  */ "\u0000\u0000\u0000\u0000\u0000\u0003\u0018\u001e\u001e\u0020\u0015\u0018\u0018\u0018\u001b\u0015\u001e\u001b\u001e\u001b\u0018\u0012\u0006\ufffd\u001b\u0003\u001e\uffe0\ufff5\u0000\u000b\ufff6\uffe8\u000e\ufffd\ufff5\ufffa\u0000\u0000\ufffd" +
/*cx.mini.Nimrod 0.55                   */ "\u0000\u0000\u0000\u0000\u0000\u000b\u0012\ufff5\u0006\u000e\u000e\u0015\u000e\u0012\u0018\u001b\u0018\u0012\u0012\u0018\u0000\u0000\u0003\u0000\u0003\u0018\u0000\u0018\u000b\u0003\u0000\ufffd\ufffa\u0003\ufff6\uffeb\ufffd\ufffa\u0000\u0003" +
/*davidalves.net.DuelistMini 1.1        */ "\u0000\u0000\u0000\u0000\u0000\u001b\u0012\n\u000b\u0020\u0020\u0020\u0023\u0023\u0023\u0023\u0020\u0023\u0023\u001b\u0023\n\ufff6\ufff5\u0018\u0006\ufff6\ufffa\ufff2\ufffd\u0003\u0000\u0003\ufff2\u0006\uffe0\u0018\u0000\u0000\u0000" +
/*dcs.Eater_of_Worlds_Mini 1.0          */ "\u0000\u0000\u0000\u0000\u0018\n\u0006\u0003\u001e\u0020\u001e\n\u0003\u0006\u0006\u0000\u0003\u0000\u0003\u0000\u0000\u0006\ufff6\u0003\ufffd\u0003\n\u0006\u000b\u000b\ufff2\ufff5\ufff2\u0000\u0000\n\u0000\u0000\u0000\u0000" +
/*dft.Cyprus 3.0                        */ "\u0000\u0000\n\ufffd\u0018\u001b\u001e\u001e\u001e\u0020\u0015\u0015\u0018\u0018\u0018\u0018\u001b\u001b\u001b\u001b\u0006\u0015\uffe8\u001b\u001e\ufff2\uffeb\ufffa\uffee\ufffd\ufffd\uffeb\u0018\uffe8\u0000\u0000\uffe8\ufff2\ufff6\u0000" +
/*dmsr.MiniR101 0.6                     */ LEAD_NONE +
/*dummy.mini.Parakeet 2.40              */ "\u0000\u0000\u0006\u000b\u000b\n\u0000\u0018\u0000\u0006\u0012\u000b\u0018\u000e\u0018\u000e\u000e\u0012\u000e\u0012\ufffd\u0006\ufffd\u000e\ufff6\ufffd\uffeb\u0000\u0000\ufff5\ufff6\u0000\ufffa\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*dvogon.GangBang 1.0                   */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u001e\u0020\u001e\u001e\u0020\u0000\u001b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0003\u0000\u0003\u000b\u0000\u0000\u0000\u0003\n\u000e\u0003\u0003\u0003\u000e\n\u0000" +
/*dz.GalbaMini 0.121                    */ "\u0000\u0000\u0000\u0000\ufffd\u000e\u0000\u000b\u001b\u001e\u0018\u0015\u001e\u0003\u001e\ufff6\u0018\u001e\n\u0018\u0003\u001b\ufff5\ufffd\u0015\uffeb\u0000\uffe2\ufff2\u0006\u0000\u0018\u0000\uffe8\ufff5\u0000\ufff5\u0000\u0000\uffee" +
/*dz.OthoMini 0.15                      */ "\u0000\u0000\u0000\u0000\ufffa\ufff6\ufff5\ufff5\u000e\u0012\u001e\u0018\u000e\u001e\u001e\u001e\u001b\u0018\u0012\u0003\u001e\uffe5\ufffa\u0012\u0006\u001b\uffeb\ufff2\u0015\ufff5\u0015\u0000\ufff6\u0000\ufffa\n\u0000\u0000\u0000\u0000" +
/*eat.HumblePieLite 1.0                 */ "\u0000\u0000\u0000\u0015\u000b\u0000\ufffa\uffeb\u0006\n\u001b\u0015\u0018\u0015\u000b\ufff6\ufff5\n\ufffd\u000e\u0000\ufff5\ufff5\u0000\ufff5\u0003\u0006\ufffd\ufff5\ufffd\ufff2\u0003\ufff6\ufffd\u0003\ufff5\u0000\u000e\u0000\u0000" +
/*el.Attackr 0.1                        */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\n\u0003\ufffa\ufffd\ufffd\u0012\ufff2\ufffd\ufffa\ufffa\u0000\ufff2\ufff2\u000e\u0000\u0006" +
/*eld.Hmm 1.0                           */ "\u0000\u0006\u0012\u0006\u0018\u001b\u001e\u001e\u001e\u0020\u0020\u0020\u0020\u001e\ufff2\u001e\u001b\u0020\ufffa\u0000\ufffd\uffeb\u0000\u0006\ufffa\u0003\ufffd\ufff2\u0000\u000b\u0000\ufffa\u0006\u000b\uffee\u0000\u0000\u0000\u0018\u0000" +
/*fala.robocode.FalaRobot 1.0           */ "\u0000\u0000\u0000\n\u000e\u0003\u000e\u000b\n\ufff6\u0000\u0000\ufffd\ufffd\ufffd\ufffd\ufffa\u0003\ufffd\u0000\ufffa\ufffd\ufff6\u0000\u0000\ufffa\u0000\ufffd\ufffa\u0000\ufffd\ufffd\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*florent.small.LittleAngel 1.8         */ "\u0000\u0000\u0000\u0000\u0006\n\u0006\u001e\u0020\u0020\u0006\u0020\u001e\u0012\u0020\u0020\u0020\u0012\u000e\u0023\u0006\u0023\u0006\u0015\u000b\u000e\u0023\u0000\u001e\u0012\u0018\u0003\u0012\uffe5\u001e\u001e\u001b\u000b\u0000\u0000" +
/*fullsail.TimbotNoPrediction 1.0       */ "\u0000\u0000\u0000\u0018\u001b\ufffd\u001e\u0006\u0020\u001e\u0018\u001e\u0000\u0000\u0000\ufffa\u0003\u0000\uffeb\uffeb\u0015\ufff6\ufffd\ufff6\ufffd\u0000\ufffa\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0003\u0000\u0000\u0000\u0000\u0000" +
/*fw.Number1 1.0b                       */ "\u0000\u0000\u0000\u0012\u001b\u001b\u001e\u001e\u001e\u001e\u0015\u001e\u001e\u0018\u000e\u000b\ufffd\ufffd\n\n\ufffa\u0006\u0006\n\n\u0006\u0006\u0003\n\ufff5\u0006\u0000\n\u0000\ufffa\u0006\u0000\ufff6\u0000\u0000" +
/*geep.mini.GPBotA 1.0                  */ "\u0000\u0000\u0000\u0012\u0018\u0012\u0012\u0012\u0015\u0015\u0018\u0015\u0018\u001e\u001e\u0023\u0023\u0020\u0023\u0023\u000e\u000e\u000b\u000e\u000e\u000e\u0012\u0012\u001b\u0015\u0020\u0015\u0018\u0006\ufff5\u001b\uffee\ufff5\u0003\u0015" +
/*geep.mini.GPBotB 1.1                  */ "\u0000\u0000\u0000\u0000\u0018\u0006\u0000\u0000\u0000\u0000\u0003\u0003\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u0018\u0012\u001b\u001b\u0006\ufffa\ufffa\u0018\u0006\u0000\u0006\u0000\ufff6\u0000\ufffa\ufffd\ufff6\u0000\u0000\u0000" +
/*gh.mini.Gruwel 0.9                    */ "\u0000\u0000\u0015\u0000\u001b\u001e\u001e\u001e\u0018\u0020\u0020\u001e\u0018\u0018\u001b\u001b\u001e\u001b\u0015\u0018\u001b\u0003\u0006\ufff5\ufffd\u0000\u0000\n\u0006\u0000\u000b\ufffd\n\u0003\ufffd\u0000\u0000\u0000\u0000\u0000" +
/*gio.RealGioBot 1.0                    */ "\u0000\u0000\u0000\u0015\u0015\u001e\u001e\u001e\u001e\u0020\u0020\u0020\u001b\u0020\u0020\u001e\u001e\u001e\u001e\u001e\u001e\ufffa\u0015\u001b\u0006\ufff5\u0003\u0000\u0003\uffeb\u0012\u0000\ufff6\ufff2\u0006\uffeb\u0006\uffeb\n\u0003" +
/*goblin.Bender 2.4                     */ "\u0000\u0000\u0000\u000b\u0018\u001b\u001e\u0000\u0020\u0020\u0020\u0020\u0020\u0020\u0000\u0020\u0000\u0000\u0020\u0000\u0020\u0000\u0000\u0000\u0000\u0020\u0000\u0003\u0018\u0000\u0000\u0000\u0000\u0000\u000b\u0000\u0000\u0000\u0000\u0000" +
/*jam.mini.Raiko 0.43                   */ "\u0000\u0000\u0000\u0000\ufff6\u0012\u001e\ufffd\u0018\u001b\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0012\u001b\u0015\ufffa\n\ufffd\u0015\u001b\u0000\u0006\ufff2\ufff5\uffee\ufff5\uffe0\u0012\ufff6\ufff6\u0000\u0000\u0000\u0000" +
/*japs.Sjonniebot 0.9.1                 */ "\u0000\u0000\u0000\n\n\n\u0015\u0015\u000e\u0012\u000b\u000b\n\u000e\u0012\u000e\u000e\u000b\u000e\u000b\u000e\u000b\u000e\u0003\u0006\u000b\u0000\ufff5\ufffd\n\ufffa\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*jekl.mini.BlackPearl .91              */ "\u0000\u0000\u0000\u0006\u0015\ufffd\u000e\n\u0020\u001e\u000b\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0003\u000b\u0012\u0020\u0020\u0000\n\u0000\uffe5\u0000\u000e\u000e\u0000\n\n\u0000\u0003\u0000\u0000\ufffa\u0000\u0000" +
/*jk.mini.CunobelinDC 0.4CT             */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0018\ufffa\u001e\ufffa\u0020\u0020\u0023\ufffd\u0018\u0018\u0003\uffeb\uffee\uffee\u0018\uffe8\u0018\uffe2\u000b\u0012\u000b\ufffd\uffeb\u0012\u0018\u001e\u0000\uffeb\u0000\u0000\u0000\u0000\u0000\u0000" +
/*kanishk.Fr0z3n 1.1                    */ "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0012\u0012\u0012\u000e\u000e\u000b\u000b\u000b\u000e\u000b\ufff5\u000b\u000b\u000e\u0012\ufffd\u000e\u0000\n\ufff2\ufff5\u0012\u0000\u0000\ufffd\ufff6\ufff5\ufffd\ufffa" +
/*kawigi.mini.Coriantumr 1.1            */ "\u0000\u0000\u0000\n\u0012\ufffd\u0015\ufffa\u0018\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0000\u0020\u0020\u0003\ufff5\u0018\ufff5\ufffd\n\uffee\ufff5\ufffa\uffe5\ufff2\uffee\u0000\uffe8\uffeb\u001e\u0000\u0000\u0000" +
/*kawigi.mini.Fhqwhgads 1.1             */ "\u0000\u0000\u000b\u0006\u0006\u000e\u0015\u0012\u000b\u0012\u0012\u001e\u0003\u001e\u001e\u0018\ufff5\ufffa\u0000\u0015\u000e\u0015\ufffa\ufff5\u001b\u000b\u0003\uffeb\uffe8\u001b\ufff2\u0015\n\u0003\ufff6\u0000\u0000\u0000\u0000\u0000" +
/*kawigi.sbf.Barracuda 1.0              */ "\u0000\u0000\u0000\n\u0012\n\u0000\ufff6\ufffd\ufffa\u0003\u001e\ufff6\u0003\ufff6\ufff6\u0000\u0000\ufffa\u000b\ufff5\u000b\u001b\u0020\uffe5\uffee\uffe8\u0000\u0000\uffe5\uffe5\ufff2\ufffa\ufff5\u0000\u0000\u0000\u0000\u0000\u0000" +
/*kawigi.sbf.FloodMini 1.4              */ "\u0000\u0000\u000e\u0006\u0000\n\u001e\u0003\u0000\u001e\ufff6\ufff5\u001e\ufff6\ufff6\uffee\ufff6\u0000\u0020\uffeb\uffeb\uffeb\u0020\u001e\uffe5\u0000\uffe8\ufff5\ufff5\uffe8\u0000\ufff6\uffee\u0015\u0003\uffee\ufff2\u0012\u0018\u0000" +
/*kawigi.sbf.Teancum 1.3                */ "\u0000\u0000\u0000\u000e\u000b\n\u0006\u0000\u0000\u001e\ufff6\ufff5\ufff2\ufff5\u0018\u0015\ufff6\ufff6\u000b\ufff5\u0018\u0015\u0018\u001b\uffeb\uffee\u0003\uffee\uffee\ufff2\uffe8\ufffa\uffee\u0000\ufff5\u0000\u0000\ufff6\u0000\u0000" +
/*kc.mini.Vyper 0.311                   */ "\u0000\u0000\u0000\u0000\ufffd\ufff5\ufff6\u001b\u0006\u0006\u0012\u0020\u0020\u0020\u0020\u0020\u0020\u0000\ufffa\u0003\ufffd\ufff6\n\ufff6\uffee\u0003\u0000\uffe2\ufff6\ufff5\u0018\u0000\u0003\u0000\u0000\u0000\ufff5\u0000\u0000\u0000" +
/*kcn.percept.PerceptBot 2.3            */ "\u0000\u0000\u0000\u0000\u0003\u0000\u0003\u0003\u0006\u001b\u0000\u0000\u0000\u0000\u0018\u0018\u0020\u001e\u0020\u000e\u0020\u000e\u001e\u001e\ufffa\u001b\u0015\u000e\uffe8\u0015\ufffd\u001e\ufff2\uffe5\u001b\u0000\u0000\u0000\u0000\u0000" +
/*krillr.mini.JointStrike 2.0.0         */ "\u0000\u0000\u0000\u0000\u0012\ufff2\ufff2\n\u0018\u0020\u000b\u001e\u0018\u0020\u0015\u000e\u0003\u0000\u0000\ufffd\u000e\ufffa\uffe2\uffee\n\u0003\ufffa\u0000\ufffa\u0006\n\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*m3thos.mini.Eva01 0.5.5               */ "\u0000\u0000\u0003\u000b\u0018\u000e\u000e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u001e\u001b\u001e\u001b\u001b\u001b\u0018\u0018\u0018\u001b\u001b\u0018\u0018\u001b\u0000\ufff6\u0000\ufffd\u0015\u0000\u0003\u0000\u0000\uffe5\u0000" +
/*marksteam.Phoenix 1.0                 */ "\u0000\u0000\u0000\u0000\u0000\u0006\ufff6\u000b\ufff2\ufff2\u0012\u000e\ufff2\u000b\ufff5\ufff6\ufffa\ufffd\u0000\u0000\u0000\u0000\ufff2\u0000\ufffd\u0003\n\uffeb\n\ufffa\ufffa\uffee\u0000\ufffa\ufffa\u0000\u0000\u0000\u0000\u0000" +
/*mbh.Mbh 0.1                           */ "\u0000\u0000\u0000\u0000\u001b\u001b\u001e\u001e\u0020\u0020\u0020\u0020\u0020\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0003\u0003\u0000\u0003\u0000\ufffd\u0000\u0000\u0000\u0000\u0003\u0000\u0000\u0000\u0000\u0000\u0000" +
/*mbro.BelajarBot 0.0.3                 */ "\u0000\u0000\u0000\n\u001b\u001b\u000e\u0018\n\u001e\u001b\u001b\u001b\u001e\u001e\u001e\u001e\u001e\u001e\u0000\u000e\ufff5\u0015\ufff2\ufff5\ufff5\u0015\u0000\ufffd\ufff5\uffeb\u0000\uffeb\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*mdouet.BotKicker 2.0                  */ "\u0000\u0000\u0000\u0015\u000e\u0012\u0015\u0015\u001b\u0018\u0018\u001b\u001b\u0018\u0018\u0018\ufff2\ufff2\uffee\u0018\uffee\ufff2\uffee\u0000\u0003\ufffd\n\ufff2\u0003\u0000\ufffd\u0012\uffeb\uffe5\ufffa\ufff6\u0000\u0000\u0000\u000b" +
/*mladjo.AIR 0.7                        */ "\u0000\u0000\u0000\u000e\u0015\u001b\u0015\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0015\u0023\u0023\u001e\ufffd\n\u001e\u0003\u0018\u0003\uffe2\ufff6\u0000\uffe0\u0003\ufffd\ufff5\u0000\uffe8\u0000\u0000\u0000\ufffa\ufff6\u0000\u0000" +
/*mladjo.Grrrrr 0.9                     */ "\u0000\u0000\u0000\u0000\u001b\u0006\u000e\u001b\u0018\u001b\u001e\u0020\u0018\u0020\u0020\u0012\u0012\ufffd\u0012\n\u0018\u001b\n\u000b\ufff6\uffeb\ufffd\u001e\u0012\u0018\u000b\ufff2\uffee\u0000\u0000\u0012\ufff5\u0000\u0000\u0000" +
/*mladjo.Startko 1.0                    */ "\u0000\u0000\u0000\u0000\u000e\ufffa\u000b\u001e\u0020\u0020\u001e\u0018\u0018\n\u0000\uffee\u0012\u0012\uffeb\ufffd\u0000\uffee\ufff2\ufff5\u0000\u0003\ufff2\u0006\uffee\ufff2\u0000\ufff2\n\ufffa\ufffa\ufff5\u0000\u0000\u0000\u0000" +
/*mwj.A1176183 1.0                      */ "\u0000\u0000\u0000\u0000\u0018\u001b\u001e\u0000\u0000\u0020\u0020\u0020\u0000\u0000\u0023\u0023\u0023\u0023\u0020\u0023\u0000\u0006\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffd\u0000\u0000\u0000\uffee\uffee\u0020\ufff6\ufff5\u0018" +
/*nic.SnippetBot 1.0                    */ "\u0000\u0000\u0000\u0018\n\u0003\u0000\u0012\u000e\u001b\u0018\u001b\u0012\u0000\uffee\u0015\u0006\u0003\ufff2\n\u0006\ufffd\ufffa\ufffd\u0000\u0000\u0000\u0003\u0003\u0000\u0000\u0000\u0006\u0006\u0000\u0000\u0000\u0003\u0000\u0000" +
/*nkn.mini.Jskr0 0.1                    */ "\u0000\u0000\u0006\ufffd\u0012\u000b\u001b\u001e\u0020\u0000\u0020\u0020\ufff6\u0020\u0020\ufffa\u0020\u0000\u0020\u0023\ufff6\u0006\u0023\n\u001e\n\u0003\u0018\u0015\uffee\u0000\uffe2\u000b\u0000\ufff5\u0000\u0000\u0000\u0000\u0000" +
/*ntc.Evader 1.2                        */ "\u0000\u0000\u0000\u0000\ufffd\ufffd\u000b\n\n\n\u0006\u0006\u0006\u0006\u0006\n\uffee\u000b\u000b\ufff2\ufff2\ufff2\u000e\ufff2\ufff5\u000e\ufff2\ufff5\u000b\uffee\uffee\uffee\n\u0000\u0000\ufff5\u0000\u0000\u0000\ufff6" +
/*ntw.Sighup 1.5                        */ "\u0000\u0000\u0000\n\u0000\u001b\u001e\u0000\u0020\u0000\u0000\u0000\u0000\u0000\u0000\u0003\u0000\u0000\u000b\u0006\u0000\ufffd\u0003\u0003\u0003\n\n\u0006\u0006\ufff6\u000b\u0003\u0003\ufff2\u0000\ufff5\ufff5\u0000\u0000\u0000" +
/*oa.weak.BotherBot 0.1                 */ LEAD_NONE +
/*oa.weak.FlyMk1 0.1                    */ "\u0000\u0000\u0000\u0015\u0018\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uffeb\u0000\uffee\u0000\ufffd\uffee\u0000" +
/*oog.mini.MagestyOfColors 0.1          */ "\u0000\u0000\u0000\u0000\u000b\n\u000e\u000b\u0000\ufffd\ufffa\ufff6\ufff6\ufff6\u0012\u001b\ufffa\u000e\u0006\ufffa\u0012\ufffd\u0003\u0000\u0003\u0015\u0003\u0000\ufff5\n\u0000\u0000\u0000\u0000\u0000\ufffa\u0000\u0006\u0000\u0000" +
/*pak.Dargon .2c                        */ "\u0000\u0000\u0000\u0000\u0015\u0015\u0003\u0000\u0006\u0000\u0000\u0000\u0000\u0000\u0006\u0000\u0000\u0000\u0000\u0000\u0006\u0000\ufffa\u0000\u0000\u0000\ufffa\u0000\ufff6\u0000\ufff6\u0000\u0003\ufffd\u0000\u0003\ufffd\u0003\ufffd\u0000" +
/*pe.mini.SandboxMini 1.2               */ "\u0000\u0000\u0000\u0000\ufffa\n\n\u0000\n\u0000\u0003\u0003\u0006\u000b\u0000\n\n\u0018\uffe5\uffe5\ufffd\ufffa\u0000\ufff2\u0000\u000b\u0003\u0000\u0003\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*pe.minimelee.SandboxMiniMelee 1.1     */ "\u0000\u0000\u0000\u0000\u0006\ufffd\u0003\u000b\u0003\u0012\u0003\u0003\u0015\u0003\u0006\u0003\u0012\u000e\uffee\u0000\n\u0000\u0006\u0006\n\ufffd\ufff6\ufff5\u0000\u0000\u000b\u000e\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*pez.mini.ChironexFleckeri 0.5         */ "\u0000\u0000\u0000\u0018\u001b\u001e\u001e\u0020\u0003\u0000\u0020\u0020\ufff6\ufff6\u0023\u0023\ufffa\u0023\u0020\u0023\u0023\u0020\u0023\u0003\u001e\ufffd\u001e\u0000\ufffd\u0003\u0000\u0000\uffe8\ufffd\u001b\u0000\u0000\u0000\u0000\u0000" +
/*pez.mini.Gouldingi 1.5                */ "\u0000\u0000\u0000\u0000\u000b\ufff6\u000e\u0018\u0018\u0000\u0015\u0003\u0020\u0012\u0020\u0020\u0018\u001b\u0012\u000e\u0015\u001b\u000e\u001b\u000e\ufffd\u0003\n\u0006\ufff5\u0000\u0015\uffe5\u001e\u000b\u0000\ufff5\u0000\u0000\u0000" +
/*pez.mini.Pugilist 2.4.18              */ "\u0000\u0000\u0015\u0000\u001b\u0000\u001e\u0006\u0020\u0020\ufffd\ufff6\u0020\ufff6\u0023\n\u000e\u0023\u0023\u0023\u0006\u0023\ufff6\uffe8\u0000\uffe8\u001b\ufffa\u000e\uffeb\u0018\u0015\u000e\uffe2\u0012\u0018\u0000\u0000\u0000\u0000" +
/*pez.mini.Tityus 0.9.1                 */ "\u0000\u0000\u0000\u0000\ufffd\ufff5\u001e\u001e\u0020\u0003\u0012\u0020\u001e\n\u0015\u0023\u000e\u0023\u000b\u0000\u0015\ufffa\u0015\ufff6\u000b\u0000\ufffd\u0006\ufffd\ufffd\u001e\u0020\ufff5\u0023\uffe5\u0006\u0000\u0000\u0000\u0000" +
/*pez.mini.VertiLeach 0.4.0             */ "\u0000\u0000\u0000\u0018\u001b\u001b\u001e\u001e\u0020\u0018\u0020\u0020\ufff5\u001e\ufff6\uffee\ufff6\u0020\u0015\u0000\ufff6\u001b\u0000\uffee\u0018\u0000\u0018\ufff6\u000e\n\u0000\u0000\uffe2\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*ph.mini.Archer 0.6.6                  */ "\u0000\u0000\u0000\u0000\u0006\u0006\u0000\u0000\u000e\u0012\u0000\u0003\n\u0003\u0006\u000e\ufffa\u0012\u001b\u0020\u000b\u0000\u000e\u0012\u0018\u0018\uffe8\ufffa\uffeb\ufff5\u0018\u0000\uffe5\u001b\u0000\u001e\u0000\u0000\u0000\u0000" +
/*pkdeken.Paladin 1.0                   */ "\u0000\u0000\u000b\u000b\u0015\u0018\u0018\u001e\u0015\u0015\u0015\u001e\u001e\u001b\u001e\u001b\u001e\u001b\u001e\u001e\u001b\u0012\u001b\u001e\u001e\ufff6\u001e\uffe8\uffe8\ufff6\ufffd\u0000\uffee\ufff5\uffe8\u0000\u0000\u0000\u0000\u0000" +
/*radnor.RamRod 1.0                     */ "\u0000\u0000\u0000\u0003\u0000\u0003\u0000\u0003\ufffd\u0003\ufffd\ufffd\u0000\ufffd\ufffd\u0006\ufffd\u0006\ufffd\n\u0003\ufffa\u0003\u0000\u0000\u0000\u0000\u0006\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" +
/*rsim.mini.BulletCatcher 0.4           */ LEAD_NONE +
/*rz.Apollon 0.23                       */ "\u0000\u0000\u0000\u0018\ufffd\u000b\u0003\u001b\uffee\u0018\u0003\u001b\u001b\u0012\u001e\u0023\u0023\u0023\u0015\u0023\u000e\u0015\u000e\u000b\u001e\u000e\u0020\u000e\uffe2\n\u0000\uffe0\u0000\u0000\u0000\u0000\u0018\u0000\u0000\u0000" +
/*rz.GlowBlowAPM 1.0                    */ "\u0000\u0000\u0000\u0000\n\u001b\u0003\u0018\u001b\u001e\ufffd\u0020\ufff6\u0020\u001e\u001e\u0020\u0020\u0020\u001e\u001b\u001e\u001b\u0015\u0018\uffee\uffe5\uffe8\ufff5\uffeb\u0006\ufffa\ufff2\uffee\uffe5\u0000\u0000\u0000\u0000\u0000" +
/*rz.GlowBlowMelee 1.4                  */ "\u0000\u0000\u0000\u0000\u0000\ufff6\ufff2\u001b\u001b\u000b\u0006\u0020\u0020\u0015\u000e\u0012\u0015\u0012\u0018\u0015\u0012\u0015\u0015\u0018\u0012\u0015\ufff2\u0012\u0000\u000b\uffe8\uffee\u0006\uffee\u0015\uffe8\uffe5\u0006\u001b\ufff2" +
/*simonton.mini.WeeksOnEnd 1.10.4       */ "\u0000\u0000\u0000\u0000\u0003\u0000\ufffd\n\u001b\u000e\u0006\u0006\u001b\ufff5\u001e\u0020\u000b\u0023\u0006\uffeb\u001e\u0006\u0006\u000b\u0003\ufff2\ufffa\u000b\ufffa\uffe5\u0003\uffeb\ufff6\ufffa\uffe8\u0006\u000e\u0015\u0000\u0000" +
/*skm.PateranBotlock2 1.0               */ LEAD_NONE +
/*skm.Ryubot 1.0                        */ LEAD_NONE +
/*sng.arco.Arco 0.0                     */ "\u0000\u0000\u0003\u0012\u000e\u001b\u001e\n\u0012\n\u0003\u0006\u0000\u0000\u0000\u0006\u0003\ufffd\ufffd\u0000\n\u0003\u0000\u0003\u0000\ufffd\ufff2\uffeb\u0003\u000e\ufff2\u0000\ufffd\u0000\u0003\ufffd\u0000\u0000\u0000\u0000" +
/*stelo.Lifestealer 1.0                 */ "\u0000\u0000\u0000\n\u000e\u000e\u001e\u001e\u001e\u001e\u001e\u0018\u001b\u001b\n\ufffa\u001b\u0006\u0000\u0000\u0000\ufffd\n\ufff6\ufffa\u0006\n\ufff6\u0012\u0000\ufffd\u0018\ufffd\ufffd\u0012\u0000\u0000\u0000\u0000\u0000" +
/*stelo.MatchupMini 1.1                 */ "\u0000\u0000\u0000\u0000\u0003\u0000\u000e\ufffd\n\u0000\u0000\u0012\u0006\u0006\n\u000b\u0015\u000e\u0003\ufff6\u0000\u0015\ufffa\u0006\u0000\u000b\u000e\u000e\u0006\n\ufffa\u0000\u0000\ufffa\n\u0000\u0000\u0000\u0000\u0000" +
/*stf.PanzerGeneral 0.1                 */ "\u0000\u0000\n\u0015\u0018\u0018\u0018\u0018\u0018\u0015\u0015\u0018\u0018\u0018\u001b\u0015\u0000\u0015\ufff6\u0015\u0015\u001b\u0012\u001b\u0018\u0018\u000e\u0003\u000b\uffe8\u001b\uffe8\u0000\u000e\u0000\u0000\u0000\u0000\u0000\u0000" +
/*synnalagma.test.MiniNeural 1.1        */ "\u0000\u0000\u000e\u0012\u0015\u0006\u0018\u0015\u0018\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\ufff5\ufff6\uffee\u000b\uffee\u0000\ufff2\ufff2\u0006\ufffd\ufffa\ufff5\u000b\u0006\uffee\n\ufff6\u0000\u0000" +
/*timmit.mini.TimVA 0.43                */ "\u0000\u0000\u0000\u000b\u0018\u0000\u001b\u001b\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u001b\u0023\u001e\u0023\u0000\ufff6\u0018\u000e\u0003\uffeb\u0000\ufff6\uffeb\u0012\uffeb\u000b\ufff2\ufffa\u0000\u0000\uffee\u0000\u0000" +
/*tobe.mini.Charon 0.9                  */ "\u0000\u0000\u0000\u0006\u000e\u0018\ufffd\u000b\u0015\u0012\u0015\u0018\u0000\u0020\u0003\u001e\u0020\u0018\u0012\u001b\u001e\u0006\u0000\u0003\u0018\u0000\u0012\ufffa\ufffa\u0018\u0003\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0012\ufffa" +
/*tornyil.Lajcsi2.Lajcsi2sm 1.0         */ "\u0000\u0000\u0000\u0015\u001b\u001b\u001e\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0020\u0023\u0023\u0023\u0023\u0015\u0023\u001e\u000b\u001b\u001e\u0000\u0018\u0003\u001b\u0000\u0000\uffe8\uffee\u0003\ufffd\u0006\u0000\u0000\u0003" +
/*vft.Valkyrie 1.0                      */ "\u0000\u0000\u0000\u0015\u0003\u0000\u001b\u001e\u0000\u0000\u0020\u0020\u0020\u001b\u0000\u0015\u0000\u0015\u0003\ufff2\u0012\u0000\u0000\u0000\u0000\u0000\ufff2\u0000\ufff2\n\uffeb\uffee\u000b\u000b\u000e\u0000\u0000\u0000\u0000\u0000" +
/*voidious.mini.Komarious 1.88          */ "\u0000\u0000\u0000\u0000\u0000\u0000\uffee\uffee\u0000\uffee\ufff6\u0018\u0020\u0006\u000e\u0023\u0023\u0018\n\u0020\u0023\u0023\u0023\u0023\u0018\u0018\u0012\u0020\u000e\u001e\ufffa\u0000\u0006\u001b\uffe5\n\uffeb\uffe5\u0000\u0018" +
/*wiki.mini.BlackDestroyer 0.9.0        */ "\u0000\u0000\u0000\u0000\u0015\u000e\ufffa\u000e\u000e\u000e\u0006\u0012\u000b\u0020\u0012\u0012\u000b\n\u000b\u000b\u0003\u0000\u0003\ufffa\uffee\u000e\u0012\uffee\ufffd\u000b\u001e\ufffa\u0000\uffeb\u0000\u0018\u000b\u0000\u0000\u0018" +
/*wiki.mini.GouldingiHT 1.0             */ "\u0000\u0000\u0006\u0018\u0003\ufffa\n\u0018\u0000\n\u0020\u001e\u001e\u0018\u001b\u0020\ufffd\ufff5\u001e\u000b\ufff6\u0003\u0000\u001b\u0000\n\uffeb\uffe8\ufffd\uffe5\uffeb\ufff2\u0000\uffeb\u0000\u0000\u0000\u0000\u0000\u0000" +
/*wiki.mini.Griffon 0.1                 */ "\u0000\u0000\n\u0000\n\n\u0006\u0003\ufffd\ufffa\ufff6\ufff6\ufff5\ufff5\ufff6\ufff6\u0012\uffeb\uffee\n\uffee\uffe5\u0015\u0006\u001e\u0000\ufff5\n\u0000\uffe8\u0003\u000b\u000b\u001b\n\uffe8\ufff6\u0000\u0000\u0000" +
/*wiki.mini.Sedan 1.0                   */ "\u0000\u0000\u0000\u0000\u0000\u0003\u0015\u0018\u0020\u001e\u0018\u0018\u0018\u0018\u0015\uffee\u001e\u0018\u0006\uffe5\u0003\uffeb\u0003\ufffd\n\u0003\uffee\uffe5\u0015\ufffd\uffee\ufff6\uffe2\ufffd\u0000\ufff5\u0000\u0000\u0000\u0000" +
/*wit.Deep7 2.0                         */ "\u0000\u0000\u0000\n\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0006\u000e\u000b\u000b\n\n\ufff5\n\n\n\u000b\ufff6\u000b\ufff6\ufffa\ufff6\n\u0006\ufffa\u0000\ufffa\u0000\ufffd\ufffa\n\u0000\u0000" +
/*yk.JahRoslav 1.1                      */ "\u0000\u0000\u0000\u0015\u0018\u000e\u001e\u001e\u0006\u000e\u001e\u001b\u0020\u001b\u000e\u0018\u001e\u001e\u001e\u001b\u000e\u001b\u000b\n\u000e\ufffd\uffee\u000e\u0003\u000b\ufff5\ufffa\u0003\u0003\u0000\u000b\u0000\u000e\u0000\u0000" + 
/*WhoAmI.WhoAmI 1.00                    */ "\u0025\u0025\u0025\u0025\u0025\u0025\u0013\u0013\u0013\u0013\u0013\u0011\u0011\u000f\u000f\r\r\u000b\u000b\u0009\u0009\u0009\u0007\u0006\u0013\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\u0000" +
/*oog.nano.Caligula 1.15                */ Ap00 + Ap00 + Ap00 + Ap24 + Ap44 + Ap00 + Ap08 + Ap08 + Am08 + Am08 + Ap80 + Ap76 + Am24 + Am28 + Am24 + Am28 + Am24 + Ap28 + Ap68 + Am44 + Am28 + Am44 + Am36 + Am44 + Am44 + Ap52 + Ap76 + Ap00 + Ap80 + Ap60 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + 
/*buba.Archivist 0.1                    */ LEAD_NONE +//Ap00 + Ap00 + Ap00 + Am16 + Ap16 + Ap00 + Ap36 + Ap76 + Ap00 + Am16 + Am16 + Ap80 + Ap76 + Am28 + Am28 + Am24 + Am44 + Am08 + Am08 + Am16 + Ap00 + Ap16 + Ap00 + Ap00 + Ap00 + Ap08 + Ap00 + Am68 + Am08 + Ap28 + Ap28 + Am08 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + 
/*buba.Buba 0.3                         */ Ap00 + Ap00 + Ap00 + Am08 + Ap36 + Am24 + Ap36 + Am44 + Am08 + Am16 + Am24 + Ap80 + Ap60 + Ap52 + Am24 + Am24 + Am68 + Am16 + Am08 + Ap00 + Ap00 + Ap08 + Am16 + Am36 + Ap16 + Am60 + Am28 + Ap08 + Ap00 + Ap00 + Am44 + Ap00 + Ap00 + Am52 + Ap08 + Ap36 + Ap00 + Ap00 + Ap00 + Ap00 + 
/*cs.ExclusionNano 1.1                  */ Ap00 + Ap00 + Ap00 + Ap00 + Ap68 + Ap00 + Ap00 + Ap80 + Ap80 + Ap00 + Ap00 + Ap00 + Ap36 + Ap28 + Ap36 + Ap44 + Ap36 + Ap52 + Ap36 + Ap36 + Ap36 + Ap36 + Ap52 + Ap52 + Ap44 + Ap36 + Ap36 + Ap28 + Ap24 + Ap36 + Ap52 + Ap44 + Ap00 + Ap28 + Ap00 + Ap24 + Ap00 + Ap00 + Ap00 + Ap00 + 
/*eskimo.micro.Echo 0.1                 */ Ap00 + Ap00 + Ap00 + Ap16 + Ap00 + Ap52 + Ap52 + Ap44 + Ap36 + Ap36 + Ap36 + Ap52 + Ap36 + Ap44 + Ap36 + Am36 + Ap28 + Ap36 + Ap52 + Am36 + Ap36 + Ap60 + Am52 + Am16 + Ap16 + Ap44 + Ap00 + Am24 + Am44 + Am36 + Ap16 + Am16 + Ap00 + Ap28 + Ap00 + Ap00 + Ap00 + Ap28 + Ap00 + Ap00 + 
/*exauge.LemonDrop 1.6.130              */ Ap00 + Ap00 + Ap00 + Ap00 + Ap16 + Ap24 + Ap16 + Ap16 + Ap16 + Ap16 + Ap08 + Ap08 + Ap08 + Ap08 + Am36 + Ap00 + Ap16 + Ap16 + Ap24 + Ap36 + Am44 + Ap16 + Am24 + Ap08 + Ap16 + Am24 + Ap16 + Ap00 + Ap08 + Ap08 + Ap00 + Am44 + Ap24 + Ap24 + Ap16 + Ap00 + Ap16 + Ap24 + Ap00 + Ap00 + 
/*gwah.GBotMarkIV 1.0                   */ Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Am16 + Am16 + Am08 + Ap00 + Ap08 + Ap08 + Ap08 + Ap00 + Ap08 + Ap00 + Ap08 + Ap00 + Am24 + Ap00 + Ap00 + Am16 + Am08 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + 
/*gwah.GerryBotMkII 1.5.1               */ Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Am16 + Am16 + Am08 + Ap00 + Ap08 + Ap08 + Ap08 + Ap00 + Ap08 + Ap00 + Ap08 + Ap00 + Am24 + Ap00 + Ap00 + Am16 + Am08 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + 
/*hapiel.Spiral 0.1                     */ Ap00 + Ap00 + Ap00 + Ap16 + Ap36 + Ap28 + Ap28 + Ap16 + Ap08 + Ap08 + Am08 + Am16 + Am24 + Am24 + Am24 + Am24 + Am28 + Am24 + Ap52 + Am08 + Ap44 + Ap00 + Ap08 + Ap00 + Ap08 + Am52 + Ap00 + Ap00 + Ap52 + Am08 + Am36 + Ap00 + Am24 + Ap00 + Am08 + Am16 + Ap00 + Ap00 + Am08 + Ap00 + 
/*jf.Dodger 1.1                         */ Ap00 + Ap00 + Ap00 + Am08 + Ap16 + Am24 + Am28 + Am36 + Am44 + Ap00 + Ap00 + Am16 + Am24 + Am28 + Am44 + Am24 + Am24 + Am36 + Am16 + Am16 + Am28 + Ap00 + Am08 + Ap00 + Ap00 + Am08 + Am44 + Ap08 + Am08 + Ap00 + Ap00 + Am24 + Am16 + Am08 + Am24 + Am24 + Ap00 + Ap00 + Ap00 + Ap00 + 
/*mym.EdgeStalker 1.0                   */ Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap88 + Ap52 + Ap08 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap16 + Ap00 + Ap00 + Ap16 + Ap00 + Ap08 + Ap08 + Ap08 + Ap00 + 
/*NG.LegatusLegionis 1.2                */ Ap00 + Ap00 + Ap00 + Ap44 + Ap36 + Ap44 + Ap68 + Ap76 + Ap00 + Ap76 + Ap76 + Ap68 + Ap76 + Ap68 + Ap76 + Ap76 + Ap76 + Ap76 + Ap68 + Ap44 + Ap60 + Ap68 + Ap60 + Ap68 + Ap00 + Ap08 + Ap00 + Ap60 + Ap44 + Ap28 + Am28 + Am44 + Ap52 + Am16 + Ap00 + Am08 + Am36 + Ap08 + Ap00 + Ap00 + 
/*povik.nano.Smilee 0.2.1               */ Ap00 + Ap00 + Ap00 + Ap16 + Am08 + Ap28 + Am16 + Am16 + Ap16 + Ap00 + Ap00 + Ap08 + Ap08 + Ap24 + Am16 + Ap08 + Am08 + Ap24 + Ap00 + Am16 + Ap16 + Ap00 + Am16 + Ap36 + Ap08 + Ap00 + Ap24 + Am28 + Am24 + Ap00 + Am16 + Ap16 + Ap00 + Am28 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + 
/*rampancy.micro.Epiphron 1.0           */ Ap00 + Ap00 + Ap00 + Ap08 + Ap68 + Am08 + Ap16 + Ap08 + Am08 + Am16 + Ap80 + Am24 + Am28 + Am28 + Am24 + Am24 + Am24 + Am44 + Am52 + Ap88 + Ap28 + Am60 + Ap08 + Ap08 + Ap24 + Am60 + Ap00 + Am16 + Am08 + Am08 + Ap24 + Ap00 + Ap28 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + 
/*SuperSample.SuperCrazy 1.0            */ Ap00 + Ap00 + Ap00 + Ap24 + Am16 + Ap68 + Ap36 + Ap68 + Ap80 + Ap80 + Ap80 + Ap80 + Ap80 + Ap80 + Ap88 + Ap80 + Ap88 + Ap88 + Ap88 + Ap88 + Ap80 + Ap00 + Ap00 + Ap00 + Ap28 + Ap88 + Ap08 + Am08 + Am08 + Ap00 + Ap24 + Am16 + Ap00 + Ap00 + Ap00 + Am36 + Ap00 + Ap00 + Ap00 + Ap00 + 
/*timmit.micro.TimXJ 0.22               */ Ap00 + Ap00 + Ap00 + Ap24 + Ap00 + Ap68 + Ap60 + Ap60 + Ap68 + Ap80 + Ap80 + Ap80 + Ap80 + Ap80 + Ap80 + Ap68 + Ap80 + Ap80 + Ap60 + Am44 + Ap80 + Ap28 + Am24 + Ap44 + Ap16 + Ap00 + Ap28 + Ap16 + Ap00 + Am36 + Am36 + Ap00 + Ap00 + Ap28 + Ap00 + Am08 + Ap44 + Ap24 + Ap00 + Ap00 + 
/*exauge.GateKeeper 1.1.121g            */ Ap00 + Ap00 + Ap00 + Ap00 + Ap00 + Ap24 + Am36 + Ap00 + Ap00 + Am08 + Am16 + Am24 + Am28 + Am28 + Am08 + Am60 + Am16 + Am24 + Am28 + Ap00 + Ap00 + Am16 + Am28 + Am28 + Ap68 + Am52 + Am44 + Ap00 + Ap00 + Ap16 + Ap00 + Am28 + Am60 + Ap24 + Ap24 + Am24 + Ap00 + Ap00 + Ap00 + Ap00 + 
/*exauge.Leopard 1.1.019                */ "\u0025\u0025\u0025\u0025\u0025\u0025\u0013\u0013\u0013\u0013\u0013\u0011\u0011\u000f\u000f\r\r\u000b\u000b\u0009\u0009\u0009\u0007\u0006\u0013\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\uffef\u0000" +
/*ayk.WallHugger 1.0                    */ Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + Ap44 + 

END_OVERFLOW_BUFFER;

static final String FIRE_30  =      "" +   FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30;
static final String FIRE_25  =      "" +   FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25;
static final String FIRE_20  =      "" +   FP30 + FP30 + FP30 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20;    

	private static final String FirePowerList = // Fire Power per range
//                               Distance:  20     40     60     80     100    120    140    160    180    200    220    240    260    280    300    320    340    360    380    400    420    440    460    480    500    520    540    560    580    600    620    640    660    680    700    720    740    760    780    800    
/*default_fail_case                  */""+ ' ' + FP30 + FP20 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 +
/*ad.last.Bottom 1.0                    */ FIRE_25 +  
/*ags.micro.Carpet 1.1                  */ FIRE_25 +  
/*ahf.Acero 1.0                         */ FIRE_25 +  
/*ahf.NanoAndrew .4                     */ FIRE_30 +  
/*amk.Punbot.Punbot 0.01                */ FIRE_25 +  
/*ap.Frederick 1.1                      */ FP30 + FP30 + FP30 + FP25 + FP25 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 +
/*apv.MicroAspid 1.8                    */ FIRE_25 +  
/*apv.NanoLauLectrik 1.0                */ FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +  
/*apv.NanoLauLectrikTheCannibal 1.1     */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +  
/*arthord.KostyaTszyu Beta2             */ FIRE_25 +  
/*arthord.MannyPacquiao Beta            */ FIRE_25 +  
/*arthord.micro.Apoptygma 0.4           */ FIRE_30 +  
/*arthord.micro.Muffin 0.6.1            */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +  
/*arthord.NanoSatan Mu                  */ FIRE_25 +  
/*arthord.NanoSatanMelee Beta           */ FIRE_30 +  
/*ary.micro.Weak 1.2                    */ FIRE_20 +  
/*ary.nano.AceSurf 1.2                  */ FIRE_25 +  
/*ary.nano.ColorNanoP 1.1               */ FIRE_30 +  
/*as.xbots 1.0                          */ FIRE_30 +  
/*awesomeness.Elite 1.0                 */ FIRE_30 +  
/*baal.nano.N 1.42                      */ FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 +
/*banshee.micro.Nexus6 0.3.0            */ FIRE_30 +  
/*bayen.nano.Squirrel 0.2               */ FIRE_25 +  
/*bayen.UbaMicro 1.4                    */ FIRE_30 +  
/*bayen.UbaRamLT 1.0                    */ FIRE_30 +  
/*bbo.RamboT 0.3                        */ FIRE_30 +
/*bons.NanoStalker 1.2                  */ FIRE_30 +
/*bp.Kuma 1.0                           */ FIRE_25 +
/*braaropolis.Abot 1.0                  */ FIRE_30 +
/*bvh.micro.Freya 0.3                   */ FIRE_25 +
/*bvh.micro.Svadilfari 0.2              */ FIRE_30 +
/*bzdp.BoxCar 2.0                       */ FIRE_25 +
/*bzbp.Pansy 2.1                        */ FIRE_30 +
/*caimano.Furia_Ceca 0.22               */ FIRE_25 +
/*chase.c.Wristwatch 1.0                */ FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*chase.o.Orbit 0.1                     */ FIRE_30 +
/*chickenfuego.UrChicken2 1.0           */ FIRE_30 +
/*cjk.Merkava 0.1.1                     */ FIRE_30 +
/*cjm.Charo 1.1                         */ FIRE_25 +
/*codemojo.nano.Woot 1.0                */ FIRE_30 +
/*cx.micro.Blur 0.2                     */ FIRE_20 +
/*cx.micro.Smoke 0.96                   */ FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*cx.micro.Spark 0.6                    */ FIRE_25 +
/*cx.nano.Smog 2.6                      */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +     
/*davidalves.net.DuelistMicro 1.22      */ FIRE_20 +
/*davidalves.net.DuelistMicroMkII 1.1   */ FIRE_20 +
/*davidalves.net.DuelistNano 1.0        */ FIRE_20 +
/*demetrix.nano.Neutrino 0.27           */ FIRE_25 +
/*demetrix.nano.SledgeHammer 0.22       */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*dft.Freddie 1.32                      */ FIRE_25 +
/*dft.Guppy 1.0                         */ FIRE_30 +
/*dggp.haiku.gpBot_0 1.1                */ FIRE_30 +
/*djdjdj.NanoSkunk10 1.0                */ FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 + FP01 +
/*dks.MicroDanMK2 1.0                   */ FIRE_25 +
/*DM.Mijit .3                           */ FIRE_20 +
/*dmp.micro.Aurora 1.41                 */ FIRE_25 +  //FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +                           
/*dmp.nano.Eve 3.41                     */ FIRE_30 +
/*donjezza.Jezza 1.0                    */ FIRE_30 +
/*donjezza.Muncho 1.0                   */ FIRE_25 +
/*drd.DreadKnoght 0.9                   */ FIRE_30 +
/*dsw.StaticD 1.0                       */ FIRE_30 +
/*dukie.Ambassador 1.0                  */ FIRE_25 +
/*dummy.micro.HummingBird 2.14          */ FIRE_25 +
/*dummy.micro.Sparrow 2.5               */ FIRE_25 +
/*dz.GalbaMicro 0.11                    */ FIRE_20 +
/*dz.MostlyHarmlessNano 2.1             */ FIRE_25 +
/*dz.OthoMicro 0.12                     */ FIRE_25 +
/*el.JumpShoot 0.2                      */ FIRE_25 +
/*el33t.EL33tGangstarr2 2.0             */ FIRE_25 +
/*elloco.Flower 0.1r1                   */ FIRE_30 +
/*elvbot.ElverionBot 0.3                */ FIRE_25 +
/*evd.X1 0.01                           */ FIRE_25 +
/*fcr.First 1.0                         */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*Fenix.FenixTrack 1.0                  */ FIRE_25 +
/*fm.claire 1.7                         */ FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*fm.mammillarias 1.3                   */ FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*fullsail.SweetTea 1.1                 */ FIRE_30 +
/*germ.TheMind .2                       */ FIRE_25 +
/*gh.micro.Grinnik 0.7                  */ FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*gh.micro.GrubbmThree 0.9              */ FIRE_30 +
/*gh.nano.Grofvuil 0.2                  */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*gio.RealGioBot 1.0                    */ FIRE_30 +
/*gu.MicroScoob 1.3                     */ FIRE_25 +
/*ins.MobyNano 0.8                      */ FIRE_20 +
/*jab.micro.Sanguijuela 0.8             */ FIRE_30 +
/*jam.micro.RaikoMicro 1.44             */ FP30 + FP30 + FP30 + FP30 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*janm.Jammy 1.0                        */ FIRE_30 +
/*japs.Serenity 1.0                     */ FIRE_25 +
/*jaw.KarenCain 0.11                    */ FIRE_20 +
/*jaw.Mouse 0.11                        */ FIRE_30 +
/*jcw.ArcherOne 1.0                     */ FIRE_30 +
/*jep.nano.Hawkwing 0.4.1               */ FIRE_25 +
/*jep.nano.Hotspur 0.1                  */ FIRE_20 +
/*jgap.JGAP12584 1.0                    */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*jgap.JGAP130166 1.0                   */ FIRE_30 +
/*jgap.JGAP23423 1.0                    */ FIRE_25 +
/*jgap.JGAP6139 1.0                     */ FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*jgap.JGAP7247_2 1.0                   */ FIRE_30 +
/*jgap.JGAP7958 1.0                     */ FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*jk.micro.Toorkild 0.1.1               */ FIRE_25 + //FIRE_20 +
/*joe.ADinosaur 1.0                     */ FIRE_30 +
/*jp.SineWall 1.0                       */ FIRE_20 +
/*js.PinBall 1.6                        */ FIRE_25 + // FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*jsal.Jsalbot 1.0                      */ FIRE_25 +
/*jt.SpearmintCT Alpha                  */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*kawigi.f.FhqwhgadsMicro 1.0           */ FIRE_20 +//FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*kawigi.micro.Shiz 1.1                 */ FIRE_25 +
/*kawigi.nano.FunkyChicken 1.1          */ FIRE_30 +
/*kawigi.nano.ThnikkaBot 0.9            */ FIRE_30 +
/*kawigi.sbf.FloodMicro 1.5             */ FIRE_25 +
/*kawigi.sbf.FloodNano 1.2              */ FIRE_20 +
/*kc.micro.Needle 0.101                 */ FIRE_20 +
/*kc.micro.Thorn 1.142                  */ FIRE_25 +
/*kc.micro.WaveShark 0.3                */ FIRE_25 +
/*kc.nano.Splinter 1.2                  */ FIRE_25 +
/*kinsen.nano.Hoplomachy 1.6            */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP30 + FP25 + FP30 + FP25 + FP30 + FP25 + FP30 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +                                
/*kinsen.nano.Quarrelet 1.0             */ FIRE_25 +
/*kinsen.nano.Senticous 1.0             */ FIRE_25 +
/*kjc.etc.Dharok 1.0                    */ FIRE_20 +
/*kjc.Karaykan 1.0                      */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 +
/*kjc.MailManX 2.0                      */ FIRE_25 +
/*kurios.DOSexe .9                      */ FIRE_30 +
/*leb.ShootAnArrow 0.1                  */ FIRE_20 +
/*lechu.Lechu 1.1                       */ FIRE_25 +
/*lion.Kresnanano 1.0                   */ FIRE_30 +
/*lk.nano.Avesnar 1.1                   */ FIRE_25 +
/*lrem.micro.FalseProphet Alpha         */ FIRE_30 +
/*lrem.micro.MoggFanatic 0.2            */ FIRE_30 +
/*lw.LuthersTest 0.1                    */ FIRE_30 +
/*m3thos.Eva00 1.1                      */ FIRE_30 +
/*marcinek.TopGun 1.3                   */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*mbro.BelajarBot 0.0.3                 */ FIRE_30 +
/*mbro.Detektor3 0.1.1                  */ FIRE_30 +
/*mc.Messapia 0.1.8                     */ FIRE_30 +
/*mld.DustBunny 3.8                     */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP20 + FP20 + FP20 + FP20 +
/*mld.Infinity 2.2                      */ FIRE_25 +
/*mld.Moebius 2.9.3                     */ FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP15 + FP15 + FP15 + FP15 + FP10 + FP10 + FP10 + FP10 + FP05 + FP05 + FP05 + FP05 + FP01 + FP01 + FP01 + FP01 +
/*mld.Tide 1.2                          */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*mld.Wisdom 1.0                        */ FIRE_30 +
/*mme.NikeEnhanced 2.0                  */ FIRE_25 +
/*mrm.MightyMoose .2                    */ FIRE_25 +
/*myl.micro.Avipes 1.00                 */ FIRE_25 +
/*myl.micro.NekoNinja 1.30              */ FIRE_25 +
/*myl.micro.Predator 1.50               */ FIRE_20 +
/*myl.micro.Troodon 1.10                */ FIRE_25 +
/*myl.nano.Graviton 1.10                */ FIRE_20 +
/*myl.nano.Kakuru 1.20                  */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*myl.nano.KomoriNinja 1.1              */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*mz.Adept 2.65                         */ FIRE_25 +
/*mz.AdeptBSB 1.03                      */ FIRE_30 +
/*mz.Movement 1.8                       */ FIRE_25 +
/*mz.NanoDeath 2.56                     */ FIRE_30 +
/*mz.NanoGod 2.02                       */ FIRE_30 +
/*nanoskank.NanoSkank 1.0               */ FIRE_25 +
/*nat.micro.NP 1.34                     */ FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*nat.micro.Reepicheep 0.1a             */ FIRE_25 +
/*nat.nano.Ocnirp 1.73                  */ FIRE_30 +
/*nat.nano.OcnirpPM 1.0                 */ FIRE_25 +
/*nat.nano.OcnirpSNG 1.0b               */ FIRE_25 +
/*ndn.DyslexicMonkey 1.1                */ FIRE_30 +
/*nexus.Prototype 1.0                   */ FIRE_30 +
/*nova.Snow 1.0                         */ FIRE_25 +
/*ntc.Cannon 1.12test                   */ FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*ntc.Knowledge 1.1                     */ FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*ntc.Plains 0.9                        */ FIRE_25 +
/*ntw.Sigsys 1.6                        */ FIRE_25 +
/*ntc.Swim 0.9                          */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 +
/*nz.jdc.micro.HedgehogGF 1.3           */ FIRE_20 +  
/*nz.jdc.micro.HedgehogP 1.2            */ FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + 
/*nz.jdc.nano.NeophytePattern 1.0       */ FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP10 + FP10 + FP10 + FP10 + FP10 + FP10 + 
/*nz.jdc.nano.NeophytePRAL 1.2          */ FIRE_20 +
/*nz.jdc.nano.NeophyteSRAL 1.2          */ FIRE_25 +
/*oog.melee.Capulet 0.1                 */ FIRE_25 +
/*oog.melee.CapuletDroid 1.0            */ FIRE_30 +
/*oog.melee.Mercutio 1.0                */ FIRE_25 +
/*oog.melee.StarLight 0.1               */ FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP15 + FP15 + FP15 + FP15 + FP15 + FP15 + FP15 + FP15 + FP15 + FP15 + FP15 + FP15 + FP15 + FP15 + FP15 + FP15 + FP15 + FP15 + FP15 + FP15 + 
/*oog.micro.MagicD3 0.41                */ FIRE_25 +
/*oog.micro.Maui 1.1                    */ FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*oog.micro.SavantMicro 0.31            */ FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*oog.nano.Fuatisha 1.0                 */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +                        
/*oog.MagicD2 2.3                       */ FIRE_25 +
/*oog.nano.SavantVS 1.1                 */ FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*oog.nano.SavantWS 1.1                 */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*pa.Improved 1.1                       */ FIRE_30 +
/*pak.Dargon 1.0b                       */ FIRE_25 +
/*pak.JakeTheTestingRobot .1b           */ FIRE_30 +
/*paolord.TheHulk 1.0                   */ FIRE_30 +
/*pb.Oscillator 1.0                     */ FIRE_20 +
/*pez.micro.Aristocles 0.3.7            */ FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*pez.nano.Icarus 0.3                   */ FIRE_25 +
/*pez.nano.LittleEvilBrother 0.1        */ FIRE_30 +
/*pfvicm.Sobieski 7.2.3b                */ FIRE_30 +
/*ph.micro.Pikeman 0.4.5                */ FIRE_30 +
/*PkKillers.PkAssassin 1.0              */ FIRE_30 +
/*pmc.SniperBot 1.0                     */ FIRE_25 +
/*projectx.ProjectNano 2.0              */ FIRE_30 +
/*projectx.TestNano 1.0                 */ FIRE_30 +
/*pulsar.Nanis 0.3                      */ FIRE_30 +
/*pulsar.PulsarNano 0.2.4               */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*quietus.Invader 0.1                   */ FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP01 + FP05 + FP01 + FP05 + FP01 + FP05 + FP01 + FP05 + FP01 + FP05 + FP01 + FP05 + FP01 + FP05 + FP01 + FP05 + FP01 + FP05 + FP01 + FP05 + FP01 + FP05 + FP01 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 + FP05 +
/*quietus.NarrowRadar 0.1               */ FIRE_30 +
/*radnor.DoctorBob 1.42                 */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*ratosh.nano.Debo 1.36                 */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*ratosh.Nobo 0.21                      */ FIRE_25 +
/*ratosh.Wesco 1.4                      */ FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*rcp.Kuramatron 1.0                    */ FIRE_30 +
/*repositorio.NanoStep 1.0              */ FIRE_25 +
/*robo.PartsBot 1.0                     */ FIRE_30 +
/*robar.haiku.Spike 1.0                 */ FIRE_30 +
/*robar.micro.Gladius 1.15              */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + 
/*robar.micro.Kirbyi 1.0                */ FIRE_25 + //FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*robar.micro.Topaz 0.25                */ FIRE_30 +
/*robar.nano.Assertive 0.3              */ FIRE_25 + //FIRE_30 +  
/*robar.nano.BlackWidow 1.3             */ FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + 
/*robar.nano.Breeze 0.3                 */ FIRE_20 +
/*robar.nano.Mosquito 1.1               */ FIRE_25 + //FIRE_30 +
/*robar.nano.MosquitoPM 1.0             */ FIRE_25 +
/*robar.nano.Prestige 1.0               */ FIRE_25 +
/*robar.nano.Pugio 1.47                 */ FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*robar.nano.Scytodes 0.3               */ FIRE_25 +
/*robar.nano.Vespa 0.95                 */ FIRE_25 +
/*rsim.micro.uCatcher 0.1               */ FIRE_20 +
/*ruc.nano.Zealot 0.2                   */ FIRE_30 +
/*ry.LightningBug 1.0                   */ FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*ry.Worst 1.0                          */ FIRE_25 +
/*rz.Artist 0.2                         */ FIRE_25 +
/*rz.GlowBlow 2.31                      */ FIRE_30 +
/*rz.HawkOnFire 0.1                     */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*rz.SmallDevil 1.502                   */ FIRE_30 +
/*sam.Samspin 1.0                       */ FIRE_30 +
/*sgp.nano.FurryLeech 1.0               */ FIRE_30 +
/*sgp.ShiningBeetle 1.1                 */ FIRE_30 +
/*sgp.SleepingGoat 1.1                  */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*simonton.GFNano_D 3.1b                */ FIRE_25 +
/*simonton.micro.GFMicro 1.0            */ FIRE_25 +
/*simonton.micro.WeeklongObsession 3.4.1*/ FIRE_30 +
/*simonton.nano.WeekendObsession_S 1.7  */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*spinnercat.haiku.Refrigerator 1.1     */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +                            
/*spinnercat.CopyKat 1.2.3              */ FIRE_25 +
/*spinnercat.Kitten 1.4                 */ FIRE_25 +
/*spinnercat.Limit .01                  */ FIRE_30 +
/*stelo.FretNano 1.1                    */ FIRE_25 +
/*stelo.MatchupMicro 1.2                */ FIRE_25 +
/*stelo.MirrorMicro 1.1                 */ FIRE_25 +
/*stelo.MirrorNano 1.4                  */ FIRE_30 +
/*stelo.MoojukNano 1.2                  */ FIRE_25 +
/*stelo.PatternRobot 1.0                */ FIRE_30 +
/*stelo.PianistNano 1.3                 */ FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*stelo.SteloTestNano 1.0               */ FIRE_25 +
/*stelo.UnfoolableNano 1.0              */ FIRE_25 +
/*stelo.UntouchableNano 1.4             */ FIRE_25 +
/*step.NanoBidu 1.0                     */ FIRE_30 +
/*step.nanoPri 1.0                      */ FIRE_30 + //FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*strider.Festis 1.2.1                  */ FIRE_30 +                    
/*strider.Mer 1.1.0                     */ FIRE_25 +
/*sul.Bicephal 1.2                      */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*sul.BlueBot 1.0                       */ FIRE_25 +
/*sul.NanoR2 1.32                       */ FIRE_20 +
/*sul.Pinkbot 1.1                       */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*stuff.Vlad 0.1                        */ FIRE_25 +
/*timmit.nano.TimCat 0.13               */ FIRE_30 +
/*timmit.nano.TimDog 0.33               */ FIRE_30 +
/*tlp.ThreeLeggedPig 1                  */ FIRE_30 +
/*tobe.calypso.Calypso 4.1              */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*tornyil.bottomup.BottomUp 1.05        */ FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*toz.Gnome 1.1                         */ FIRE_30 +
/*trab.nano.AinippeNano 1.3             */ FIRE_30 +
/*usa.nano.Nemo 2.0                     */ FIRE_30 +
/*vft.Hrist 1.0                         */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + 
/*vft.Valkyrie 1.0                      */ FIRE_30 +
/*voidious.micro.Jen 1.11               */ FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*wiki.nano.DevilFISH 1.0               */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +
/*wiki.nano.RaikoNano 1.1               */ FIRE_25 +
/*winamp32.micro.MicroMacro 1.0         */ FIRE_25 +
/*yarghard.Y101 1.0                     */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 + FP20 +  
/*yk.JahMicro 1.0                       */ FIRE_30 +
/*zch.David 0.21                        */ FIRE_25 +
/*zch.Hirkan 0.11                       */ FIRE_25 +
/*zyx.micro.Ant 1.1                     */ FIRE_25 +
/*zyx.nano.Ant 1.1                      */ FIRE_25 +
/*zyx.nano.EscherichiaColi 1.0          */ FIRE_25 +
/*zyx.nano.RedBull 1.0                  */ FIRE_30 +

/*ahf.r2d2.R2d2 0.86                    */ FIRE_25 +
/*AIR.iRobot 1.0                        */ FIRE_25 +
/*amk.ChumbaMini 0.2                    */ FIRE_25 +
/*amk.jointstrike.JointStrike 0.2       */ FIRE_25 +
/*apv.Aspid 1.7                         */ FIRE_25 +
/*apv.AspidReloaded 0.6                 */ FIRE_25 +
/*ar.QuantumChromodynamics 1.2.1        */ FIRE_25 +
/*ary.mini.Nimi 1.0                     */ FIRE_25 +
/*banshee.mini.Nexus6 0.2.0             */ FIRE_25 +
/*bbo.TheRoof 1.4.3                     */ FIRE_25 +
/*bvh.hdr.Hodur 0.4                     */ FIRE_25 +
/*bvh.mini.Fenrir 0.39                  */ FIRE_25 +
/*bvh.mini.Freya 0.55                   */ FIRE_25 +
/*bvh.mini.Mjolnir 0.3                  */ FIRE_25 +
/*bvh.mini.Wodan 0.50                   */ FIRE_25 +
/*cf.mini.Chiva 1.0                     */ FIRE_25 +
/*ch.rhj.rbc.RHJ1 1.0                   */ FIRE_25 +
/*chase.pm.Pytko 1.0                    */ FIRE_25 +
/*cjk.Merkava 0.2.0                     */ FIRE_25 +
/*cjk.Merkava 0.3.0                     */ FIRE_25 +
/*cjm.Che 1.2                           */ FIRE_25 +
/*cx.mini.BlackSwans 0.60               */ FIRE_25 +
/*cx.mini.Cigaret 1.31                  */ FIRE_25 +
/*cx.mini.Nimrod 0.55                   */ FIRE_25 +
/*davidalves.net.DuelistMini 1.1        */ FIRE_25 +
/*dcs.Eater_of_Worlds_Mini 1.0          */ FIRE_25 +
/*dft.Cyprus 3.0                        */ FIRE_25 +
/*dmsr.MiniR101 0.6                     */ FIRE_25 +
/*dummy.mini.Parakeet 2.40              */ FIRE_25 +
/*dvogon.GangBang 1.0                   */ FIRE_25 +
/*dz.GalbaMini 0.121                    */ FIRE_25 +
/*dz.OthoMini 0.15                      */ FIRE_25 +
/*eat.HumblePieLite 1.0                 */ FIRE_25 +
/*el.Attackr 0.1                        */ FIRE_25 +
/*eld.Hmm 1.0                           */ FIRE_25 +
/*fala.robocode.FalaRobot 1.0           */ FIRE_25 +
/*florent.small.LittleAngel 1.8         */ FIRE_25 +
/*fullsail.TimbotNoPrediction 1.0       */ FIRE_25 +
/*fw.Number1 1.0b                       */ FIRE_25 +
/*geep.mini.GPBotA 1.0                  */ FIRE_25 +
/*geep.mini.GPBotB 1.1                  */ FIRE_25 +
/*gh.mini.Gruwel 0.9                    */ FIRE_25 +
/*gio.RealGioBot 1.0                    */ FIRE_25 +
/*goblin.Bender 2.4                     */ FIRE_25 +
/*jam.mini.Raiko 0.43                   */ FIRE_25 +
/*japs.Sjonniebot 0.9.1                 */ FIRE_25 +
/*jekl.mini.BlackPearl .91              */ FIRE_25 +
/*jk.mini.CunobelinDC 0.4CT             */ FIRE_25 +
/*kanishk.Fr0z3n 1.1                    */ FIRE_25 +
/*kawigi.mini.Coriantumr 1.1            */ FIRE_25 +
/*kawigi.mini.Fhqwhgads 1.1             */ FIRE_25 +
/*kawigi.sbf.Barracuda 1.0              */ FIRE_25 +
/*kawigi.sbf.FloodMini 1.4              */ FIRE_25 +
/*kawigi.sbf.Teancum 1.3                */ FIRE_25 +
/*kc.mini.Vyper 0.311                   */ FIRE_25 +
/*kcn.percept.PerceptBot 2.3            */ FIRE_25 +
/*krillr.mini.JointStrike 2.0.0         */ FIRE_25 +
/*m3thos.mini.Eva01 0.5.5               */ FIRE_25 +
/*marksteam.Phoenix 1.0                 */ FIRE_25 +
/*mbh.Mbh 0.1                           */ FIRE_25 +
/*mbro.BelajarBot 0.0.3                 */ FIRE_25 +
/*mdouet.BotKicker 2.0                  */ FIRE_25 +
/*mladjo.AIR 0.7                        */ FIRE_25 +
/*mladjo.Grrrrr 0.9                     */ FIRE_25 +
/*mladjo.Startko 1.0                    */ FIRE_25 +
/*mwj.A1176183 1.0                      */ FIRE_25 +
/*nic.SnippetBot 1.0                    */ FIRE_25 +
/*nkn.mini.Jskr0 0.1                    */ FIRE_25 +
/*ntc.Evader 1.2                        */ FIRE_25 +
/*ntw.Sighup 1.5                        */ FIRE_25 +
/*oa.weak.BotherBot 0.1                 */ FIRE_25 +
/*oa.weak.FlyMk1 0.1                    */ FIRE_25 +
/*oog.mini.MagestyOfColors 0.1          */ FIRE_25 +
/*pak.Dargon .2c                        */ FIRE_25 +
/*pe.mini.SandboxMini 1.2               */ FIRE_25 +
/*pe.minimelee.SandboxMiniMelee 1.1     */ FIRE_25 +
/*pez.mini.ChironexFleckeri 0.5         */ FIRE_25 +
/*pez.mini.Gouldingi 1.5                */ FIRE_25 +
/*pez.mini.Pugilist 2.4.18              */ FIRE_25 +
/*pez.mini.Tityus 0.9.1                 */ FIRE_25 +
/*pez.mini.VertiLeach 0.4.0             */ FIRE_25 +
/*ph.mini.Archer 0.6.6                  */ FIRE_25 +
/*pkdeken.Paladin 1.0                   */ FIRE_25 +
/*radnor.RamRod 1.0                     */ FIRE_25 +
/*rsim.mini.BulletCatcher 0.4           */ FIRE_25 +
/*rz.Apollon 0.23                       */ FIRE_25 +
/*rz.GlowBlowAPM 1.0                    */ FIRE_25 +
/*rz.GlowBlowMelee 1.4                  */ FIRE_25 +
/*simonton.mini.WeeksOnEnd 1.10.4       */ FIRE_25 +
/*skm.PateranBotlock2 1.0               */ FIRE_25 +
/*skm.Ryubot 1.0                        */ FIRE_25 +
/*sng.arco.Arco 0.0                     */ FIRE_25 +
/*stelo.Lifestealer 1.0                 */ FIRE_25 +
/*stelo.MatchupMini 1.1                 */ FIRE_25 +
/*stf.PanzerGeneral 0.1                 */ FIRE_25 +
/*synnalagma.test.MiniNeural 1.1        */ FIRE_25 +
/*timmit.mini.TimVA 0.43                */ FIRE_25 +
/*tobe.mini.Charon 0.9                  */ FIRE_25 +
/*tornyil.Lajcsi2.Lajcsi2sm 1.0         */ FIRE_25 +
/*vft.Valkyrie 1.0                      */ FIRE_25 +
/*voidious.mini.Komarious 1.88          */ FIRE_25 +
/*wiki.mini.BlackDestroyer 0.9.0        */ FIRE_25 +
/*wiki.mini.GouldingiHT 1.0             */ FIRE_25 +
/*wiki.mini.Griffon 0.1                 */ FIRE_25 +
/*wiki.mini.Sedan 1.0                   */ FIRE_25 +
/*wit.Deep7 2.0                         */ FIRE_25 +
/*yk.JahRoslav 1.1                      */ FIRE_25 +
/*WhoAmI.WhoAmI 1.00                    */ FIRE_30 +
/*oog.nano.Caligula 1.15                */ FIRE_25 +
/*buba.Archivist 0.1                    */ FIRE_25 +
/*buba.Buba 0.3                         */ FP30 + FP30 + FP30 + FP30 + FP30 + FP30 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 + FP25 +
/*cs.ExclusionNano 1.1                  */ FIRE_25 +
/*eskimo.micro.Echo 0.1                 */ FIRE_25 +
/*exauge.LemonDrop 1.6.130              */ FIRE_25 +
/*gwah.GBotMarkIV 1.0                   */ FIRE_25 +
/*gwah.GerryBotMkII 1.5.1               */ FIRE_25 +
/*hapiel.Spiral 0.1                     */ FIRE_25 +
/*jf.Dodger 1.1                         */ FIRE_25 +
/*mym.EdgeStalker 1.0                   */ FIRE_25 +
/*NG.LegatusLegionis 1.2                */ FIRE_25 +
/*povik.nano.Smilee 0.2.1               */ FIRE_25 +
/*rampancy.micro.Epiphron 1.0           */ FIRE_25 +
/*SuperSample.SuperCrazy 1.0            */ FIRE_25 +
/*timmit.micro.TimXJ 0.22               */ FIRE_25 +
/*exauge.GateKeeper 1.1.121g            */ FIRE_20 +
/*exauge.Leopard 1.1.019                */ FIRE_30 +
/*ayk.WallHugger 1.0                    */ FIRE_30 +

END_OVERFLOW_BUFFER;

static final String MOVE_STRAIGHT  =      "" + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA;
static final String MOVE_RANDOM_15 =      "" + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15 + RN15;
static final String MOVE_RANDOM_20 =      "" + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20;
static final String MOVE_RANDOM_30 =      "" + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30;
static final String MOVE_RANDOM_40 =      "" + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40 + RN40;
static final String MOVE_RANDOM_45 =      "" + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1;
static final String MOVE_RANDOM_50 =      "" + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50;
static final String MOVE_RANDOM_60 =      "" + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60 + RN60;
static final String MOVE_RANDOM_80 =      "" + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80;
static final String MOVE_OSCOLATE  =      "" + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO;

	private static final String MoveTypeList = // Movement type per range
//                               Distance: 20     40     60     80     100    120    140    160    180    200    220    240    260    280    300    320    340    360    380    400    420    440    460    480    500    520    540    560    580    600    620    640    660    680    700    720    740    760    780    800    
/*default_fail_case                    */' '+//RN30 + RN30 + RN30 + RN30 + RN50 + RN50 + RN50 + RN50 + RN40 + RN40 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + 
											  MOVE_STRAIGHT +    
/*ad.last.Bottom 1.0                    */ MOVE_STRAIGHT +    
/*ags.micro.Carpet 1.1                  */ OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + OSCO + STRA + OSCO + STRA + OSCO + STRA + OSCO + STRA + OSCO + STRA + OSCO + STRA + OSCO + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*ahf.Acero 1.0                         */ MOVE_STRAIGHT + 
/*ahf.NanoAndrew .4                     */ MOVE_OSCOLATE + 
/*amk.Punbot.Punbot 0.01                */ MOVE_OSCOLATE + 
/*ap.Frederick 1.1                      */ MOVE_STRAIGHT + 
/*apv.MicroAspid 1.8                    */ MOVE_RANDOM_45 + 
/*apv.NanoLauLectrik 1.0                */ MOVE_RANDOM_50 + 
/*apv.NanoLauLectrikTheCannibal 1.1     */ MOVE_STRAIGHT + 
/*arthord.KostyaTszyu Beta2             */ MOVE_RANDOM_45 + 
/*arthord.MannyPacquiao Beta            */ MOVE_STRAIGHT + 
/*arthord.micro.Apoptygma 0.4           */ MOVE_RANDOM_45 + 
/*arthord.micro.Muffin 0.6.1            */ MOVE_RANDOM_50 + 
/*arthord.NanoSatan Mu                  */ MOVE_RANDOM_45 + 
/*arthord.NanoSatanMelee Beta           */ MOVE_STRAIGHT + 
/*ary.micro.Weak 1.2                    */ MOVE_RANDOM_45 + 
/*ary.nano.AceSurf 1.2                  */ MOVE_OSCOLATE + 
/*ary.nano.ColorNanoP 1.1               */ MOVE_RANDOM_45 + 
/*as.xbots 1.0                          */ STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*awesomeness.Elite 1.0                 */ MOVE_OSCOLATE + 
/*baal.nano.N 1.42                      */ MOVE_OSCOLATE + 
/*banshee.micro.Nexus6 0.3.0            */ MOVE_OSCOLATE + 
/*bayen.nano.Squirrel 0.2               */ MOVE_OSCOLATE + 
/*bayen.UbaMicro 1.4                    */ MOVE_OSCOLATE + 
/*bayen.UbaRamLT 1.0                    */ MOVE_STRAIGHT + 
/*bbo.RamboT 0.3                        */ MOVE_STRAIGHT + 
/*bons.NanoStalker 1.2                  */ MOVE_STRAIGHT + 
/*bp.Kuma 1.0                           */ MOVE_STRAIGHT + 
/*braaropolis.Abot 1.0                  */ MOVE_STRAIGHT + 
/*bvh.micro.Freya 0.3                   */ MOVE_OSCOLATE + 
/*bvh.micro.Svadilfari 0.2              */ MOVE_OSCOLATE + 
/*bzdp.BoxCar 2.0                       */ MOVE_OSCOLATE + 
/*bzbp.Pansy 2.1                        */ MOVE_STRAIGHT + 
/*caimano.Furia_Ceca 0.22               */ MOVE_STRAIGHT + 
/*chase.c.Wristwatch 1.0                */ STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*chase.o.Orbit 0.1                     */ MOVE_OSCOLATE + 
/*chickenfuego.UrChicken2 1.0           */ MOVE_STRAIGHT + 
/*cjk.Merkava 0.1.1                     */ MOVE_STRAIGHT + 
/*cjm.Charo 1.1                         */ RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN40 + RN30 + RN50 + RN30 + RN50 + RN30 + RN50 + RN30 + RN50 + RN30 + RN50 + RN30 + RN50 + RN30 + RN50 + RN30 + RN50 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + 
/*codemojo.nano.Woot 1.0                */ MOVE_RANDOM_45 + 
/*cx.micro.Blur 0.2                     */ MOVE_RANDOM_45 + 
/*cx.micro.Smoke 0.96                   */ STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN50 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + 
/*cx.micro.Spark 0.6                    */ MOVE_RANDOM_45 + 
/*cx.nano.Smog 2.6                      */ MOVE_STRAIGHT + 
/*davidalves.net.DuelistMicro 1.22      */ MOVE_RANDOM_45 + 
/*davidalves.net.DuelistMicroMkII 1.1   */ MOVE_RANDOM_45 + 
/*davidalves.net.DuelistNano 1.0        */ MOVE_STRAIGHT + 
/*demetrix.nano.Neutrino 0.27           */ STRA + STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*demetrix.nano.SledgeHammer 0.22       */ STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*dft.Freddie 1.32                      */ MOVE_OSCOLATE + 
/*dft.Guppy 1.0                         */ RN50 + RN50 + RN50 + RN50 + RN50 + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + //MOVE_STRAIGHT + //STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*dggp.haiku.gpBot_0 1.1                */ MOVE_STRAIGHT + 
/*djdjdj.NanoSkunk10 1.0                */ STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*dks.MicroDanMK2 1.0                   */ MOVE_STRAIGHT + 
/*DM.Mijit .3                           */ MOVE_RANDOM_45 + 
/*dmp.micro.Aurora 1.41                 */ MOVE_RANDOM_80 + 
/*dmp.nano.Eve 3.41                     */ MOVE_RANDOM_45 + 
/*donjezza.Jezza 1.0                    */ MOVE_STRAIGHT + 
/*donjezza.Muncho 1.0                   */ MOVE_STRAIGHT + 
/*drd.DreadKnoght 0.9                   */ MOVE_STRAIGHT + 
/*dsw.StaticD 1.0                       */ STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*dukie.Ambassador 1.0                  */ STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*dummy.micro.HummingBird 2.14          */ MOVE_RANDOM_45 + 
/*dummy.micro.Sparrow 2.5               */ MOVE_STRAIGHT + 
/*dz.GalbaMicro 0.11                    */ MOVE_RANDOM_45 + 
/*dz.MostlyHarmlessNano 2.1             */ MOVE_STRAIGHT + 
/*dz.OthoMicro 0.12                     */ MOVE_RANDOM_45 + 
/*el.JumpShoot 0.2                      */ MOVE_STRAIGHT + 
/*el33t.EL33tGangstarr2 2.0             */ MOVE_RANDOM_45 +//RN70 + RN70 + RN70 + RN70 + RN70 + RN70 + RN70 + RN70 + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*elloco.Flower 0.1r1                   */ MOVE_OSCOLATE + 
/*elvbot.ElverionBot 0.3                */ MOVE_RANDOM_45 + 
/*evd.X1 0.01                           */ MOVE_STRAIGHT + 
/*fcr.First 1.0                         */ MOVE_OSCOLATE + 
/*Fenix.FenixTrack 1.0                  */ MOVE_STRAIGHT + 
/*fm.claire 1.7                         */ STRA + STRA + STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*fm.mammillarias 1.3                   */ MOVE_STRAIGHT + 
/*fullsail.SweetTea 1.1                 */ MOVE_STRAIGHT + 
/*germ.TheMind .2                       */ MOVE_STRAIGHT + 
/*gh.micro.Grinnik 0.7                  */ MOVE_RANDOM_60 + 
/*gh.micro.GrubbmThree 0.9              */ STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*gh.nano.Grofvuil 0.2                  */ MOVE_OSCOLATE + 
/*gio.RealGioBot 1.0                    */ MOVE_STRAIGHT + 
/*gu.MicroScoob 1.3                     */ MOVE_RANDOM_45 + 
/*ins.MobyNano 0.8                      */ MOVE_RANDOM_45 + 
/*jab.micro.Sanguijuela 0.8             */ STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*jam.micro.RaikoMicro 1.44             */ STRA + STRA + STRA + STRA + STRA + STRA + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + 
/*janm.Jammy 1.0                        */ MOVE_OSCOLATE + 
/*japs.Serenity 1.0                     */ MOVE_STRAIGHT + 
/*jaw.KarenCain 0.11                    */ MOVE_OSCOLATE + 
/*jaw.Mouse 0.11                        */ MOVE_OSCOLATE + 
/*jcw.ArcherOne 1.0                     */ MOVE_STRAIGHT + 
/*jep.nano.Hawkwing 0.4.1               */ MOVE_STRAIGHT + 
/*jep.nano.Hotspur 0.1                  */ MOVE_STRAIGHT + 
/*jgap.JGAP12584 1.0                    */ MOVE_STRAIGHT + 
/*jgap.JGAP130166 1.0                   */ MOVE_STRAIGHT + 
/*jgap.JGAP23423 1.0                    */ MOVE_STRAIGHT + 
/*jgap.JGAP6139 1.0                     */ RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + 
/*jgap.JGAP7247_2 1.0                   */ MOVE_STRAIGHT + 
/*jgap.JGAP7958 1.0                     */ RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + RN10 + 
/*jk.micro.Toorkild 0.1.1               */ MOVE_RANDOM_45 + 
/*joe.ADinosaur 1.0                     */ STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*jp.SineWall 1.0                       */ MOVE_STRAIGHT + 
/*js.PinBall 1.6                        */ STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*jsal.Jsalbot 1.0                      */ MOVE_OSCOLATE + 
/*jt.SpearmintCT Alpha                  */ STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*kawigi.f.FhqwhgadsMicro 1.0           */ MOVE_RANDOM_50 + 
/*kawigi.micro.Shiz 1.1                 */ MOVE_STRAIGHT + 
/*kawigi.nano.FunkyChicken 1.1          */ MOVE_RANDOM_45 + 
/*kawigi.nano.ThnikkaBot 0.9            */ MOVE_STRAIGHT + 
/*kawigi.sbf.FloodMicro 1.5             */ MOVE_STRAIGHT + 
/*kawigi.sbf.FloodNano 1.2              */ MOVE_STRAIGHT + 
/*kc.micro.Needle 0.101                 */ MOVE_RANDOM_45 + 
/*kc.micro.Thorn 1.142                  */ STRA + STRA + STRA + STRA + STRA + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + 
/*kc.micro.WaveShark 0.3                */ RN30 + RN30 + RN30 + RN30 + RN50 + RN50 + RN50 + RN50 + RN40 + RN40 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + 
/*kc.nano.Splinter 1.2                  */ MOVE_OSCOLATE + 
/*kinsen.nano.Hoplomachy 1.6            */ STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*kinsen.nano.Quarrelet 1.0             */ MOVE_RANDOM_45 + 
/*kinsen.nano.Senticous 1.0             */ MOVE_RANDOM_45 + 
/*kjc.etc.Dharok 1.0                    */ MOVE_STRAIGHT + 
/*kjc.Karaykan 1.0                      */ MOVE_STRAIGHT + 
/*kjc.MailManX 2.0                      */ MOVE_STRAIGHT + 
/*kurios.DOSexe .9                      */ STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*leb.ShootAnArrow 0.1                  */ MOVE_STRAIGHT + 
/*lechu.Lechu 1.1                       */ MOVE_OSCOLATE + 
/*lion.Kresnanano 1.0                   */ MOVE_STRAIGHT + 
/*lk.nano.Avesnar 1.1                   */ MOVE_STRAIGHT + 
/*lrem.micro.FalseProphet Alpha         */ MOVE_RANDOM_45 + 
/*lrem.micro.MoggFanatic 0.2            */ MOVE_OSCOLATE + 
/*lw.LuthersTest 0.1                    */ MOVE_STRAIGHT + 
/*m3thos.Eva00 1.1                      */ MOVE_STRAIGHT +
/*marcinek.TopGun 1.3                   */ STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*mbro.BelajarBot 0.0.3                 */ MOVE_STRAIGHT + 
/*mbro.Detektor3 0.1.1                  */ MOVE_STRAIGHT + 
/*mc.Messapia 0.1.8                     */ MOVE_STRAIGHT + 
/*mld.DustBunny 3.8                     */ OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*mld.Infinity 2.2                      */ OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*mld.Moebius 2.9.3                     */ MOVE_RANDOM_45 + 
/*mld.Tide 1.2                          */ STRA + STRA + STRA + STRA + STRA + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + 
/*mld.Wisdom 1.0                        */ STRA + STRA + RN30 + RN30 + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*mme.NikeEnhanced 2.0                  */ MOVE_STRAIGHT + 
/*mrm.MightyMoose .2                    */ OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + OSCO + STRA + OSCO + STRA + OSCO + STRA + OSCO + STRA + OSCO + STRA + OSCO + STRA + OSCO + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*myl.micro.Avipes 1.00                 */ MOVE_RANDOM_45 + 
/*myl.micro.NekoNinja 1.30              */ MOVE_STRAIGHT + 
/*myl.micro.Predator 1.50               */ MOVE_STRAIGHT + 
/*myl.micro.Troodon 1.10                */ MOVE_STRAIGHT + 
/*myl.nano.Graviton 1.10                */ MOVE_STRAIGHT + 
/*myl.nano.Kakuru 1.20                  */ MOVE_RANDOM_30 +
/*myl.nano.KomoriNinja 1.1              */ MOVE_OSCOLATE + 
/*mz.Adept 2.65                         */ MOVE_OSCOLATE + 
/*mz.AdeptBSB 1.03                      */ MOVE_OSCOLATE + 
/*mz.Movement 1.8                       */ MOVE_OSCOLATE + 
/*mz.NanoDeath 2.56                     */ STRA + STRA + STRA + RN10 + RN10 + RN10 + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*mz.NanoGod 2.02                       */ STRA + STRA + RN30 + RN30 + RN30 + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*nanoskank.NanoSkank 1.0               */ MOVE_STRAIGHT + 
/*nat.micro.NP 1.34                     */ MOVE_STRAIGHT + 
/*nat.micro.Reepicheep 0.1a             */ MOVE_RANDOM_45 + 
/*nat.nano.Ocnirp 1.5                   */ MOVE_RANDOM_50 + 
/*nat.nano.OcnirpPM 1.0                 */ MOVE_RANDOM_45 + 
/*nat.nano.OcnirpSNG 1.0b               */ MOVE_RANDOM_45 + 
/*ndn.DyslexicMonkey 1.1                */ MOVE_OSCOLATE + 
/*nexus.Prototype 1.0                   */ MOVE_STRAIGHT + 
/*nova.Snow 1.0                         */ MOVE_RANDOM_45 + 
/*ntc.Cannon 1.12test                   */ MOVE_RANDOM_50 + 
/*ntc.Knowledge 1.1                     */ MOVE_RANDOM_30 + 
/*ntc.Plains 0.9                        */ MOVE_STRAIGHT + 
/*ntw.Sigsys 1.6                        */ MOVE_STRAIGHT + 
/*ntc.Swim 0.9                          */ MOVE_STRAIGHT + 
/*nz.jdc.micro.HedgehogGF 1.3           */ MOVE_RANDOM_45 + 
/*nz.jdc.micro.HedgehogP 1.2            */ STRA + STRA + STRA + STRA + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 +  
/*nz.jdc.nano.NeophytePattern 1.0       */ MOVE_RANDOM_45 + 
/*nz.jdc.nano.NeophytePRAL 1.2          */ MOVE_RANDOM_30 +//STRA + STRA + STRA + STRA + STRA + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + 
/*nz.jdc.nano.NeophyteSRAL 1.2          */ MOVE_OSCOLATE + 
/*oog.melee.Capulet 0.1                 */ MOVE_OSCOLATE + 
/*oog.melee.CapuletDroid 1.0            */ MOVE_STRAIGHT + 
/*oog.melee.Mercutio 1.0                */ MOVE_OSCOLATE + 
/*oog.melee.StarLight 0.1               */ OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*oog.micro.MagicD3 0.41                */ RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + STRA + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + 
/*oog.micro.Maui 1.1                    */ MOVE_RANDOM_30 +
/*oog.micro.SavantMicro 0.31            */ RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + 
/*oog.nano.Fuatisha 1.0                 */ RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + STRA + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + 
/*oog.MagicD2 2.3                       */ MOVE_OSCOLATE + 
/*oog.nano.SavantVS 1.1                 */ STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*oog.nano.SavantWS 1.1                 */ MOVE_STRAIGHT + 
/*pa.Improved 1.1                       */ MOVE_STRAIGHT + 
/*pak.Dargon 1.0b                       */ MOVE_STRAIGHT + 
/*pak.JakeTheTestingRobot .1b           */ MOVE_OSCOLATE + 
/*paolord.TheHulk 1.0                   */ MOVE_STRAIGHT + 
/*pb.Oscillator 1.0                     */ MOVE_STRAIGHT + 
/*pez.micro.Aristocles 0.3.7            */ RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + 
/*pez.nano.Icarus 0.3                   */ MOVE_OSCOLATE + 
/*pez.nano.LittleEvilBrother 0.1        */ MOVE_STRAIGHT + 
/*pfvicm.Sobieski 7.2.3b                */ MOVE_OSCOLATE + 
/*ph.micro.Pikeman 0.4.5                */ MOVE_RANDOM_45 + 
/*PkKillers.PkAssassin 1.0              */ RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + RN20 + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*pmc.SniperBot 1.0                     */ MOVE_STRAIGHT +     
/*projectx.ProjectNano 2.0              */ MOVE_STRAIGHT +   
/*projectx.TestNano 1.0                 */ MOVE_OSCOLATE + 
/*pulsar.Nanis 0.3                      */ MOVE_RANDOM_40 + 
/*pulsar.PulsarNano 0.2.4               */ MOVE_OSCOLATE + //STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*quietus.Invader 0.1                   */ MOVE_STRAIGHT + 
/*quietus.NarrowRadar 0.1               */ STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*radnor.DoctorBob 1.42                 */ MOVE_OSCOLATE + 
/*ratosh.nano.Debo 1.36                 */ STRA + STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + OSCO + STRA + OSCO + STRA + OSCO + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*ratosh.Nobo 0.21                      */ MOVE_OSCOLATE + 
/*ratosh.Wesco 1.4                      */ MOVE_STRAIGHT +
/*rcp.Kuramatron 1.0                    */ MOVE_STRAIGHT + 
/*repositorio.NanoStep 1.0              */ MOVE_STRAIGHT + 
/*robo.PartsBot 1.0                     */ STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*robar.haiku.Spike 1.0                 */ MOVE_STRAIGHT + 
/*robar.micro.Gladius 1.15              */ MOVE_RANDOM_50 + 
/*robar.micro.Kirbyi 1.0                */ MOVE_RANDOM_50 + 
/*robar.micro.Topaz 0.25                */ MOVE_RANDOM_45 + 
/*robar.nano.Assertive 0.3              */ RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + 
/*robar.nano.BlackWidow 1.3             */ MOVE_RANDOM_45 + 
/*robar.nano.Breeze 0.3                 */ MOVE_RANDOM_20 + 
/*robar.nano.Mosquito 1.1               */ MOVE_OSCOLATE + 
/*robar.nano.MosquitoPM 1.0             */ MOVE_RANDOM_20 + 
/*robar.nano.Prestige 1.0               */ RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + RN30 + 
/*robar.nano.Pugio 1.47                 */ OSCO + RND1 + OSCO + RND1 + OSCO + RND1 + OSCO + RND1 + OSCO + RND1 + OSCO + STRA + OSCO + STRA + RND1 + RND1 + RND1 + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*robar.nano.Scytodes 0.3               */ MOVE_RANDOM_45 + 
/*robar.nano.Vespa 0.95                 */ MOVE_RANDOM_45 + 
/*rsim.micro.uCatcher 0.1               */ MOVE_STRAIGHT + 
/*ruc.nano.Zealot 0.2                   */ MOVE_STRAIGHT +    
/*ry.LightningBug 1.0                   */ MOVE_STRAIGHT +    
/*ry.Worst 1.0                          */ MOVE_STRAIGHT + 
/*rz.Artist 0.2                         */ MOVE_OSCOLATE + 
/*rz.GlowBlow 2.31                      */ MOVE_RANDOM_45 + 
/*rz.HawkOnFire 0.1                     */ MOVE_STRAIGHT + 
/*rz.SmallDevil 1.502                   */ MOVE_OSCOLATE + 
/*sam.Samspin 1.0                       */ MOVE_STRAIGHT + 
/*sgp.nano.FurryLeech 1.0               */ MOVE_STRAIGHT + 
/*sgp.ShiningBeetle 1.1                 */ MOVE_STRAIGHT + 
/*sgp.SleepingGoat 1.1                  */ STRA + STRA + STRA + STRA + RND1 + STRA + STRA + STRA + RND1 + STRA + RND1 + STRA + RND1 + STRA + RND1 + STRA + RND1 + STRA + RND1 + STRA + RND1 + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*simonton.GFNano_D 3.1b                */ MOVE_RANDOM_45 + 
/*simonton.micro.GFMicro 1.0            */ MOVE_RANDOM_45 + 
/*simonton.micro.WeeklongObsession 3.4.1*/ MOVE_RANDOM_45 + 
/*simonton.nano.WeekendObsession_S 1.7  */ MOVE_RANDOM_45 + 
/*spinnercat.haiku.Refrigerator 1.1     */ MOVE_RANDOM_80 + //RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + RN90 + 
/*spinnercat.CopyKat 1.2.3              */ RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + RN35 + 
/*spinnercat.Kitten 1.4                 */ MOVE_RANDOM_50 + 
/*spinnercat.Limit .01                  */ MOVE_STRAIGHT + 
/*stelo.FretNano 1.1                    */ MOVE_RANDOM_45 + 
/*stelo.MatchupMicro 1.2                */ MOVE_RANDOM_45 + 
/*stelo.MirrorMicro 1.1                 */ MOVE_RANDOM_45 + 
/*stelo.MirrorNano 1.4                  */ MOVE_OSCOLATE + 
/*stelo.MoojukNano 1.2                  */ MOVE_RANDOM_45 + 
/*stelo.PatternRobot 1.0                */ MOVE_STRAIGHT + 
/*stelo.PianistNano 1.3                 */ MOVE_RANDOM_30 + 
/*stelo.SteloTestNano 1.0               */ MOVE_RANDOM_45 + 
/*stelo.UnfoolableNano 1.0              */ MOVE_RANDOM_20 + 
/*stelo.UntouchableNano 1.4             */ STRA + STRA + STRA + STRA + STRA + RND1 + STRA + RND1 + STRA + RND1 + STRA + RND1 + STRA + RND1 + STRA + RND1 + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*step.NanoBidu 1.0                     */ STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*step.nanoPri 1.0                      */ STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*strider.Festis 1.2.1                  */ MOVE_OSCOLATE + 
/*strider.Mer 1.1.0                     */ MOVE_RANDOM_20 +
/*sul.Bicephal 1.2                      */ STRA + STRA + STRA + STRA + STRA + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + RND1 + 
/*sul.BlueBot 1.0                       */ MOVE_STRAIGHT + 
/*sul.NanoR2 1.32                       */ MOVE_STRAIGHT + 
/*sul.Pinkbot 1.1                       */ MOVE_OSCOLATE + 
/*stuff.Vlad 0.1                        */ MOVE_STRAIGHT + 
/*timmit.nano.TimCat 0.13               */ MOVE_STRAIGHT + 
/*timmit.nano.TimDog 0.33               */ MOVE_OSCOLATE + 
/*tlp.ThreeLeggedPig 1                  */ MOVE_OSCOLATE + 
/*tobe.calypso.Calypso 4.1              */ MOVE_RANDOM_15 + 
/*tornyil.bottomup.BottomUp 1.05        */ MOVE_RANDOM_50 + 
/*toz.Gnome 1.1                         */ MOVE_OSCOLATE + 
/*trab.nano.AinippeNano 1.3             */ MOVE_RANDOM_45 + 
/*usa.nano.Nemo 2.0                     */ MOVE_OSCOLATE + 
/*vft.Hrist 1.0                         */ MOVE_RANDOM_50 + 
/*vft.Valkyrie 1.0                      */ MOVE_OSCOLATE + 
/*voidious.micro.Jen 1.11               */ MOVE_RANDOM_50 + 
/*wiki.nano.DevilFISH 1.0               */ STRA + STRA + RN30 + RN30 + RN30 + RN30 + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + 
/*wiki.nano.RaikoNano 1.1               */ MOVE_OSCOLATE + 
/*winamp32.micro.MicroMacro 1.0         */ MOVE_RANDOM_80 + 
/*yarghard.Y101 1.0                     */ MOVE_STRAIGHT + 
/*yk.JahMicro 1.0                       */ MOVE_OSCOLATE + 
/*zch.David 0.21                        */ MOVE_STRAIGHT + 
/*zch.Hirkan 0.11                       */ MOVE_STRAIGHT + 
/*zyx.micro.Ant 1.1                     */ MOVE_RANDOM_45 + 
/*zyx.nano.Ant 1.1                      */ MOVE_STRAIGHT + 
/*zyx.nano.EscherichiaColi 1.0          */ MOVE_STRAIGHT + 
/*zyx.nano.RedBull 1.0                  */ MOVE_STRAIGHT +

/*ahf.r2d2.R2d2 0.86                    */ MOVE_RANDOM_40 +
/*AIR.iRobot 1.0                        */ MOVE_RANDOM_50 +
/*amk.ChumbaMini 0.2                    */ MOVE_RANDOM_40 +
/*amk.jointstrike.JointStrike 0.2       */ MOVE_OSCOLATE +
/*apv.Aspid 1.7                         */ MOVE_RANDOM_40 +
/*apv.AspidReloaded 0.6                 */ MOVE_RANDOM_40 +
/*ar.QuantumChromodynamics 1.2.1        */ MOVE_OSCOLATE +
/*ary.mini.Nimi 1.0                     */ MOVE_OSCOLATE +
/*banshee.mini.Nexus6 0.2.0             */ MOVE_OSCOLATE +
/*bbo.TheRoof 1.4.3                     */ MOVE_STRAIGHT +
/*bvh.hdr.Hodur 0.4                     */ MOVE_RANDOM_20 +
/*bvh.mini.Fenrir 0.39                  */ MOVE_RANDOM_40 +
/*bvh.mini.Freya 0.55                   */ MOVE_RANDOM_50 +
/*bvh.mini.Mjolnir 0.3                  */ MOVE_STRAIGHT +
/*bvh.mini.Wodan 0.50                   */ MOVE_RANDOM_50 +
/*cf.mini.Chiva 1.0                     */ MOVE_RANDOM_40 +
/*ch.rhj.rbc.RHJ1 1.0                   */ MOVE_OSCOLATE +
/*chase.pm.Pytko 1.0                    */ MOVE_RANDOM_40 +
/*cjk.Merkava 0.2.0                     */ MOVE_RANDOM_20 +
/*cjk.Merkava 0.3.0                     */ MOVE_RANDOM_20 +
/*cjm.Che 1.2                           */ MOVE_RANDOM_40 +
/*cx.mini.BlackSwans 0.60               */ MOVE_RANDOM_50 +
/*cx.mini.Cigaret 1.31                  */ MOVE_RANDOM_50 +
/*cx.mini.Nimrod 0.55                   */ MOVE_RANDOM_50 +
/*davidalves.net.DuelistMini 1.1        */ MOVE_RANDOM_50 +
/*dcs.Eater_of_Worlds_Mini 1.0          */ MOVE_STRAIGHT +
/*dft.Cyprus 3.0                        */ MOVE_RANDOM_40 +
/*dmsr.MiniR101 0.6                     */ MOVE_OSCOLATE +
/*dummy.mini.Parakeet 2.40              */ MOVE_RANDOM_50 +
/*dvogon.GangBang 1.0                   */ MOVE_STRAIGHT +
/*dz.GalbaMini 0.121                    */ MOVE_RANDOM_50 +
/*dz.OthoMini 0.15                      */ MOVE_RANDOM_50 +
/*eat.HumblePieLite 1.0                 */ MOVE_RANDOM_60 +
/*el.Attackr 0.1                        */ MOVE_RANDOM_20 +
/*eld.Hmm 1.0                           */ MOVE_RANDOM_80 +
/*fala.robocode.FalaRobot 1.0           */ MOVE_STRAIGHT +
/*florent.small.LittleAngel 1.8         */ MOVE_RANDOM_40 +
/*fullsail.TimbotNoPrediction 1.0       */ MOVE_STRAIGHT +
/*fw.Number1 1.0b                       */ MOVE_STRAIGHT +
/*geep.mini.GPBotA 1.0                  */ MOVE_STRAIGHT +
/*geep.mini.GPBotB 1.1                  */ MOVE_STRAIGHT +
/*gh.mini.Gruwel 0.9                    */ MOVE_OSCOLATE +
/*gio.RealGioBot 1.0                    */ MOVE_RANDOM_50 +
/*goblin.Bender 2.4                     */ MOVE_STRAIGHT +
/*jam.mini.Raiko 0.43                   */ MOVE_RANDOM_50 +
/*japs.Sjonniebot 0.9.1                 */ MOVE_OSCOLATE +
/*jekl.mini.BlackPearl .91              */ MOVE_RANDOM_50 +
/*jk.mini.CunobelinDC 0.4CT             */ MOVE_RANDOM_40 +
/*kanishk.Fr0z3n 1.1                    */ MOVE_STRAIGHT +
/*kawigi.mini.Coriantumr 1.1            */ MOVE_RANDOM_50 +
/*kawigi.mini.Fhqwhgads 1.1             */ MOVE_RANDOM_50 +
/*kawigi.sbf.Barracuda 1.0              */ MOVE_STRAIGHT +
/*kawigi.sbf.FloodMini 1.4              */ MOVE_RANDOM_50 +
/*kawigi.sbf.Teancum 1.3                */ MOVE_RANDOM_40 +
/*kc.mini.Vyper 0.311                   */ MOVE_RANDOM_40 +
/*kcn.percept.PerceptBot 2.3            */ MOVE_OSCOLATE +
/*krillr.mini.JointStrike 2.0.0         */ MOVE_STRAIGHT +
/*m3thos.mini.Eva01 0.5.5               */ MOVE_RANDOM_80 +
/*marksteam.Phoenix 1.0                 */ MOVE_STRAIGHT +
/*mbh.Mbh 0.1                           */ MOVE_STRAIGHT +
/*mbro.BelajarBot 0.0.3                 */ MOVE_RANDOM_80 +
/*mdouet.BotKicker 2.0                  */ MOVE_RANDOM_40 +
/*mladjo.AIR 0.7                        */ MOVE_RANDOM_40 +
/*mladjo.Grrrrr 0.9                     */ MOVE_RANDOM_40 +
/*mladjo.Startko 1.0                    */ MOVE_RANDOM_40 +
/*mwj.A1176183 1.0                      */ MOVE_STRAIGHT +
/*nic.SnippetBot 1.0                    */ MOVE_OSCOLATE +
/*nkn.mini.Jskr0 0.1                    */ MOVE_RANDOM_40 +
/*ntc.Evader 1.2                        */ MOVE_OSCOLATE +
/*ntw.Sighup 1.5                        */ MOVE_STRAIGHT +
/*oa.weak.BotherBot 0.1                 */ MOVE_OSCOLATE +
/*oa.weak.FlyMk1 0.1                    */ MOVE_OSCOLATE +
/*oog.mini.MagestyOfColors 0.1          */ MOVE_RANDOM_50 +
/*pak.Dargon .2c                        */ MOVE_RANDOM_80 +
/*pe.mini.SandboxMini 1.2               */ MOVE_RANDOM_40 +
/*pe.minimelee.SandboxMiniMelee 1.1     */ MOVE_OSCOLATE +
/*pez.mini.ChironexFleckeri 0.5         */ MOVE_RANDOM_40 +
/*pez.mini.Gouldingi 1.5                */ MOVE_RANDOM_40 +
/*pez.mini.Pugilist 2.4.18              */ MOVE_RANDOM_60 +
/*pez.mini.Tityus 0.9.1                 */ MOVE_RANDOM_50 +
/*pez.mini.VertiLeach 0.4.0             */ MOVE_RANDOM_60 +
/*ph.mini.Archer 0.6.6                  */ MOVE_RANDOM_50 +
/*pkdeken.Paladin 1.0                   */ MOVE_RANDOM_40 +
/*radnor.RamRod 1.0                     */ STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*rsim.mini.BulletCatcher 0.4           */ MOVE_RANDOM_40 +
/*rz.Apollon 0.23                       */ MOVE_RANDOM_50 +
/*rz.GlowBlowAPM 1.0                    */ MOVE_RANDOM_40 +
/*rz.GlowBlowMelee 1.4                  */ MOVE_RANDOM_50 +
/*simonton.mini.WeeksOnEnd 1.10.4       */ MOVE_RANDOM_60 +
/*skm.PateranBotlock2 1.0               */ MOVE_STRAIGHT +
/*skm.Ryubot 1.0                        */ MOVE_STRAIGHT +
/*sng.arco.Arco 0.0                     */ MOVE_STRAIGHT +
/*stelo.Lifestealer 1.0                 */ MOVE_RANDOM_80 +
/*stelo.MatchupMini 1.1                 */ MOVE_RANDOM_40 +
/*stf.PanzerGeneral 0.1                 */ MOVE_RANDOM_40 +
/*synnalagma.test.MiniNeural 1.1        */ MOVE_RANDOM_50 +
/*timmit.mini.TimVA 0.43                */ MOVE_RANDOM_40 +
/*tobe.mini.Charon 0.9                  */ MOVE_STRAIGHT +
/*tornyil.Lajcsi2.Lajcsi2sm 1.0         */ MOVE_OSCOLATE +
/*vft.Valkyrie 1.0                      */ MOVE_STRAIGHT +
/*voidious.mini.Komarious 1.88          */ MOVE_RANDOM_50 +
/*wiki.mini.BlackDestroyer 0.9.0        */ MOVE_RANDOM_40 +
/*wiki.mini.GouldingiHT 1.0             */ MOVE_STRAIGHT +
/*wiki.mini.Griffon 0.1                 */ MOVE_RANDOM_40 +
/*wiki.mini.Sedan 1.0                   */ MOVE_RANDOM_50 +
/*wit.Deep7 2.0                         */ MOVE_OSCOLATE +
/*yk.JahRoslav 1.1                      */ MOVE_OSCOLATE +
/*WhoAmI.WhoAmI 1.00                    */ STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA +
/*oog.nano.Caligula 1.15                */ STRA + STRA + STRA + OSCO + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 + RN80 +
/*buba.Archivist 0.1                    */ MOVE_RANDOM_40 +
/*buba.Buba 0.3                         */ MOVE_STRAIGHT +
/*cs.ExclusionNano 1.1                  */ MOVE_OSCOLATE +
/*eskimo.micro.Echo 0.1                 */ MOVE_STRAIGHT +
/*exauge.LemonDrop 1.6.130              */ MOVE_RANDOM_40 +
/*gwah.GBotMarkIV 1.0                   */ MOVE_STRAIGHT +
/*gwah.GerryBotMkII 1.5.1               */ MOVE_STRAIGHT +
/*hapiel.Spiral 0.1                     */ MOVE_RANDOM_50 +
/*jf.Dodger 1.1                         */ MOVE_RANDOM_40 +
/*mym.EdgeStalker 1.0                   */ MOVE_STRAIGHT +
/*NG.LegatusLegionis 1.2                */ MOVE_STRAIGHT +
/*povik.nano.Smilee 0.2.1               */ MOVE_RANDOM_40 +
/*rampancy.micro.Epiphron 1.0           */ MOVE_STRAIGHT +
/*SuperSample.SuperCrazy 1.0            */ MOVE_OSCOLATE +
/*timmit.micro.TimXJ 0.22               */ MOVE_RANDOM_50 +
/*exauge.GateKeeper 1.1.121g            */ MOVE_RANDOM_20 +
/*exauge.Leopard 1.1.019                */ STRA + STRA + STRA + STRA + STRA + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + OSCO + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + STRA + 
/*ayk.WallHugger 1.0                    */ MOVE_RANDOM_40 +


END_OVERFLOW_BUFFER;

static final String MOVE_RANGE_000 =      "" + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000 + M000;
static final String MOVE_RANGE_060 =      "" + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060 + M060;
static final String MOVE_RANGE_090 =      "" + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090 + M090;
static final String MOVE_RANGE_120 =      "" + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120 + M120;
static final String MOVE_RANGE_240 =      "" + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240;

	private static final String MoveRangeDistanceList = // Randomness of movement
//                               Distance: 20     40     60     80     100    120    140    160    180    200    220    240    260    280    300    320    340    360    380    400    420    440    460    480    500    520    540    560    580    600    620    640    660    680    700    720    740    760    780    800    
/*default_fail_case                    */' '+//M120 + M120 + M120 + M120 + M120 + M120 + M120 + M150 + M150 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + 
											  MOVE_RANGE_000 + 
/*ad.last.Bottom 1.0                    */ MOVE_RANGE_240 + 
/*ags.micro.Carpet 1.1                  */ MOVE_RANGE_240 + 
/*ahf.Acero 1.0                         */ MOVE_RANGE_240 +
/*ahf.NanoAndrew .4                     */ MOVE_RANGE_240 +
/*amk.Punbot.Punbot 0.01                */ MOVE_RANGE_240 +
/*ap.Frederick 1.1                      */ MOVE_RANGE_240 + 
/*apv.MicroAspid 1.8                    */ MOVE_RANGE_240 +
/*apv.NanoLauLectrik 1.0                */ MOVE_RANGE_240 +
/*apv.NanoLauLectrikTheCannibal 1.1     */ MOVE_RANGE_240 +
/*arthord.KostyaTszyu Beta2             */ MOVE_RANGE_240 +
/*arthord.MannyPacquiao Beta            */ MOVE_RANGE_240 +
/*arthord.micro.Apoptygma 0.4           */ MOVE_RANGE_240 +
/*arthord.micro.Muffin 0.6.1            */ MOVE_RANGE_240 +
/*arthord.NanoSatan Mu                  */ MOVE_RANGE_240 +
/*arthord.NanoSatanMelee Beta           */ MOVE_RANGE_240 +
/*ary.micro.Weak 1.2                    */ MOVE_RANGE_240 +
/*ary.nano.AceSurf 1.2                  */ MOVE_RANGE_000 + 
/*ary.nano.ColorNanoP 1.1               */ MOVE_RANGE_240 +
/*as.xbots 1.0                          */ MOVE_RANGE_240 +
/*awesomeness.Elite 1.0                 */ MOVE_RANGE_240 +
/*baal.nano.N 1.42                      */ MOVE_RANGE_240 +
/*banshee.micro.Nexus6 0.3.0            */ MOVE_RANGE_240 +
/*bayen.nano.Squirrel 0.2               */ MOVE_RANGE_000 + 
/*bayen.UbaMicro 1.4                    */ MOVE_RANGE_240 +
/*bayen.UbaRamLT 1.0                    */ MOVE_RANGE_240 + 
/*bbo.RamboT 0.3                        */ MOVE_RANGE_240 +
/*bons.NanoStalker 1.2                  */ MOVE_RANGE_240 +
/*bp.Kuma 1.0                           */ MOVE_RANGE_240 +
/*braaropolis.Abot 1.0                  */ MOVE_RANGE_240 +
/*bvh.micro.Freya 0.3                   */ MOVE_RANGE_240 +
/*bvh.micro.Svadilfari 0.2              */ MOVE_RANGE_240 +
/*bzdp.BoxCar 2.0                       */ MOVE_RANGE_240 +
/*bzbp.Pansy 2.1                        */ MOVE_RANGE_240 +
/*caimano.Furia_Ceca 0.22               */ MOVE_RANGE_240 +
/*chase.c.Wristwatch 1.0                */ MOVE_RANGE_000 + 
/*chase.o.Orbit 0.1                     */ MOVE_RANGE_240 +
/*chickenfuego.UrChicken2 1.0           */ MOVE_RANGE_240 +
/*cjk.Merkava 0.1.1                     */ MOVE_RANGE_240 +
/*cjm.Charo 1.1                         */ MOVE_RANGE_240 +
/*codemojo.nano.Woot 1.0                */ MOVE_RANGE_240 +
/*cx.micro.Blur 0.2                     */ MOVE_RANGE_240 +
/*cx.micro.Smoke 0.96                   */ MOVE_RANGE_240 +
/*cx.micro.Spark 0.6                    */ MOVE_RANGE_240 +
/*cx.nano.Smog 2.6                      */ MOVE_RANGE_000 + 
/*davidalves.net.DuelistMicro 1.22      */ MOVE_RANGE_240 +
/*davidalves.net.DuelistMicroMkII 1.1   */ MOVE_RANGE_240 +
/*davidalves.net.DuelistNano 1.0        */ MOVE_RANGE_240 +
/*demetrix.nano.Neutrino 0.27           */ MOVE_RANGE_240 +
/*demetrix.nano.SledgeHammer 0.22       */ MOVE_RANGE_240 +          
/*dft.Freddie 1.32                      */ MOVE_RANGE_240 +
/*dft.Guppy 1.0                         */ MOVE_RANGE_000 +
/*dggp.haiku.gpBot_0 1.1                */ MOVE_RANGE_240 +
/*djdjdj.NanoSkunk10 1.0                */ MOVE_RANGE_240 +
/*dks.MicroDanMK2 1.0                   */ MOVE_RANGE_240 +
/*DM.Mijit .3                           */ MOVE_RANGE_240 +
/*dmp.micro.Aurora 1.41                 */ MOVE_RANGE_240 +//M120 + M120 + M120 + M120 + M120 + M120 + M120 + M150 + M150 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + 
/*dmp.nano.Eve 3.41                     */ MOVE_RANGE_240 +
/*donjezza.Jezza 1.0                    */ MOVE_RANGE_240 +
/*donjezza.Muncho 1.0                   */ MOVE_RANGE_240 +
/*drd.DreadKnoght 0.9                   */ MOVE_RANGE_240 +
/*dsw.StaticD 1.0                       */ MOVE_RANGE_240 +
/*dukie.Ambassador 1.0                  */ MOVE_RANGE_000 + 
/*dummy.micro.HummingBird 2.14          */ MOVE_RANGE_240 +
/*dummy.micro.Sparrow 2.5               */ MOVE_RANGE_000 + 
/*dz.GalbaMicro 0.11                    */ MOVE_RANGE_240 +
/*dz.MostlyHarmlessNano 2.1             */ MOVE_RANGE_000 + 
/*dz.OthoMicro 0.12                     */ MOVE_RANGE_240 +
/*el.JumpShoot 0.2                      */ MOVE_RANGE_240 +
/*el33t.EL33tGangstarr2 2.0             */ MOVE_RANGE_060 + 
/*elloco.Flower 0.1r1                   */ MOVE_RANGE_240 +
/*elvbot.ElverionBot 0.3                */ MOVE_RANGE_240 +                      
/*evd.X1 0.01                           */ MOVE_RANGE_240 +
/*fcr.First 1.0                         */ MOVE_RANGE_240 +
/*Fenix.FenixTrack 1.0                  */ MOVE_RANGE_240 +
/*fm.claire 1.7                         */ MOVE_RANGE_240 +
/*fm.mammillarias 1.3                   */ MOVE_RANGE_000 + 
/*fullsail.SweetTea 1.1                 */ MOVE_RANGE_240 +
/*germ.TheMind .2                       */ MOVE_RANGE_240 +
/*gh.micro.Grinnik 0.7                  */ MOVE_RANGE_240 +
/*gh.micro.GrubbmThree 0.9              */ MOVE_RANGE_240 +
/*gh.nano.Grofvuil 0.2                  */ MOVE_RANGE_240 +
/*gio.RealGioBot 1.0                    */ MOVE_RANGE_240 +
/*gu.MicroScoob 1.3                     */ MOVE_RANGE_240 +
/*ins.MobyNano 0.8                      */ MOVE_RANGE_240 +
/*jab.micro.Sanguijuela 0.8             */ MOVE_RANGE_240 +
/*jam.micro.RaikoMicro 1.44             */ MOVE_RANGE_240 +
/*janm.Jammy 1.0                        */ MOVE_RANGE_240 +
/*japs.Serenity 1.0                     */ MOVE_RANGE_240 +
/*jaw.KarenCain 0.11                    */ MOVE_RANGE_240 +
/*jaw.Mouse 0.11                        */ MOVE_RANGE_240 +
/*jcw.ArcherOne 1.0                     */ MOVE_RANGE_240 +
/*jep.nano.Hawkwing 0.4.1               */ MOVE_RANGE_240 +
/*jep.nano.Hotspur 0.1                  */ MOVE_RANGE_240 +
/*jgap.JGAP12584 1.0                    */ MOVE_RANGE_240 +
/*jgap.JGAP130166 1.0                   */ MOVE_RANGE_240 +
/*jgap.JGAP23423 1.0                    */ MOVE_RANGE_240 +
/*jgap.JGAP6139 1.0                     */ MOVE_RANGE_240 +
/*jgap.JGAP7247_2 1.0                   */ MOVE_RANGE_240 +
/*jgap.JGAP7958 1.0                     */ MOVE_RANGE_240 +
/*jk.micro.Toorkild 0.1.1               */ MOVE_RANGE_240 +
/*joe.ADinosaur 1.0                     */ MOVE_RANGE_240 +
/*jp.SineWall 1.0                       */ MOVE_RANGE_240 +
/*js.PinBall 1.6                        */ MOVE_RANGE_240 +
/*jsal.Jsalbot 1.0                      */ MOVE_RANGE_240 +
/*jt.SpearmintCT Alpha                  */ MOVE_RANGE_000 + 
/*kawigi.f.FhqwhgadsMicro 1.0           */ MOVE_RANGE_240 + 
/*kawigi.micro.Shiz 1.1                 */ MOVE_RANGE_240 +
/*kawigi.nano.FunkyChicken 1.1          */ MOVE_RANGE_240 +
/*kawigi.nano.ThnikkaBot 0.9            */ MOVE_RANGE_000 + 
/*kawigi.sbf.FloodMicro 1.5             */ MOVE_RANGE_000 + 
/*kawigi.sbf.FloodNano 1.2              */ MOVE_RANGE_240 +
/*kc.micro.Needle 0.101                 */ MOVE_RANGE_240 +
/*kc.micro.Thorn 1.142                  */ MOVE_RANGE_240 +
/*kc.micro.WaveShark 0.3                */ M120 + M120 + M120 + M120 + M120 + M120 + M120 + M150 + M150 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + M240 + 
/*kc.nano.Splinter 1.2                  */ MOVE_RANGE_240 +
/*kinsen.nano.Hoplomachy 1.6            */ MOVE_RANGE_240 +
/*kinsen.nano.Quarrelet 1.0             */ MOVE_RANGE_240 +
/*kinsen.nano.Senticous 1.0             */ MOVE_RANGE_240 +
/*kjc.etc.Dharok 1.0                    */ MOVE_RANGE_240 +
/*kjc.Karaykan 1.0                      */ MOVE_RANGE_240 +
/*kjc.MailManX 2.0                      */ MOVE_RANGE_240 +
/*kurios.DOSexe .9                      */ MOVE_RANGE_240 +
/*leb.ShootAnArrow 0.1                  */ MOVE_RANGE_240 +
/*lechu.Lechu 1.1                       */ MOVE_RANGE_240 +
/*lion.Kresnanano 1.0                   */ MOVE_RANGE_000 + 
/*lk.nano.Avesnar 1.1                   */ MOVE_RANGE_000 + 
/*lrem.micro.FalseProphet Alpha         */ MOVE_RANGE_240 +
/*lrem.micro.MoggFanatic 0.2            */ MOVE_RANGE_240 +
/*lw.LuthersTest 0.1                    */ MOVE_RANGE_240 +
/*m3thos.Eva00 1.1                      */ MOVE_RANGE_000 + 
/*marcinek.TopGun 1.3                   */ MOVE_RANGE_240 +
/*mbro.BelajarBot 0.0.3                 */ MOVE_RANGE_240 +
/*mbro.Detektor3 0.1.1                  */ MOVE_RANGE_240 +
/*mc.Messapia 0.1.8                     */ MOVE_RANGE_240 +
/*mld.DustBunny 3.8                     */ MOVE_RANGE_000 + 
/*mld.Infinity 2.2                      */ MOVE_RANGE_000 + 
/*mld.Moebius 2.9.3                     */ MOVE_RANGE_240 +
/*mld.Tide 1.2                          */ MOVE_RANGE_240 +
/*mld.Wisdom 1.0                        */ MOVE_RANGE_240 +
/*mme.NikeEnhanced 2.0                  */ MOVE_RANGE_240 +
/*mrm.MightyMoose .2                    */ MOVE_RANGE_240 +
/*myl.micro.Avipes 1.00                 */ MOVE_RANGE_240 +
/*myl.micro.NekoNinja 1.30              */ MOVE_RANGE_000 + 
/*myl.micro.Predator 1.50               */ MOVE_RANGE_240 +
/*myl.micro.Troodon 1.10                */ MOVE_RANGE_240 +
/*myl.nano.Graviton 1.10                */ MOVE_RANGE_240 +
/*myl.nano.Kakuru 1.20                  */ MOVE_RANGE_240 +
/*myl.nano.KomoriNinja 1.1              */ MOVE_RANGE_240 +
/*mz.Adept 2.65                         */ MOVE_RANGE_240 +
/*mz.AdeptBSB 1.03                      */ MOVE_RANGE_240 +
/*mz.Movement 1.8                       */ MOVE_RANGE_240 +
/*mz.NanoDeath 2.56                     */ MOVE_RANGE_240 +
/*mz.NanoGod 2.02                       */ MOVE_RANGE_240 +
/*nanoskank.NanoSkank 1.0               */ MOVE_RANGE_240 +
/*nat.micro.NP 1.34                     */ MOVE_RANGE_240 +
/*nat.micro.Reepicheep 0.1a             */ MOVE_RANGE_240 +
/*nat.nano.Ocnirp 1.5                   */ MOVE_RANGE_240 + 
/*nat.nano.OcnirpPM 1.0                 */ MOVE_RANGE_240 +
/*nat.nano.OcnirpSNG 1.0b               */ MOVE_RANGE_240 +
/*ndn.DyslexicMonkey 1.1                */ MOVE_RANGE_240 +
/*nexus.Prototype 1.0                   */ MOVE_RANGE_240 +
/*nova.Snow 1.0                         */ MOVE_RANGE_240 +
/*ntc.Cannon 1.12test                   */ MOVE_RANGE_240 +
/*ntc.Knowledge 1.1                     */ MOVE_RANGE_240 +
/*ntc.Plains 0.9                        */ MOVE_RANGE_000 + 
/*ntw.Sigsys 1.6                        */ MOVE_RANGE_240 +
/*ntc.Swim 0.9                          */ MOVE_RANGE_240 +
/*nz.jdc.micro.HedgehogGF 1.3           */ MOVE_RANGE_240 +
/*nz.jdc.micro.HedgehogP 1.2            */ MOVE_RANGE_240 + 
/*nz.jdc.nano.NeophytePattern 1.0       */ MOVE_RANGE_240 +
/*nz.jdc.nano.NeophytePRAL 1.2          */ MOVE_RANGE_240 +
/*nz.jdc.nano.NeophyteSRAL 1.2          */ MOVE_RANGE_240 +
/*oog.melee.Capulet 0.1                 */ MOVE_RANGE_240 +
/*oog.melee.CapuletDroid 1.0            */ MOVE_RANGE_240 +
/*oog.melee.Mercutio 1.0                */ MOVE_RANGE_240 +
/*oog.melee.StarLight 0.1               */ MOVE_RANGE_240 +
/*oog.micro.MagicD3 0.41                */ MOVE_RANGE_240 +
/*oog.micro.Maui 1.1                    */ MOVE_RANGE_240 +
/*oog.micro.SavantMicro 0.31            */ MOVE_RANGE_240 + 
/*oog.nano.Fuatisha 1.0                 */ MOVE_RANGE_240 + 
/*oog.MagicD2 2.3                       */ MOVE_RANGE_240 +
/*oog.nano.SavantVS 1.1                 */ MOVE_RANGE_000 + 
/*oog.nano.SavantWS 1.1                 */ MOVE_RANGE_240 + 
/*pa.Improved 1.1                       */ MOVE_RANGE_240 +
/*pak.Dargon 1.0b                       */ MOVE_RANGE_240 +
/*pak.JakeTheTestingRobot .1b           */ MOVE_RANGE_240 +
/*paolord.TheHulk 1.0                   */ MOVE_RANGE_240 +
/*pb.Oscillator 1.0                     */ MOVE_RANGE_240 +
/*pez.micro.Aristocles 0.3.7            */ MOVE_RANGE_240 +
/*pez.nano.Icarus 0.3                   */ MOVE_RANGE_240 +
/*pez.nano.LittleEvilBrother 0.1        */ MOVE_RANGE_240 +
/*pfvicm.Sobieski 7.2.3b                */ MOVE_RANGE_240 +
/*ph.micro.Pikeman 0.4.5                */ MOVE_RANGE_240 +
/*PkKillers.PkAssassin 1.0              */ MOVE_RANGE_240 +
/*pmc.SniperBot 1.0                     */ MOVE_RANGE_240 +
/*projectx.ProjectNano 2.0              */ MOVE_RANGE_000 + 
/*projectx.TestNano 1.0                 */ MOVE_RANGE_240 +
/*pulsar.Nanis 0.3                      */ MOVE_RANGE_240 +
/*pulsar.PulsarNano 0.2.4               */ MOVE_RANGE_240 +
/*quietus.Invader 0.1                   */ MOVE_RANGE_240 + 
/*quietus.NarrowRadar 0.1               */ MOVE_RANGE_240 +
/*radnor.DoctorBob 1.42                 */ MOVE_RANGE_240 +
/*ratosh.nano.Debo 1.36                 */ MOVE_RANGE_240 +
/*ratosh.Nobo 0.21                      */ MOVE_RANGE_240 +
/*ratosh.Wesco 1.4                      */ MOVE_RANGE_000 + 
/*rcp.Kuramatron 1.0                    */ MOVE_RANGE_240 +
/*repositorio.NanoStep 1.0              */ MOVE_RANGE_240 +
/*robo.PartsBot 1.0                     */ MOVE_RANGE_240 +
/*robar.haiku.Spike 1.0                 */ MOVE_RANGE_240 +
/*robar.micro.Gladius 1.15              */ MOVE_RANGE_240 +
/*robar.micro.Kirbyi 1.0                */ MOVE_RANGE_240 +
/*robar.micro.Topaz 0.25                */ MOVE_RANGE_240 +
/*robar.nano.Assertive 0.3              */ MOVE_RANGE_240 +
/*robar.nano.BlackWidow 1.3             */ MOVE_RANGE_240 +
/*robar.nano.Breeze 0.3                 */ MOVE_RANGE_060 +
/*robar.nano.Mosquito 1.1               */ MOVE_RANGE_240 +
/*robar.nano.MosquitoPM 1.0             */ MOVE_RANGE_240 +
/*robar.nano.Prestige 1.0               */ MOVE_RANGE_240 +
/*robar.nano.Pugio 1.47                 */ MOVE_RANGE_240 +
/*robar.nano.Scytodes 0.3               */ MOVE_RANGE_240 +
/*robar.nano.Vespa 0.95                 */ MOVE_RANGE_240 +
/*rsim.micro.uCatcher 0.1               */ MOVE_RANGE_240 +
/*ruc.nano.Zealot 0.2                   */ MOVE_RANGE_240 +
/*ry.LightningBug 1.0                   */ MOVE_RANGE_240 +
/*ry.Worst 1.0                          */ MOVE_RANGE_240 +
/*rz.Artist 0.2                         */ MOVE_RANGE_240 +
/*rz.GlowBlow 2.31                      */ MOVE_RANGE_240 +
/*rz.HawkOnFire 0.1                     */ MOVE_RANGE_240 +
/*rz.SmallDevil 1.502                   */ MOVE_RANGE_240 +
/*sam.Samspin 1.0                       */ MOVE_RANGE_240 +
/*sgp.nano.FurryLeech 1.0               */ MOVE_RANGE_240 +
/*sgp.ShiningBeetle 1.1                 */ MOVE_RANGE_240 +
/*sgp.SleepingGoat 1.1                  */ MOVE_RANGE_240 +
/*simonton.GFNano_D 3.1b                */ MOVE_RANGE_240 +
/*simonton.micro.GFMicro 1.0            */ MOVE_RANGE_240 +
/*simonton.micro.WeeklongObsession 3.4.1*/ MOVE_RANGE_240 +
/*simonton.nano.WeekendObsession_S 1.7  */ MOVE_RANGE_240 +
/*spinnercat.haiku.Refrigerator 1.1     */ MOVE_RANGE_060 +
/*spinnercat.CopyKat 1.2.3              */ MOVE_RANGE_240 +
/*spinnercat.Kitten 1.4                 */ MOVE_RANGE_240 +
/*spinnercat.Limit .01                  */ MOVE_RANGE_240 +
/*stelo.FretNano 1.1                    */ MOVE_RANGE_240 +
/*stelo.MatchupMicro 1.2                */ MOVE_RANGE_240 +
/*stelo.MirrorMicro 1.1                 */ MOVE_RANGE_240 +
/*stelo.MirrorNano 1.4                  */ MOVE_RANGE_240 +
/*stelo.MoojukNano 1.2                  */ MOVE_RANGE_240 +
/*stelo.PatternRobot 1.0                */ MOVE_RANGE_240 +
/*stelo.PianistNano 1.3                 */ MOVE_RANGE_240 +
/*stelo.SteloTestNano 1.0               */ MOVE_RANGE_240 +
/*stelo.UnfoolableNano 1.0              */ MOVE_RANGE_240 +
/*stelo.UntouchableNano 1.4             */ MOVE_RANGE_240 +
/*step.NanoBidu 1.0                     */ MOVE_RANGE_240 +   
/*step.nanoPri 1.0                      */ MOVE_RANGE_240 +
/*strider.Festis 1.2.1                  */ MOVE_RANGE_240 +
/*strider.Mer 1.1.0                     */ MOVE_RANGE_120 + 
/*sul.Bicephal 1.2                      */ MOVE_RANGE_240 +
/*sul.BlueBot 1.0                       */ MOVE_RANGE_240 +
/*sul.NanoR2 1.32                       */ MOVE_RANGE_240 +
/*sul.Pinkbot 1.1                       */ MOVE_RANGE_240 +
/*stuff.Vlad 0.1                        */ MOVE_RANGE_240 +
/*timmit.nano.TimCat 0.13               */ MOVE_RANGE_240 +
/*timmit.nano.TimDog 0.33               */ MOVE_RANGE_240 +
/*tlp.ThreeLeggedPig 1                  */ MOVE_RANGE_240 +
/*tobe.calypso.Calypso 4.1              */ MOVE_RANGE_000 + 
/*tornyil.bottomup.BottomUp 1.05        */ MOVE_RANGE_240 +
/*toz.Gnome 1.1                         */ MOVE_RANGE_240 +
/*trab.nano.AinippeNano 1.3             */ MOVE_RANGE_240 +
/*usa.nano.Nemo 2.0                     */ MOVE_RANGE_240 +
/*vft.Hrist 1.0                         */ MOVE_RANGE_240 +
/*vft.Valkyrie 1.0                      */ MOVE_RANGE_240 +
/*voidious.micro.Jen 1.11               */ MOVE_RANGE_240 + 
/*wiki.nano.DevilFISH 1.0               */ MOVE_RANGE_240 +
/*wiki.nano.RaikoNano 1.1               */ MOVE_RANGE_240 +
/*winamp32.micro.MicroMacro 1.0         */ MOVE_RANGE_240 + 
/*yarghard.Y101 1.0                     */ MOVE_RANGE_000 + 
/*yk.JahMicro 1.0                       */ MOVE_RANGE_240 +
/*zch.David 0.21                        */ MOVE_RANGE_240 +
/*zch.Hirkan 0.11                       */ MOVE_RANGE_240 +                 
/*zyx.micro.Ant 1.1                     */ MOVE_RANGE_240 +
/*zyx.nano.Ant 1.1                      */ MOVE_RANGE_240 +
/*zyx.nano.EscherichiaColi 1.0          */ MOVE_RANGE_240 +
/*zyx.nano.RedBull 1.0                  */ MOVE_RANGE_240 +

/*ahf.r2d2.R2d2 0.86                    */ MOVE_RANGE_120 +
/*AIR.iRobot 1.0                        */ MOVE_RANGE_120 +
/*amk.ChumbaMini 0.2                    */ MOVE_RANGE_240 +
/*amk.jointstrike.JointStrike 0.2       */ MOVE_RANGE_120 +
/*apv.Aspid 1.7                         */ MOVE_RANGE_240 +
/*apv.AspidReloaded 0.6                 */ MOVE_RANGE_120 +
/*ar.QuantumChromodynamics 1.2.1        */ MOVE_RANGE_240 +
/*ary.mini.Nimi 1.0                     */ MOVE_RANGE_240 +
/*banshee.mini.Nexus6 0.2.0             */ MOVE_RANGE_240 +
/*bbo.TheRoof 1.4.3                     */ MOVE_RANGE_000 +
/*bvh.hdr.Hodur 0.4                     */ MOVE_RANGE_120 +
/*bvh.mini.Fenrir 0.39                  */ MOVE_RANGE_240 +
/*bvh.mini.Freya 0.55                   */ MOVE_RANGE_240 +
/*bvh.mini.Mjolnir 0.3                  */ MOVE_RANGE_000 +
/*bvh.mini.Wodan 0.50                   */ MOVE_RANGE_240 +
/*cf.mini.Chiva 1.0                     */ MOVE_RANGE_240 +
/*ch.rhj.rbc.RHJ1 1.0                   */ MOVE_RANGE_240 +
/*chase.pm.Pytko 1.0                    */ MOVE_RANGE_240 +
/*cjk.Merkava 0.2.0                     */ MOVE_RANGE_120 +
/*cjk.Merkava 0.3.0                     */ MOVE_RANGE_120 +
/*cjm.Che 1.2                           */ MOVE_RANGE_120 +
/*cx.mini.BlackSwans 0.60               */ MOVE_RANGE_120 +
/*cx.mini.Cigaret 1.31                  */ MOVE_RANGE_240 +
/*cx.mini.Nimrod 0.55                   */ MOVE_RANGE_240 +
/*davidalves.net.DuelistMini 1.1        */ MOVE_RANGE_240 +
/*dcs.Eater_of_Worlds_Mini 1.0          */ MOVE_RANGE_240 +
/*dft.Cyprus 3.0                        */ MOVE_RANGE_240 +
/*dmsr.MiniR101 0.6                     */ MOVE_RANGE_240 +
/*dummy.mini.Parakeet 2.40              */ MOVE_RANGE_240 +
/*dvogon.GangBang 1.0                   */ MOVE_RANGE_240 +
/*dz.GalbaMini 0.121                    */ MOVE_RANGE_240 +
/*dz.OthoMini 0.15                      */ MOVE_RANGE_240 +
/*eat.HumblePieLite 1.0                 */ MOVE_RANGE_120 +
/*el.Attackr 0.1                        */ MOVE_RANGE_240 +
/*eld.Hmm 1.0                           */ MOVE_RANGE_240 +
/*fala.robocode.FalaRobot 1.0           */ MOVE_RANGE_000 +
/*florent.small.LittleAngel 1.8         */ MOVE_RANGE_240 +
/*fullsail.TimbotNoPrediction 1.0       */ MOVE_RANGE_240 +
/*fw.Number1 1.0b                       */ MOVE_RANGE_240 +
/*geep.mini.GPBotA 1.0                  */ MOVE_RANGE_000 +
/*geep.mini.GPBotB 1.1                  */ MOVE_RANGE_240 +
/*gh.mini.Gruwel 0.9                    */ MOVE_RANGE_240 +
/*gio.RealGioBot 1.0                    */ MOVE_RANGE_240 +
/*goblin.Bender 2.4                     */ MOVE_RANGE_240 +
/*jam.mini.Raiko 0.43                   */ MOVE_RANGE_240 +
/*japs.Sjonniebot 0.9.1                 */ MOVE_RANGE_120 +
/*jekl.mini.BlackPearl .91              */ MOVE_RANGE_240 +
/*jk.mini.CunobelinDC 0.4CT             */ MOVE_RANGE_240 +
/*kanishk.Fr0z3n 1.1                    */ MOVE_RANGE_000 +
/*kawigi.mini.Coriantumr 1.1            */ MOVE_RANGE_240 +
/*kawigi.mini.Fhqwhgads 1.1             */ MOVE_RANGE_240 +
/*kawigi.sbf.Barracuda 1.0              */ MOVE_RANGE_000 +
/*kawigi.sbf.FloodMini 1.4              */ MOVE_RANGE_240 +
/*kawigi.sbf.Teancum 1.3                */ MOVE_RANGE_240 +
/*kc.mini.Vyper 0.311                   */ MOVE_RANGE_120 +
/*kcn.percept.PerceptBot 2.3            */ MOVE_RANGE_120 +
/*krillr.mini.JointStrike 2.0.0         */ MOVE_RANGE_240 +
/*m3thos.mini.Eva01 0.5.5               */ MOVE_RANGE_120 +
/*marksteam.Phoenix 1.0                 */ MOVE_RANGE_000 +
/*mbh.Mbh 0.1                           */ MOVE_RANGE_240 +
/*mbro.BelajarBot 0.0.3                 */ MOVE_RANGE_240 +
/*mdouet.BotKicker 2.0                  */ MOVE_RANGE_240 +
/*mladjo.AIR 0.7                        */ MOVE_RANGE_120 +
/*mladjo.Grrrrr 0.9                     */ MOVE_RANGE_240 +
/*mladjo.Startko 1.0                    */ MOVE_RANGE_240 +
/*mwj.A1176183 1.0                      */ MOVE_RANGE_240 +
/*nic.SnippetBot 1.0                    */ MOVE_RANGE_120 +
/*nkn.mini.Jskr0 0.1                    */ MOVE_RANGE_240 +
/*ntc.Evader 1.2                        */ MOVE_RANGE_240 +
/*ntw.Sighup 1.5                        */ MOVE_RANGE_240 +
/*oa.weak.BotherBot 0.1                 */ MOVE_RANGE_240 +
/*oa.weak.FlyMk1 0.1                    */ MOVE_RANGE_240 +
/*oog.mini.MagestyOfColors 0.1          */ MOVE_RANGE_240 +
/*pak.Dargon .2c                        */ MOVE_RANGE_240 +
/*pe.mini.SandboxMini 1.2               */ MOVE_RANGE_240 +
/*pe.minimelee.SandboxMiniMelee 1.1     */ MOVE_RANGE_240 +
/*pez.mini.ChironexFleckeri 0.5         */ MOVE_RANGE_120 +
/*pez.mini.Gouldingi 1.5                */ MOVE_RANGE_240 +
/*pez.mini.Pugilist 2.4.18              */ MOVE_RANGE_240 +
/*pez.mini.Tityus 0.9.1                 */ MOVE_RANGE_240 +
/*pez.mini.VertiLeach 0.4.0             */ MOVE_RANGE_240 +
/*ph.mini.Archer 0.6.6                  */ MOVE_RANGE_240 +
/*pkdeken.Paladin 1.0                   */ MOVE_RANGE_240 +
/*radnor.RamRod 1.0                     */ MOVE_RANGE_240 +
/*rsim.mini.BulletCatcher 0.4           */ MOVE_RANGE_240 +
/*rz.Apollon 0.23                       */ MOVE_RANGE_120 +
/*rz.GlowBlowAPM 1.0                    */ MOVE_RANGE_240 +
/*rz.GlowBlowMelee 1.4                  */ MOVE_RANGE_240 +
/*simonton.mini.WeeksOnEnd 1.10.4       */ MOVE_RANGE_240 +
/*skm.PateranBotlock2 1.0               */ MOVE_RANGE_240 +
/*skm.Ryubot 1.0                        */ MOVE_RANGE_240 +
/*sng.arco.Arco 0.0                     */ MOVE_RANGE_240 +
/*stelo.Lifestealer 1.0                 */ MOVE_RANGE_240 +
/*stelo.MatchupMini 1.1                 */ MOVE_RANGE_120 +
/*stf.PanzerGeneral 0.1                 */ MOVE_RANGE_240 +
/*synnalagma.test.MiniNeural 1.1        */ MOVE_RANGE_240 +
/*timmit.mini.TimVA 0.43                */ MOVE_RANGE_240 +
/*tobe.mini.Charon 0.9                  */ MOVE_RANGE_000 +
/*tornyil.Lajcsi2.Lajcsi2sm 1.0         */ MOVE_RANGE_240 +
/*vft.Valkyrie 1.0                      */ MOVE_RANGE_240 +
/*voidious.mini.Komarious 1.88          */ MOVE_RANGE_240 +
/*wiki.mini.BlackDestroyer 0.9.0        */ MOVE_RANGE_240 +
/*wiki.mini.GouldingiHT 1.0             */ MOVE_RANGE_240 +
/*wiki.mini.Griffon 0.1                 */ MOVE_RANGE_240 +
/*wiki.mini.Sedan 1.0                   */ MOVE_RANGE_120 +
/*wit.Deep7 2.0                         */ MOVE_RANGE_240 +
/*yk.JahRoslav 1.1                      */ MOVE_RANGE_120 +
/*WhoAmI.WhoAmI 1.00                    */ MOVE_RANGE_240 +
/*oog.nano.Caligula 1.15                */ MOVE_RANGE_240 + 
/*buba.Archivist 0.1                    */ MOVE_RANGE_240 +
/*buba.Buba 0.3                         */ MOVE_RANGE_000 +
/*cs.ExclusionNano 1.1                  */ MOVE_RANGE_000 +
/*eskimo.micro.Echo 0.1                 */ MOVE_RANGE_000 +
/*exauge.LemonDrop 1.6.130              */ MOVE_RANGE_240 +
/*gwah.GBotMarkIV 1.0                   */ MOVE_RANGE_000 +
/*gwah.GerryBotMkII 1.5.1               */ MOVE_RANGE_000 +
/*hapiel.Spiral 0.1                     */ MOVE_RANGE_000 +
/*jf.Dodger 1.1                         */ MOVE_RANGE_240 +
/*mym.EdgeStalker 1.0                   */ MOVE_RANGE_000 +
/*NG.LegatusLegionis 1.2                */ MOVE_RANGE_000 +
/*povik.nano.Smilee 0.2.1               */ MOVE_RANGE_240 +
/*rampancy.micro.Epiphron 1.0           */ MOVE_RANGE_000 +
/*SuperSample.SuperCrazy 1.0            */ MOVE_RANGE_240 +
/*timmit.micro.TimXJ 0.22               */ MOVE_RANGE_240 +
/*exauge.GateKeeper 1.1.121g            */ MOVE_RANGE_240 +
/*exauge.Leopard 1.1.019                */ MOVE_RANGE_240 +
/*ayk.WallHugger 1.0                    */ MOVE_RANGE_240 +

END_OVERFLOW_BUFFER;

static final String MOVE_00 =      "" + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00;
static final String MOVE_05 =      "" + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05;
static final String MOVE_15 =      "" + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15;
static final String MOVE_25 =      "" + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25;
static final String MOVE_99 =      "" + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99;
static final String MOVE_MX =      "" + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX;
static final String MOVE_STOP_GO = "" + MMAX + MMAX + MMAX + MMAX + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA;

	private static final String MoveDistanceList = // Movement distance (non-randomness) per range
//                               Distance: 20     40     60     80     100    120    140    160    180    200    220    240    260    280    300    320    340    360    380    400    420    440    460    480    500    520    540    560    580    600    620    640    660    680    700    720    740    760    780    800    
/*default_fail_case                    */' '+ MOVE_STOP_GO + 
/*ad.last.Bottom 1.0                    */ MOVE_99 +
/*ags.micro.Carpet 1.1                  */ MOVE_99 +
/*ahf.Acero 1.0                         */ MOVE_99 +
/*ahf.NanoAndrew .4                     */ MOVE_15 +
/*amk.Punbot.Punbot 0.01                */ MOVE_99 +
/*ap.Frederick 1.1                      */ MOVE_MX + 
/*apv.MicroAspid 1.8                    */ MOVE_15 +
/*apv.NanoLauLectrik 1.0                */ MOVE_15 +
/*apv.NanoLauLectrikTheCannibal 1.1     */ MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV15 + MV99 + MV99 + MV99 + MV99 + MV25 + MV99 + MV15 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 +
/*arthord.KostyaTszyu Beta2             */ MOVE_00 +
/*arthord.MannyPacquiao Beta            */ MOVE_99 +
/*arthord.micro.Apoptygma 0.4           */ MOVE_00 +
/*arthord.micro.Muffin 0.6.1            */ MOVE_00 +
/*arthord.NanoSatan Mu                  */ MOVE_15 +
/*arthord.NanoSatanMelee Beta           */ MOVE_99 +
/*ary.micro.Weak 1.2                    */ MOVE_00 +
/*ary.nano.AceSurf 1.2                  */ MOVE_STOP_GO + 
/*ary.nano.ColorNanoP 1.1               */ MOVE_15 +
/*as.xbots 1.0                          */ MOVE_99 +
/*awesomeness.Elite 1.0                 */ MOVE_99 +
/*baal.nano.N 1.42                      */ MOVE_99 +
/*banshee.micro.Nexus6 0.3.0            */ MOVE_99 +
/*bayen.nano.Squirrel 0.2               */ MMAX + MMAX + MMAX + MMAX + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 +   
/*bayen.UbaMicro 1.4                    */ MOVE_15 +
/*bayen.UbaRamLT 1.0                    */ MOVE_MX + 
/*bbo.RamboT 0.3                        */ MOVE_99 +
/*bons.NanoStalker 1.2                  */ MOVE_99 +
/*bp.Kuma 1.0                           */ MOVE_99 +
/*braaropolis.Abot 1.0                  */ MOVE_99 +
/*bvh.micro.Freya 0.3                   */ MOVE_99 +
/*bvh.micro.Svadilfari 0.2              */ MOVE_99 +
/*bzdp.BoxCar 2.0                       */ MOVE_15 +
/*bzbp.Pansy 2.1                        */ MOVE_99 +
/*caimano.Furia_Ceca 0.22               */ MOVE_99 +
/*chase.c.Wristwatch 1.0                */ MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 +
/*chase.o.Orbit 0.1                     */ MOVE_15 +
/*chickenfuego.UrChicken2 1.0           */ MOVE_15 +
/*cjk.Merkava 0.1.1                     */ MOVE_15 +
/*cjm.Charo 1.1                         */ MOVE_15 +     
/*codemojo.nano.Woot 1.0                */ MOVE_99 +
/*cx.micro.Blur 0.2                     */ MOVE_99 +
/*cx.micro.Smoke 0.96                   */ MOVE_15 +
/*cx.micro.Spark 0.6                    */ MOVE_00 +
/*cx.nano.Smog 2.6                      */ MOVE_STOP_GO + 
/*davidalves.net.DuelistMicro 1.22      */ MOVE_00 +
/*davidalves.net.DuelistMicroMkII 1.1   */ MOVE_15 +
/*davidalves.net.DuelistNano 1.0        */ MOVE_99 +
/*demetrix.nano.Neutrino 0.27           */ MOVE_99 +
/*demetrix.nano.SledgeHammer 0.22       */ MOVE_99 +
/*dft.Freddie 1.32                      */ MOVE_99 +
/*dft.Guppy 1.0                         */ MMAX + MMAX + MMAX + MMAX + MMAX + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA +//MOVE_STOP_GO + //MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV25 + MV25 + MV25 + MV15 + MV05 + MV15 + MV05 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 +
/*dggp.haiku.gpBot_0 1.1                */ MOVE_99 +
/*djdjdj.NanoSkunk10 1.0                */ MOVE_99 +
/*dks.MicroDanMK2 1.0                   */ MOVE_99 +
/*DM.Mijit .3                           */ MOVE_00 +
/*dmp.micro.Aurora 1.41                 */ MOVE_15 +
/*dmp.nano.Eve 3.41                     */ MOVE_99 +
/*donjezza.Jezza 1.0                    */ MOVE_15 +
/*donjezza.Muncho 1.0                   */ MOVE_99 +
/*drd.DreadKnoght 0.9                   */ MOVE_15 +
/*dsw.StaticD 1.0                       */ MOVE_15 +
/*dukie.Ambassador 1.0                  */ MOVE_STOP_GO + 
/*dummy.micro.HummingBird 2.14          */ MOVE_99 +
/*dummy.micro.Sparrow 2.5               */ MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MV99 + MV99 + MV99 +
/*dz.GalbaMicro 0.11                    */ MOVE_00 +
/*dz.MostlyHarmlessNano 2.1             */ MOVE_STOP_GO + 
/*dz.OthoMicro 0.12                     */ MOVE_15 +
/*el.JumpShoot 0.2                      */ MOVE_99 +
/*el33t.EL33tGangstarr2 2.0             */ MOVE_STOP_GO + 
/*elloco.Flower 0.1r1                   */ MOVE_99 +
/*elvbot.ElverionBot 0.3                */ MOVE_15 +
/*evd.X1 0.01                           */ MOVE_99 +
/*fcr.First 1.0                         */ MOVE_15 +
/*Fenix.FenixTrack 1.0                  */ MOVE_99 +
/*fm.claire 1.7                         */ MOVE_99 +
/*fm.mammillarias 1.3                   */ MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + 
/*fullsail.SweetTea 1.1                 */ MOVE_99 +
/*germ.TheMind .2                       */ MOVE_99 +
/*gh.micro.Grinnik 0.7                  */ MOVE_15 +
/*gh.micro.GrubbmThree 0.9              */ MOVE_99 +
/*gh.nano.Grofvuil 0.2                  */ MOVE_99 +
/*gio.RealGioBot 1.0                    */ MOVE_99 +
/*gu.MicroScoob 1.3                     */ MV25 + MV25 + MV25 + MV25 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 +
/*ins.MobyNano 0.8                      */ MOVE_15 +
/*jab.micro.Sanguijuela 0.8             */ MOVE_99 +
/*jam.micro.RaikoMicro 1.44             */ MV99 + MV99 + MV99 + MV99 + MV15 + MV99 + MV15 + MV99 + MV15 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 +
/*janm.Jammy 1.0                        */ MOVE_99 +
/*japs.Serenity 1.0                     */ MOVE_99 +
/*jaw.KarenCain 0.11                    */ MOVE_99 +
/*jaw.Mouse 0.11                        */ MOVE_99 +
/*jcw.ArcherOne 1.0                     */ MOVE_99 +
/*jep.nano.Hawkwing 0.4.1               */ MOVE_15 +
/*jep.nano.Hotspur 0.1                  */ MOVE_15 +
/*jgap.JGAP12584 1.0                    */ MOVE_00 +
/*jgap.JGAP130166 1.0                   */ MOVE_15 +
/*jgap.JGAP23423 1.0                    */ MOVE_99 +
/*jgap.JGAP6139 1.0                     */ MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV05 + MV05 + MV05 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 +
/*jgap.JGAP7247_2 1.0                   */ MOVE_00 +
/*jgap.JGAP7958 1.0                     */ MOVE_15 +
/*jk.micro.Toorkild 0.1.1               */ MOVE_00 +
/*joe.ADinosaur 1.0                     */ MOVE_15 +
/*jp.SineWall 1.0                       */ MOVE_99 +
/*js.PinBall 1.6                        */ MOVE_15 +
/*jsal.Jsalbot 1.0                      */ MOVE_15 +
/*jt.SpearmintCT Alpha                  */ MOVE_STOP_GO + 
/*kawigi.f.FhqwhgadsMicro 1.0           */ MOVE_05 + 
/*kawigi.micro.Shiz 1.1                 */ MOVE_99 +
/*kawigi.nano.FunkyChicken 1.1          */ MOVE_00 +
/*kawigi.nano.ThnikkaBot 0.9            */ MOVE_STOP_GO + 
/*kawigi.sbf.FloodMicro 1.5             */ MOVE_STOP_GO + 
/*kawigi.sbf.FloodNano 1.2              */ MOVE_99 +
/*kc.micro.Needle 0.101                 */ MOVE_15 +
/*kc.micro.Thorn 1.142                  */ MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 +
/*kc.micro.WaveShark 0.3                */ MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV05 + MV05 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 +
/*kc.nano.Splinter 1.2                  */ MOVE_15 +
/*kinsen.nano.Hoplomachy 1.6            */ MOVE_99 +
/*kinsen.nano.Quarrelet 1.0             */ MOVE_15 +
/*kinsen.nano.Senticous 1.0             */ MOVE_00 +
/*kjc.etc.Dharok 1.0                    */ MOVE_99 +
/*kjc.Karaykan 1.0                      */ MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 +
/*kjc.MailManX 2.0                      */ MOVE_99 +
/*kurios.DOSexe .9                      */ MV00 + MV00 + MV00 + MV00 + MV00 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 +
/*leb.ShootAnArrow 0.1                  */ MOVE_99 +
/*lechu.Lechu 1.1                       */ MOVE_15 +
/*lion.Kresnanano 1.0                   */ MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + 
/*lk.nano.Avesnar 1.1                   */ MOVE_STOP_GO + 
/*lrem.micro.FalseProphet Alpha         */ MOVE_00 +
/*lrem.micro.MoggFanatic 0.2            */ MOVE_99 +
/*lw.LuthersTest 0.1                    */ MOVE_99 +
/*m3thos.Eva00 1.1                      */ MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + 
/*marcinek.TopGun 1.3                   */ MOVE_99 +
/*mbro.BelajarBot 0.0.3                 */ MOVE_99 +
/*mbro.Detektor3 0.1.1                  */ MOVE_99 +
/*mc.Messapia 0.1.8                     */ MOVE_99 +  
/*mld.DustBunny 3.8                     */ MOVE_99 +  
/*mld.Infinity 2.2                      */ MOVE_MX +
/*mld.Moebius 2.9.3                     */ MOVE_00 +
/*mld.Tide 1.2                          */ MV00 + MV00 + MV00 + MV00 + MV00 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 +
/*mld.Wisdom 1.0                        */ MOVE_99 +
/*mme.NikeEnhanced 2.0                  */ MOVE_99 +
/*mrm.MightyMoose .2                    */ MOVE_99 +
/*myl.micro.Avipes 1.00                 */ MOVE_00 +
/*myl.micro.NekoNinja 1.30              */ MOVE_STOP_GO + 
/*myl.micro.Predator 1.50               */ MOVE_15 +
/*myl.micro.Troodon 1.10                */ MOVE_15 +
/*myl.nano.Graviton 1.10                */ MOVE_99 +
/*myl.nano.Kakuru 1.20                  */ MOVE_00 +
/*myl.nano.KomoriNinja 1.1              */ MOVE_99 +
/*mz.Adept 2.65                         */ MOVE_99 +
/*mz.AdeptBSB 1.03                      */ MOVE_15 +
/*mz.Movement 1.8                       */ MOVE_99 +
/*mz.NanoDeath 2.56                     */ MOVE_99 +
/*mz.NanoGod 2.02                       */ MOVE_99 +
/*nanoskank.NanoSkank 1.0               */ MOVE_99 +
/*nat.micro.NP 1.34                     */ MOVE_15 +
/*nat.micro.Reepicheep 0.1a             */ MOVE_15 +
/*nat.nano.Ocnirp 1.5                   */ MOVE_05 + 
/*nat.nano.OcnirpPM 1.0                 */ MOVE_15 +
/*nat.nano.OcnirpSNG 1.0b               */ MOVE_00 +
/*ndn.DyslexicMonkey 1.1                */ MOVE_15 +
/*nexus.Prototype 1.0                   */ MOVE_99 +
/*nova.Snow 1.0                         */ MOVE_00 +
/*ntc.Cannon 1.12test                   */ MOVE_00 +
/*ntc.Knowledge 1.1                     */ MOVE_25 +
/*ntc.Plains 0.9                        */ MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + 
/*ntw.Sigsys 1.6                        */ MOVE_99 +
/*ntc.Swim 0.9                          */ MOVE_15 +
/*nz.jdc.micro.HedgehogGF 1.3           */ MOVE_15 +
/*nz.jdc.micro.HedgehogP 1.2            */ MV99 + MV99 + MV99 + MV99 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + 
/*nz.jdc.nano.NeophytePattern 1.0       */ MOVE_00 +
/*nz.jdc.nano.NeophytePRAL 1.2          */ MV00 + MV00 + MV00 + MV00 + MV00 + MV99 + MV00 + MV99 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 +
/*nz.jdc.nano.NeophyteSRAL 1.2          */ MOVE_99 +
/*oog.melee.Capulet 0.1                 */ MOVE_15 +
/*oog.melee.CapuletDroid 1.0            */ MV99 + MV99 + MV99 + MV99 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 +
/*oog.melee.Mercutio 1.0                */ MOVE_15 +
/*oog.melee.StarLight 0.1               */ MOVE_99 +
/*oog.micro.MagicD3 0.41                */ MOVE_15 +
/*oog.micro.Maui 1.1                    */ MOVE_15 +
/*oog.micro.SavantMicro 0.31            */ MOVE_05 + 
/*oog.nano.Fuatisha 1.0                 */ MOVE_15 +
/*oog.MagicD2 2.3                       */ MOVE_00 +
/*oog.nano.SavantVS 1.1                 */ MOVE_STOP_GO + 
/*oog.nano.SavantWS 1.1                 */ MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + 
/*pa.Improved 1.1                       */ MOVE_99 +
/*pak.Dargon 1.0b                       */ MOVE_99 +
/*pak.JakeTheTestingRobot .1b           */ MOVE_15 +
/*paolord.TheHulk 1.0                   */ MOVE_99 +
/*pb.Oscillator 1.0                     */ MOVE_99 +
/*pez.micro.Aristocles 0.3.7            */ MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 +
/*pez.nano.Icarus 0.3                   */ MOVE_15 +
/*pez.nano.LittleEvilBrother 0.1        */ MOVE_99 +
/*pfvicm.Sobieski 7.2.3b                */ MOVE_15 +
/*ph.micro.Pikeman 0.4.5                */ MOVE_00 +
/*PkKillers.PkAssassin 1.0              */ MV00 + MV00 + MV00 + MV00 + MV00 + MV99 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV99 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 +
/*pmc.SniperBot 1.0                     */ MOVE_15 +
/*projectx.ProjectNano 2.0              */ MOVE_STOP_GO + 
/*projectx.TestNano 1.0                 */ MOVE_99 +
/*pulsar.Nanis 0.3                      */ MOVE_05 +
/*pulsar.PulsarNano 0.2.4               */ MOVE_15 +
/*quietus.Invader 0.1                   */ MOVE_MX + 
/*quietus.NarrowRadar 0.1               */ MOVE_99 +
/*radnor.DoctorBob 1.42                 */ MOVE_15 +
/*ratosh.nano.Debo 1.36                 */ MV99 + MV99 + MV99 + MV15 + MV15 + MV15 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 +
/*ratosh.Nobo 0.21                      */ MOVE_15 +
/*ratosh.Wesco 1.4                      */ MMAX + MMAX + MMAX + MMAX + MMAX + MMAX + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + 
/*rcp.Kuramatron 1.0                    */ MOVE_99 +
/*repositorio.NanoStep 1.0              */ MOVE_99 +
/*robo.PartsBot 1.0                     */ MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 +
/*robar.haiku.Spike 1.0                 */ MOVE_99 +
/*robar.micro.Gladius 1.15              */ MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 +
/*robar.micro.Kirbyi 1.0                */ MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 +
/*robar.micro.Topaz 0.25                */ MOVE_00 +
/*robar.nano.Assertive 0.3              */ MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 +
/*robar.nano.BlackWidow 1.3             */ MOVE_00 +
/*robar.nano.Breeze 0.3                 */ MOVE_15 +
/*robar.nano.Mosquito 1.1               */ MOVE_99 +
/*robar.nano.MosquitoPM 1.0             */ MOVE_15 + //MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 +
/*robar.nano.Prestige 1.0               */ MOVE_15 +
/*robar.nano.Pugio 1.47                 */ MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV15 + MV99 + MV00 + MV99 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 +
/*robar.nano.Scytodes 0.3               */ MOVE_99 +
/*robar.nano.Vespa 0.95                 */ MOVE_15 +
/*rsim.micro.uCatcher 0.1               */ MOVE_15 +
/*ruc.nano.Zealot 0.2                   */ MOVE_99 +
/*ry.LightningBug 1.0                   */ MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 +
/*ry.Worst 1.0                          */ MOVE_99 +
/*rz.Artist 0.2                         */ MOVE_MX + 
/*rz.GlowBlow 2.31                      */ MOVE_00 +
/*rz.HawkOnFire 0.1                     */ MOVE_99 +
/*rz.SmallDevil 1.502                   */ MOVE_99 +
/*sam.Samspin 1.0                       */ MOVE_99 +
/*sgp.nano.FurryLeech 1.0               */ MOVE_15 +
/*sgp.ShiningBeetle 1.1                 */ MOVE_99 +
/*sgp.SleepingGoat 1.1                  */ MOVE_99 +
/*simonton.GFNano_D 3.1b                */ MOVE_15 +
/*simonton.micro.GFMicro 1.0            */ MOVE_15 +
/*simonton.micro.WeeklongObsession 3.4.1*/ MOVE_00 +
/*simonton.nano.WeekendObsession_S 1.7  */ MOVE_15 +
/*spinnercat.haiku.Refrigerator 1.1     */ MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV25 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 + MV15 +//MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV15 + MV15 + MV15 + MV15 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 + MV00 +
/*spinnercat.CopyKat 1.2.3              */ MOVE_15 +
/*spinnercat.Kitten 1.4                 */ MOVE_15 +
/*spinnercat.Limit .01                  */ MOVE_99 +
/*stelo.FretNano 1.1                    */ MOVE_00 +
/*stelo.MatchupMicro 1.2                */ MOVE_15 +
/*stelo.MirrorMicro 1.1                 */ MOVE_99 +
/*stelo.MirrorNano 1.4                  */ MOVE_99 +
/*stelo.MoojukNano 1.2                  */ MOVE_15 +
/*stelo.PatternRobot 1.0                */ MOVE_99 +
/*stelo.PianistNano 1.3                 */ MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV15 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 +
/*stelo.SteloTestNano 1.0               */ MOVE_99 +
/*stelo.UnfoolableNano 1.0              */ MV99 + MV99 + MV99 + MV99 + MV99 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 + MV05 +
/*stelo.UntouchableNano 1.4             */ MOVE_99 +
/*step.NanoBidu 1.0                     */ MOVE_15 +
/*step.nanoPri 1.0                      */ MOVE_99 +
/*strider.Festis 1.2.1                  */ MOVE_15 +
/*strider.Mer 1.1.0                     */ MOVE_15 + 
/*sul.Bicephal 1.2                      */ MV00 + MV00 + MV00 + MV00 + MV00 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MV99 +
/*sul.BlueBot 1.0                       */ MOVE_99 +
/*sul.NanoR2 1.32                       */ MOVE_99 +
/*sul.Pinkbot 1.1                       */ MOVE_15 +
/*stuff.Vlad 0.1                        */ MOVE_99 +
/*timmit.nano.TimCat 0.13               */ MOVE_15 +
/*timmit.nano.TimDog 0.33               */ MOVE_15 +
/*tlp.ThreeLeggedPig 1                  */ MOVE_00 +
/*tobe.calypso.Calypso 4.1              */ MOVE_MX + 
/*tornyil.bottomup.BottomUp 1.05        */ MOVE_15 +
/*toz.Gnome 1.1                         */ MOVE_99 +
/*trab.nano.AinippeNano 1.3             */ MOVE_00 +
/*usa.nano.Nemo 2.0                     */ MOVE_99 +
/*vft.Hrist 1.0                         */ MOVE_MX + 
/*vft.Valkyrie 1.0                      */ MOVE_99 +
/*voidious.micro.Jen 1.11               */ MOVE_05 + 
/*wiki.nano.DevilFISH 1.0               */ MOVE_99 +
/*wiki.nano.RaikoNano 1.1               */ MOVE_99 +
/*winamp32.micro.MicroMacro 1.0         */ MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + MV10 + 
/*yarghard.Y101 1.0                     */ MV99 + MV99 + MV99 + MV99 + MV99 + MV99 + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MUSA + MV99 + MV99 + MV99 +
/*yk.JahMicro 1.0                       */ MOVE_15 +
/*zch.David 0.21                        */ MOVE_99 +
/*zch.Hirkan 0.11                       */ MOVE_99 +
/*zyx.micro.Ant 1.1                     */ MOVE_15 +
/*zyx.nano.Ant 1.1                      */ MOVE_99 +
/*zyx.nano.EscherichiaColi 1.0          */ MOVE_99 +
/*zyx.nano.RedBull 1.0                  */ MOVE_99 +

/*ahf.r2d2.R2d2 0.86                    */ MOVE_00 +
/*AIR.iRobot 1.0                        */ MOVE_15 +
/*amk.ChumbaMini 0.2                    */ MOVE_15 +
/*amk.jointstrike.JointStrike 0.2       */ MOVE_15 +
/*apv.Aspid 1.7                         */ MOVE_15 +
/*apv.AspidReloaded 0.6                 */ MOVE_15 +
/*ar.QuantumChromodynamics 1.2.1        */ MOVE_MX + 
/*ary.mini.Nimi 1.0                     */ MOVE_00 +
/*banshee.mini.Nexus6 0.2.0             */ MOVE_00 +
/*bbo.TheRoof 1.4.3                     */ MOVE_STOP_GO + 
/*bvh.hdr.Hodur 0.4                     */ MOVE_15 +
/*bvh.mini.Fenrir 0.39                  */ MOVE_00 +
/*bvh.mini.Freya 0.55                   */ MOVE_00 +
/*bvh.mini.Mjolnir 0.3                  */ MOVE_STOP_GO + 
/*bvh.mini.Wodan 0.50                   */ MOVE_00 +
/*cf.mini.Chiva 1.0                     */ MOVE_00 +
/*ch.rhj.rbc.RHJ1 1.0                   */ MOVE_15 +
/*chase.pm.Pytko 1.0                    */ MOVE_00 +
/*cjk.Merkava 0.2.0                     */ MOVE_15 +
/*cjk.Merkava 0.3.0                     */ MOVE_15 +
/*cjm.Che 1.2                           */ MOVE_00 +
/*cx.mini.BlackSwans 0.60               */ MOVE_00 +
/*cx.mini.Cigaret 1.31                  */ MOVE_00 +
/*cx.mini.Nimrod 0.55                   */ MOVE_00 +
/*davidalves.net.DuelistMini 1.1        */ MOVE_00 +
/*dcs.Eater_of_Worlds_Mini 1.0          */ MOVE_MX +
/*dft.Cyprus 3.0                        */ MOVE_00 +
/*dmsr.MiniR101 0.6                     */ MOVE_15 +
/*dummy.mini.Parakeet 2.40              */ MOVE_15 +
/*dvogon.GangBang 1.0                   */ MOVE_MX +
/*dz.GalbaMini 0.121                    */ MOVE_00 +
/*dz.OthoMini 0.15                      */ MOVE_MX +
/*eat.HumblePieLite 1.0                 */ MOVE_15 +
/*el.Attackr 0.1                        */ MOVE_MX +
/*eld.Hmm 1.0                           */ MOVE_15 +
/*fala.robocode.FalaRobot 1.0           */ MOVE_STOP_GO +
/*florent.small.LittleAngel 1.8         */ MOVE_00 +
/*fullsail.TimbotNoPrediction 1.0       */ MOVE_MX +
/*fw.Number1 1.0b                       */ MOVE_MX + 
/*geep.mini.GPBotA 1.0                  */ MOVE_STOP_GO + 
/*geep.mini.GPBotB 1.1                  */ MOVE_15 +
/*gh.mini.Gruwel 0.9                    */ MOVE_15 +
/*gio.RealGioBot 1.0                    */ MOVE_00 +
/*goblin.Bender 2.4                     */ MOVE_MX + 
/*jam.mini.Raiko 0.43                   */ MOVE_00 +
/*japs.Sjonniebot 0.9.1                 */ MOVE_15 +
/*jekl.mini.BlackPearl .91              */ MOVE_00 +
/*jk.mini.CunobelinDC 0.4CT             */ MOVE_00 +
/*kanishk.Fr0z3n 1.1                    */ MOVE_15 +
/*kawigi.mini.Coriantumr 1.1            */ MOVE_15 +
/*kawigi.mini.Fhqwhgads 1.1             */ MOVE_00 +
/*kawigi.sbf.Barracuda 1.0              */ MOVE_STOP_GO + 
/*kawigi.sbf.FloodMini 1.4              */ MOVE_15 +
/*kawigi.sbf.Teancum 1.3                */ MOVE_00 +
/*kc.mini.Vyper 0.311                   */ MOVE_15 +
/*kcn.percept.PerceptBot 2.3            */ MOVE_15 +
/*krillr.mini.JointStrike 2.0.0         */ MOVE_MX + 
/*m3thos.mini.Eva01 0.5.5               */ MOVE_15 +
/*marksteam.Phoenix 1.0                 */ MOVE_STOP_GO + 
/*mbh.Mbh 0.1                           */ MOVE_MX + 
/*mbro.BelajarBot 0.0.3                 */ MOVE_MX + 
/*mdouet.BotKicker 2.0                  */ MOVE_15 +
/*mladjo.AIR 0.7                        */ MOVE_15 +
/*mladjo.Grrrrr 0.9                     */ MOVE_00 +
/*mladjo.Startko 1.0                    */ MOVE_00 +
/*mwj.A1176183 1.0                      */ MOVE_MX + 
/*nic.SnippetBot 1.0                    */ MOVE_15 +
/*nkn.mini.Jskr0 0.1                    */ MOVE_00 +
/*ntc.Evader 1.2                        */ MOVE_MX + 
/*ntw.Sighup 1.5                        */ MOVE_MX + 
/*oa.weak.BotherBot 0.1                 */ MOVE_MX + 
/*oa.weak.FlyMk1 0.1                    */ MOVE_15 +
/*oog.mini.MagestyOfColors 0.1          */ MOVE_00 +
/*pak.Dargon .2c                        */ MOVE_15 +
/*pe.mini.SandboxMini 1.2               */ MOVE_MX + 
/*pe.minimelee.SandboxMiniMelee 1.1     */ MOVE_MX + 
/*pez.mini.ChironexFleckeri 0.5         */ MOVE_15 +
/*pez.mini.Gouldingi 1.5                */ MOVE_MX + 
/*pez.mini.Pugilist 2.4.18              */ MOVE_00 +
/*pez.mini.Tityus 0.9.1                 */ MOVE_00 +
/*pez.mini.VertiLeach 0.4.0             */ MOVE_00 +
/*ph.mini.Archer 0.6.6                  */ MOVE_00 +
/*pkdeken.Paladin 1.0                   */ MOVE_15 +
/*radnor.RamRod 1.0                     */ MOVE_MX + 
/*rsim.mini.BulletCatcher 0.4           */ MOVE_15 +
/*rz.Apollon 0.23                       */ MOVE_00 +
/*rz.GlowBlowAPM 1.0                    */ MOVE_15 +
/*rz.GlowBlowMelee 1.4                  */ MOVE_15 +
/*simonton.mini.WeeksOnEnd 1.10.4       */ MOVE_00 +
/*skm.PateranBotlock2 1.0               */ MOVE_MX + 
/*skm.Ryubot 1.0                        */ MOVE_MX + 
/*sng.arco.Arco 0.0                     */ MOVE_STOP_GO + 
/*stelo.Lifestealer 1.0                 */ MOVE_MX + 
/*stelo.MatchupMini 1.1                 */ MOVE_15 +
/*stf.PanzerGeneral 0.1                 */ MOVE_15 +
/*synnalagma.test.MiniNeural 1.1        */ MOVE_MX + 
/*timmit.mini.TimVA 0.43                */ MOVE_15 +
/*tobe.mini.Charon 0.9                  */ MOVE_STOP_GO + 
/*tornyil.Lajcsi2.Lajcsi2sm 1.0         */ MOVE_MX + 
/*vft.Valkyrie 1.0                      */ MOVE_15 +
/*voidious.mini.Komarious 1.88          */ MOVE_00 +
/*wiki.mini.BlackDestroyer 0.9.0        */ MOVE_00 +
/*wiki.mini.GouldingiHT 1.0             */ MOVE_MX + 
/*wiki.mini.Griffon 0.1                 */ MOVE_00 +
/*wiki.mini.Sedan 1.0                   */ MOVE_15 +
/*wit.Deep7 2.0                         */ MOVE_MX + 
/*yk.JahRoslav 1.1                      */ MOVE_15 +         
/*WhoAmI.WhoAmI 1.00                    */ MOVE_MX +
/*oog.nano.Caligula 1.15                */ MOVE_15 +
/*buba.Archivist 0.1                    */ MOVE_15 +
/*buba.Buba 0.3                         */ MOVE_MX +
/*cs.ExclusionNano 1.1                  */ MOVE_STOP_GO +
/*eskimo.micro.Echo 0.1                 */ MOVE_STOP_GO +
/*exauge.LemonDrop 1.6.130              */ MOVE_00 +
/*gwah.GBotMarkIV 1.0                   */ MOVE_MX +
/*gwah.GerryBotMkII 1.5.1               */ MOVE_MX +
/*hapiel.Spiral 0.1                     */ MOVE_STOP_GO +
/*jf.Dodger 1.1                         */ MOVE_15 +
/*mym.EdgeStalker 1.0                   */ MOVE_STOP_GO +
/*NG.LegatusLegionis 1.2                */ MOVE_MX +
/*povik.nano.Smilee 0.2.1               */ MOVE_STOP_GO +
/*rampancy.micro.Epiphron 1.0           */ MOVE_STOP_GO +
/*SuperSample.SuperCrazy 1.0            */ MOVE_15 +
/*timmit.micro.TimXJ 0.22               */ MOVE_15 +
/*exauge.GateKeeper 1.1.121g            */ MOVE_15 +
/*exauge.Leopard 1.1.019                */ MOVE_MX +
/*ayk.WallHugger 1.0                    */ MOVE_15 +

END_OVERFLOW_BUFFER;

private final static String DISTANCE_160_NORMAL  = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_260_NORMAL  = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM20 + AM20 + AM20 + AM20 + AM10 + AM10 + A000 + A010 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;


private final static String DISTANCE_100_NORMAL2 = "" + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_120_NORMAL2 = "" + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_140_NORMAL2 = "" + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_160_NORMAL2 = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_180_NORMAL2 = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_200_NORMAL2 = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_220_NORMAL2 = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_240_NORMAL2 = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_260_NORMAL2 = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_280_NORMAL2 = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_300_NORMAL2 = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_320_NORMAL2 = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_340_NORMAL2 = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_360_NORMAL2 = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_380_NORMAL2 = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_400_NORMAL2 = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_420_NORMAL2 = "" + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;
private final static String DISTANCE_ARM_NORMAL2 = "" + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;  ;

private final static String DISTANCE_ARM_NORMAL3 = "" + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005 + A005;

private final static String DISTANCE_DEFAULT    = "" + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040;  

	private static final String DesiredAngleList = // Desired angle to travel at enemy per range
//                               Distance:             20     40     60     80     100    120    140    160    180    200    220    240    260    280    300    320    340    360    380    400    420    440    460    480    500    520    540    560    580    600    620    640    660    680    700    720    740    760    780    800    
/*default_fail_case                    */' '+DISTANCE_200_NORMAL2 +
/*ad.last.Bottom 1.0                    */ DISTANCE_160_NORMAL +	
/*ags.micro.Carpet 1.1                  */ DISTANCE_200_NORMAL2 +
/*ahf.Acero 1.0                         */ DISTANCE_120_NORMAL2 +	
/*ahf.NanoAndrew .4                     */ DISTANCE_ARM_NORMAL2 +	
/*amk.Punbot.Punbot 0.01                */ DISTANCE_200_NORMAL2 +	
/*ap.Frederick 1.1                      */ AM30 + AM30 + AM60 + A000 + A010 + A010 + A020 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 +
/*apv.MicroAspid 1.8                    */ DISTANCE_220_NORMAL2 +
/*apv.NanoLauLectrik 1.0                */ AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + AM10 + A000 + A010 + A020 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*apv.NanoLauLectrikTheCannibal 1.1     */ AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*arthord.KostyaTszyu Beta2             */ DISTANCE_260_NORMAL2 +
/*arthord.MannyPacquiao Beta            */ DISTANCE_200_NORMAL2 +	
/*arthord.micro.Apoptygma 0.4           */ DISTANCE_200_NORMAL2 +	
/*arthord.micro.Muffin 0.6.1            */ DISTANCE_200_NORMAL2 +	
/*arthord.NanoSatan Mu                  */ DISTANCE_280_NORMAL2 +	
/*arthord.NanoSatanMelee Beta           */ DISTANCE_100_NORMAL2 +	
/*ary.micro.Weak 1.2                    */ DISTANCE_260_NORMAL +	
/*ary.nano.AceSurf 1.2                  */ AM30 + AM30 + AM30 + AM30 + AM10 + A000 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A020 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*ary.nano.ColorNanoP 1.1               */ DISTANCE_180_NORMAL2 +	
/*as.xbots 1.0                          */ A000 + A000 + A000 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM20 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*awesomeness.Elite 1.0                 */ DISTANCE_140_NORMAL2 +	
/*baal.nano.N 1.42                      */ DISTANCE_360_NORMAL2 +	
/*banshee.micro.Nexus6 0.3.0            */ DISTANCE_260_NORMAL2 +	
/*bayen.nano.Squirrel 0.2               */ DISTANCE_200_NORMAL2 +	
/*bayen.UbaMicro 1.4                    */ DISTANCE_180_NORMAL2 +	
/*bayen.UbaRamLT 1.0                    */ A000 + A000 + A000 + A000 + A000 + A000 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + 
/*bbo.RamboT 0.3                        */ AM30 + AM30 + AM10 + AM10 + AM20 + AM20 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*bons.NanoStalker 1.2                  */ DISTANCE_ARM_NORMAL2 +	
/*bp.Kuma 1.0                           */ DISTANCE_160_NORMAL +	
/*braaropolis.Abot 1.0                  */ DISTANCE_160_NORMAL +	
/*bvh.micro.Freya 0.3                   */ DISTANCE_220_NORMAL2 +	
/*bvh.micro.Svadilfari 0.2              */ DISTANCE_220_NORMAL2 +	
/*bzdp.BoxCar 2.0                       */ DISTANCE_120_NORMAL2 +	
/*bzbp.Pansy 2.1                        */ DISTANCE_360_NORMAL2 +	
/*caimano.Furia_Ceca 0.22               */ DISTANCE_160_NORMAL +	
/*chase.c.Wristwatch 1.0                */ AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + AM10 + AM10 + A000 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*chase.o.Orbit 0.1                     */ DISTANCE_220_NORMAL2 +	
/*chickenfuego.UrChicken2 1.0           */ DISTANCE_180_NORMAL2 +	
/*cjk.Merkava 0.1.1                     */ DISTANCE_160_NORMAL +	
/*cjm.Charo 1.1                         */ DISTANCE_300_NORMAL2 +
/*codemojo.nano.Woot 1.0                */ DISTANCE_220_NORMAL2 +	
/*cx.micro.Blur 0.2                     */ DISTANCE_140_NORMAL2 +	
/*cx.micro.Smoke 0.96                   */ A010 + A010 + A010 + A010 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*cx.micro.Spark 0.6                    */ DISTANCE_160_NORMAL2 +	
/*cx.nano.Smog 2.6                      */ DISTANCE_240_NORMAL2 +
/*davidalves.net.DuelistMicro 1.22      */ DISTANCE_180_NORMAL2 +	
/*davidalves.net.DuelistMicroMkII 1.1   */ DISTANCE_240_NORMAL2 +
/*davidalves.net.DuelistNano 1.0        */ DISTANCE_160_NORMAL +	
/*demetrix.nano.Neutrino 0.27           */ AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*demetrix.nano.SledgeHammer 0.22       */ AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + 
/*dft.Freddie 1.32                      */ DISTANCE_120_NORMAL2 +	   
/*dft.Guppy 1.0                         */ AM20 + AM20 + AM20 + AM15 + AM15 + AM15 + AM15 + AM15 + AM15 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*dggp.haiku.gpBot_0 1.1                */ AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A020 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*djdjdj.NanoSkunk10 1.0                */ AM20 + AM20 + AM10 + AM10 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*dks.MicroDanMK2 1.0                   */ DISTANCE_160_NORMAL +	
/*DM.Mijit .3                           */ DISTANCE_320_NORMAL2 +
/*dmp.micro.Aurora 1.41                 */ DISTANCE_260_NORMAL2 +
/*dmp.nano.Eve 3.41                     */ DISTANCE_220_NORMAL2 +
/*donjezza.Jezza 1.0                    */ DISTANCE_140_NORMAL2 +
/*donjezza.Muncho 1.0                   */ DISTANCE_140_NORMAL2 +
/*drd.DreadKnoght 0.9                   */ DISTANCE_140_NORMAL2 +
/*dsw.StaticD 1.0                       */ DISTANCE_260_NORMAL2 +
/*dukie.Ambassador 1.0                  */ AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM20 + AM20 + AM20 + AM20 + AM10 + A000 + A010 + A020 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*dummy.micro.HummingBird 2.14          */ DISTANCE_180_NORMAL2 +
/*dummy.micro.Sparrow 2.5               */ DISTANCE_260_NORMAL2 +
/*dz.GalbaMicro 0.11                    */ DISTANCE_220_NORMAL2 +
/*dz.MostlyHarmlessNano 2.1             */ AM40 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*dz.OthoMicro 0.12                     */ DISTANCE_200_NORMAL2 +
/*el.JumpShoot 0.2                      */ DISTANCE_160_NORMAL +
/*el33t.EL33tGangstarr2 2.0             */ DISTANCE_DEFAULT +
/*elloco.Flower 0.1r1                   */ DISTANCE_100_NORMAL2 +
/*elvbot.ElverionBot 0.3                */ DISTANCE_100_NORMAL2 +
/*evd.X1 0.01                           */ DISTANCE_160_NORMAL +
/*fcr.First 1.0                         */ DISTANCE_ARM_NORMAL2 +
/*Fenix.FenixTrack 1.0                  */ DISTANCE_160_NORMAL +
/*fm.claire 1.7                         */ DISTANCE_360_NORMAL2 +
/*fm.mammillarias 1.3                   */ DISTANCE_100_NORMAL2 +
/*fullsail.SweetTea 1.1                 */ DISTANCE_220_NORMAL2 +
/*germ.TheMind .2                       */ DISTANCE_160_NORMAL +
/*gh.micro.Grinnik 0.7                  */ A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A020 + A020 + A020 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*gh.micro.GrubbmThree 0.9              */ DISTANCE_340_NORMAL2 +
/*gh.nano.Grofvuil 0.2                  */ DISTANCE_160_NORMAL +
/*gio.RealGioBot 1.0                    */ DISTANCE_220_NORMAL2 +
/*gu.MicroScoob 1.3                     */ DISTANCE_300_NORMAL2 +
/*ins.MobyNano 0.8                      */ DISTANCE_160_NORMAL2 +
/*jab.micro.Sanguijuela 0.8             */ A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + 
/*jam.micro.RaikoMicro 1.44             */ A070 + A070 + A070 + A070 + A080 + A080 + A080 + A040 + A050 + A030 + A060 + A060 + A020 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + 
/*janm.Jammy 1.0                        */ AM40 + AM30 + AM30 + AM30 + AM30 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A010 + A010 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*japs.Serenity 1.0                     */ DISTANCE_160_NORMAL +
/*jaw.KarenCain 0.11                    */ DISTANCE_300_NORMAL2 +
/*jaw.Mouse 0.11                        */ AM30 + AM20 + AM10 + AM10 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*jcw.ArcherOne 1.0                     */ DISTANCE_160_NORMAL +
/*jep.nano.Hawkwing 0.4.1               */ DISTANCE_100_NORMAL2 +
/*jep.nano.Hotspur 0.1                  */ DISTANCE_280_NORMAL2 +
/*jgap.JGAP12584 1.0                    */ DISTANCE_ARM_NORMAL2 +
/*jgap.JGAP130166 1.0                   */ DISTANCE_160_NORMAL +
/*jgap.JGAP23423 1.0                    */ DISTANCE_180_NORMAL2 +
/*jgap.JGAP6139 1.0                     */ AM50 + AM50 + AM50 + AM50 + AM50 + AM50 + AM50 + AM50 + AM50 + AM50 + AM40 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*jgap.JGAP7247_2 1.0                   */ AM40 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*jgap.JGAP7958 1.0                     */ AM40 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*jk.micro.Toorkild 0.1.1               */ DISTANCE_240_NORMAL2 +
/*joe.ADinosaur 1.0                     */ AM30 + AM20 + AM10 + A000 + A000 + A000 + A000 + A000 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*jp.SineWall 1.0                       */ DISTANCE_380_NORMAL2 +
/*js.PinBall 1.6                        */ DISTANCE_200_NORMAL2 +
/*jsal.Jsalbot 1.0                      */ DISTANCE_160_NORMAL +
/*jt.SpearmintCT Alpha                  */ DISTANCE_100_NORMAL2 +
/*kawigi.f.FhqwhgadsMicro 1.0           */ DISTANCE_380_NORMAL2 +
/*kawigi.micro.Shiz 1.1                 */ DISTANCE_120_NORMAL2 +
/*kawigi.nano.FunkyChicken 1.1          */ DISTANCE_200_NORMAL2 +
/*kawigi.nano.ThnikkaBot 0.9            */ DISTANCE_260_NORMAL2 +
/*kawigi.sbf.FloodMicro 1.5             */ DISTANCE_260_NORMAL2 +
/*kawigi.sbf.FloodNano 1.2              */ DISTANCE_160_NORMAL +
/*kc.micro.Needle 0.101                 */ DISTANCE_320_NORMAL2 +
/*kc.micro.Thorn 1.142                  */ AM30 + AM30 + AM30 + AM20 + AM20 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + A020 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*kc.micro.WaveShark 0.3                */ AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A010 + A010 + A010 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*kc.nano.Splinter 1.2                  */ DISTANCE_200_NORMAL2 +
/*kinsen.nano.Hoplomachy 1.6            */ DISTANCE_ARM_NORMAL2 +
/*kinsen.nano.Quarrelet 1.0             */ DISTANCE_200_NORMAL2 +
/*kinsen.nano.Senticous 1.0             */ AM30 + AM30 + AM10 + AM10 + AM10 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A000 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*kjc.etc.Dharok 1.0                    */ DISTANCE_160_NORMAL +
/*kjc.Karaykan 1.0                      */ DISTANCE_160_NORMAL +
/*kjc.MailManX 2.0                      */ DISTANCE_100_NORMAL2 +
/*kurios.DOSexe .9                      */ AM10 + AM10 + AM10 + AM10 + AM60 + AM10 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*leb.ShootAnArrow 0.1                  */ DISTANCE_160_NORMAL2 +
/*lechu.Lechu 1.1                       */ DISTANCE_240_NORMAL2 +
/*lion.Kresnanano 1.0                   */ DISTANCE_260_NORMAL2 +
/*lk.nano.Avesnar 1.1                   */ AM30 + AM30 + AM30 + AM20 + AM20 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A010 + A010 + A020 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*lrem.micro.FalseProphet Alpha         */ DISTANCE_180_NORMAL2 +
/*lrem.micro.MoggFanatic 0.2            */ DISTANCE_160_NORMAL +
/*lw.LuthersTest 0.1                    */ DISTANCE_200_NORMAL2 +
/*m3thos.Eva00 1.1                      */ AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + AM10 + AM10 + AM10 + A000 + A010 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*marcinek.TopGun 1.3                   */ DISTANCE_240_NORMAL2 +
/*mbro.BelajarBot 0.0.3                 */ DISTANCE_160_NORMAL +
/*mbro.Detektor3 0.1.1                  */ DISTANCE_180_NORMAL2 +
/*mc.Messapia 0.1.8                     */ DISTANCE_160_NORMAL +
/*mld.DustBunny 3.8                     */ AM30 + AM30 + AM10 + A020 + A020 + A020 + A020 + A020 + A020 + A020 + A020 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*mld.Infinity 2.2                      */ DISTANCE_320_NORMAL2 +
/*mld.Moebius 2.9.3                     */ AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + AM10 + AM10 + AM10 + A000 + A010 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*mld.Tide 1.2                          */ AM20 + AM20 + AM10 + A000 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*mld.Wisdom 1.0                        */ DISTANCE_180_NORMAL2 +
/*mme.NikeEnhanced 2.0                  */ DISTANCE_100_NORMAL2 +
/*mrm.MightyMoose .2                    */ AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + AM10 + AM10 + AM10 + A000 + A010 + A010 + A010 + A020 + A020 + A020 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*myl.micro.Avipes 1.00                 */ DISTANCE_260_NORMAL2 +
/*myl.micro.NekoNinja 1.30              */ DISTANCE_100_NORMAL2 +
/*myl.micro.Predator 1.50               */ DISTANCE_160_NORMAL2 +
/*myl.micro.Troodon 1.10                */ DISTANCE_160_NORMAL +
/*myl.nano.Graviton 1.10                */ DISTANCE_220_NORMAL2 +
/*myl.nano.Kakuru 1.20                  */ DISTANCE_220_NORMAL2 +
/*myl.nano.KomoriNinja 1.1              */ DISTANCE_240_NORMAL2 +
/*mz.Adept 2.65                         */ DISTANCE_160_NORMAL +
/*mz.AdeptBSB 1.03                      */ DISTANCE_120_NORMAL2 +
/*mz.Movement 1.8                       */ DISTANCE_180_NORMAL2 +
/*mz.NanoDeath 2.56                     */ AM20 + AM20 + AM20 + AM20 + AM20 + AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + 
/*mz.NanoGod 2.02                       */ AM20 + AM20 + AM10 + AM10 + AM10 + AM10 + AM05 + AM05 + AM05 + AM05 + AM05 + AM05 + AM05 + AM05 + AM05 + A040 + A050 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*nanoskank.NanoSkank 1.0               */ DISTANCE_180_NORMAL2 +
/*nat.micro.NP 1.34                     */ DISTANCE_100_NORMAL2 +
/*nat.micro.Reepicheep 0.1a             */ DISTANCE_280_NORMAL2 +
/*nat.nano.Ocnirp 1.5                   */ DISTANCE_180_NORMAL2 +
/*nat.nano.OcnirpPM 1.0                 */ DISTANCE_200_NORMAL2 +
/*nat.nano.OcnirpSNG 1.0b               */ AM20 + AM20 + AM10 + AM10 + AM10 + AM10 + AM10 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*ndn.DyslexicMonkey 1.1                */ DISTANCE_ARM_NORMAL2 +
/*nexus.Prototype 1.0                   */ DISTANCE_160_NORMAL +
/*nova.Snow 1.0                         */ DISTANCE_160_NORMAL +
/*ntc.Cannon 1.12test                   */ DISTANCE_200_NORMAL2 +
/*ntc.Knowledge 1.1                     */ DISTANCE_220_NORMAL2 +
/*ntc.Plains 0.9                        */ DISTANCE_240_NORMAL2 +
/*ntw.Sigsys 1.6                        */ DISTANCE_260_NORMAL2 +
/*ntc.Swim 0.9                          */ A010 + A010 + A010 + A010 + A010 + A020 + A020 + A020 + A020 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*nz.jdc.micro.HedgehogGF 1.3           */ DISTANCE_300_NORMAL2 +
/*nz.jdc.micro.HedgehogP 1.2            */ A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*nz.jdc.nano.NeophytePattern 1.0       */ DISTANCE_ARM_NORMAL2 +
/*nz.jdc.nano.NeophytePRAL 1.2          */ DISTANCE_280_NORMAL2 +
/*nz.jdc.nano.NeophyteSRAL 1.2          */ DISTANCE_240_NORMAL2 +
/*oog.melee.Capulet 0.1                 */ DISTANCE_160_NORMAL +
/*oog.melee.CapuletDroid 1.0            */ DISTANCE_160_NORMAL +
/*oog.melee.Mercutio 1.0                */ DISTANCE_220_NORMAL2 +
/*oog.melee.StarLight 0.1               */ DISTANCE_360_NORMAL2 +
/*oog.micro.MagicD3 0.41                */ DISTANCE_ARM_NORMAL2 +
/*oog.micro.Maui 1.1                    */ AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + AM20 + A030 + AM40 + A040 + AM40 + A040 + AM40 + A040 + AM40 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +  
/*oog.micro.SavantMicro 0.31            */ AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A010 + AM20 + A030 + AM40 + A040 + AM40 + A040 + AM40 + A040 + AM40 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +  
/*oog.nano.Fuatisha 1.0                 */ DISTANCE_340_NORMAL2 + //AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + A005 + A010 + A010 + A010 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*oog.MagicD2 2.3                       */ DISTANCE_200_NORMAL2 +
/*oog.nano.SavantVS 1.1                 */ AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + A010 + A010 + A010 + A010 + A010 + A010 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*oog.nano.SavantWS 1.0                 */ DISTANCE_260_NORMAL2 +
/*pa.Improved 1.1                       */ DISTANCE_160_NORMAL +
/*pak.Dargon 1.0b                       */ DISTANCE_160_NORMAL +
/*pak.JakeTheTestingRobot .1b           */ DISTANCE_200_NORMAL2 +
/*paolord.TheHulk 1.0                   */ DISTANCE_160_NORMAL +
/*pb.Oscillator 1.0                     */ DISTANCE_ARM_NORMAL2 +
/*pez.micro.Aristocles 0.3.7            */ DISTANCE_300_NORMAL2 +
/*pez.nano.Icarus 0.3                   */ DISTANCE_160_NORMAL2 +
/*pez.nano.LittleEvilBrother 0.1        */ DISTANCE_160_NORMAL +
/*pfvicm.Sobieski 7.2.3b                */ DISTANCE_160_NORMAL +
/*ph.micro.Pikeman 0.4.5                */ DISTANCE_340_NORMAL2 +
/*PkKillers.PkAssassin 1.0              */ AM30 + AM20 + AM10 + AM10 + AM10 + AM10 + AM10 + AM30 + AM30 + AM30 + AM20 + A000 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*pmc.SniperBot 1.0                     */ DISTANCE_160_NORMAL +
/*projectx.ProjectNano 2.0              */ DISTANCE_280_NORMAL2 +
/*projectx.TestNano 1.0                 */ DISTANCE_240_NORMAL2 +
/*pulsar.Nanis 0.3                      */ AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + A020 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000+ A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + 
/*pulsar.PulsarNano 0.2.4               */ DISTANCE_140_NORMAL2 +
/*quietus.Invader 0.1                   */ AM30 + AM10 + AM10 + AM10 + AM10 + A000 + A010 + A010 + A010 + A010 + A010 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 + A060 +
/*quietus.NarrowRadar 0.1               */ AM10 + AM10 + AM10 + AM10 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*radnor.DoctorBob 1.42                 */ AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*ratosh.nano.Debo 1.36                 */ AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A010 + A010 + A020 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*ratosh.Nobo 0.21                      */ DISTANCE_160_NORMAL2 +
/*ratosh.Wesco 1.4                      */ AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM20 + AM20 + AM20 + AM20 + AM10 + A000 + A020 + A020 + A020 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*rcp.Kuramatron 1.0                    */ DISTANCE_380_NORMAL2 +
/*repositorio.NanoStep 1.0              */ DISTANCE_160_NORMAL +
/*robo.PartsBot 1.0                     */ AM30 + AM30 + AM30 + AM20 + AM20 + AM20 + AM20 + AM20 + AM10 + AM10 + A000 + A020 + A030 + A040 + A040 + A050 + A050 + A050 + A050 + A050 + A050 + A050 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*robar.haiku.Spike 1.0                 */ DISTANCE_160_NORMAL +
/*robar.micro.Gladius 1.15              */ AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM20 + AM20 + AM20 + AM10 + AM10 + A000 + A010 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*robar.micro.Kirbyi 1.0                */ AM30 + AM30 + AM30 + AM30 + AM20 + AM20 + AM20 + AM20 + AM20 + AM20 + AM10 + AM10 + A000 + A010 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*robar.micro.Topaz 0.25                */ AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*robar.nano.Assertive 0.3              */ DISTANCE_240_NORMAL2 +
/*robar.nano.BlackWidow 1.3             */ DISTANCE_200_NORMAL2 + //AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + AM10 + AM10 + AM10 + A000 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*robar.nano.Breeze 0.3                 */ DISTANCE_200_NORMAL2 +
/*robar.nano.Mosquito 1.1               */ DISTANCE_160_NORMAL +
/*robar.nano.MosquitoPM 1.0             */ AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A010 + A010 + A010 + A010 + A010 + A010 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*robar.nano.Prestige 1.0               */ DISTANCE_360_NORMAL2 +
/*robar.nano.Pugio 1.47                 */ AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*robar.nano.Scytodes 0.3               */ DISTANCE_280_NORMAL2 +
/*robar.nano.Vespa 0.95                 */ AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM20 + AM20 + AM20 + AM20 + AM20 + AM10 + A000 + A010 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*rsim.micro.uCatcher 0.1               */ DISTANCE_160_NORMAL +
/*ruc.nano.Zealot 0.2                   */ DISTANCE_340_NORMAL2 +
/*ry.LightningBug 1.0                   */ A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + A080 + 
/*ry.Worst 1.0                          */ DISTANCE_160_NORMAL +
/*rz.Artist 0.2                         */ AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + AM10 + AM10 + A000 + A010 + A020 + A040 + A040 + A000 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*rz.GlowBlow 2.31                      */ DISTANCE_180_NORMAL2 +
/*rz.HawkOnFire 0.1                     */ DISTANCE_120_NORMAL2 +
/*rz.SmallDevil 1.502                   */ DISTANCE_160_NORMAL +
/*sam.Samspin 1.0                       */ DISTANCE_120_NORMAL2 +
/*sgp.nano.FurryLeech 1.0               */ DISTANCE_160_NORMAL2 +
/*sgp.ShiningBeetle 1.1                 */ DISTANCE_160_NORMAL +
/*sgp.SleepingGoat 1.1                  */ AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*simonton.GFNano_D 3.1b                */ DISTANCE_ARM_NORMAL2 +
/*simonton.micro.GFMicro 1.0            */ DISTANCE_280_NORMAL2 +
/*simonton.micro.WeeklongObsession 3.4.1*/ DISTANCE_160_NORMAL +
/*simonton.nano.WeekendObsession_S 1.7  */ DISTANCE_220_NORMAL2 +
/*spinnercat.haiku.Refrigerator 1.1     */ DISTANCE_400_NORMAL2 +
/*spinnercat.CopyKat 1.2.3              */ DISTANCE_260_NORMAL2 +
/*spinnercat.Kitten 1.4                 */ AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM20 + AM20 + AM10 + AM10 + AM10 + AM10 + A000 + A010 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*spinnercat.Limit .01                  */ DISTANCE_160_NORMAL +
/*stelo.FretNano 1.1                    */ DISTANCE_360_NORMAL2 +
/*stelo.MatchupMicro 1.2                */ DISTANCE_220_NORMAL2 +
/*stelo.MirrorMicro 1.1                 */ DISTANCE_180_NORMAL2 +
/*stelo.MirrorNano 1.4                  */ DISTANCE_160_NORMAL +
/*stelo.MoojukNano 1.2                  */ DISTANCE_160_NORMAL +
/*stelo.PatternRobot 1.0                */ DISTANCE_160_NORMAL +
/*stelo.PianistNano 1.3                 */ AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM10 + A000 + A010 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*stelo.SteloTestNano 1.0               */ DISTANCE_160_NORMAL +
/*stelo.UnfoolableNano 1.0              */ AM20 + AM20 + AM20 + AM20 + AM20 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A020 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*stelo.UntouchableNano 1.4             */ AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*step.NanoBidu 1.0                     */ DISTANCE_200_NORMAL2 +
/*step.nanoPri 1.0                      */ AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + //AM40 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*strider.Festis 1.2.1                  */ DISTANCE_160_NORMAL +
/*strider.Mer 1.1.0                     */ AM40 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + AM10 + AM10 + AM10 + A000 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*sul.Bicephal 1.2                      */ AM20 + AM20 + AM10 + A000 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM10 + A000 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*sul.BlueBot 1.0                       */ DISTANCE_220_NORMAL2 +
/*sul.NanoR2 1.32                       */ DISTANCE_160_NORMAL +
/*sul.Pinkbot 1.1                       */ DISTANCE_160_NORMAL +
/*stuff.Vlad 0.1                        */ DISTANCE_100_NORMAL2 +
/*timmit.nano.TimCat 0.13               */ DISTANCE_160_NORMAL +
/*timmit.nano.TimDog 0.33               */ DISTANCE_200_NORMAL2 +
/*tlp.ThreeLeggedPig 1                  */ DISTANCE_240_NORMAL2 +
/*tobe.calypso.Calypso 4.1              */ AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM20 + AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A010 + A010 + A010 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*tornyil.bottomup.BottomUp 1.05        */ DISTANCE_360_NORMAL2 +
/*toz.Gnome 1.1                         */ DISTANCE_180_NORMAL2 +
/*trab.nano.AinippeNano 1.3             */ DISTANCE_240_NORMAL2 +
/*usa.nano.Nemo 2.0                     */ DISTANCE_240_NORMAL2 +
/*vft.Hrist 1.0                         */ DISTANCE_220_NORMAL2 +
/*vft.Valkyrie 1.0                      */ DISTANCE_160_NORMAL2 +
/*voidious.micro.Jen 1.11               */ DISTANCE_300_NORMAL2 +
/*wiki.nano.DevilFISH 1.0               */ AM30 + AM30 + AM30 + AM30 + AM30 + AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A010 + A010 + A020 + A030 + A040 + A050 + A050 + A050 + A050 + A060 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +	
/*wiki.nano.RaikoNano 1.1               */ DISTANCE_240_NORMAL2 +
/*winamp32.micro.MicroMacro 1.0         */ DISTANCE_360_NORMAL2 +
/*yarghard.Y101 1.0                     */ AM30 + AM30 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A060 + A060 + A060 + A060 + A070 + A070 + A070 + A070 + A070 + A070 + A070 + A070 + A070 +
/*yk.JahMicro 1.0                       */ DISTANCE_220_NORMAL2 +
/*zch.David 0.21                        */ DISTANCE_240_NORMAL2 +
/*zch.Hirkan 0.11                       */ DISTANCE_320_NORMAL2 +
/*zyx.micro.Ant 1.1                     */ AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A010 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*zyx.nano.Ant 1.1                      */ DISTANCE_100_NORMAL2 +
/*zyx.nano.EscherichiaColi 1.0          */ DISTANCE_160_NORMAL +
/*zyx.nano.RedBull 1.0                  */ DISTANCE_160_NORMAL +

/*ahf.r2d2.R2d2 0.86                    */ DISTANCE_100_NORMAL2 +
/*AIR.iRobot 1.0                        */ DISTANCE_160_NORMAL2 +
/*amk.ChumbaMini 0.2                    */ DISTANCE_200_NORMAL2 +
/*amk.jointstrike.JointStrike 0.2       */ DISTANCE_220_NORMAL2 +
/*apv.Aspid 1.7                         */ DISTANCE_220_NORMAL2 +
/*apv.AspidReloaded 0.6                 */ DISTANCE_160_NORMAL2 +
/*ar.QuantumChromodynamics 1.2.1        */ DISTANCE_240_NORMAL2 +
/*ary.mini.Nimi 1.0                     */ DISTANCE_140_NORMAL2 +
/*banshee.mini.Nexus6 0.2.0             */ DISTANCE_240_NORMAL2 +
/*bbo.TheRoof 1.4.3                     */ DISTANCE_380_NORMAL2 +
/*bvh.hdr.Hodur 0.4                     */ DISTANCE_180_NORMAL2 +
/*bvh.mini.Fenrir 0.39                  */ DISTANCE_160_NORMAL2 +
/*bvh.mini.Freya 0.55                   */ DISTANCE_200_NORMAL2 +
/*bvh.mini.Mjolnir 0.3                  */ DISTANCE_160_NORMAL2 +
/*bvh.mini.Wodan 0.50                   */ DISTANCE_180_NORMAL2 +
/*cf.mini.Chiva 1.0                     */ DISTANCE_220_NORMAL2 +
/*ch.rhj.rbc.RHJ1 1.0                   */ DISTANCE_260_NORMAL2 +
/*chase.pm.Pytko 1.0                    */ DISTANCE_280_NORMAL2 +
/*cjk.Merkava 0.2.0                     */ DISTANCE_140_NORMAL2 +
/*cjk.Merkava 0.3.0                     */ DISTANCE_140_NORMAL2 +
/*cjm.Che 1.2                           */ DISTANCE_ARM_NORMAL2 +
/*cx.mini.BlackSwans 0.60               */ DISTANCE_180_NORMAL2 +
/*cx.mini.Cigaret 1.31                  */ DISTANCE_200_NORMAL2 +
/*cx.mini.Nimrod 0.55                   */ DISTANCE_260_NORMAL2 +
/*davidalves.net.DuelistMini 1.1        */ DISTANCE_240_NORMAL2 +
/*dcs.Eater_of_Worlds_Mini 1.0          */ DISTANCE_100_NORMAL2 +
/*dft.Cyprus 3.0                        */ DISTANCE_300_NORMAL2 +
/*dmsr.MiniR101 0.6                     */ DISTANCE_340_NORMAL2 +
/*dummy.mini.Parakeet 2.40              */ DISTANCE_220_NORMAL2 +
/*dvogon.GangBang 1.0                   */ DISTANCE_120_NORMAL2 +
/*dz.GalbaMini 0.121                    */ DISTANCE_140_NORMAL2 +
/*dz.OthoMini 0.15                      */ DISTANCE_220_NORMAL2 +
/*eat.HumblePieLite 1.0                 */ DISTANCE_280_NORMAL2 +
/*el.Attackr 0.1                        */ DISTANCE_120_NORMAL2 +
/*eld.Hmm 1.0                           */ DISTANCE_200_NORMAL2 +
/*fala.robocode.FalaRobot 1.0           */ DISTANCE_160_NORMAL2 +
/*florent.small.LittleAngel 1.8         */ DISTANCE_340_NORMAL2 +
/*fullsail.TimbotNoPrediction 1.0       */ DISTANCE_200_NORMAL2 +
/*fw.Number1 1.0b                       */ DISTANCE_100_NORMAL2 +
/*geep.mini.GPBotA 1.0                  */ DISTANCE_100_NORMAL2 +
/*geep.mini.GPBotB 1.1                  */ DISTANCE_200_NORMAL2 +
/*gh.mini.Gruwel 0.9                    */ DISTANCE_180_NORMAL2 +
/*gio.RealGioBot 1.0                    */ DISTANCE_220_NORMAL2 +
/*goblin.Bender 2.4                     */ DISTANCE_140_NORMAL2 +
/*jam.mini.Raiko 0.43                   */ DISTANCE_240_NORMAL2 +
/*japs.Sjonniebot 0.9.1                 */ DISTANCE_220_NORMAL2 +
/*jekl.mini.BlackPearl .91              */ DISTANCE_220_NORMAL2 +
/*jk.mini.CunobelinDC 0.4CT             */ DISTANCE_120_NORMAL2 +
/*kanishk.Fr0z3n 1.1                    */ DISTANCE_300_NORMAL2 +
/*kawigi.mini.Coriantumr 1.1            */ DISTANCE_240_NORMAL2 +
/*kawigi.mini.Fhqwhgads 1.1             */ DISTANCE_280_NORMAL2 +
/*kawigi.sbf.Barracuda 1.0              */ DISTANCE_280_NORMAL2 +
/*kawigi.sbf.FloodMini 1.4              */ DISTANCE_260_NORMAL2 +
/*kawigi.sbf.Teancum 1.3                */ DISTANCE_240_NORMAL2 +
/*kc.mini.Vyper 0.311                   */ DISTANCE_100_NORMAL2 +
/*kcn.percept.PerceptBot 2.3            */ DISTANCE_280_NORMAL2 +
/*krillr.mini.JointStrike 2.0.0         */ DISTANCE_260_NORMAL2 +
/*m3thos.mini.Eva01 0.5.5               */ DISTANCE_280_NORMAL2 +
/*marksteam.Phoenix 1.0                 */ DISTANCE_260_NORMAL2 +
/*mbh.Mbh 0.1                           */ DISTANCE_200_NORMAL2 +
/*mbro.BelajarBot 0.0.3                 */ DISTANCE_140_NORMAL2 +
/*mdouet.BotKicker 2.0                  */ DISTANCE_200_NORMAL2 +
/*mladjo.AIR 0.7                        */ DISTANCE_180_NORMAL2 +
/*mladjo.Grrrrr 0.9                     */ DISTANCE_340_NORMAL2 +
/*mladjo.Startko 1.0                    */ DISTANCE_200_NORMAL2 +
/*mwj.A1176183 1.0                      */ DISTANCE_180_NORMAL2 +
/*nic.SnippetBot 1.0                    */ DISTANCE_340_NORMAL2 +
/*nkn.mini.Jskr0 0.1                    */ DISTANCE_200_NORMAL2 +
/*ntc.Evader 1.2                        */ DISTANCE_280_NORMAL2 +
/*ntw.Sighup 1.5                        */ DISTANCE_140_NORMAL2 +
/*oa.weak.BotherBot 0.1                 */ DISTANCE_260_NORMAL2 +
/*oa.weak.FlyMk1 0.1                    */ DISTANCE_180_NORMAL2 +
/*oog.mini.MagestyOfColors 0.1          */ DISTANCE_240_NORMAL2 +
/*pak.Dargon .2c                        */ DISTANCE_140_NORMAL2 +
/*pe.mini.SandboxMini 1.2               */ DISTANCE_300_NORMAL2 +
/*pe.minimelee.SandboxMiniMelee 1.1     */ DISTANCE_200_NORMAL2 +
/*pez.mini.ChironexFleckeri 0.5         */ DISTANCE_240_NORMAL2 +
/*pez.mini.Gouldingi 1.5                */ DISTANCE_220_NORMAL2 +
/*pez.mini.Pugilist 2.4.18              */ DISTANCE_100_NORMAL2 +
/*pez.mini.Tityus 0.9.1                 */ DISTANCE_220_NORMAL2 +
/*pez.mini.VertiLeach 0.4.0             */ DISTANCE_120_NORMAL2 +
/*ph.mini.Archer 0.6.6                  */ DISTANCE_300_NORMAL2 +
/*pkdeken.Paladin 1.0                   */ DISTANCE_100_NORMAL2 +
/*radnor.RamRod 1.0                     */ DISTANCE_140_NORMAL2 +
/*rsim.mini.BulletCatcher 0.4           */ DISTANCE_100_NORMAL2 +
/*rz.Apollon 0.23                       */ DISTANCE_120_NORMAL2 +
/*rz.GlowBlowAPM 1.0                    */ DISTANCE_280_NORMAL2 +
/*rz.GlowBlowMelee 1.4                  */ DISTANCE_340_NORMAL2 +
/*simonton.mini.WeeksOnEnd 1.10.4       */ DISTANCE_220_NORMAL2 +
/*skm.PateranBotlock2 1.0               */ DISTANCE_120_NORMAL2 +
/*skm.Ryubot 1.0                        */ DISTANCE_160_NORMAL2 +
/*sng.arco.Arco 0.0                     */ DISTANCE_160_NORMAL2 +
/*stelo.Lifestealer 1.0                 */ DISTANCE_200_NORMAL2 +
/*stelo.MatchupMini 1.1                 */ DISTANCE_200_NORMAL2 +
/*stf.PanzerGeneral 0.1                 */ DISTANCE_220_NORMAL2 +
/*synnalagma.test.MiniNeural 1.1        */ DISTANCE_200_NORMAL2 +
/*timmit.mini.TimVA 0.43                */ DISTANCE_260_NORMAL2 +
/*tobe.mini.Charon 0.9                  */ DISTANCE_120_NORMAL2 +
/*tornyil.Lajcsi2.Lajcsi2sm 1.0         */ DISTANCE_320_NORMAL2 +
/*vft.Valkyrie 1.0                      */ DISTANCE_160_NORMAL2 +
/*voidious.mini.Komarious 1.88          */ DISTANCE_180_NORMAL2 +
/*wiki.mini.BlackDestroyer 0.9.0        */ DISTANCE_280_NORMAL2 +
/*wiki.mini.GouldingiHT 1.0             */ DISTANCE_140_NORMAL2 +
/*wiki.mini.Griffon 0.1                 */ DISTANCE_180_NORMAL2 +
/*wiki.mini.Sedan 1.0                   */ DISTANCE_140_NORMAL2 +
/*wit.Deep7 2.0                         */ DISTANCE_280_NORMAL2 +
/*yk.JahRoslav 1.1                      */ DISTANCE_220_NORMAL2 +
/*WhoAmI.WhoAmI 1.00                    */ AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*oog.nano.Caligula 1.15                */ AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*buba.Archivist 0.1                    */ DISTANCE_DEFAULT + //AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM20 + AM20 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + AM10 + A010 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*buba.Buba 0.3                         */ DISTANCE_140_NORMAL2 +
/*cs.ExclusionNano 1.1                  */ DISTANCE_240_NORMAL2 +
/*eskimo.micro.Echo 0.1                 */ DISTANCE_140_NORMAL2 +
/*exauge.LemonDrop 1.6.130              */ AM30 + AM30 + AM30 + AM30 + AM30 + AM20 + AM20 + AM20 + AM10 + AM10 + AM10 + AM10 + A000 + A010 + A010 + A020 + A030 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*gwah.GBotMarkIV 1.0                   */ DISTANCE_140_NORMAL2 +
/*gwah.GerryBotMkII 1.5.1               */ DISTANCE_140_NORMAL2 +
/*hapiel.Spiral 0.1                     */ DISTANCE_180_NORMAL2 +
/*jf.Dodger 1.1                         */ AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 + A040 +
/*mym.EdgeStalker 1.0                   */ DISTANCE_180_NORMAL2 +
/*NG.LegatusLegionis 1.2                */ DISTANCE_180_NORMAL2 +
/*povik.nano.Smilee 0.2.1               */ DISTANCE_260_NORMAL2 +
/*rampancy.micro.Epiphron 1.0           */ DISTANCE_180_NORMAL2 +
/*SuperSample.SuperCrazy 1.0            */ DISTANCE_260_NORMAL2 +
/*timmit.micro.TimXJ 0.22               */ DISTANCE_260_NORMAL2 +
/*exauge.GateKeeper 1.1.121g            */ DISTANCE_400_NORMAL2 +
/*exauge.Leopard 1.1.019                */ AM10 + AM10 + AM10 + AM10 + AM10 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A000 + A040 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + AM40 + 
/*ayk.WallHugger 1.0                    */ DISTANCE_380_NORMAL2 +
END_OVERFLOW_BUFFER;
}
