package EH.nano;
import robocode.*;
import robocode.util.*;
/**
 * NightBird - a robot by (Edward He)
 * 
 * V.1.0:
 * -My first NanoBot!
 * -random movement/stop and go
 * -head on targeting
 * -locking radar
 * -Codesize 239
 * 
 * V.1.1:
 * -linear gun
 * -wierd movement
 * -same radar
 * -not good...
 * 
 * V.1.2:
 * -complete rewrite due to messy code and errors
 * -random movement
 * -infinity lock
 * -linear targeting
 * -codesize 170
 * 
 * V.1.2M:
 * -Multi mod with stop and go
 * -beats 1.2
 */
public class NightBird extends AdvancedRobot{

int direction=1;
double prevEnergy = 100;

	public void run() {
		
		//gun/radar settings
		setAdjustGunForRobotTurn(true); 
		setAdjustRadarForGunTurn(true);
		
		while(true) {
		turnRadarRightRadians(Double.POSITIVE_INFINITY);
		}
	}
	public void onScannedRobot(ScannedRobotEvent e) {
		//infinity lock
		setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
		if (getRoundNum() >= 5) {
		setTurnLeft(90-e.getBearing());
		if (Math.random()<0.035) {
			direction=-direction;
		}
		setAhead(100*direction);
		}
		else if (getRoundNum() <= 5) {
			setTurnLeft(90-e.getBearing()-10);
			if (prevEnergy - e.getEnergy() > 0 && prevEnergy - e.getEnergy() <= 3) {
				setAhead(60*direction);
			}
			prevEnergy = e.getEnergy();
		}
		double bulletPower = 2;
    	double headOnBearing =
			   getHeadingRadians() + e.getBearingRadians();
    	double linearBearing =
 			   headOnBearing + Math.asin(e.getVelocity() / Rules.getBulletSpeed(bulletPower)
 * Math.sin(e.getHeadingRadians() - headOnBearing));	setTurnGunRightRadians(Utils.normalRelativeAngle(linearBearing - getGunHeadingRadians()));
    	fire(bulletPower);
		}
		public void onHitWall(){
			direction = -direction;
		}
}
								