package mld;
import robocode.*;
import java.awt.Color;
import robocode.util.Utils;

//  Moebius - a robot by Michael Dorgan

// --------------------------------------------------------------------------------------------------------------------------------------------
// Revision 3-09-03 ver 1.0
//
// After very carefully studying the pattern-matching code that Albert provided to the Wiki, I've modified it slightly,
// added a pattern it has trouble hitting to my bot, and here it is - Mobius, my first effective pattern Matching aim bot.
// The parameters can be tweeked later, but for now, I'm just happy it's alive and working.  A strong 1v1 contender in
// NanoBot land.
//
// CodeSize: 248 (No colors yet)
//
// Revision 3-12-03 ver 1.01
//
// Lowered the search depth to 9.  Changed movement to exact triangle pattern as this seems even better than box.
// Freed a bunch of bytes from the pattern code and that allowed me to use a more exact value for the pattern
// match itself - the angular velocity vs the straight velocity.  Really helps when locking onto circle bots.
// Alos made room for colors (style does matter!)  Fixed the spelling of our name (thanks Dave), and a few typos in 
// the comments.  A very, very strong 1v1 Nanobot.
//
// Codesize: 249 with colors!
//
// Revision 3-17-03 ver 1.1
//
// Changed to tan() style locking to gain a few bytes back.  Removed toString() from pattern matcher as it wasn't
// needed.  Had to swtich to dirty triangle movement.  Used saved bytes to implement a fire power control system.
// This allows better survival against certain bots and helps a bit in melee.  Upped movement per leg to 170 to
// help dodge no linear/circular aim shots.  A fairly good improvement.  It survives better against all bots, but
// doesn't win as convincingly against a few it locked onto last revision.  Still, a good improvement.
//
// Codesize: 248 with colors!
//
// Revision 3-25-03 ver 1.2
//
// Radar now uses Infinity style Infinite radar.  I've also re-purposed Albert's wonderful, wonderful pattern
// matching gun for my own use.  I've shrank its codesize somewhat in the process so he can feel free to take 
// it back and have his bot do new things too (like color!)  It's also more accurate than his due to the endBufferCheck.
// I've upped my triange edge a bit to help dodge  as this is the cheapest pattern I could find that caused 
// this new system of aiming to have (just a little) problem hitting.  It's a nice melee pattern as well so I 
// may do decent there too.  I've taken out the power management stuff as it was costing me too many damage points 
// and now I'm hitting even more often so it's not needed.  So far, I've not found a single Nanobot that consistently 
// beats me - though Smog 1.5 gives me problems.  All others fall before my (borrowed and improved) Nano-Scythe 
// of destruction!!! :) 
//
// Codesize: 249 with colors!
//
// Revision 3-26-03 ver 1.3
// I've switched from box movement to orbit movement with random jerkiness thrown in to kill pattern matching.
// This pattern really gives our aim trouble, keeps us equal distance from target which improves aim quality,
// and does decent dodging in all cases.  I've done a few code tricks to optimize codespace and make room for this
// new pattern.  Basically, my death shot code got reduced by 10 shots, my aim cannon at target isn't quite as good, 
// and I still don't get adjustGun() call to help with dead bots.  Still, this bot is really awesome right now.  It 
// annihilates most and only Pinball and Graviton currently stay somewhat close.  An excellent NanoBot 1v1 specialist!
// Many thanks to Albert for this wonderful gun idea and to all other coders who have made me stretch my mind in 
// order to compete.  Thanks!
//
// Codesize: 249 with colors! (And no more room to be had that I can find!)
//
// Revision 8-15-03 ver 2.0
// I incorporated the latest FunckyChicken gun (which was derived from my gun - which was from NanoLauLektrik...) 
// to help with aim and codesize.  I changed movement to be completely random around the radius of the target.
// I added some power management code to help me outlast FunkyChicken.  Good update.  Has a chance for title.
// I could get another couple of bytes but I don't need them.
//
// Codesize: 246 with colors. (Thanks Kawigi for ideas!)
//
// Revision 9-28-07 ver 2.1
//
// I borrowed Weekend Obsession's excellent code size shrinkage on his gun.  I used this plus a little space here
// and there to go multi-movement mode.  Smaller movementType helps with full-linear type bots.  Larger helps with
// straight on shot bots.  Swapping between both confuses pattern matchers a bit.  That plus some move forward
// aggression code cause many orbiters to kill themselves in corners.  A decent upgrade.  Will still keep working on it.
//
// Codesize: 247 - no color.
//
//  Revision 10-08-07 ver 2.2
//
// Switched over to a dual movement mode idea.  True stop and go to start and switch to rando move if we lose a more than
// we win.  Hopefully, the lower tier victories will push me higher when I lose to the upper-tier bots.  I may preload
// the aim array further next version.
//
// Codesize 249 - no color and nothing I can find to spare.  I'd love about 15 more bytes...
//
//  Revision 10-09-07 ver 2.3
//
// Last revision stunk.  Improved and shortened stop and go.  Added better random movement.  Added better move state switch
// code.  Much better now against lower bots.  A little better against higher bots.  Should go far.
//
// Codesize 249 - no color and nothing I can find to spare.  I'd still love about 10 more bytes...
//
// Revision 5/11/2009 ver 2.4
// 
// Can't beat them, take their ideas and tweak them.  This bot is now 90% John Cleland's code and ideas
// I'm just taking tem and playing with them a bit to see if I can improve them
// or find any extra code space.  No colors.  No pride here.
//
// Revision 5/18/2009 ver 2.5.1
// 
// Adjusted to use hitByBullet event as a test.  Could be better, could be worse.
//
// Revision 5/18/2009 ver 2.7
//
// Adjusted look ahead.  Adjusted preferred range.  Adjusted movement to be slightly more random.  Seems to be an across the board slight
// improvement.  Codesize 249
//
// Revision 5/18/2009 ver 2.8 - small tweaks that harmed performance
//
// Revision 5/19/2009 ver 2.9 - Firing at 2.5 instead of 3 to take advantage of buggy bots.
//
// Revision 5/26/2009 ver 2.9.3 - Ran through a testing suite and this is the best numbers so far.
//
// --------------------------------------------------------------------------------------------------------------------------------------------

public class Moebius extends AdvancedRobot
{
  // tunable constants
  // for movement
  private final static double MOVE_DISTANCE       = 240;
  private final static double NON_RAND            = 0.15;
  private final static double PREFERRED_RANGE     = 160.0;
  private final static double CLOSE_FCT           = 450 * MOVE_DISTANCE;
  
  // for gun
  private final static int    DISTANCE_OFFSET     = 2;
  private final static double BULLET_POWER        = 2.5D;
  private final static double BULLET_SPEED        = 20.0 - 3 * BULLET_POWER; 
  private final static double DISTANCE_DIVISOR    = PREFERRED_RANGE;
  private final static int    PREDICT_TICKS       = (int) (DISTANCE_OFFSET + (DISTANCE_DIVISOR / BULLET_SPEED));
  private final static int    MAX_MATCH_LEN       = 30;
  
  // attributes
  // for movement
  private static double       enemyEnergy;
  private static double       moveDir             = MOVE_DISTANCE;
  private static int          mode            	= -1;

  	// the pattern
  	public static String enemyHistory = ""
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 1 + (char) 2 + (char) 3 + (char) 4
    + (char) 5 + (char) 6 + (char) 7 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 6 + (char) 4 + (char) 2 + (char) 0
    + (char)-1 + (char)-2 + (char)-3 + (char)-4
    + (char)-5 + (char)-6 + (char)-7 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-6 + (char)-4 + (char)-2 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char)-1 + (char)-2 + (char)-3 + (char)-4
    + (char)-5 + (char)-6 + (char)-7 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-6 + (char)-4 + (char)-2 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0;

  /**
   * Bot run method.
   */
 	public void run() 
	{
    	// helps targeting accuracy
    	setAdjustGunForRobotTurn(true);

    	// start our infinite radar loop
    	turnRadarRightRadians(Double.POSITIVE_INFINITY);
  	}
  
  	/**
  	* Scan handler.
   	* This is where it all happens.
   	*/ 
  	public void onScannedRobot(ScannedRobotEvent e) {
    	// register vars, should be the most commonly used
    	int    ri = MAX_MATCH_LEN;
    	double rd = e.getBearingRadians();
 
    	// other vars
    	int    matchPos;

    	// radar scan
    	setTurnRadarLeftRadians(getRadarTurnRemaining());

    	// bullet dodge a random distance
    	if (enemyEnergy > (enemyEnergy = e.getEnergy())) 
		{
  			setAhead((moveDir *= mode) * (Math.random() + NON_RAND));
    	}

		setFire(BULLET_POWER);
	
    	// turn perpendicular with range control
    	setTurnRightRadians(Math.cos(rd - (e.getDistance() - PREFERRED_RANGE) * moveDir / CLOSE_FCT));
    
    	// rd has enemy relative bearing
    	rd += getHeadingRadians();

    	// pattern gun from WeekendOnsession by Eric Simonton
    	// add last enemy move to the pattern
    	enemyHistory = String.valueOf((char) (e.getVelocity() * (Math.sin(e.getHeadingRadians() - rd))))
      	.concat(enemyHistory);

    	// search for a match
    	while((matchPos = enemyHistory.indexOf(enemyHistory.substring(0, ri--), PREDICT_TICKS)) < 0);

    	// calculate aim offset
    	ri = PREDICT_TICKS;
    	do { rd += ((short) enemyHistory.charAt(--matchPos)) /  (DISTANCE_DIVISOR); } while (--ri > 0);
    
    	// turn gun
    	setTurnGunRightRadians(Utils.normalRelativeAngle(rd - getGunHeadingRadians()));
	}
  
  	/**
   	* Hit a wall, reverse direction and start moving immediately.
   	*/
  	public void onHitWall(HitWallEvent e) 
	{
    	setAhead(moveDir = -moveDir);
  	}

  	/**
   	* If we die, swap movement.
   	*/

  	public void onHitByBullet(HitByBulletEvent event) 
//  	public void onDeath(DeathEvent event) 
	{
    	mode = -mode;
  	}
}

