package jok;
import robocode.*;
import java.awt.geom.*;

/**
 * MyClass - a class by (your name here)
 */
public abstract class Targeting
{
	Enemy target;
	AdvancedRobot me;
	Rectangle2D.Double field;
	
	static int hits;
	static int attempts;
	double firePower;
	
	public void update(AdvancedRobot ar, Enemy en)
	{
		me = ar;
		target = en;
		field = new Rectangle2D.Double(0,0,me.getBattleFieldWidth(), me.getBattleFieldHeight());
	}
	
	public double getChance()
	{
		if(attempts < 3) return .8*Math.random();
		else return hits/attempts;
	}
	
	public void fire()
	{
		firepower();
		aim();
		me.setFire(firePower);
	}
	
	void firepower()
	{
		if(me.getEnergy() < 3.5) firePower = me.getEnergy()-.1;
		if(target.getEnergy() < 16) firePower = (target.getEnergy() - 2)/2;
		else firePower = 800/target.getDistance()+.1;
		firePower = Math.max(Math.min(firePower,3),.1);
	}
	
	public void aim()
	{
    	double time = me.getTime();
    	double nextTime;
    	Point2D.Double p;
    	p = new Point2D.Double(target.x, target.y);
    	for (int i = 0; i < 10; i++)
		{
        	nextTime =  (int)Math.round(p.distance(me.getX(),me.getY())/(20-(3*firePower)));
        	time = me.getTime() + nextTime;
        	p = guessPosition(time);
    	}
		if(field.contains(p))
		{
		  	double gunOffset = BotMath.absbearing(me.getX(),me.getY(),p.x,p.y) - me.getGunHeading();
    		me.setTurnGunRight(BotMath.normaliseBearing(gunOffset));
		}
	}
	
	abstract Point2D.Double guessPosition(double time);
}
