package hirataatsushi;

import java.util.*;

//̃NXraybot04Ƃ܂

/**
 * A force that can be attributed to enemy bots in order to
 * control the movement of our own bot.  It is comprised of
 * direction in degrees (compass orientation) and force
 * (how far we have to move to escape the repulsion).
 */
public final class AntiGravity {

    private static final double ANTI_GRAVITY_WALLS      = 2;
    private static final double ANTI_GRAVITY_ROBOTS     = 2;

    private double direction;
    private double force;


    /**
     * Create an AntiGravity object with
     * zero direction and force.
     */
    public AntiGravity() {

        this (0,0);
    }


    /**
     * Create an AntiGravity object with
     * specified direction and force.
     *
     * @param newDirection  Direction in degrees of AntiGravity object.
     * @param newForce      Force of new AntiGravity object.
     */
    public AntiGravity(double newDirection, double newForce) {

        direction   = newDirection;
        force       = newForce;
    }


    /**
     * Create an AntiGravity object and calculate the
     * force and direction using specified data.
     *
     * @param ba    BotArray containing all known enemy bots.
     * @param g     BattleField containing game dimensions.
     * @param yourX Your x coordinate.
     * @param yourY Your y coordinate.
     */
    public AntiGravity(Iterator bots,
                       BattleFieldManager g,
                       double yourX,
                       double yourY) {
	        this (0,0);
		System.out.println("AntiGravity method called");
		System.out.print(" my pos is ");
		System.out.print(yourX);
		System.out.print(" , ");
		System.out.println(yourY);

        calcAntiGravity(bots, g, yourX, yourY);
    }


    /** Return direction (in degrees) of AntiGravity force. */
    public double getDirection() {
        return direction;
    }


    /** Return AntiGravity force. */
    public double getForce() {
        return force;
    }


    /**
     * Assigns an anti-gravity force to each enemy bot and combines
     * these to determine the total anti-gravity force acting on
     * our robot.  Sets direction and force accordingly.
     *
     * @param ba    BotArray containing all known enemy bots.
     * @param g     BattleField containing game dimensions.
     * @param yourX Your x coordinate.
     * @param yourY Your y coordinate.
     */
    public void calcAntiGravity(Iterator bots,
                                BattleFieldManager g,
                                double yourX,
                                double yourY) {

        Enemy b               = null;
        int forceCount      = 0;
        double x            = 0;
        double y            = 0;
        double relX         = 0;
        double relY         = 0;
        double buffer       = Math.min(g.midX, g.midY) * .75 ;

		double force_from_Enemy = 0;
		double force_from_wall_X = 0;
		double force_from_wall_Y = 0;

		System.out.print(" buffer is ");
		System.out.println(buffer);
        /*
         * This is how anti gravity works: We want to be "buffer"
         * distance away from the enemy.  If we are closer than that,
         * then the anti gravity force pushes us away.
         */
		double tmp_direction = 0;
		double tmp_force = 0;
		while(bots.hasNext()){
			    System.out.println("CalcAntiGravity : while loop begin");
			Enemy tmp = (Enemy)bots.next();
				System.out.print("EnemyName is ");
				System.out.println(tmp.getName());
			
			if (tmp.getEnergy() > -1) {
				tmp_force = buffer - tmp.getDistance();
				if (Math.abs(force) > 0) {
					force_from_Enemy += Math.pow(tmp_force, ANTI_GRAVITY_ROBOTS);
                    tmp_direction += tmp.getBearing();
                    x += Math.sin(direction) * force;
                    y += Math.cos(direction) * force;
                    forceCount++;
				}
			}
			tmp_direction = (tmp_direction/forceCount + Math.PI)%Math.PI*2;
				System.out.println("                : while loop end");
		}
		
        /*
         * Now calculate the anti-gravity force for all four walls.
         */
        //forceCount++;

        force_from_wall_X = (yourX > g.midX) ?
            Math.min(g.maxX - buffer - yourX, 0) :
            Math.max(g.minX + buffer - yourX, 0) ;
        force_from_wall_X = Math.pow(Math.abs(force_from_wall_X), ANTI_GRAVITY_WALLS);
        x += (yourX > g.midX ? -force_from_wall_X : +force_from_wall_X);


        force_from_wall_Y = (yourY > g.midY) ?
            Math.min(g.maxY - buffer - yourY, 0) :
            Math.max(g.minY + buffer - yourY, 0) ;
        force_from_wall_Y = Math.pow(Math.abs(force_from_wall_Y), ANTI_GRAVITY_WALLS);
        y += (yourY > g.midY ? -force_from_wall_Y : +force_from_wall_Y);



        /*
         * average the x,y coordinates, then determine the
         * bearing and force from these coordinates.
         */
        x = x / forceCount;
        y = y / forceCount;
        relX = x - yourX;
        relY = y - yourY;

        direction = Helper.normalizeBearingRadians( (Helper.atan(relY, relX) + tmp_direction) / 2 ) ;
        force     = ( Math.sqrt(Math.pow(relY, 2) +
                                 Math.pow(relX, 2)) + force_from_Enemy ) /2;
		System.out.print("forceCount is ");
		System.out.println(forceCount);
		System.out.print("direction is ");
		System.out.println(direction);
		System.out.print("force is ");
		System.out.println(force);
    }
}
