/*
 * Written by Kinsen Choy
 */

package kinsen.melee.Guns;
import kinsen.melee.Details;

/*
 * Circular - A gun class that fires circularly predicted bullets.
 */
public class Circular extends Gun
{
	// Last enemy details
	private Details enemy = null;
	// Average enemy turn
	private double enemyTurn;
	// Last my details
	private Details me = null;
	// Last time
	private long lastTime = 0;

	public void calculateGun(double initialFirePower)
	{
		// If there is no data then it can not fire
		if (enemy != null)
		{
			// Sets target location and fire power
			firePower = initialFirePower;
			fireAt = super.predictPosition(enemy.getX(), enemy.getY(), me.getX(), me.getY(), enemy.getHeading(), enemy.getVelocity(), enemyTurn, firePower);
		}
	}

	public void calculateGun(double initialFirePower, boolean canChangePower)
	{
		calculateGun(initialFirePower);
	}

	public void recordData(Details enemyDetails, Details myDetails, long time)
	{
		// If there is previous data then calculate turn
		if (enemy != null)
			enemyTurn = (enemyDetails.getHeading() - enemy.getHeading()) / (time - lastTime);
		enemy = enemyDetails;
		me = myDetails;
		lastTime = time;
	}
}