package djc;
import robocode.*;

/**
 * MovingObject
 *  Heading is in radians
 */
public class MovingObject extends GravPoint
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */
    public static final String INVALID_TARGET_LOCATION = "The target position is off field";

    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */
    public double lastTimePosition = -1;
    public double heading_rad = 0;
    public double bearing_rad = 0;
    public String name = "";
    public double velocity = 0;
    public double avgVelocity = 0;
    public double angularVelocity = 0;
    public double avgAngVelocity = 0;

    /**
     * MovingObject Constructor
     *
     * @param targetName - String for the name
     */
    public MovingObject(String targetName)
    {
	super();
	name = targetName;
    }

    /**
     * MovingObject Constructor
     *
     * @param targetName - String for the name
     */
    public MovingObject()
    {
	super();
    }

}
