package theo.avenge.surf;
import theo.avenge.surf.predictor.*;
import robocode.*;
import robocode.util.Utils;
import java.util.*;
import java.awt.geom.*;
import java.util.*;
import theo.avenge.Pequod;
import theo.avenge.enemy.*;
import theo.avenge.wave.*;
import theo.avenge.utils.*;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Random;
/**
 * MyClass - a class by (your name here)
 */
public class SurfHandler
{

	public Pequod owner;
	Enemy enemy;
	
	ScannedRobotEvent ref;
	
	private static int NUM_NEIGHBORS;
	private static double MAX_DISTANCE;
	
	public static List<Wave> waveList;
	
	public static List<Point2D.Double> spotList, futurePoss;
	
	public double bPower = 3, bSpeed, bearingFrom, angleFrom, botWidth, lastBPower;
	public double latVelocity, latHeading;
	
	public static double[] stats, lastStats;
	
	public static HashMap<double[],Double> factorMap,
				theoryMap = new HashMap<double[],Double>();
	public static List<double[]> theoryList;
	
	public static List<Double> neighborList, theoryNList;
	
	public static double lastHitGF, activeGF, passingGF;
	
	public Wave currentWave, lastWave;
	
	public static double emptyDir;//, angleFrom;
	
	public static double maxDanger;
	
	public static boolean flatten = false;
	
	public static Point2D.Double desiredSpot;
	
	public static boolean paintWaves = false;
	
	public static double wrongness = 0.0;
	
	public static double shotsFired = 0.0;
	
	public static int flattenerVal = 2;
	
	public static boolean emptySurf = false;
	
	public HashMap<String,Double> statsBuffer = new HashMap<String,Double>();
	
	protected long time;
	protected double heading, velocity;
	
	//separate avenge and theory shots in different tables;
	
	static{
		waveList = new ArrayList<Wave>();
		spotList = new ArrayList<Point2D.Double>();
		stats = new double[12];
		factorMap = new HashMap<double[],Double>();
		theoryMap = new HashMap<double[],Double>();
		theoryList = new ArrayList<double[]>();
		neighborList = new ArrayList<Double>();
		theoryNList = new ArrayList<Double>();
		futurePoss = new ArrayList<Point2D.Double>();
		NUM_NEIGHBORS = 8;
		emptyDir = 1;
	}
	
	public SurfHandler(Pequod owner, Enemy enemy){
		this.owner = owner;
		this.enemy = enemy;
		
		MAX_DISTANCE = owner.getBattleFieldWidth()*owner.getBattleFieldWidth();
		MAX_DISTANCE += owner.getBattleFieldHeight()*owner.getBattleFieldHeight();
		MAX_DISTANCE = Math.sqrt(MAX_DISTANCE);
		
		this.desiredSpot = owner.ourPos;
	}
	
	public void update(ScannedRobotEvent ref){
		this.time = owner.getTime();
		this.velocity = owner.getVelocity();
		this.ref = ref;
		this.bearingFrom = WaveUtils.absBearing(Enemy.pos,owner.ourPos);
		this.angleFrom = WaveUtils.absAngle(Enemy.pos,owner.ourPos);
		this.latHeading = Utils.normalRelativeAngle(angleFrom-owner.heading);
		this.latVelocity = owner.velocity*Math.sin(this.latHeading);
		//this.botWidth = 36.0/Enemy.distance;
		//System.out.println("BeforeWidth: " + (botWidth/(2*Math.PI)*360));
		this.botWidth = 2.0*Math.atan2(18d,Math.sqrt(Enemy.distance*Enemy.distance + 18*18));
		//System.out.println((this.botWidth/(2*Math.PI)*360d) + " vs guesss: " + (36d/Enemy.distance/(2*Math.PI)*360.));
		//System.out.println("botWidth: " + (this.botWidth/(2*Math.PI)*360));
		//this.angleFrom = WaveUtils.absBearing(Enemy.pos,owner.ourPos);
		this.setStats();
		
		this.checkWaveSpawn();
		this.advanceWaves();
		//this.currentWave = this.getClosestSurfableWave();
		//desiredSpot = owner.ourPos;
		if(this.currentWave != this.lastWave && this.currentWave.startPoint != null){
			this.setNeighbors();
		//	this.desiredSpot = (Point2D.Double)this.computeFuture();
		//	this.driveTo(this.desiredSpot);
		}
		this.lastWave = this.currentWave;

	//	if(Math.abs(owner.getTurnRemainingRadians()) > Math.PI/720d*(40d - 3d*Math.abs(owner.velocity)) && this.currentWave.startPoint != null){
			//this.desiredSpot = (Point2D.Double)this.computeFuture();
	//		this.driveTo(this.desiredSpot);
	//	}
		
		if(this.currentWave.startPoint != null){
			this.activeGF = getActiveFactor(this.currentWave);
			this.emptyDir = owner.latDirection;
			this.emptySurf = false;
			//owner.setMaxVelocity(Math.abs(Math.PI/owner.getTurnRemainingRadians()));
			this.desiredSpot = (Point2D.Double)this.computeFuture();
			
			//System.out.println(this.desiredSpot.distance(owner.ourPos));
			//if(this.desiredSpot!=null)
			this.driveTo(this.desiredSpot);
		}
		else{
			this.emptySurf(true);
			this.emptySurf = true;
		}
		

		////////////////////////////////////////////////////////////
		/*if(this.currentWave != this.lastWave && this.currentWave.startPoint != null){
			System.out.println("At : " + this.activeGF);
			System.out.println("Going : " + getStandardFactor(this.currentWave,this.desiredSpot));
			System.out.println("----------------------");
		}*/
		
//		this.lastWave = this.currentWave;
		////////////////////////////////////////////////////////////

		
		double legitTurn = owner.getTurnRemainingRadians();
		if(Math.abs(legitTurn)>Math.PI/2d){
			legitTurn = Utils.normalRelativeAngle(Math.PI-legitTurn);
		}
		owner.setMaxVelocity(Math.abs(Math.PI/legitTurn));
		
		statsBuffer.put("Velocity", owner.velocity);
		statsBuffer.put("LastVelocity", owner.lastVelocity);
		statsBuffer.put("LateralVelocity", latVelocity);
		statsBuffer.put("Heading", owner.heading);
		statsBuffer.put("LastHeading", owner.lastHeading);
		statsBuffer.put("LatDirection", (double)owner.latDirection);
		statsBuffer.put("EnemyPosX", Enemy.pos.x);
		statsBuffer.put("EnemyPosY", Enemy.pos.y);
		statsBuffer.put("OurX", owner.ourPos.x);
		statsBuffer.put("OurY", owner.ourPos.y);
		statsBuffer.put("AngleFrom", WaveUtils.absAngle(Enemy.pos,owner.ourPos));
		statsBuffer.put("BearingFrom", WaveUtils.absBearing(Enemy.pos,owner.ourPos));
		statsBuffer.put("Distance", Enemy.distance);
		statsBuffer.put("BotWidth", botWidth);//(2.0*Math.atan2(18d,Enemy.distance)));
		statsBuffer.put("ActiveFactor", activeGF);
		statsBuffer.put("ABSBearingTo", Enemy.absBearing);
		statsBuffer.put("RadianWallRatio", radianToWallRatio());
		lastStats = this.stats.clone();
		
		//System.out.println("angle from: " + (statsBuffer.get("AngleFrom")*360/(2*Math.PI)));
		//System.out.println("bear  from: " + (statsBuffer.get("BearingFrom")*360/(2*Math.PI)));
		//System.out.println("---------------------");
	}
	
	public void emptySurf(boolean go){
		double desiredAngle = Utils.normalRelativeAngle(angleFrom+Math.PI/2.0);
		if(go){
			desiredAngle = Utils.normalRelativeAngle(desiredAngle-Math.PI/10.0*owner.latDirection);
		}
		double headAngle = findAngle(desiredAngle,owner.heading,owner.ourPos,owner.latDirection);
		double turnAmount = Utils.normalRelativeAngle(headAngle - owner.heading);
		
		/*if(turnAmount>Math.PI/2.0){
			headAngle = Utils.normalRelativeAngle(Math.PI - headAngle);
			emptyDir *= -1;
		}*/
		
		Point2D.Double destination = (Point2D.Double)WaveUtils.project(owner.ourPos,130*emptyDir,headAngle);
		//System.out.println(destination.toString());
		if(!owner.playField.contains(destination) && destination.distance(Enemy.pos)<owner.ourPos.distance(Enemy.pos)){
			emptyDir *= -1;
		}
		if(go){
			owner.setAhead(emptyDir*100);
		}
	//	else{
	//		turnAmount = Utils.normalRelativeAngle(desiredAngle-owner.heading);
	//	}
		owner.setTurnRightRadians(turnAmount);
		//owner.setMaxVelocity(Math.PI/owner.getTurnRemainingRadians());
	}
	
	public void setStats(){
		if(statsBuffer.get("Velocity")!=null){
			stats[0] = Math.abs(statsBuffer.get("Velocity"))/8.0;
			stats[9] = statsBuffer.get("Distance")/MAX_DISTANCE;
			stats[1] = 36/statsBuffer.get("Distance");
		//stats[2] = Math.abs((Math.min(owner.velocity,owner.lastVelocity)-Math.max(owner.velocity,owner.lastVelocity) + 2*(owner.latDirection*(Enemy.absBearing<0?-1:1)))/4.0);
			stats[2] = Math.abs((Math.abs(statsBuffer.get("Velocity")) - Math.abs(statsBuffer.get("LastVelocity"))))/2.0;
			stats[3] = bPower/3.0;//lastBPower/3.0;
			stats[4] = WaveUtils.limit(/*-1d*/0d,Math.abs((Utils.normalRelativeAngle(statsBuffer.get("Heading")-statsBuffer.get("LastHeading"))/ // *statsBuffer.get("LatDirection") /
					(Math.PI/20d))),1d);/* owner.latDirection; 
						(owner.velocity<0?-1:1);*/
			stats[5] = (lastHitGF * lastHitGF);
		//stats[5] = (
			stats[6] = statsBuffer.get("ActiveFactor") * statsBuffer.get("ActiveFactor");
			stats[7] = Math.abs(statsBuffer.get("RadianWallRatio"));
			stats[8] = Math.abs(statsBuffer.get("LateralVelocity"))/8.0;
			stats[10] = Math.abs(statsBuffer.get("ABSBearingTo"))/Math.PI;
			stats[11] = passingGF * passingGF;
		}
		else{
			stats[0] = Math.abs(owner.velocity)/8.0;
			stats[9] = Enemy.distance/MAX_DISTANCE;
			stats[1] = 36/Enemy.distance;
		//stats[2] = Math.abs((Math.min(owner.velocity,owner.lastVelocity)-Math.max(owner.velocity,owner.lastVelocity) + 2*(owner.latDirection*(Enemy.absBearing<0?-1:1)))/4.0);
			stats[2] = (Math.abs(owner.velocity) - Math.abs(owner.lastVelocity))/2.0;
			stats[3] = bPower/3.0;//lastBPower/3.0;
			stats[4] = WaveUtils.limit(-1d,Math.abs((Utils.normalRelativeAngle(owner.heading-owner.lastHeading))*owner.latDirection /
					(Math.PI/20d)),1d);/* owner.latDirection; 
						(owner.velocity<0?-1:1);*/
			stats[5] = (lastHitGF *lastHitGF);
		//stats[5] = (
			stats[6] = activeGF * activeGF;
			stats[7] = Math.abs(radianToWallRatio());
			stats[8] = Math.abs(latVelocity)/8.0;
			stats[10] = Enemy.absBearing/Math.PI;
			stats[11] = passingGF * passingGF;
			//System.out.println("using current state");
		}
		//for(double stat: stats){
		for(int i = 0; i < stats.length; i ++){
			double stat = stats[i];
			//if (Math.abs(stat)>1){
			//	System.out.println(stat + " at " + i);
			//}
			stats[i] = WaveUtils.limit(0.0,stats[i],1d);
		}
	}
	
	public void checkWaveSpawn(){
		if(Enemy.lastEnergy - Enemy.energy <= 3 && Enemy.lastEnergy - Enemy.energy > 0){
			this.bPower = Enemy.lastEnergy - Enemy.energy;
			this.bSpeed = WaveUtils.bSpeed(this.bPower);
			spawnWave(true);
		}
		else if(statsBuffer.get("Velocity")!=null && time % flattenerVal == 0 && !this.emptySurf){
			spawnWave(false);
		}
	}
	
	void spawnWave(boolean isReal){
		Wave wave = new Wave();
		wave.startPoint = new Point2D.Double(statsBuffer.get("EnemyPosX"),statsBuffer.get("EnemyPosY"));
		wave.aimPoint = new Point2D.Double(statsBuffer.get("OurX"),statsBuffer.get("OurY"));
		wave.velocity = this.bSpeed;
		wave.bPower = this.bPower;
		wave.latDirection = statsBuffer.get("LatDirection");
		wave.maxEscapeAngle = Math.asin(8.0/wave.velocity)*wave.latDirection;//this.liveMaxEscapeAngle();//Math.asin(8.0/wave.velocity)*wave.latDirection;
		wave.startBearing = statsBuffer.get("BearingFrom");
		wave.startAngle = statsBuffer.get("AngleFrom");
		//wave.maxEscapeAngle = liveMaxEscapeAngle();
		wave.maxBearing = Utils.normalRelativeAngle(wave.maxEscapeAngle+wave.startAngle);
		wave.minBearing = Utils.normalRelativeAngle(wave.startAngle-wave.maxEscapeAngle);
		wave.distance = statsBuffer.get("Distance");
		wave.distTraveled = bSpeed;
		wave.targetVelocity = statsBuffer.get("Velocity");
		wave.shotTime = time-1;
		//wave.stats = lastStats;
		wave.stats = stats.clone();
		wave.botWidth = statsBuffer.get("BotWidth");
		wave.isReal = isReal;
		
		this.lastBPower = wave.bPower;
		//System.out.println("theyShot: " + waveList.size());
		if(wave.isReal){
			this.shotsFired ++;
		}
		waveList.add(wave);
	}
	
	void advanceWaves(){
		for(int i = 0; i < waveList.size(); i ++){
			Wave testWave = (Wave)waveList.get(i);
			testWave.distTraveled = (time - testWave.shotTime) * testWave.velocity;
			//waveList.set(i, testWave);
			testWave.desiredSpot = (Point2D.Double)this.desiredSpot;
			if(testWave.distTraveled > testWave.startPoint.distance(owner.ourPos) + 18){
				//Testing flattener:
				if(flatten || !testWave.isReal){
					storeWave(testWave, (Point2D.Double)owner.ourPos);
				}
				else{
					waveList.remove(testWave);
				}
				//System.out.println("storing wave");
				//this.currentWave = this.getClosestSurfableWave();
				//this.setNeighbors();
				i--;
				this.update(ref);
			}
		}
		this.currentWave = getClosestSurfableWave();
	}
	
	public void handleHit(Point2D.Double pos, double pow){
		//if(this.currentWave!=null){
		Wave hitWave = getClosestWave(pos,pow);
		if(hitWave.startPoint!=null){
			storeWave(hitWave, pos);
		}
		else{
			System.out.println("ARG ME LOST A WAVE MATEY");
		}
	}
	
	void storeWave(Wave wave, Point2D.Double pos){
		//double factor = getActiveFactor(wave);
		double factor = getStandardFactor(wave, pos);
		assert Math.abs(factor) <= 1;
		this.passingGF = factor;
		//System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
		//System.out.println("Hit at factor: " + factor);
		wrongness += Utils.normalRelativeAngle(angleForOffset(
							Math.abs(factor)-Math.abs(getStandardFactor(wave, wave.desiredSpot)),wave)
								- wave.startBearing)*360d/(2*Math.PI);
		if(wave.isReal){
			this.factorMap.put(wave.stats,factor);
			this.lastHitGF = factor;
		}
		else{
			double [] tempStats = wave.stats;
			theoryMap.put(tempStats,factor);
			theoryList.add(tempStats);
			if(theoryList.size()>11000){
				Double val = theoryMap.remove(theoryList.get(0));
				//System.out.println("Val removed: " + val);
				theoryList.remove(theoryList.get(0));
			}
		}
	//	owner.out.println(theoryMap.keySet().size() + " keySize");
		
		/*if(factor<0){
			System.out.println("WaveMEA: " + (wave.maxEscapeAngle/(2*Math.PI)*360.));
			System.out.println("WaveResult: " + ((WaveUtils.absAngle(wave.startPoint,pos)-wave.startAngle)/(2*Math.PI)*360.));
			System.out.println("WaveStart: " + (wave.startAngle/(2*Math.PI)*360.));
			System.out.println("WaveEnd: " + (WaveUtils.absAngle(wave.startPoint,pos)/(2*Math.PI)*360.));
			System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
		}*/
		//if(flatten){
			this.waveList.remove(wave);
		//}
		//this.currentWave = this.getClosestSurfableWave();
		//this.setNeighbors();
		//this.lastWave = this.currentWave;
		//this.update(ref);
	}
	
	Point2D.Double computeFuture(){
		spotList.clear(); futurePoss.clear();
		double desiredAngle = Utils.normalAbsoluteAngle(Enemy.absBearing+Math.PI/2.0);
		double predVelocity = velocity;
		double timeTillHit = (currentWave.distTraveled-
								currentWave.startPoint.distance(owner.ourPos))
									/currentWave.velocity;
		boolean interrupted = false;
		int ticks = 0;
		double[] dirGroup = new double[]{currentWave.latDirection,-1d*currentWave.latDirection};
		Point2D.Double point = (Point2D.Double)owner.ourPos;
		double maxTurn = Math.PI/45d, predHeading = owner.heading;
		double turnAmount = Utils.normalRelativeAngle(desiredAngle-predHeading);
		double predLatDirection = owner.latDirection, lastPredLatDirection = owner.latDirection;
		spotList.add(point);
		double maxVelocity = 8d, turnRemaining = 0d;
	//	List<Point2D.Double> forwardSpots = new ArrayList<Point2D.Double>();
	//	List<Point2D.Double> backwardSpots = new ArrayList<Point2D.Double>();
	//	List<Point2D.Double> spotHolder = new ArrayList<Point2D.Double>();
		int spotCounter = 0;

		for(double dir: dirGroup){
			point = (Point2D.Double)owner.ourPos;//;
			predVelocity = owner.velocity;
			predHeading = owner.heading;
			predLatDirection = owner.latDirection;
			lastPredLatDirection = predLatDirection;
			interrupted = false;
			ticks = 0;
			desiredAngle = Utils.normalAbsoluteAngle(Enemy.absBearing+Math.PI/2.0);
			Utils.normalRelativeAngle(desiredAngle-predHeading);
			maxVelocity = WaveUtils.limit(0,Math.abs(Math.PI/turnAmount),8d);
			turnRemaining = turnAmount;
			spotCounter = 0;
			while(!interrupted){
				desiredAngle = Utils.normalRelativeAngle(WaveUtils.absAngle(currentWave.startPoint,point)+Math.PI/2.0-Math.PI/10.0*predLatDirection);
				desiredAngle = findAngle(desiredAngle,predHeading,point,predLatDirection);
				predVelocity += (predVelocity*dir<0?2*dir:dir);
				//predVelocity = WaveUtils.limit(-8d,predVelocity,8d);
				predVelocity = WaveUtils.limit(-1*maxVelocity,predVelocity,maxVelocity);
				//System.out.println("dir vel: " + dir + " " + predVelocity);
				predLatDirection = (predVelocity<0?-1:1)*
									(Utils.normalRelativeAngle((WaveUtils.absBearing(point,currentWave.startPoint)
										-predHeading))<0?-1:1);
				if(predLatDirection!=lastPredLatDirection){
					predVelocity = 0;
				}
				lastPredLatDirection = predLatDirection;
				maxTurn = Math.PI/720d*(40d - 3d*Math.abs(predVelocity));
				turnAmount = Utils.normalRelativeAngle(desiredAngle - predHeading);
				turnRemaining = turnAmount;
				turnAmount = WaveUtils.limit(-maxTurn,turnAmount,maxTurn);
				turnRemaining = Utils.normalRelativeAngle(turnRemaining - turnAmount);
				if(Math.abs(turnRemaining)>Math.PI/2){
					turnRemaining = (Utils.normalRelativeAngle(Math.PI+turnRemaining));
				}
				maxVelocity = WaveUtils.limit(0,Math.abs(Math.PI/turnRemaining),8d);
						
						//predVelocity += (predVelocity*dir>0?dir:2*dir);
						//predVelocity = WaveUtils.limit(-8d,predVelocity,8d);
						//predVelocity = WaveUtils.limit(-1*maxVelocity,predVelocity,maxVelocity);
				predHeading = Utils.normalAbsoluteAngle(predHeading+turnAmount);
				point = WaveUtils.project(point,predVelocity,predHeading);
				spotList.add((Point2D.Double)point.clone());
				ticks ++;
				timeTillHit = (currentWave.startPoint.distance(point)
								- currentWave.distTraveled - currentWave.velocity*ticks - 18)
									/currentWave.velocity;
				//timeTillHit -= ticks;
				interrupted = timeTillHit<1.0;
				
				spotCounter++;
			/*	if(dir<0){
					backwardSpots.add(point);
				}
				else{
					forwardSpots.add(point);
				} */
			}
		/*	if(dir == owner.latDirection)
				System.out.println("forward spots: " + spotCounter);
			else 
				System.out.println("backward spots: " + spotCounter);*/
		}
		/*Point2D.Double aheadPoint = WaveUtils.project(owner.ourPos,predVelocity,desiredAngle);
		aheadPoint = satisfy(owner.ourPos, aheadPoint, owner.latDirection);
		Point2D.Double behindPoint = WaveUtils.project(owner.ourPos,-1*predVelocity,desiredAngle);
		behindPoint = satisfy(owner.ourPos, behindPoint, owner.latDirection);
		
		spotList.add(aheadPoint);
		spotList.add(behindPoint);*/
		
		double angleToSpot;
		int direction = 1;
		
		Point2D.Double desiredSpotTemp = (Point2D.Double)leastDangerous(spotList, false);
		angleToSpot = WaveUtils.absAngle(owner.ourPos,desiredSpotTemp);
		direction = (Math.abs(Utils.normalRelativeAngle(angleToSpot-owner.heading))<Math.PI/2.0?1:-1);
		if(direction < 0){
			angleToSpot = Utils.normalAbsoluteAngle(angleToSpot + Math.PI);
		}
		RoboPredicter predicter = new RoboPredicter(this,desiredSpotTemp.distance(owner.ourPos),
										angleToSpot,direction);
										
		this.futurePoss = predicter.getPosList();
		
		desiredSpotTemp = leastDangerous((List<Point2D.Double>)this.futurePoss, false);

		// = leastDangerous(spotList, true);
		//List<Point2D.Double> futurePoss1 = new ArrayList<Point2D.Double>();
	//	List<Point2D.Double> futurePoss2 = new ArrayList<Point2D.Double>();
		
	/*	for(int i = 0; i < 2; i ++){
			if(i ==0){
				spotHolder = backwardSpots;
			}
			else{ spotHolder = forwardSpots; }
			
			desiredSpotTemp = leastDangerous(spotHolder,false);

			angleToSpot = WaveUtils.absAngle(owner.ourPos,desiredSpotTemp);
			direction = (Math.abs(Utils.normalRelativeAngle(angleToSpot-owner.heading))<Math.PI/2.0?1:-1);
			if(direction < 0){
				angleToSpot = Utils.normalAbsoluteAngle(angleToSpot + Math.PI);
			}
			RoboPredicter futurePosses = new RoboPredicter(this,desiredSpotTemp.distance(owner.ourPos),
											angleToSpot,direction,currentWave);
			if(i == 0){
				futurePoss1 = futurePosses.getPosList();
				for(Point2D.Double val : futurePoss1){
					futurePoss.add(val);
				}
			}
			else if (i == 1){
				futurePoss2 = futurePosses.getPosList();
				for(Point2D.Double val : futurePoss2){
					futurePoss.add(val);
				}
			}
			//desiredSpotTemp = leastDangerous(futurePoss, false);
		}

		desiredSpotTemp = leastDangerous(futurePoss1, false);
		Point2D.Double desiredSpot2 = leastDangerous(futurePoss2, false);
		
		spotHolder.clear();
		spotHolder.add(desiredSpotTemp);
		spotHolder.add(desiredSpot2);
		
		desiredSpotTemp = leastDangerous(spotHolder,false);
		futurePoss.add(desiredSpotTemp);*/

		//return leastDangerous(futurePoss);
		return desiredSpotTemp;
		
	}
	
	

	double findAngle(double desiredAngle, double actual, Point2D.Double pos, double dir){
		double toTurn = Utils.normalRelativeAngle(desiredAngle - actual);
		
	/*	if(Math.abs(toTurn)>Math.PI/2.0){
			toTurn *= -1;
			toTurn = Utils.normalRelativeAngle(Math.PI-toTurn);
			dir *= -1;
		}
	*/	
		double dist = 120*dir;
		int i = 0;
		Point2D.Double projection = (Point2D.Double)WaveUtils.project(pos,dist,actual+toTurn);
		while(!owner.playField.contains(projection)&&i<315){
			toTurn += dir*0.01;
			projection = WaveUtils.project(pos,dist,actual+toTurn);
			i++;
		}
		//return (WaveUtils.absBearing(pos,projection));
		return Utils.normalAbsoluteAngle(actual+toTurn);
		

	}
	
	Point2D.Double satisfy(Point2D.Double start, Point2D.Double test, int dir){
		double angleTo = WaveUtils.absBearing(start,test);
		double angleChanger = Utils.normalRelativeAngle(angleTo-owner.heading);
		double distTo = start.distance(test);
		int i = 0;
		while(!owner.playField.contains(test)&&i<314){
			angleChanger += 0.01*dir;
			test = WaveUtils.project(start,distTo,angleChanger+owner.heading);
			i++;
		}
		return (Point2D.Double)test;
	}
	
	Point2D.Double leastDangerous(List<Point2D.Double> list, boolean print){
		double minDanger = Double.POSITIVE_INFINITY;
		double dangers;
		Point2D.Double returnSpot = (Point2D.Double)owner.ourPos;
		this.maxDanger = 0;
		int s = 0;
		for (Point2D.Double testSpot : list){
			dangers = getTotalDanger(testSpot);
			if(dangers > this.maxDanger){
				this.maxDanger = dangers;
			}
			if(dangers<=minDanger){
				minDanger = dangers;
				returnSpot = (Point2D.Double)testSpot;//;
			}
			s++;
			if(print)
				System.out.println("Danger spot # : " + s + " " + dangers + " || at factor " + getStandardFactor(currentWave,testSpot));
		}
		if(print)
			System.out.println("Trying for factor: " + getStandardFactor(currentWave,returnSpot));
		return (Point2D.Double)returnSpot;
	}
	
	void driveTo(Point2D.Double spot){
		double angleTo = WaveUtils.absAngle(owner.ourPos,spot);
		double deltaTheta = Utils.normalRelativeAngle(angleTo - owner.heading);
		double dist = owner.ourPos.distance(spot);
		double dir;
		if(deltaTheta>Math.PI/2||deltaTheta<-Math.PI/2){
			dir = -1.0;
			deltaTheta = Utils.normalRelativeAngle(Math.PI/*(deltaTheta>0?1:-1)*/+deltaTheta);
			//deltaTheta *= -1;
			//deltaTheta = Utils.normalRelativeAngle(Math.PI-deltaTheta);
		}
		else { dir = 1.0; }
		owner.setTurnRightRadians(deltaTheta*Math.signum(dist));
	//	if(owner.getTurnRemainingRadians()==0){
			owner.setAhead(dist*dir);
	//	}
	//	if(Math.signum(desiredSpot.distance(owner.ourPos))==0){
	//		emptySurf(false);
	//	}
	}
	
	double getTotalDanger(Point2D.Double pos){
		double danger = 0;
		double angle1 = WaveUtils.absAngle(currentWave.startPoint,pos);
		///double botWidths = 2*Math.atan2(18d,(double)currentWave.startPoint.distance(pos));
		double botWidths = 36.0/currentWave.startPoint.distance(pos);
		for(double factor : neighborList){
			//System.out.println("Neighbor Factors: " + factor);
			double tempDang = getDanger(botWidths, factor, angle1, currentWave);
			//tempDang *= 10000.0;
			//tempDang /= pos.distance(currentWave.startPoint);
			//tempDang /= pos.distance(WaveTheory.pos);
			danger += tempDang;// *WaveTheory.pos.distance(currentWave.startPoint)/pos.distance(currentWave.startPoint);
		}
		for(double factor : theoryNList){
			double tempDang = getDanger(botWidths, factor, angle1, currentWave);
		//	tempDang /= 2.0;
			//tempDang *= 2.0;
			danger += tempDang / 4.0;
		}
		//System.out.println("--------------------");
		//System.out.println(danger);
		return danger;
	}
	
	static double getDanger(double botWidths, double factor, double angle1, Wave wave){
		//double currentFactor = getActiveFactor(currentWave);
		double danger;
		//System.out.println(currentWave.startPoint.x);
		//double angle1 = WaveUtils.absBearing(currentWave.startPoint,pos);
		//double angleA = angleForOffset(getStandardFactor(currentWave,pos),currentWave);
		double angle2 = angleForOffset(factor,wave);
		//System.out.println("A - 1 : " + (angleA-angle1));
		double ratio = Utils.normalRelativeAngle((angle2)-(angle1))/botWidths;
		//if (Math.abs(ratio) <= 1){
		//	danger ++;
		//}
		//if(Math.abs(ratio)<=1){
		danger = Math.pow(Math.E,-.5d*(ratio*ratio));
		//}
		return danger;
	}
	
	static double angleForOffset(double factor, Wave wave){
		//return Utils.normalRelativeAngle(factor*wave.maxEscapeAngle + wave.startBearing);
		return Utils.normalAbsoluteAngle(factor*wave.maxEscapeAngle + WaveUtils.absAngle(wave.startPoint,wave.aimPoint));//wave.startAngle);
	}
	
	static double bearingForOffset(double factor, Wave wave){
		return Utils.normalRelativeAngle(factor*wave.maxEscapeAngle + WaveUtils.absAngle(wave.startPoint,wave.aimPoint));//wave.startAngle);
	}
	
	Wave getClosestSurfableWave(){
		double minTime = Double.POSITIVE_INFINITY;
		Wave returnWave = new Wave();
		for(Wave test : waveList){
			double deltaDist = owner.ourPos.distance(test.startPoint) - test.distTraveled - 18;
			double timeTillHit = deltaDist / test.velocity;
			if(timeTillHit < minTime && timeTillHit >= 1.0 && test.isReal){
				minTime = timeTillHit;
				returnWave = test;
			}
		}
		return returnWave;
	}
	
	Wave getClosestWave(Point2D.Double pos, double pow){
		double minDist = Double.POSITIVE_INFINITY;
		Wave returnWave = new Wave();
		for(Wave test : waveList){
			double deltaDist = Math.abs(pos.distance(test.startPoint) - test.distTraveled);
			if(deltaDist < minDist && Math.abs(test.bPower-pow)<0.05 && test.isReal){
				minDist = deltaDist;
				returnWave = test;
			}
		}
		return returnWave;
	}
	
	double liveMaxEscapeAngle(){
		//double agent = Math.asin(8.0/bSpeed)*currentWave.latDirection;
//		double agent = Math.asin(8.0/bSpeed)*owner.latDirection;
		double agent;
		if(statsBuffer.get("LatDirection")!=null){
			agent = Math.asin(8.0/this.bSpeed)*statsBuffer.get("LatDirection");
		}
		else{
			agent = Math.asin(8.0/this.bSpeed)*owner.latDirection;
		}
		return agent;
	}
	
	double getActiveFactor(Wave wave){
		//double theta = Utils.normalRelativeAngle(
		//				WaveUtils.absAngle(wave.startPoint,owner.ourPos)-WaveUtils.absAngle(wave.startPoint,wave.aimPoint));
		double theta = Utils.normalRelativeAngle(
						WaveUtils.absAngle(wave.startPoint,new Point2D.Double(statsBuffer.get("OurX"),
											statsBuffer.get("OurY")))-WaveUtils.absAngle(wave.startPoint,wave.aimPoint));//wave.startAngle);
		return theta/wave.maxEscapeAngle;
	}
	double getStandardFactor(Wave wave, Point2D.Double pos){
		double theta = Utils.normalRelativeAngle(
						WaveUtils.absAngle(wave.startPoint,pos)-WaveUtils.absAngle(wave.startPoint,wave.aimPoint));//wave.startAngle);
		return theta/wave.maxEscapeAngle;
	}

	void setNeighbors(){
		this.neighborList = WaveUtils.findNearestSurfNeighbors(
							(double[])this.currentWave.stats.clone(), factorMap, NUM_NEIGHBORS);
		this.theoryNList = WaveUtils.findNearestSurfNeighbors(
							(double[])this.currentWave.stats.clone(), theoryMap, NUM_NEIGHBORS);
	}
	
	public void paint(Graphics2D g){
		Point2D.Double spot;
		Color custom;
		g.setColor(Color.yellow);
		for (int i = 0; i < spotList.size(); i++){
			spot = (Point2D.Double)spotList.get(i);//;
			if(spot!=null&&currentWave.startPoint!=null){
				custom = new Color((int)(WaveUtils.limit(0,getTotalDanger(spot)/SurfHandler.maxDanger*255.0,255.0)),255,255);
				g.setColor(custom);
				g.drawOval((int)spot.x-1,(int)spot.y-1,1,1);
			}
		}
		for (int i = 0; i < futurePoss.size(); i ++){
			spot = futurePoss.get(i);
			if(spot!=null&&currentWave.startPoint!=null){
				custom = new Color((int)WaveUtils.limit(0,getTotalDanger(spot)/SurfHandler.maxDanger*255.0,255.0),
							(int)WaveUtils.limit(0,getTotalDanger(spot)/SurfHandler.maxDanger*255.0,255.0),
								(int)WaveUtils.limit(0,255.0 - getTotalDanger(spot)/SurfHandler.maxDanger*255.0,255.0));
				g.setColor(custom);
				g.drawOval((int)spot.x-1,(int)spot.y-1,2,2);
			}
		}
		//spot = (Point2D.Double)desiredSpot;
		//g.setColor(Color.red);
		//g.drawOval((int)spot.x-18,(int)spot.y-18,36,36);
		g.setColor(Color.white);
		if(paintWaves)
		for (Wave toPaint : waveList){
			double radius = toPaint.distTraveled + toPaint.velocity;
			g.setColor((toPaint.isReal?Color.white:Color.yellow));
			if(toPaint.equals(currentWave)) g.setColor(Color.blue);
			//else g.setColor(Color.white);
			g.drawOval(new Double(toPaint.startPoint.x - radius).intValue(),
				new Double(toPaint.startPoint.y - radius).intValue(),
					new Double(radius*2).intValue(), new Double(radius*2).intValue());
			g.setColor(Color.green);
			Point2D.Double midBin = new Point2D.Double((radius*Math.sin(toPaint.startBearing) + toPaint.startPoint.x),
										(radius*Math.cos(toPaint.startBearing) + toPaint.startPoint.y));
			Point2D.Double maxBin = new Point2D.Double((radius*Math.sin(toPaint.maxBearing) + toPaint.startPoint.x),
										(radius*Math.cos(toPaint.maxBearing) + toPaint.startPoint.y));
			Point2D.Double minBin = new Point2D.Double((radius*Math.sin(toPaint.minBearing) + toPaint.startPoint.x),
										(radius*Math.cos(toPaint.minBearing) + toPaint.startPoint.y));
			g.drawOval((int)midBin.x-5,(int)midBin.y-5,10,10);
			g.drawOval((int)maxBin.x-5,(int)maxBin.y-5,10,10);
			g.setColor(Color.blue);
			g.drawOval((int)minBin.x-5,(int)minBin.y-5,10,10);
		}
	}
	
	double radianToWallRatio(){
		Point2D.Double projPos = owner.ourPos;
		double mEA = Math.abs(liveMaxEscapeAngle()), thetaOffset = 0;
		double bearingToUs = WaveUtils.absBearing(Enemy.pos,owner.ourPos);
		while(Math.abs(thetaOffset) < mEA && owner.playField.contains(projPos)){
			thetaOffset += 0.007 * owner.latDirection;
			projPos = WaveUtils.project(Enemy.pos, Enemy.distance, bearingToUs + thetaOffset);
		}
		thetaOffset = Math.min(Math.abs(thetaOffset), mEA);
		return thetaOffset/mEA;
	}

}
