package tobe.statistics;
import tobe.util.*;
import robocode.ScannedRobotEvent;

/**
 * The big book with all the info
 */
public class TargetStatistics implements java.io.Serializable
{
	public TargetStatistics(String targetName) {
		name = targetName;
	}
	
	public CircularArray getEvasions() {
		return evasions;
	}
	
	public CircularArray getDeltas() {
		return deltas;
	}
	
	public BearingVector getPosition() {
		return new BearingVector(position);
	}
	
	public void getPosition(BearingVector v) {
		v.setVector(position);
	}
	
	public BearingVector getMovement() {
		return new BearingVector(movement);
	}
	
	public void getMovement(BearingVector v) {
		v.setVector(movement);
	}
	
	public double getHeading() {
		return movement.getAbsoluteBearing();
	}
	
	public double getAverageVelocity() { return averageVelocity; }
	
	public double getDistance(double myX, double myY) {
		BearingVector b = new BearingVector(position);
		b.setOrigin(myX, myY);
		return b.getDistance();
	}
	
	public double getBearing(double myX, double myY) {
		BearingVector b = new BearingVector(position);
		b.setOrigin(myX, myY);
		return b.getBearing();
	}
	
	public double getX() { return position.getToX(); }
	
	public double getY() { return position.getToY(); }
			
	public double getEnergy() {
		return energy;
	}
	
	public double firedBullet(double now) {
		double bullet = lastObservedEnergy - energy;
		if(now - time <= 1 && bullet >= 0.1 && bullet <= 3.0) return bullet;
		else return 0;
	}
	
	public double getTime() {
		return time;
	}
	
	public boolean isSeen() { return seen; }
	
	public boolean isMercyShot() { return mercy; }
	
	public void mercyGiven() { mercy = true; }
		
	public String getName() { return name; }
	
	//modifying
	public void digestScan(ScannedRobotEvent e, double myHeading, double myX, double myY, boolean justFired) {
		if(e.getTime() - time < 1.0) return;//I know this
		BearingVector p = new BearingVector(e.getBearingRadians()+myHeading, e.getDistance(), myX, myY);
		BearingVector m = new BearingVector(e.getHeadingRadians(), e.getVelocity());
		if(seen) for(int i = 0; i < e.getTime() - time; i++) {
			Delta d = new Delta(p,m,position,movement,e.getTime() - time);
			d.fired = justFired;
			deltas.add(d);
		}
		position.setVector(p);
		movement.setVector(m);
		lastObservedEnergy = energy;
		energy = e.getEnergy();
		if(energy > 0) mercy = false;
		time = e.getTime();
		double v = Math.abs(e.getVelocity());
		if(seen) averageVelocity = 0.9*averageVelocity + 0.1*v;
		else averageVelocity = v;
		seen = true;
	}
	
	//if I get info from other than scan
	public void updateInfo(double x, double y, double h, double v, double now) {
		if(now - time < 1.0) return;//I guess I know this already
		BearingVector p = new BearingVector();
		p.setPoints(x,y,0,0);
		BearingVector m = new BearingVector(h,v);
		if(seen) for(int i = 0; i < now - time; i++) {
			deltas.add(new Delta(p,m,position,movement,now - time));
		}
		position.pointTo(x,y);
		movement.setPolar(h,v);
		time = now;
		seen = true;
	}
	
	public void addEvasion(EvasionCondition e, double currentTime) {
		evasions.add(new Evasion(e, position.getToX(), position.getToY(), currentTime-time));
	}
	
	public void died() { seen = false; time = -1; }
	
	public void reset() {
		if(seen) survival++;
		died();
	}
	
	final static int MAX_EVASIONS = 50;
	final static int MAX_DELTAS = 600;
	
	CircularArray evasions = new CircularArray(MAX_EVASIONS);//for speed
	CircularArray deltas = new CircularArray(MAX_DELTAS);
	public double[] gunEfficiency;
	public double[] gunDisabled;
	transient BearingVector position = new BearingVector();
	transient BearingVector movement = new BearingVector();
	transient double lastObservedEnergy;
	transient double energy;
	transient boolean seen;
	transient boolean mercy;
	transient double time;
	transient double averageVelocity;
	transient int survival;
	
	//members
	String name;
	
	//serialization hocus-pocus
	private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException {
		s.defaultReadObject();
		position = new BearingVector();
		movement = new BearingVector();
	}
}
