/*
 * Decompiled with CFR 0.152.
 */
package justin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import justin.BulletInfo;
import justin.BulletInfoEnemy;
import justin.Enemy;
import justin.Gun;
import justin.HistoryLog;
import justin.Movement;
import justin.Radar;
import justin.SelectEnemy;
import justin.Special;
import justin.Targeting;
import justin.utils.FastTrig;
import justin.utils.KdTree;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public abstract class Module
extends AdvancedRobot {
    public Radar radar;
    public Targeting targeting;
    public Movement movement;
    public Gun gun;
    public SelectEnemy selectEnemy;
    public Vector<Special> specials = new Vector();
    public static final boolean enablePaint = true;
    public static final boolean enableWavesOnly = true;
    public static boolean paintWaves;
    public static boolean paintTargeting;
    public static boolean paintMovement;
    public static boolean paintRadar;
    public static boolean paintAll;
    public static boolean paintNone;
    public static int skippedTurns;
    private static int wallHits;
    private static int wallDamage;
    private static int[] finishes;
    public Enemy enemy = new Enemy();
    public Enemy myData = new Enemy();
    public static Hashtable<String, Enemy> enemies;
    public Vector<BulletInfo> bullets = new Vector();
    public Vector<BulletInfoEnemy> enemyBullets = new Vector();
    public static final boolean useNonSegmented = true;
    public static final int BINS = 41;
    public static boolean melee;
    public static double bw;
    public static double bh;
    public static Rectangle2D.Double bf;

    static {
        FastTrig.init();
        paintWaves = false;
        paintTargeting = false;
        paintMovement = false;
        paintRadar = false;
        paintAll = false;
        paintNone = true;
        skippedTurns = 0;
        wallHits = 0;
        wallDamage = 0;
        enemies = new Hashtable();
        melee = true;
    }

    public void run() {
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        if (finishes == null) {
            finishes = new int[this.getOthers() + 1];
        }
        bw = this.getBattleFieldWidth();
        bh = this.getBattleFieldHeight();
        bf = new Rectangle2D.Double(17.6, 17.6, bw - 35.2, bh - 35.2);
        this.initialize();
        while (true) {
            melee = this.getOthers() > 1;
            this.updateMyData();
            BulletInfoEnemy.updateEnemyBullets(this);
            this.selectBehavior();
            this.executeBehavior();
        }
    }

    protected abstract void selectBehavior();

    protected abstract void initialize();

    private void executeBehavior() {
        this.selectEnemy.select();
        this.radar.scan();
        this.targeting.target();
        this.movement.move();
        Iterator<Special> i = this.specials.iterator();
        while (i.hasNext()) {
            i.next().doIt();
        }
        this.execute();
    }

    private void listenEvent(Event e) {
        this.selectEnemy.listen(e);
        this.radar.listen(e);
        this.targeting.listen(e);
        this.movement.listen(e);
        Iterator<Special> i = this.specials.iterator();
        while (i.hasNext()) {
            i.next().listen(e);
        }
    }

    private void listenInputEvent(InputEvent e) {
        if (this.selectEnemy != null) {
            this.selectEnemy.listenInput(e);
        }
        if (this.radar != null) {
            this.radar.listenInput(e);
        }
        if (this.targeting != null) {
            this.targeting.listenInput(e);
        }
        if (this.movement != null) {
            this.movement.listenInput(e);
        }
        for (Special special : this.specials) {
            if (special == null) continue;
            special.listenInput(e);
        }
    }

    public void activate(Special special) {
        if (!this.specials.contains(special)) {
            this.specials.add(special);
        }
    }

    public void deactivate(Special special) {
        this.specials.remove(special);
    }

    public void registerMyBullet(Bullet bullet) {
        BulletInfo bulletInfo = new BulletInfo();
        bulletInfo.bullet = bullet;
        bulletInfo.targeting = this.targeting.getClass().getSimpleName();
        bulletInfo.timeFire = (int)this.getTime();
        this.bullets.add(bulletInfo);
    }

    public void updateMyData() {
        double dir;
        this.myData.alive = true;
        this.myData.name = this.getName();
        this.myData.scanTime = this.getTime();
        this.myData.deltaScanTime = 1.0;
        this.myData.previousBearingRadians = 0.0;
        this.myData.bearingRadians = 0.0;
        this.myData.deltaHeadingRadians = Utils.normalRelativeAngle((double)(this.myData.headingRadians - this.getHeadingRadians()));
        this.myData.headingRadians = this.getHeadingRadians();
        this.myData.velocity = this.getVelocity();
        double d = dir = this.myData.velocity != 0.0 ? Math.signum(this.myData.velocity) : this.myData.direction;
        this.myData.tSDC = this.myData.direction == dir && this.myData.deltaScanTime < 20.0 && this.myData.round == (double)this.getRoundNum() ? (this.myData.tSDC += 1.0) : 0.0;
        this.myData.direction = dir;
        this.myData.round = this.getRoundNum();
        this.myData.correctedHeadingRadians = this.myData.direction < 0.0 ? Utils.normalAbsoluteAngle((double)(this.getHeadingRadians() + Math.PI)) : this.getHeadingRadians();
        this.myData.distance = 0.0;
        this.myData.location = new Point2D.Double(this.getX(), this.getY());
        this.myData.energy = this.getEnergy();
        this.myData.scanTime = this.getTime();
        this.myData.round = this.getRoundNum();
        Enemy myClosestBot = Enemy.getClosestBotTo(this.myData, this);
        this.myData.cbName = myClosestBot.name;
        this.myData.cbD = this.myData.location.distance(myClosestBot.location);
        this.myData.cbC = 0.0;
        this.myData.timeAliveTogether += 1.0;
        HistoryLog historyLog = new HistoryLog();
        historyLog.scanTime = this.getTime();
        historyLog.round = this.getRoundNum();
        historyLog.location = this.myData.location;
        historyLog.headingRadians = this.myData.correctedHeadingRadians;
        historyLog.velocity = this.getVelocity();
        if (this.myData.last != null) {
            Enemy.updateHistoryLog(historyLog, this.myData);
        } else {
            this.myData.last = historyLog;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy oldData = enemies.get(e.getName());
        if (oldData == null) {
            oldData = new Enemy();
            oldData.gunTree1vrs1 = new KdTree.SqrEuclid<HistoryLog>(9, 30000);
            oldData.gunTreeMelee = new KdTree.SqrEuclid<HistoryLog>(9, 30000);
            oldData.enemyWaveTree1vrs1 = new KdTree.SqrEuclid<HistoryLog>(8, 30000);
            oldData.enemyWaveTreeMelee = new KdTree.SqrEuclid<HistoryLog>(7, 30000);
            oldData.surfStats1vrs1 = BulletInfoEnemy.getDefaultWave();
            oldData.surfStatsMelee = BulletInfoEnemy.getDefaultWave();
        }
        Enemy scanned = Enemy.update(oldData, e, this);
        enemies.put(e.getName(), scanned);
        BulletInfoEnemy.detection(scanned, e, this);
        this.listenEvent((Event)e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Enemy him = enemies.get(e.getBullet().getName());
        him.damageGiven += Rules.getBulletDamage((double)e.getBullet().getPower());
        him.timeLastBulletHit = e.getTime();
        if (melee) {
            him.bulletHitsMelee += 1.0;
        } else {
            him.bulletHits1v1 += 1.0;
        }
        if (!this.enemyBullets.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            BulletInfoEnemy hitWave = null;
            int x = 0;
            while (x < this.enemyBullets.size()) {
                BulletInfoEnemy ew = this.enemyBullets.get(x);
                if (ew.fromName == e.getBullet().getName()) {
                    ew.surf = true;
                }
                if (Math.abs(ew.distanceTraveled - hitBulletLocation.distance(ew.fireLocation)) < 50.0 && Math.round(Rules.getBulletSpeed((double)e.getBullet().getPower()) * 10.0) == Math.round(ew.velocity * 10.0) && ew.fromName == e.getBullet().getName()) {
                    hitWave = ew;
                }
                ++x;
            }
            if (hitWave != null) {
                BulletInfoEnemy.logHit(hitWave, hitBulletLocation, 1.0, this);
                if (hitWave.melee) {
                    him.enemyWaveTreeMelee.addPoint(hitWave.DCdistanceLocation, hitWave.myInfo);
                } else {
                    him.enemyWaveTree1vrs1.addPoint(hitWave.DCdistanceLocation, hitWave.myInfo);
                }
                this.enemyBullets.remove(this.enemyBullets.lastIndexOf(hitWave));
                this.paintHitWave(hitWave);
            }
        }
        this.listenEvent((Event)e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.listenEvent((Event)e);
    }

    public void onHitWall(HitWallEvent e) {
        this.listenEvent((Event)e);
    }

    public void onBulletHit(BulletHitEvent e) {
        Enemy him = enemies.get(e.getName());
        him.damageRecieved += Rules.getBulletDamage((double)e.getBullet().getPower());
        this.listenEvent((Event)e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (!this.enemyBullets.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getHitBullet().getX(), e.getHitBullet().getY());
            BulletInfoEnemy hitWave = null;
            BulletInfoEnemy ew = null;
            int x = 0;
            while (x < this.enemyBullets.size()) {
                ew = this.enemyBullets.get(x);
                if (ew.distanceTraveled - hitBulletLocation.distance(ew.fireLocation) < 50.0 && Math.abs(e.getHitBullet().getVelocity() - ew.velocity) < 0.006 && ew.fromName == e.getHitBullet().getName()) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                BulletInfoEnemy.logHit(hitWave, hitBulletLocation, 0.5, this);
                this.enemyBullets.remove(this.enemyBullets.lastIndexOf(hitWave));
            }
        }
        this.listenEvent((Event)e);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.listenEvent((Event)e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Enemy him = enemies.get(e.getName());
        him.alive = false;
        if (him.name == this.enemy.name) {
            this.enemy = new Enemy();
        }
        this.selectEnemy.select();
        this.listenEvent((Event)e);
    }

    public void onWin(WinEvent e) {
        this.finishRound();
        this.listenEvent((Event)e);
    }

    public void onDeath(DeathEvent e) {
        this.finishRound();
        this.listenEvent((Event)e);
    }

    public void finishRound() {
        this.out.println();
        System.out.print("Finishes :");
        int n = this.getOthers();
        finishes[n] = finishes[n] + 1;
        int i = 0;
        while (i < finishes.length) {
            this.out.print(String.valueOf(finishes[i]) + " ");
            ++i;
        }
        this.out.println();
        System.out.println("Wall Damage Total :" + wallDamage);
        System.out.println("wall Hits Total :" + wallHits);
        System.out.println("Skipped Turn Total :" + skippedTurns);
        System.out.println(" -===  GunStats  ===-");
        System.out.println("  ");
        if (this.getRoundNum() == 35) {
            System.out.println(" I don't need a big gun, when I'm standing behind you.");
        }
        for (Enemy him : enemies.values()) {
            if (!him.alive) {
                him.alive = true;
            }
            him.timeLastBulletHit = 0L;
        }
        this.out.println();
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        System.out.println("Skipped Turn time:" + this.getTime() + " , skippedTurn total :" + ++skippedTurns);
        this.listenEvent((Event)e);
    }

    public void onKeyPressed(KeyEvent e) {
        char key = e.getKeyChar();
        if (key == 'w') {
            paintWaves = this.toggleButton(paintWaves);
        }
        if (key == 't') {
            paintTargeting = this.toggleButton(paintTargeting);
        }
        if (key == 'r') {
            paintRadar = this.toggleButton(paintRadar);
        }
        if (key == 'm') {
            paintMovement = this.toggleButton(paintMovement);
        }
        if (key == 'a') {
            this.allButtons(true);
        }
        if (key == 'n') {
            this.allButtons(false);
        }
        this.listenInputEvent(e);
    }

    public boolean toggleButton(boolean button) {
        return !button;
    }

    public void allButtons(boolean button) {
        if (button) {
            paintAll = true;
            paintNone = false;
        } else {
            paintAll = false;
            paintNone = true;
        }
        paintWaves = button;
        paintTargeting = button;
        paintMovement = button;
        paintRadar = button;
    }

    public void onKeyReleased(KeyEvent e) {
        this.listenInputEvent(e);
    }

    public void onMouseMoved(MouseEvent e) {
        this.listenInputEvent(e);
    }

    public void onMousePressed(MouseEvent e) {
        this.listenInputEvent(e);
    }

    public void onMouseReleased(MouseEvent e) {
        Rectangle2D.Double allButton = new Rectangle2D.Double(80.0, 0.0, 52.0, 30.0);
        Rectangle2D.Double noneButton = new Rectangle2D.Double(132.0, 0.0, 50.0, 30.0);
        Rectangle2D.Double wavesButton = new Rectangle2D.Double(190.0, 0.0, 100.0, 30.0);
        Rectangle2D.Double targetingButton = new Rectangle2D.Double(290.0, 0.0, 100.0, 30.0);
        Rectangle2D.Double movementButton = new Rectangle2D.Double(400.0, 0.0, 100.0, 30.0);
        Rectangle2D.Double radarButton = new Rectangle2D.Double(500.0, 0.0, 100.0, 30.0);
        Point2D.Double pt = new Point2D.Double(e.getPoint().x, e.getPoint().y);
        if (allButton.contains(pt)) {
            paintAll = this.toggleButton(paintAll);
            this.allButtons(paintAll);
        }
        if (noneButton.contains(pt)) {
            this.allButtons(false);
        }
        if (wavesButton.contains(pt)) {
            paintWaves = this.toggleButton(paintWaves);
        }
        if (targetingButton.contains(pt)) {
            paintTargeting = this.toggleButton(paintTargeting);
        }
        if (movementButton.contains(pt)) {
            paintMovement = this.toggleButton(paintMovement);
        }
        if (radarButton.contains(pt)) {
            paintRadar = this.toggleButton(paintRadar);
        }
        this.listenInputEvent(e);
    }

    public void onPaint(Graphics2D g) {
        if (this.getTime() < 10L) {
            return;
        }
        g.setColor(Color.white);
        g.drawString("  PAINT :    All / None", 20, 5);
        if (paintWaves) {
            BulletInfoEnemy.paintWaves(g, this);
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        g.drawString("  Waves", 200, 5);
        if (paintTargeting) {
            this.targeting.onPaint(g);
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        g.drawString("  Targeting", 300, 5);
        if (paintMovement) {
            this.movement.onPaint(g);
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        g.drawString("  Movement", 400, 5);
        if (paintRadar) {
            this.radar.onPaint(g);
            this.selectEnemy.onPaint(g);
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        g.drawString("  Radar", 500, 5);
    }

    public void paintHitWave(BulletInfoEnemy w) {
        Graphics2D g = this.getGraphics();
        g.setColor(Color.red);
        g.drawOval((int)(w.fireLocation.x - w.distanceTraveled - 1.0), (int)(w.fireLocation.y - w.distanceTraveled - 1.0), (int)(2.0 * (w.distanceTraveled + 2.0)), (int)(2.0 * (2.0 + w.distanceTraveled)));
    }
}

