/*
 * Decompiled with CFR 0.152.
 */
package josago;

import java.util.HashMap;
import josago.InfoRobot;
import josago.Utilidades;

public class GestorObjetivos {
    private static final long OBJETIVO_UMBRAL_TIEMPO = 50L;
    private static final double OBJETIVO_FACTOR_DISTANCIA = 30.0;
    private static final double OBJETIVO_FACTOR_INTERDISTANCIA = 50.0;
    private static final double OBJETIVO_FACTOR_ENERGIA = 25.0;
    private String enemigoFijado = null;
    private long tiempoFijado;

    public String seleccionarObjetivo(HashMap enemigos, int enemigos_restantes, double mi_x, double mi_y, double diagonal_mapa, long t) {
        if (enemigos.size() < enemigos_restantes) {
            this.enemigoFijado = null;
        } else if (this.enemigoFijado == null || t - this.tiempoFijado >= 50L) {
            double[] puntuaciones = new double[enemigos.size()];
            Object[] array_enemigos = enemigos.values().toArray();
            int i = 0;
            while (i < array_enemigos.length) {
                InfoRobot enemigo = (InfoRobot)array_enemigos[i];
                double distancia = Utilidades.distancia(mi_x, mi_y, enemigo.datos[0].x, enemigo.datos[0].y);
                int n = i;
                puntuaciones[n] = puntuaciones[n] - 30.0 * (distancia / diagonal_mapa);
                double interdistancia = 0.0;
                for (int j = 0; j < array_enemigos.length; ++j) {
                    if (i == j) continue;
                    InfoRobot otro_enemigo = (InfoRobot)array_enemigos[j];
                    interdistancia += Math.sqrt(Math.pow(enemigo.datos[0].x - otro_enemigo.datos[0].x, 2.0) + Math.pow(enemigo.datos[0].y - otro_enemigo.datos[0].y, 2.0));
                }
                int n2 = i;
                puntuaciones[n2] = puntuaciones[n2] - 50.0 * ((interdistancia /= (double)(array_enemigos.length - 1)) / diagonal_mapa);
                int n3 = i++;
                puntuaciones[n3] = puntuaciones[n3] - 25.0 * Utilidades.normalizarEnergia(enemigo.datos[0].energia);
            }
            int indice_puntuacion_maxima = 0;
            double puntuacion_maxima = puntuaciones[0];
            for (int i2 = 1; i2 < puntuaciones.length; ++i2) {
                if (!(puntuaciones[i2] > puntuacion_maxima)) continue;
                puntuacion_maxima = puntuaciones[i2];
                indice_puntuacion_maxima = i2;
            }
            this.enemigoFijado = ((InfoRobot)array_enemigos[indice_puntuacion_maxima]).nombre;
            this.tiempoFijado = t;
        }
        return this.enemigoFijado;
    }

    public void deseleccionarEnemigo() {
        this.enemigoFijado = null;
    }
}

