/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.segment;

import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.math.LinearEquation;
import xander.core.track.Wave;
import xander.gfws.segment.Segmenter;

public abstract class AbstractSegmenter
implements Segmenter {
    private static final Log log = Logger.getLog(AbstractSegmenter.class);
    private LinearEquation le;
    private int numSegments;
    private double minOfRange;
    private double maxOfRange;
    private double range;

    public AbstractSegmenter(int numSegments, double minOfRange, double maxOfRange) {
        this.numSegments = numSegments;
        this.minOfRange = minOfRange;
        this.maxOfRange = maxOfRange;
        this.range = maxOfRange - minOfRange;
        this.le = new LinearEquation(minOfRange, 0.0, maxOfRange, numSegments, 0.0, (double)numSegments - 0.01);
    }

    protected abstract String getDescriptionForRange(int var1, double var2, double var4);

    @Override
    public int getNumSegments() {
        return this.numSegments;
    }

    @Override
    public int getSegmentIndex(Wave wave) {
        double doubleIndex = this.le.getY(this.getSegmentValue(wave));
        return (int)Math.round(Math.floor(doubleIndex));
    }

    @Override
    public double getSegmentValuePercent(Wave wave) {
        double segmentValue = Math.max(this.minOfRange, Math.min(this.maxOfRange, this.getSegmentValue(wave)));
        double svp = (segmentValue - this.minOfRange) / this.range;
        if (svp < 0.0 || svp > 1.0) {
            log.error("Segmentation percent svp out of range 0 to 1: svp=" + Logger.format(svp, 2) + ";segmentValue=" + Logger.format(segmentValue, 2) + ";minOfRange=" + Logger.format(this.minOfRange, 2) + ";range=" + Logger.format(this.range, 2));
        }
        return svp;
    }

    @Override
    public String getSegmentDescription(int segmentIndex) {
        double rangeStart = this.le.getX(segmentIndex);
        double rangeStop = this.le.getX(segmentIndex + 1);
        return this.getDescriptionForRange(segmentIndex, rangeStart, rangeStop);
    }
}

