/*
 * Decompiled with CFR 0.152.
 */
package xander.core.drive;

import java.awt.geom.Point2D;
import xander.core.RobotProxy;
import xander.core.track.Snapshot;

public class DriveState {
    Point2D.Double position;
    double heading;
    double velocity;

    public DriveState() {
    }

    public DriveState(RobotProxy robotProxy) {
        this.position = new Point2D.Double(robotProxy.getX(), robotProxy.getY());
        this.velocity = robotProxy.getVelocity();
        this.heading = robotProxy.getHeadingDegrees();
    }

    public DriveState(Snapshot rs) {
        this.position = new Point2D.Double(rs.getX(), rs.getY());
        this.heading = rs.getHeadingRoboDegrees();
        this.velocity = rs.getVelocity();
    }

    public DriveState(DriveState ds) {
        this.position = new Point2D.Double(ds.position.x, ds.position.y);
        this.heading = ds.heading;
        this.velocity = ds.velocity;
    }

    public void setState(DriveState ds) {
        this.position = new Point2D.Double(ds.position.x, ds.position.y);
        this.heading = ds.heading;
        this.velocity = ds.velocity;
    }

    public Point2D.Double getPosition() {
        return this.position;
    }

    public double getX() {
        return this.position.x;
    }

    public double getY() {
        return this.position.y;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getVelocity() {
        return this.velocity;
    }
}

