/*
 * Decompiled with CFR 0.152.
 */
package tkt;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import tkt.util.RobotInfo;

public class RedShift
extends AdvancedRobot {
    public static final double PREFERRED_DISTANCE = 200.0;
    public static final double DISTANCE_BUFFER = 50.0;
    public static final double MAX_FIRING_DISTANCE = 400.0;
    public static int NUM_VELOCITIES = 1;
    public static Map<Integer, Double> accuracies = new HashMap<Integer, Double>();
    public static double enemyAccuracyWithDodge = 0.0;
    public static double enemyAccuracyWithoutDodge = 0.0;
    private int direction = 1;
    private RobotInfo targetInfo = null;
    private List<Double> velocities = new LinkedList<Double>();
    private int hits = 0;
    private int misses = 0;
    private boolean dodge = false;
    private Random rng = new Random();

    public void run() {
        this.setBodyColor(new Color(64, 0, 0));
        this.setGunColor(new Color(128, 0, 0));
        this.setRadarColor(new Color(172, 0, 0));
        this.setBulletColor(new Color(255, 0, 0));
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        if (this.getRoundNum() == 0) {
            NUM_VELOCITIES = 1;
            this.dodge = false;
        } else if (this.getRoundNum() == 1) {
            NUM_VELOCITIES = 50;
            this.dodge = true;
        } else {
            boolean bl = this.dodge = enemyAccuracyWithDodge < enemyAccuracyWithoutDodge;
            if (this.getRoundNum() % 2 == 0) {
                NUM_VELOCITIES = RedShift.getBestNumVelocities();
            } else {
                int num = RedShift.getBestNumVelocities() + (this.rng.nextInt(21) - 10);
                NUM_VELOCITIES = Math.max(1, num);
            }
        }
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        this.execute();
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        this.setTurnRadarLeftRadians(this.getRadarTurnRemainingRadians());
        if (this.targetInfo == null) {
            this.targetInfo = new RobotInfo((Robot)this, event);
        } else {
            this.targetInfo.updateInfo((Robot)this, event);
        }
        this.velocities.add(0, event.getVelocity());
        if (this.velocities.size() > NUM_VELOCITIES) {
            this.velocities.remove(this.velocities.size() - 1);
        }
        this.setTurn(event);
        this.setAimAndFire(event);
        this.setAhead((double)this.direction * 100.0);
    }

    private void setTurn(ScannedRobotEvent event) {
        if (this.targetInfo.justFired && this.dodge) {
            this.direction *= -1;
        }
        double turnHeading = this.targetInfo.absoluteBearing + 1.5707963267948966;
        if (event.getDistance() > 250.0) {
            turnHeading -= (double)this.direction * 0.39269908169872414;
        } else if (event.getDistance() < 150.0) {
            turnHeading += (double)this.direction * 0.39269908169872414;
        }
        double turnAmount = turnHeading - this.getHeadingRadians();
        turnAmount = Utils.normalRelativeAngle((double)turnAmount);
        this.setTurnRightRadians(turnAmount);
    }

    private void setAimAndFire(ScannedRobotEvent event) {
        double bulletPower = 3.0 - event.getDistance() / 150.0;
        double bulletVelocity = 20.0 - 3.0 * bulletPower;
        double myX = this.getX();
        double myY = this.getY();
        double enemyHeading = event.getHeadingRadians();
        double enemyVelocity = this.getAverageEnemyVelocity();
        double predictedX = this.targetInfo.x;
        double predictedY = this.targetInfo.y;
        double enemyDeltaX = Math.sin(enemyHeading) * enemyVelocity;
        double enemyDeltaY = Math.cos(enemyHeading) * enemyVelocity;
        double bulletTravelDistance = 0.0;
        while ((bulletTravelDistance += bulletVelocity) < Point2D.Double.distance(myX, myY, predictedX += enemyDeltaX, predictedY += enemyDeltaY)) {
        }
        double xDiff = predictedX - myX;
        double yDiff = predictedY - myY;
        double gunHeading = Math.atan2(xDiff, yDiff);
        double turnAmount = gunHeading - this.getGunHeadingRadians();
        turnAmount = Utils.normalRelativeAngle((double)turnAmount);
        this.setTurnGunRightRadians(turnAmount);
        if (event.getDistance() <= 400.0) {
            this.setFire(bulletPower);
        }
    }

    public double getAverageEnemyVelocity() {
        double result = 0.0;
        int weight = this.velocities.size();
        int totalWeight = 0;
        for (double v : this.velocities) {
            result += (double)weight * v;
            totalWeight += weight--;
        }
        return result /= (double)totalWeight;
    }

    public void onHitWall(HitWallEvent event) {
        this.direction *= -1;
    }

    public void onHitRobot(HitRobotEvent event) {
        this.direction *= -1;
    }

    public void onHitByBullet(HitByBulletEvent event) {
        ++this.targetInfo.shotsHit;
    }

    public void onBulletHit(BulletHitEvent event) {
        ++this.hits;
    }

    public void onBulletMissed(BulletMissedEvent event) {
        ++this.misses;
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        ++this.misses;
    }

    public void onRoundEnded(RoundEndedEvent event) {
        if (!accuracies.containsKey(NUM_VELOCITIES) || accuracies.get(NUM_VELOCITIES) > this.getAccuracy()) {
            accuracies.put(NUM_VELOCITIES, this.getAccuracy());
        }
        if (this.dodge) {
            enemyAccuracyWithDodge = Math.max(enemyAccuracyWithDodge, this.targetInfo.getAccuracy());
        } else {
            enemyAccuracyWithoutDodge = Math.max(enemyAccuracyWithDodge, this.targetInfo.getAccuracy());
        }
    }

    public double getAccuracy() {
        return (double)this.hits / (double)(this.hits + this.misses);
    }

    private static int getBestNumVelocities() {
        double result = 0.0;
        double totalWeight = Double.MIN_VALUE;
        for (Map.Entry<Integer, Double> entry : accuracies.entrySet()) {
            double weight = entry.getValue() * entry.getValue();
            result += weight * (double)entry.getKey().intValue();
            totalWeight += weight;
        }
        return Math.max(1, (int)(result /= totalWeight));
    }
}

