/*
 * Decompiled with CFR 0.152.
 */
package synnalagma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Arrays;
import synnalagma.DodgeBullet;
import synnalagma.Ennemi;
import synnalagma.Point;
import synnalagma.RobotBase;
import synnalagma.RobotMath;
import synnalagma.neural.NNet;
import synnalagma.shooting.NeuralShoot;

public class EnnemiShoot {
    Ennemi e;
    NNet nnet;
    protected static final int TRAIN_SIZE = 10;
    protected Shot[] trainingSet = new Shot[10];
    protected int trainIndex = 0;

    public EnnemiShoot(Ennemi ennemi) {
        this.e = ennemi;
        String[] stringArray = new String[]{"layer=0 tnode=32 nname=synnalagma.neural.NodeLin", "layer=1 tnode=17 nname=synnalagma.neural.NodeSigm", "layer=2 tnode=10 nname=synnalagma.neural.NodeSigm", "linktype=all fromlayer=0 tolayer=1", "linktype=all fromlayer=1 tolayer=2"};
        this.nnet = new NNet(stringArray);
    }

    public void save(DataOutputStream dataOutputStream) {
        try {
            this.nnet.save(dataOutputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void load(DataInputStream dataInputStream) {
        try {
            this.nnet = new NNet(dataInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void uptdate(DodgeBullet dodgeBullet) {
        Shot shot = (Shot)dodgeBullet.autre;
        Point point = new Point(shot.x, shot.y, 0.0);
        double d = point.bearingTo(RobotBase.monRobot.getX(), RobotBase.monRobot.getY());
        double d2 = d - shot.angleMinMax[0];
        if (Math.abs(d2) > Math.PI) {
            d2 = d > shot.angleMinMax[0] ? -(Math.PI * 2 - d + shot.angleMinMax[0]) : Math.PI * 2 - shot.angleMinMax[0] + d;
        }
        int n = (int)(d2 * 10.0 / shot.angleMinMax[2]);
        float[] fArray = new float[10];
        Arrays.fill(fArray, 0.0f);
        if (n < 10 && n >= 0) {
            fArray[n] = 1.0f;
            if (n < 9) {
                fArray[n + 1] = 1.0f;
            }
            shot.out = fArray;
            this.trainingSet[this.trainIndex] = shot;
            ++this.trainIndex;
            if (this.trainIndex == 10) {
                this.trainIndex = 0;
                int n2 = 0;
                while (n2 < 10) {
                    int n3 = 0;
                    while (n3 < 10) {
                        this.nnet.ebplearnNNet(this.trainingSet[n3].input, this.trainingSet[n3].out);
                        ++n3;
                    }
                    ++n2;
                }
                Arrays.fill(this.trainingSet, null);
            }
        }
    }

    public DodgeBullet fire(double d) {
        Shot shot = new Shot(d);
        float[] fArray = new float[10];
        this.nnet.frwNNet(shot.input, fArray);
        double d2 = NeuralShoot.mean(fArray);
        if (d2 == -1.0) {
            d2 = NeuralShoot.max(fArray);
        }
        return new DodgeBullet(this.e.x, this.e.y, RobotMath.NormaliseHeading(shot.angleMinMax[0] + d2 * (shot.angleMinMax[2] / 10.0)), this.e.getName(), d, 1, shot);
    }

    public class Shot {
        float[] input = new float[32];
        double[] angleMinMax = new double[3];
        float[] out;
        double x;
        double y;
        long time;

        public Shot(double d) {
            this.x = EnnemiShoot.this.e.x;
            this.y = EnnemiShoot.this.e.y;
            this.time = RobotBase.monRobot.getTime();
            Point point = new Point(RobotBase.monRobot.getX(), RobotBase.monRobot.getY(), 0.0);
            Point point2 = new Point(RobotBase.monRobot.getX(), RobotBase.monRobot.getY(), 0.0);
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 20.0 - 3.0 * d;
            int n = 0;
            while (n < 3) {
                double d5 = EnnemiShoot.this.e.distance(point2) / d4;
                double d6 = EnnemiShoot.this.e.distance(point) / d4;
                point2 = RobotBase.monRobot.getMinPoint(d5, EnnemiShoot.this.e);
                point = RobotBase.monRobot.getMaxPoint(d6, EnnemiShoot.this.e);
                ++n;
            }
            d3 = RobotMath.NormaliseHeading(EnnemiShoot.this.e.bearingTo(point2));
            d2 = RobotMath.NormaliseHeading(EnnemiShoot.this.e.bearingTo(point));
            this.angleMinMax = new double[3];
            this.angleMinMax[0] = d3;
            this.angleMinMax[1] = d2;
            double d7 = d2 - d3;
            if (Math.abs(d7) > Math.PI) {
                d7 = d2 > d3 ? -(Math.PI * 2 - d2 + d3) : Math.PI * 2 - d3 + d2;
            }
            this.angleMinMax[2] = d7;
            Arrays.fill(this.input, 0.0f);
            this.input[Math.round((float)(((float)RobotBase.monRobot.velocity + 8.0f) / 2.0f))] = 1.0f;
            this.input[9] = RobotBase.monRobot.velocity > 0.0 ? 0.0f : 0.0f;
            this.input[10 + RobotMath.quadrant((double)RobotBase.monRobot.getHeadingRadians())] = 1.0f;
            double d8 = RobotBase.monRobot.distanceTo(EnnemiShoot.this.e);
            int n2 = d8 < 100.0 ? 0 : (d8 < 175.0 ? 1 : (d8 < 250.0 ? 2 : (d8 < 350.0 ? 3 : (d8 < 500.0 ? 4 : 5))));
            this.input[14 + n2] = 1.0f;
            double d9 = RobotBase.monRobot.getX();
            int n3 = 0;
            if (RobotBase.monRobot.getY() < d9) {
                d9 = RobotBase.monRobot.getY();
                n3 = 1;
            }
            if (RobotBase.monRobot.myGetBattleFieldWidth() - RobotBase.monRobot.getX() < d9) {
                d9 = RobotBase.monRobot.myGetBattleFieldWidth() - RobotBase.monRobot.getX();
                n3 = 2;
            }
            if (RobotBase.monRobot.myGetBattleFieldHeight() - RobotBase.monRobot.getY() < d9) {
                d9 = RobotBase.monRobot.myGetBattleFieldHeight() - RobotBase.monRobot.getY();
                n3 = 3;
            }
            int n4 = -1;
            if (d9 < 50.0) {
                n4 = 0;
            } else if (d9 < 100.0) {
                n4 = 1;
            } else if (d9 < 175.0) {
                n4 = 2;
            } else if (d9 < 250.0) {
                n4 = 3;
            }
            if (n4 != -1) {
                this.input[20 + n4] = 1.0f;
                this.input[24 + n3] = 1.0f;
            }
            this.input[28 + RobotMath.quadrant((double)EnnemiShoot.this.e.bearingTo((double)RobotBase.monRobot.getX(), (double)RobotBase.monRobot.getY()))] = 1.0f;
        }
    }
}

