/*
 * Decompiled with CFR 0.152.
 */
package grav;

import grav.IGravitySource;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import math.Vect2d;
import sim.Bot;
import sim.Data;

public class GravPoint
implements IGravitySource {
    public double Strength;
    public double DropoffFactor;
    public Point2D.Double Location;

    public GravPoint(double strength, double dropoffFactor, Point2D.Double location) {
        this.Location = location;
        this.Strength = strength;
        this.DropoffFactor = dropoffFactor;
    }

    @Override
    public Vect2d GetEffectiveGravity(long time) {
        return GravPoint.GetPointForce(this, time, this.Location);
    }

    public static Vect2d GetPointForce(GravPoint grav, long time, Point2D.Double forcePoint) {
        Bot robot = Data.Robots.Self;
        Vect2d gravity = Vect2d.fromPosition(robot.Position, forcePoint);
        double distance = gravity.length();
        double forceTotal = GravPoint.ForceAtDistance(grav, distance);
        gravity.setMagnitude(forceTotal);
        return gravity;
    }

    public static double ForceAtDistance(GravPoint grav, double distance) {
        return -grav.Strength / Math.pow(distance, grav.DropoffFactor);
    }

    @Override
    public void Draw(Graphics2D e) {
        e.setColor(Color.PINK);
        e.drawOval((int)(this.Location.getX() - 2.0), (int)(this.Location.getY() - 2.0), 4, 4);
    }
}

