/*
 * Decompiled with CFR 0.152.
 */
package gun;

import gun.IGun;
import java.awt.Color;
import java.awt.geom.Point2D;
import math.Fath;
import robocode.Rules;
import robocode.util.Utils;
import sim.Bot;
import sim.Stat;

public class HeadOnGun
implements IGun {
    @Override
    public double GetDeltaBearing(Bot self, Point2D.Double nextPosition, long time, Bot enemy, double bulletPower) {
        Point2D.Double enemyPos = enemy.Position;
        double theta = Utils.normalAbsoluteAngle((double)Fath.atan2(enemyPos.getX() - nextPosition.getX(), enemyPos.getY() - nextPosition.getY()));
        double enemyAbsoluteBearing = enemy.Get(Stat.ABSOLUTEBEARING);
        double baseFiringAngle = Utils.normalRelativeAngle((double)(theta - enemyAbsoluteBearing));
        double crossSection = Math.min(enemy.Get(Stat.RADAR_CROSSSECTION), Rules.GUN_TURN_RATE_RADIANS);
        double rand = Math.random();
        int sign = rand < 0.5 ? -1 : 1;
        double wobble = rand * crossSection * (double)sign * 0.5 * 0.9;
        return baseFiringAngle + wobble;
    }

    @Override
    public Color GetBulletColor() {
        return Color.WHITE;
    }
}

