/*
 * Decompiled with CFR 0.152.
 */
package util;

public class CircularArray {
    private final int _length;
    private final double[] _buffer;
    private int _maxIndex;

    public CircularArray(int capacity) {
        this._length = capacity + 1;
        this._buffer = new double[this._length];
        this._maxIndex = 0;
    }

    public double Latest() {
        return this._buffer[this._maxIndex];
    }

    public double Previous() {
        int index = (this._maxIndex - 1) % this._length;
        return this._buffer[index];
    }

    public double[] All() {
        return this._buffer;
    }

    public void Add(double item) {
        int index = (this._maxIndex + 1) % this._length;
        this._buffer[index] = item;
        this._maxIndex = index;
    }
}

