/*
 * Decompiled with CFR 0.152.
 */
package labg.shooting;

import java.awt.geom.Point2D;
import labg.util.Enemy;
import labg.util.EvolutionManager;
import labg.util.Geometry;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class ShootingStrategy {
    AdvancedRobot myBot;
    Enemy target;
    EvolutionManager evoMan;
    private static final String closePower = "closePower";
    private static final String farPower = "farPower";
    private static final String damPower = "damPower";

    public ShootingStrategy(AdvancedRobot myBot, Enemy target, EvolutionManager evoMan) {
        this.myBot = myBot;
        this.target = target;
        this.evoMan = evoMan;
        evoMan.addVariable(closePower, 600.0, 50.0, 1000.0);
        evoMan.addVariable(farPower, 300.0, 50.0, 1000.0);
        evoMan.addVariable(damPower, 200.0, 50.0, 1000.0);
    }

    public void shoot() {
        double shotPower = 0.0;
        if (this.myBot.getEnergy() > 30.0) {
            if (this.target.distance > 300.0) {
                shotPower = this.evoMan.getVariable(farPower) / this.target.distance;
            } else if (this.target.distance <= 300.0) {
                shotPower = this.evoMan.getVariable(closePower) / this.target.distance;
            }
        } else {
            shotPower = this.evoMan.getVariable(damPower) / this.target.distance;
        }
        long currTime = this.myBot.getTime() + (long)((int)Math.round(Geometry.getRange(this.myBot.getX(), this.myBot.getY(), this.target.xPos, this.target.yPos) / (20.0 - 3.0 * shotPower)));
        Point2D.Double currPoint = this.target.heading - this.target.prevHeading < 1.0E-4 ? this.target.guessPosition(currTime) : this.target.guessCircularPosition(currTime);
        int i = 0;
        while (i < 10) {
            long prevTime = currTime;
            Point2D.Double prevPoint = currPoint;
            currTime = this.myBot.getTime() + (long)((int)Math.round(Geometry.getRange(this.myBot.getX(), this.myBot.getY(), prevPoint.x, prevPoint.y) / (20.0 - 3.0 * shotPower)));
            currPoint = this.target.heading - this.target.prevHeading < 1.0E-4 ? this.target.guessPosition(currTime) : this.target.guessCircularPosition(currTime);
            ++i;
        }
        if (currPoint.x < 0.0) {
            currPoint.x = 0.0;
        } else if (currPoint.x > this.myBot.getBattleFieldWidth()) {
            currPoint.x = this.myBot.getBattleFieldWidth();
        }
        if (currPoint.y < 0.0) {
            currPoint.y = 0.0;
        } else if (currPoint.y > this.myBot.getBattleFieldHeight()) {
            currPoint.y = this.myBot.getBattleFieldHeight();
        }
        double gunOffset = this.myBot.getGunHeadingRadians() - (1.5707963267948966 - Math.atan2(currPoint.y - this.myBot.getY(), currPoint.x - this.myBot.getX()));
        this.myBot.setTurnGunLeftRadians(Geometry.normaliseBearing(gunOffset));
        if (this.myBot.getEnergy() > shotPower) {
            this.myBot.setFire(shotPower);
        } else {
            this.myBot.setFire(this.myBot.getEnergy());
        }
    }

    public void setEnemy(Enemy foe) {
        this.target = foe;
    }

    public Enemy getEnemy() {
        return this.target;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onDeath(DeathEvent e) {
    }

    public void onHitRobot(HitRobotEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onRobotDeath(RobotDeathEvent e) {
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
    }

    public void onWin(WinEvent e) {
    }
}

