/*
 * Decompiled with CFR 0.152.
 */
package labg.tactics;

import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import labg.Cataclysm;
import labg.movement.DodgerMovementStrategy;
import labg.movement.MovementStrategy;
import labg.movement.OooMovementStrategy;
import labg.movement.QuietCornerMovementStrategy2;
import labg.shooting.FactoredShootingStrategy;
import labg.shooting.ShootingStrategy;
import labg.targeting.OptimalTargetingStrategy;
import labg.targeting.TargetingStrategy;
import labg.targeting.TrackTargetingStrategy;
import labg.util.Enemy;
import labg.util.EvolutionManager;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class TacticalEngine {
    Cataclysm myBot;
    EvolutionManager evoMan;
    MovementStrategy moveStrat;
    MovementStrategy currMoveStrat;
    OooMovementStrategy oooMoveStrat;
    DodgerMovementStrategy dodgeMoveStrat;
    QuietCornerMovementStrategy2 quietMoveStrat;
    TargetingStrategy optimTargStrat;
    TargetingStrategy trackTargStrat;
    TargetingStrategy currTargStrat;
    ShootingStrategy shootStrat;
    FactoredShootingStrategy facShootStrat;
    ShootingStrategy currShootStrat;
    HashMap enemies;
    Enemy currTarget;
    Enemy avoidTarget;
    boolean selector = false;
    double score = 0.0;
    Enemy temp = new Enemy("temp");

    public TacticalEngine(Cataclysm myBot, EvolutionManager evoMan, HashMap enemies) {
        this.myBot = myBot;
        this.evoMan = evoMan;
        this.enemies = enemies;
        this.moveStrat = new MovementStrategy(myBot);
        this.oooMoveStrat = new OooMovementStrategy(myBot, enemies, evoMan);
        this.dodgeMoveStrat = new DodgerMovementStrategy(myBot, new Enemy("temp"), evoMan);
        this.quietMoveStrat = new QuietCornerMovementStrategy2(myBot, enemies, evoMan);
        this.optimTargStrat = new OptimalTargetingStrategy(myBot, enemies, new Enemy("temp"));
        this.trackTargStrat = new TrackTargetingStrategy(myBot, new Enemy("temp"));
        this.shootStrat = new ShootingStrategy(myBot, new Enemy("temp"), evoMan);
        this.temp.takenShot = true;
        this.facShootStrat = new FactoredShootingStrategy(myBot, this.temp, evoMan, enemies);
        this.currMoveStrat = this.quietMoveStrat;
        this.optimTargStrat.setShootingStrategy(this.facShootStrat);
        this.currTarget = this.temp;
        this.avoidTarget = new Enemy("temp");
        evoMan.doEvolution();
        evoMan.printRoundsPerEvo();
        this.resetEnemies();
    }

    public void compute() {
        this.temp.takenShot = true;
        this.selectTarget();
        this.facShootStrat.moveFriendlyBullets();
        this.avoidTarget();
        this.currShootStrat = this.facShootStrat;
        if (this.myBot.getOthers() > 1) {
            this.currTargStrat = this.optimTargStrat;
            this.currMoveStrat = this.quietMoveStrat;
        } else {
            this.currMoveStrat = this.dodgeMoveStrat;
            this.currTargStrat = this.trackTargStrat;
        }
        this.currTargStrat.setEnemy(this.currTarget);
        this.currShootStrat.setEnemy(this.currTarget);
        this.dodgeMoveStrat.setEnemy(this.currTarget);
        this.optimTargStrat.setEnemy(this.currTarget);
    }

    private void selectTarget() {
        double origTarget = this.currTarget.getTargetPotential();
        String origName = this.currTarget.name;
        if (this.currTarget.isAlive) {
            if (this.currTarget.takenShot) {
                this.currTarget.takenShot = false;
                double max = -1000.0;
                Collection enemyColl = this.enemies.values();
                Iterator it = enemyColl.iterator();
                while (it.hasNext()) {
                    double pot;
                    Enemy enTemp = (Enemy)it.next();
                    if (!enTemp.isAlive || this.myBot.getTime() - enTemp.timeLastSeen >= 40L || !((pot = enTemp.getTargetPotential()) >= max)) continue;
                    max = pot;
                    this.currTarget = enTemp;
                }
            }
            if (this.currTarget.getTargetPotential() / 1.2 < origTarget && !origName.equalsIgnoreCase("temp")) {
                this.currTarget = (Enemy)this.enemies.get(origName);
            }
        } else {
            double max = -1000.0;
            Collection enemyColl = this.enemies.values();
            Iterator it = enemyColl.iterator();
            while (it.hasNext()) {
                double pot;
                Enemy enTemp = (Enemy)it.next();
                if (!enTemp.isAlive || this.myBot.getTime() - enTemp.timeLastSeen >= 40L || !((pot = enTemp.getTargetPotential()) >= max)) continue;
                max = pot;
                this.currTarget = enTemp;
            }
        }
    }

    private void avoidTarget() {
        Collection enemyColl = this.enemies.values();
        Iterator it = enemyColl.iterator();
        while (it.hasNext()) {
            Enemy enTemp = (Enemy)it.next();
            if (!enTemp.isAlive || !(enTemp.damToMe > this.avoidTarget.damToMe) && this.avoidTarget.isAlive) continue;
            this.avoidTarget = enTemp;
        }
    }

    private void resetEnemies() {
        Collection enemyColl = this.enemies.values();
        Iterator it = enemyColl.iterator();
        while (it.hasNext()) {
            Enemy enTemp = (Enemy)it.next();
            enTemp.reset();
        }
    }

    public MovementStrategy getMovementStrategy() {
        return this.currMoveStrat;
    }

    public TargetingStrategy getTargetingStrategy() {
        return this.currTargStrat;
    }

    public ShootingStrategy getShootingStrategy() {
        return this.currShootStrat;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.currTargStrat.onScannedRobot(e);
        if (this.enemies.get(e.getName()) == null) {
            double absbearing_rad = (this.myBot.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
            Enemy temp = new Enemy(e.getName());
            temp.prevTimeLastSeen = temp.timeLastSeen;
            temp.timeLastSeen = e.getTime();
            temp.prevBearing = temp.currBearing;
            temp.currBearing = e.getBearingRadians();
            temp.prevBearingRel2Gun = temp.prevBearing + (this.myBot.getHeadingRadians() - this.myBot.getGunHeadingRadians());
            temp.currBearingRel2Gun = temp.currBearing + (this.myBot.getHeadingRadians() - this.myBot.getGunHeadingRadians());
            temp.distance = e.getDistance();
            temp.prevEnergy = temp.currEnergy;
            temp.currEnergy = e.getEnergy();
            temp.velocity = e.getVelocity();
            temp.prevHeading = temp.heading;
            temp.heading = e.getHeadingRadians();
            temp.xPos = this.myBot.getX() + Math.sin(absbearing_rad) * e.getDistance();
            temp.yPos = this.myBot.getY() + Math.cos(absbearing_rad) * e.getDistance();
            temp.prevXPos = temp.xPos;
            temp.prevYPos = temp.yPos;
            temp.xPosAdjust = this.myBot.getX() + Math.sin(absbearing_rad) * (e.getDistance() - 36.0);
            temp.yPosAdjust = this.myBot.getY() + Math.cos(absbearing_rad) * (e.getDistance() - 36.0);
            this.enemies.put(e.getName(), temp);
            System.out.println("Added new enemy: " + ((Enemy)this.enemies.get((Object)e.getName())).name);
        } else {
            double absbearing_rad = (this.myBot.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
            Enemy temp = (Enemy)this.enemies.get(e.getName());
            temp.prevTimeLastSeen = temp.timeLastSeen;
            temp.timeLastSeen = e.getTime();
            temp.prevBearing = temp.currBearing;
            temp.currBearing = e.getBearingRadians();
            temp.prevBearingRel2Gun = temp.prevBearing + (this.myBot.getHeadingRadians() - this.myBot.getGunHeadingRadians());
            temp.currBearingRel2Gun = temp.currBearing + (this.myBot.getHeadingRadians() - this.myBot.getGunHeadingRadians());
            temp.distance = e.getDistance();
            temp.prevEnergy = temp.currEnergy;
            temp.currEnergy = e.getEnergy();
            temp.prevVelocity = temp.velocity;
            temp.velocity = e.getVelocity();
            temp.prevHeading = temp.heading;
            temp.heading = e.getHeadingRadians();
            temp.prevXPos = temp.xPos;
            temp.prevYPos = temp.yPos;
            temp.xPos = this.myBot.getX() + Math.sin(absbearing_rad) * e.getDistance();
            temp.yPos = this.myBot.getY() + Math.cos(absbearing_rad) * e.getDistance();
            temp.xPosAdjust = this.myBot.getX() + Math.sin(absbearing_rad) * (e.getDistance() - 36.0);
            temp.yPosAdjust = this.myBot.getY() + Math.cos(absbearing_rad) * (e.getDistance() - 36.0);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (e.getPower() > 1.0) {
            double dam = 4.0 * e.getPower();
            ((Enemy)this.enemies.get((Object)e.getName())).damToMe = dam += 2.0 * (e.getPower() - 1.0);
        } else {
            ((Enemy)this.enemies.get((Object)e.getName())).damToMe = e.getPower() * 4.0;
        }
        ((Enemy)this.enemies.get((Object)e.getName())).timeLastHitMe = this.myBot.getTime();
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
        ((Enemy)this.enemies.get((Object)e.getName())).hits += 1.0;
        if (e.getBullet().getPower() <= 1.0) {
            this.score += 4.0 * e.getBullet().getPower();
        } else {
            double tempDam = 4.0 * e.getBullet().getPower();
            this.score += tempDam + 2.0 * (e.getBullet().getPower() - 1.0);
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onDeath(DeathEvent e) {
        System.out.println("Score = " + this.score);
        this.evoMan.addRoundResult(this.score);
        if (this.myBot.getRoundNum() % 50 == 0 || this.myBot.getRoundNum() == this.myBot.getNumRounds()) {
            try {
                System.out.println("About to write obj");
                ObjectOutputStream oos = new ObjectOutputStream((OutputStream)new RobocodeFileOutputStream(this.myBot.getDataFile("evoObject.dat")));
                oos.writeObject(this.evoMan);
                oos.close();
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
        Collection enemyColl = this.enemies.values();
        Iterator it = enemyColl.iterator();
        double hits = 0.0;
        double shots = 0.0;
        while (it.hasNext()) {
            Enemy enTemp = (Enemy)it.next();
            System.out.println(String.valueOf(enTemp.name) + " ACC= " + enTemp.accuracy + "%");
            hits += enTemp.hits;
            shots += enTemp.shots;
        }
        System.out.println("Overall ACC= " + hits / shots * 100.0 + "%");
    }

    public void onHitRobot(HitRobotEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onRobotDeath(RobotDeathEvent e) {
        try {
            ((Enemy)this.enemies.get((Object)e.getName())).isAlive = false;
            this.score += 50.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
    }

    public void onWin(WinEvent e) {
        this.score += (double)(10 * this.enemies.size());
        System.out.println("Score = " + this.score);
        this.evoMan.addRoundResult(this.score);
        if (this.myBot.getRoundNum() % 50 == 0 || this.myBot.getRoundNum() == this.myBot.getNumRounds()) {
            try {
                System.out.println("About to write obj");
                ObjectOutputStream oos = new ObjectOutputStream((OutputStream)new RobocodeFileOutputStream(this.myBot.getDataFile("evoObject.dat")));
                oos.writeObject(this.evoMan);
                oos.close();
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
        Collection enemyColl = this.enemies.values();
        Iterator it = enemyColl.iterator();
        double hits = 0.0;
        double shots = 0.0;
        while (it.hasNext()) {
            Enemy enTemp = (Enemy)it.next();
            System.out.println(String.valueOf(enTemp.name) + " ACC= " + enTemp.accuracy + "%");
            hits += enTemp.hits;
            shots += enTemp.shots;
        }
        System.out.println("Overall ACC= " + hits / shots * 100.0 + "%");
    }
}

