/*
 * Decompiled with CFR 0.152.
 */
package labg.util;

public class FriendlyBullet {
    public String targetName;
    int guessIndex;
    int distanceIndex;
    double originX;
    double originY;
    double absBearing;
    long time;
    double power;

    public FriendlyBullet(String targetName, int guessIndex, int distanceIndex, double originX, double originY, double absBearing, long time, double power) {
        this.targetName = targetName;
        this.guessIndex = guessIndex;
        this.distanceIndex = distanceIndex;
        this.originX = originX;
        this.originY = originY;
        this.absBearing = absBearing;
        this.time = time;
        this.power = power;
    }

    public String toString() {
        return "targetName= " + this.targetName + "   guessIndex= " + this.guessIndex + "   distanceIndex= " + this.distanceIndex + "   originX = " + this.originX + "   originY = " + this.originY + "   absBearing = " + this.absBearing + "   time = " + this.time + "   power = " + this.power;
    }

    public double distance(double now) {
        return (now - (double)this.time) * (20.0 - 3.0 * this.power);
    }

    public double getX(double now) {
        return this.originX + Math.sin(this.absBearing) * this.distance(now);
    }

    public double getY(double now) {
        return this.originY + Math.cos(this.absBearing) * this.distance(now);
    }

    public boolean targetWasHit(double targetX, double targetY, long now) {
        if (this.range(targetX, targetY, now) > 50.0) {
            return false;
        }
        double fraction = 0.0;
        while (fraction < 1.05) {
            if (this.range(targetX, targetY, (double)now - fraction) < 30.0) {
                return true;
            }
            fraction += 0.1;
        }
        return false;
    }

    public boolean outOfRange(double targetX, double targetY, long now) {
        double targetFromOrigin = Math.sqrt((targetX - this.originX) * (targetX - this.originX) + (targetY - this.originY) * (targetY - this.originY));
        return this.range(this.originX, this.originY, now) > targetFromOrigin + 30.0;
    }

    public double range(double targetX, double targetY, double now) {
        double xo = targetX - this.getX(now);
        double yo = targetY - this.getY(now);
        return Math.sqrt(xo * xo + yo * yo);
    }
}

