/*
 * Decompiled with CFR 0.152.
 */
package justin;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

class RandomMovement {
    private static final double BATTLE_FIELD_WIDTH = 1000.0;
    private static final double BATTLE_FIELD_HEIGHT = 1000.0;
    private static final double WALL_MARGIN = 18.0;
    private static final double MAX_TRIES = 125.0;
    private static final double REVERSE_TUNER = 0.421075;
    private static final double DEFAULT_EVASION = 1.2;
    private static final double WALL_BOUNCE_TUNER = 0.699484;
    private AdvancedRobot robot;
    private Rectangle2D fieldRectangle = new Rectangle2D.Double(18.0, 18.0, 964.0, 964.0);
    private double enemyFirePower = 3.0;
    private double direction = 0.4;

    RandomMovement(AdvancedRobot _robot) {
        this.robot = _robot;
    }

    public void onScanRobot(ScannedRobotEvent e) {
        Point2D robotDestination;
        this.robot.setMaxVelocity(8.0);
        double enemyAbsoluteBearing = this.robot.getHeadingRadians() + e.getBearingRadians();
        double enemyDistance = e.getDistance();
        Point2D.Double robotLocation = new Point2D.Double(this.robot.getX(), this.robot.getY());
        Point2D enemyLocation = RandomMovement.project(robotLocation, enemyAbsoluteBearing, enemyDistance);
        double tries = 0.0;
        while (!this.fieldRectangle.contains(robotDestination = RandomMovement.project(enemyLocation, enemyAbsoluteBearing + Math.PI + this.direction, enemyDistance * (1.2 - tries / 100.0))) && tries < 125.0) {
            tries += 1.0;
        }
        if (Math.random() < RandomMovement.bulletVelocity(this.enemyFirePower) / 0.421075 / enemyDistance || tries > enemyDistance / RandomMovement.bulletVelocity(this.enemyFirePower) / 0.699484) {
            this.direction = -this.direction;
        }
        double angle = RandomMovement.absoluteBearing(robotLocation, robotDestination) - this.robot.getHeadingRadians();
        this.robot.setAhead(Math.cos(angle) * 100.0);
        this.robot.setTurnRightRadians(Math.tan(angle));
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static Point2D project(Point2D sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }
}

