/*
 * Decompiled with CFR 0.152.
 */
package catcat20.move;

import catcat20.bot.Bot;
import catcat20.bot.BotState;
import catcat20.gun.LambdaGun;
import catcat20.move.KNNResultWithWave;
import catcat20.move.NonWaveMove;
import catcat20.move.SurfPathPos;
import catcat20.move.SurfWave;
import catcat20.move.formula.SurfKNNModel;
import catcat20.radar.Radar;
import catcat20.utils.LConstants;
import catcat20.utils.LUtils;
import catcat20.utils.MovementPredictor;
import catcat20.utils.PreciseWallSmooth;
import catcat20.utils.ShadowBullet;
import catcat20.utils.knn.GFData;
import catcat20.utils.knn.KNNData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.SkippedTurnEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public class Surfing {
    public static boolean RABBIT_MODE = false;
    public static boolean FLATTENER_ONLY_MODE = false;
    public static final double FLATTENER_WEIGHT = 0.5;
    public NonWaveMove nonWaveMove;
    public static int DIRECTIONS = 6;
    private static double DESIRED_DISTANCE = 650.0;
    private static double MAX_ATTACK_ANGLE = 1.413716694115407;
    public static int WALL_STICK = 150;
    public static int MELEE_STICK = 110;
    public boolean PATH_DRAW_MODE = false;
    public boolean drawListener = false;
    public boolean MELEE_SURF_MODE = false;
    public boolean MELEE_BOTDANGER_MODE = false;
    public static int MAX_SURF;
    public double duelHitLost = 0.0;
    public double meleeHitLost = 0.0;
    public TeamRobot _robot;
    public static Point2D.Double nextMyPos;
    public static ArrayList<SurfWave> _waves;
    Point2D.Double _myPos = new Point2D.Double();
    long _time;
    int _others;
    double _energy;
    public final int BACK_STATE_LOG = 2;
    public boolean isProcessing = false;
    public int riskCalled;
    public int loops;
    public int nodes;
    public int dangerCalled;
    public long dangerTime;
    public int cutNodes;
    public double sumWaveRisk = 1.0;
    public double waveRiskCount = 1.0;
    public double waveRiskAve = 1.0;
    public double sumBotRisk = 1.0;
    public double botRiskCount = 1.0;
    public double botRiskAve = 1.0;
    public boolean fallback_move = true;
    Color whiteRed = new Color(255, 190, 190);
    Color whiteBlue = new Color(190, 190, 255);
    PreciseWallSmooth.Trig trig = new PreciseWallSmooth.Trig();
    public Point2D.Double duelEnPos;
    boolean isContainingMyWave = false;
    public double lastDestX = Double.NaN;
    public double lastDestY = Double.NaN;
    public static final int BOT_HALFSIZE = 18;
    public static final int ORBIT_FORWARD = 1;
    public static final int ORBIT_REVERSE = 2;
    public static final int ORBIT_BACK = 4;
    public static final int ORBIT_SURFDISTANCER = 8;
    public static final int ORBIT_ANTIRAMDISTANCER = 16;
    public static final int HEADING = -1;
    Point2D.Double cache = new Point2D.Double();
    ArrayList<SurfWave> removedWaveCache = new ArrayList(3);
    DistanceController distancer = new DistanceController();
    Graphics2D g = null;
    BasicStroke bs = new BasicStroke(1.5f);

    public Surfing(TeamRobot _robot) {
        this._robot = _robot;
        this.nonWaveMove = new NonWaveMove(_robot);
    }

    public void init() {
        _waves = new ArrayList();
        this.duelHitLost = 0.0;
        this.meleeHitLost = 0.0;
    }

    public void onTick() {
        this.PATH_DRAW_MODE = this.drawListener;
        this.duelEnPos = new Point2D.Double(LConstants.fieldCenter.x, LConstants.fieldCenter.y);
        nextMyPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        this._myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        this._time = this._robot.getTime();
        this._others = this._robot.getOthers();
        this._energy = this._robot.getEnergy();
        this.isProcessing = true;
        this.loops = 0;
        this.nodes = 0;
        this.riskCalled = 0;
        this.cutNodes = 0;
        this.dangerCalled = 0;
        this.dangerTime = 0L;
        this.waveRiskAve = (this.sumWaveRisk + 1.0E-5) / (this.waveRiskCount + 1.0E-5);
        this.botRiskAve = (this.sumBotRisk + 1.0E-5) / (this.botRiskCount + 1.0E-5);
        this.sumWaveRisk = 0.0;
        this.sumBotRisk = 0.0;
        this.waveRiskCount = 0.0;
        this.botRiskCount = 0.0;
        if (_waves.isEmpty()) {
            this.fallback_move = true;
        }
        if (this._others <= 1) {
            this.fallback_move = false;
        }
        for (Bot bot : Radar.enemies.values()) {
            ArrayList<KNNData<Double>> power;
            double energyDrop;
            double dist;
            boolean isRam;
            if (this._robot.isTeammate(bot.name) || !bot.isAlive || bot.states.size() <= 2 || bot.shotDataMaps.size() <= 2 || !bot.shotDataMaps.get(2).containsKey(bot.nearestBotName)) continue;
            if (this._others <= 1) {
                this.duelEnPos.setLocation(bot.currentState.x, bot.currentState.y);
            }
            boolean bl = isRam = (dist = this._myPos.distance(bot.currentState.x, bot.currentState.y)) <= 250.0;
            if (this._others > 1) {
                isRam = false;
            }
            if (this._others <= 1 && this._time <= 30L) {
                isRam = false;
            }
            boolean canFire = false;
            if (this._others <= 1 && bot.gunHeat <= LConstants.GUN_COOLING_RATE * 2.0) {
                canFire = true;
            }
            if (this._others > 1) {
                canFire = true;
            }
            if ((energyDrop = bot.states.get((int)1).energy - bot.currentState.energy) > 0.01 && energyDrop < 3.01 && canFire) {
                this.fallback_move = false;
                if (this._others <= 1) {
                    ++bot.youShotsFiredDuel;
                    bot.gunHeat = LUtils.limit(0.0, Rules.getGunHeat((double)energyDrop) - LConstants.GUN_COOLING_RATE * 2.0, 3.0);
                } else {
                    bot.gunHeat = LUtils.limit(0.0, Rules.getGunHeat((double)energyDrop) - LConstants.GUN_COOLING_RATE * (double)(this._time - bot.gunHeatTime + 1L), 3.0);
                }
                bot.bulletPowerPredictor.addPoint(bot.bulletPowerDataPoint(bot.currentState.energy, bot.nearestBotEnergy, bot.nearestBotDist, this._others), energyDrop);
                long fireTime = (long)((double)(this._time + bot.lastScanTime) / 2.0 - 2.0);
                int ago = (int)(this._time - fireTime);
                BotState botState = bot.states.get(ago);
                BotState fireBotState = bot.states.get(ago - 1);
                SurfWave w = new SurfWave(fireBotState.x, fireBotState.y, bot.name, energyDrop, fireTime);
                w.myPos = (Point2D.Double)this._myPos.clone();
                w.isMyWave = bot.nearestBotName.equals(Radar.myName);
                if (this._others > 1) {
                    w.doBranchWave = false;
                    if (w.isMyWave) {
                        w.doBranchWave = true;
                    }
                } else {
                    w.doBranchWave = true;
                }
                w.isMeleeWave = this._others > 1;
                _waves.add(w);
            } else if (this.fallback_move || isRam) {
                BotState botState = bot.states.get(2);
                BotState youState = null;
                youState = bot.nearestBotName.equals(Radar.myName) ? Radar.myStates.get(2) : Radar.getBot((String)bot.nearestBotName).states.get(2);
                double absBearing = LUtils.absoluteBearing(botState.x, botState.y, youState.x, youState.y);
                long fireTime = this._time - 1L;
                double ramPower = LUtils.bulletPowerFromVelocity(8.0);
                SurfWave w = new SurfWave(botState.x, botState.y, bot.name, ramPower, fireTime);
                w.myPos = (Point2D.Double)this._myPos.clone();
                w.isMeleeWave = this._others > 1;
                w.isMyWave = bot.nearestBotName.equals(Radar.myName);
                w.doBranchWave = this._others <= 1;
                w.isRamWave = true;
                _waves.add(w);
            }
            if (this._others > 1 || (power = bot.bulletPowerPredictor.getNearestNeighborsList(bot.bulletPowerDataPoint(bot.currentState.energy, this._energy, this._myPos.distance(bot.currentState.x, bot.currentState.y), this._others), 1)) == null || power.isEmpty()) continue;
            this.getMea((Double)power.get((int)0).data, Radar.myState, bot.currentState.x, bot.currentState.y, 0L, this._robot.getGraphics(), LUtils.sign(Bot.lateralVelocity(bot.currentState, Radar.myState)));
        }
        this.updateWaves();
        if (_waves.isEmpty() && this._others <= 1) {
            this.nonWaveMove.onTick();
        } else {
            this.doSurfing();
        }
        this.isProcessing = false;
        this.drawListener = false;
    }

    public double[] getMea(double power, BotState en, double myX, double myY, long time, Graphics2D g, int direction) {
        MovementPredictor.PredictionStatus status = new MovementPredictor.PredictionStatus(en.x, en.y, en.heading, en.velocity, time);
        double absBearing = LUtils.absoluteBearing(myX, myY, en.x, en.y);
        double distance = Point2D.Double.distance(myX, myY, en.x, en.y);
        double bft = distance / Rules.getBulletSpeed((double)power);
        int count = (int)bft;
        MovementPredictor.PredictionStatus dir1 = (MovementPredictor.PredictionStatus)status.clone();
        double distTravel1 = 0.0;
        for (int i = 0; i < count; ++i) {
            distTravel1 += Rules.getBulletSpeed((double)power);
            double dist1 = Point2D.Double.distance(myX, myY, dir1.x, dir1.y);
            if (!(dist1 - distTravel1 > 0.0)) break;
            double angle = LUtils.absoluteBearing(dir1.x, dir1.y, myX, myY) + 1.5707963267948966 * (double)direction;
            this.trig.sin = Math.sin(angle);
            this.trig.cos = Math.cos(angle);
            angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, dir1.x, dir1.y, -1 * direction);
            dir1 = MovementPredictor.predict(dir1, angle, 8.0);
            g.setColor(this.whiteRed);
            g.drawOval((int)dir1.x - 1, (int)dir1.y - 1, 2, 2);
        }
        double distTravel2 = 0.0;
        MovementPredictor.PredictionStatus dir2 = (MovementPredictor.PredictionStatus)status.clone();
        for (int i = 0; i < count; ++i) {
            distTravel2 += Rules.getBulletSpeed((double)power);
            double dist2 = Point2D.Double.distance(myX, myY, dir2.x, dir2.y);
            if (!(dist2 - distTravel2 > 0.0)) break;
            double angle = LUtils.absoluteBearing(dir2.x, dir2.y, myX, myY) - 1.5707963267948966 * (double)direction;
            this.trig.sin = Math.sin(angle);
            this.trig.cos = Math.cos(angle);
            angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, dir2.x, dir2.y, 1 * direction);
            dir2 = MovementPredictor.predict(dir2, angle, 8.0);
            g.setColor(this.whiteBlue);
            g.drawOval((int)dir2.x - 1, (int)dir2.y - 1, 2, 2);
        }
        double mea1 = Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(myX, myY, dir1.x, dir1.y) - absBearing));
        double mea2 = Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(myX, myY, dir2.x, dir2.y) - absBearing));
        return new double[]{Math.abs(mea1), Math.abs(mea2)};
    }

    public void doSurfing() {
        if (Double.isNaN(this.lastDestX) && Double.isNaN(this.lastDestY)) {
            this.lastDestX = this._myPos.x;
            this.lastDestY = this._myPos.y;
        }
        if (!_waves.isEmpty()) {
            double heading;
            this.MELEE_SURF_MODE = this._others > 1;
            this.MELEE_BOTDANGER_MODE = this._others > 1;
            int waveCount = 0;
            if (this._others <= 1) {
                MAX_SURF = 2;
                waveCount = Math.min(_waves.size(), MAX_SURF);
            } else {
                waveCount = Math.min(_waves.size(), 10);
                MAX_SURF = 2;
            }
            this.isContainingMyWave = false;
            ArrayList clonedWaves = (ArrayList)_waves.clone();
            ArrayList<SurfWave> surfWaves = new ArrayList<SurfWave>();
            SurfWave surfWave = null;
            double lastWaveDist = 0.0;
            for (int i = 0; i < waveCount; ++i) {
                SurfWave nearWave = this.getClosestSurfableWave(clonedWaves, this._myPos.x, this._myPos.y, this._time);
                double waveDist = this._myPos.distance(nearWave.x, nearWave.y) / nearWave.bulletVelocity;
                if (this._others <= 1) {
                    nearWave.doBranchWave = true;
                    this.isContainingMyWave = true;
                }
                if (nearWave.isMyWave) {
                    this.isContainingMyWave = true;
                }
                if (i == 0) {
                    surfWave = nearWave;
                    lastWaveDist = waveDist;
                }
                surfWaves.add(nearWave);
                clonedWaves.remove(nearWave);
                if (!(waveDist - lastWaveDist > 10.0)) continue;
                lastWaveDist = waveDist;
            }
            waveCount = Math.min(waveCount, MAX_SURF);
            double velocity = this._robot.getVelocity();
            double bestGoAngle = heading = this._robot.getHeadingRadians();
            double bestMaxVelocity = 8.0;
            double bestRisk = Double.POSITIVE_INFINITY;
            double bestDist = 100.0;
            ArrayList<SurfPathPos> bestPathPosList = null;
            ArrayList<SurfPathPos> pathPosList = null;
            if (!this.MELEE_SURF_MODE) {
                double nextRisk1;
                if (this.PATH_DRAW_MODE) {
                    pathPosList = new ArrayList<SurfPathPos>();
                }
                double goAngle = this.orbitAngle(1, this._myPos.x, this._myPos.y, surfWave, 0.6);
                double nextRisk0 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle, 9, this._time, pathPosList);
                bestGoAngle = goAngle;
                bestMaxVelocity = 8.0;
                bestRisk = nextRisk0;
                bestPathPosList = pathPosList;
                if (this.PATH_DRAW_MODE) {
                    pathPosList = new ArrayList();
                }
                if ((nextRisk1 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle = this.orbitAngle(2, this._myPos.x, this._myPos.y, surfWave, 0.6), 10, this._time, pathPosList)) < bestRisk) {
                    bestGoAngle = goAngle;
                    bestRisk = nextRisk1;
                    bestMaxVelocity = 8.0;
                    bestPathPosList = pathPosList;
                }
                if (!surfWave.isRamWave && surfWave.distanceSq(this._myPos) > 62500.0) {
                    double nextRisk2;
                    if (this.PATH_DRAW_MODE) {
                        pathPosList = new ArrayList();
                    }
                    if ((nextRisk2 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 0.0, waveCount - 1, goAngle = this.orbitAngle(1, this._myPos.x, this._myPos.y, surfWave, 0.6), 9, this._time, pathPosList)) < bestRisk) {
                        bestGoAngle = goAngle;
                        bestRisk = nextRisk2;
                        bestMaxVelocity = 0.0;
                        bestPathPosList = pathPosList;
                    }
                } else {
                    double nextRisk;
                    if (this.PATH_DRAW_MODE) {
                        pathPosList = new ArrayList();
                    }
                    goAngle = this.orbitAngle(1, this._myPos.x, this._myPos.y, surfWave, 1.0);
                    nextRisk0 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle, 17, this._time, pathPosList);
                    bestGoAngle = goAngle;
                    bestMaxVelocity = 8.0;
                    bestRisk = nextRisk0;
                    bestPathPosList = pathPosList;
                    if (this.PATH_DRAW_MODE) {
                        pathPosList = new ArrayList();
                    }
                    if ((nextRisk1 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle = this.orbitAngle(2, this._myPos.x, this._myPos.y, surfWave, 1.0), 18, this._time, pathPosList)) < bestRisk) {
                        bestGoAngle = goAngle;
                        bestRisk = nextRisk1;
                        bestMaxVelocity = 8.0;
                        bestPathPosList = pathPosList;
                    }
                    if (this.PATH_DRAW_MODE) {
                        pathPosList = new ArrayList();
                    }
                    if ((nextRisk = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle = this.orbitAngle(1, this._myPos.x, this._myPos.y, surfWave, 10000.0), 5, this._time, pathPosList)) < bestRisk) {
                        bestGoAngle = goAngle;
                        bestRisk = nextRisk;
                        bestMaxVelocity = 8.0;
                        bestPathPosList = pathPosList;
                    }
                    if (this.PATH_DRAW_MODE) {
                        pathPosList = new ArrayList();
                    }
                    if ((nextRisk = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle = this.orbitAngle(2, this._myPos.x, this._myPos.y, surfWave, 10000.0), 6, this._time, pathPosList)) < bestRisk) {
                        bestGoAngle = goAngle;
                        bestRisk = nextRisk;
                        bestMaxVelocity = 8.0;
                        bestPathPosList = pathPosList;
                    }
                }
            } else {
                double nextRisk;
                double bestDestX = this.lastDestX;
                double bestDestY = this.lastDestY;
                int direction = DIRECTIONS;
                for (int i = 0; i < direction; ++i) {
                    double nextRisk2;
                    if (this.PATH_DRAW_MODE) {
                        pathPosList = new ArrayList();
                    }
                    double goAngle = heading + Math.toRadians((double)i * (360.0 / (double)direction));
                    goAngle = this.meleePreciseSmooth(goAngle);
                    if (this.g != null) {
                        double preX = this._myPos.x + Math.sin(goAngle) * (double)MELEE_STICK;
                        double preY = this._myPos.y + Math.cos(goAngle) * (double)MELEE_STICK;
                        this.g.setColor(new Color(255, 255, 255, 50));
                        this.g.fillOval((int)preX - 18, (int)preY - 18, 36, 36);
                    }
                    double dist = 125.0;
                    double nextDestX = this._myPos.x + Math.sin(goAngle) * dist;
                    double nextDestY = this._myPos.y + Math.cos(goAngle) * dist;
                    int margin = 20;
                    nextDestX = LUtils.limit((double)margin, nextDestX, LConstants.fieldWidth - (double)margin);
                    nextDestY = LUtils.limit((double)margin, nextDestY, LConstants.fieldHeight - (double)margin);
                    if (this.PATH_DRAW_MODE) {
                        this.g.setColor(Color.blue);
                        this.g.fillOval((int)nextDestX - 5, (int)nextDestY - 5, 10, 10);
                    }
                    if (!(bestRisk > (nextRisk2 = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle, -1, this._time, pathPosList, nextDestX, nextDestY, 8.0, bestRisk)))) continue;
                    bestRisk = nextRisk2;
                    bestMaxVelocity = 8.0;
                    bestGoAngle = goAngle;
                    bestPathPosList = pathPosList;
                    bestDestX = nextDestX;
                    bestDestY = nextDestY;
                    bestDist = Point2D.Double.distance(this._myPos.x, this._myPos.y, nextDestX, nextDestY);
                }
                if (this.PATH_DRAW_MODE) {
                    pathPosList = new ArrayList();
                }
                double goAngle = LUtils.absoluteBearing(this._myPos.x, this._myPos.y, this.lastDestX, this.lastDestY);
                goAngle = this.meleePreciseSmooth(goAngle);
                if (this.g != null) {
                    this.g.setColor(new Color(0, 255, 0));
                    this.g.fillOval((int)this.lastDestX - 5, (int)this.lastDestY - 5, 10, 10);
                }
                if (bestRisk > (nextRisk = this.simulate(surfWaves, this._myPos.x, this._myPos.y, heading, velocity, 8.0, waveCount - 1, goAngle, -1, this._time, pathPosList, this.lastDestX, this.lastDestY, 8.0, bestRisk))) {
                    bestRisk = nextRisk;
                    bestMaxVelocity = 8.0;
                    bestGoAngle = goAngle;
                    bestPathPosList = pathPosList;
                    bestDestX = this.lastDestX;
                    bestDestY = this.lastDestY;
                    bestDist = Point2D.Double.distance(this._myPos.x, this._myPos.y, this.lastDestX, this.lastDestY);
                }
                this.lastDestX = bestDestX;
                this.lastDestY = bestDestY;
                if (this.g != null) {
                    this.g.setColor(Color.red);
                    this.g.fillOval((int)this.lastDestX - 6, (int)this.lastDestY - 6, 12, 12);
                }
            }
            if (this.PATH_DRAW_MODE && bestPathPosList != null) {
                double oldX = this._myPos.x;
                double oldY = this._myPos.y;
                Stroke reset = this.g.getStroke();
                this.g.setStroke(this.bs);
                for (SurfPathPos pos : bestPathPosList) {
                    this.g.setColor(pos.color);
                    int size = (int)pos.size;
                    if (pos.isConnected) {
                        if (size > 2) {
                            this.g.fillOval((int)(pos.x - (double)size), (int)(pos.y - (double)size), size * 2, size * 2);
                        }
                        this.g.drawLine((int)oldX, (int)oldY, (int)pos.x, (int)pos.y);
                        oldX = pos.x;
                        oldY = pos.y;
                        continue;
                    }
                    this.g.drawRect((int)(pos.x - (double)size), (int)(pos.y - (double)size), size * 2, size * 2);
                }
                this.g.setStroke(reset);
            }
            double epsilon = Utils.getRandom().nextDouble(-1.0E-12, 1.0E-12);
            if (RABBIT_MODE && bestMaxVelocity > 1.0) {
                bestMaxVelocity = Surfing.getRabbitVelocity(this._time);
            }
            this._robot.setMaxVelocity(bestMaxVelocity + epsilon);
            if (this.MELEE_SURF_MODE) {
                Surfing.setBackAsFront((AdvancedRobot)this._robot, bestGoAngle);
            } else {
                Surfing.setBackAsFront((AdvancedRobot)this._robot, bestGoAngle);
            }
            if (this._others <= 1 && bestMaxVelocity <= 0.1 && Math.random() < 0.5) {
                bestGoAngle += Math.PI;
            }
            LUtils.projectWithCache(nextMyPos, bestGoAngle, MovementPredictor.getVelocity(velocity, bestMaxVelocity + epsilon, Double.POSITIVE_INFINITY), nextMyPos);
        }
    }

    public double meleePreciseSmooth(double goAngle) {
        this.trig.sin = Math.sin(goAngle);
        this.trig.cos = Math.cos(goAngle);
        double smoothed1 = LConstants.preciseWallSmooth.smoothHeading(goAngle, this.trig, this._myPos.x, this._myPos.y, 1);
        this.trig.sin = Math.sin(smoothed1);
        this.trig.cos = Math.cos(smoothed1);
        smoothed1 = LConstants.preciseWallSmooth.smoothHeading(smoothed1, this.trig, this._myPos.x, this._myPos.y, 1);
        this.trig.sin = Math.sin(goAngle);
        this.trig.cos = Math.cos(goAngle);
        double smoothed2 = LConstants.preciseWallSmooth.smoothHeading(goAngle, this.trig, this._myPos.x, this._myPos.y, -1);
        this.trig.sin = Math.sin(smoothed2);
        this.trig.cos = Math.cos(smoothed2);
        smoothed2 = LConstants.preciseWallSmooth.smoothHeading(smoothed2, this.trig, this._myPos.x, this._myPos.y, -1);
        goAngle = Math.abs(Utils.normalRelativeAngle((double)(smoothed1 - goAngle))) > Math.abs(Utils.normalRelativeAngle((double)(smoothed2 - goAngle))) ? smoothed2 : smoothed1;
        return goAngle;
    }

    private void goTo(double x, double y) {
        double angleToTarget = Math.atan2(x -= this._robot.getX(), y -= this._robot.getY());
        double targetAngle = Utils.normalRelativeAngle((double)(angleToTarget - this._robot.getHeadingRadians()));
        double distance = Math.hypot(x, y);
        double turnAngle = Math.atan(Math.tan(targetAngle));
        this._robot.setTurnRightRadians(turnAngle);
        if (targetAngle == turnAngle) {
            this._robot.setAhead(distance);
        } else {
            this._robot.setBack(distance);
        }
    }

    public double meleeWallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        double step = 0.0;
        double v = Math.toRadians(2.5);
        while (!LConstants.safeField.contains(LUtils.project(botLocation, angle, MELEE_STICK)) && step <= 720.0) {
            angle += (double)orientation * (step += 1.0) * v;
            orientation *= -1;
        }
        return angle;
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        Surfing.setBackAsFront(robot, goAngle, 100.0);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle, double dist) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(dist);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(dist);
        }
    }

    public double orbitAngle(int GO_TYPE, double x, double y, SurfWave surfWave, double mul) {
        int direction = 1;
        if (GO_TYPE == 2) {
            direction = -1;
        }
        double distancerAngle = this.distancer.attackAngle(surfWave.distance(x, y), mul);
        if (GO_TYPE - 4 > 0) {
            distancerAngle = 1.5707963267948966;
            direction = 1;
            if (2 == GO_TYPE - 4) {
                direction = -1;
            }
        }
        double goAngle = LUtils.absoluteBearing(x, y, this.duelEnPos.x, this.duelEnPos.y) + Math.PI + (double)direction * (1.5707963267948966 + distancerAngle);
        this.trig.sin = Math.sin(goAngle);
        this.trig.cos = Math.cos(goAngle);
        goAngle = LConstants.preciseWallSmooth.smoothHeading(goAngle, this.trig, x, y, direction);
        if (surfWave.distanceSq(x, y) <= 62500.0) {
            goAngle = this.meleePreciseSmooth(goAngle);
        }
        return goAngle;
    }

    public static double getRabbitVelocity(long time) {
        long mod = time % 17L;
        double vel = 8.0;
        if (mod >= 12L) {
            vel = 0.0;
        }
        return LUtils.limit(0.0, vel, 8.0);
    }

    public double simulate(ArrayList<SurfWave> waves, double x, double y, double heading, double velocity, double maxVelocity, int depth, double goAngle, int GO_TYPE, long simTime, ArrayList<SurfPathPos> drawPathDest) {
        return this.simulate(waves, x, y, heading, velocity, maxVelocity, depth, goAngle, GO_TYPE, simTime, drawPathDest, Double.NaN, Double.NaN, maxVelocity, Double.POSITIVE_INFINITY);
    }

    public double simulate(ArrayList<SurfWave> waves, double x, double y, double heading, double velocity, double maxVelocity, int depth, double goAngle, int GO_TYPE, long simTime, ArrayList<SurfPathPos> drawPathDest, double destX, double destY, double targetVel, double minimum) {
        ++this.nodes;
        double firstX = x;
        double firstY = y;
        double addDistance = 0.0;
        double risk = 0.0;
        int hitCount = 0;
        int counter = 0;
        while (counter < 100) {
            double dist;
            ++simTime;
            ++this.loops;
            ++counter;
            if (RABBIT_MODE && targetVel > 1.0) {
                maxVelocity = Surfing.getRabbitVelocity(simTime);
            }
            SurfWave surfWave = this.getClosestSurfableWave(waves, x, y, simTime);
            double distRemaining = Double.POSITIVE_INFINITY;
            if (GO_TYPE > 0) {
                if (GO_TYPE - 16 > 0) {
                    goAngle = this.orbitAngle(GO_TYPE - 16, x, y, surfWave, 1.0);
                } else if (GO_TYPE - 8 > 0) {
                    goAngle = this.orbitAngle(GO_TYPE - 8, x, y, surfWave, 0.6);
                } else if (GO_TYPE - 4 == 0) {
                    goAngle = this.orbitAngle(GO_TYPE, x, y, surfWave, 10000.0);
                }
            }
            double posDist = Point2D.Double.distance(x, y, destX, destY);
            if (!Double.isNaN(destX) && !Double.isNaN(destY) && posDist >= 0.0) {
                goAngle = Utils.normalAbsoluteAngle((double)LUtils.absoluteBearing(x, y, destX, destY));
            }
            int moveDir = 1;
            double relativeGoAngle = goAngle - heading;
            if (Math.cos(relativeGoAngle) < 0.0) {
                moveDir = -1;
                relativeGoAngle += Math.PI;
            }
            relativeGoAngle = Utils.normalRelativeAngle((double)relativeGoAngle);
            double maxTurning = Math.toRadians(10.0 - 0.75 * velocity);
            velocity = MovementPredictor.getVelocity(velocity, maxVelocity, distRemaining * (double)moveDir);
            x += Math.sin(heading += LUtils.limit(-maxTurning, relativeGoAngle, maxTurning)) * velocity;
            y += Math.cos(heading) * velocity;
            if (this.PATH_DRAW_MODE) {
                SurfPathPos pos = new SurfPathPos().setX(x).setY(y).setSize(1.0);
                if (!LConstants.roundRect.contains(x, y)) {
                    pos.color = Color.red;
                }
                drawPathDest.add(pos);
            }
            if (!LConstants.roundRect.contains(x, y)) {
                risk += 5.0E8;
            }
            if ((dist = this.duelEnPos.distanceSq(x, y)) <= 2500.0) {
                risk += 5000.0 / dist;
            }
            if (dist <= 1764.0) {
                risk += 5000.0;
            }
            if (this.g != null && this.drawListener && depth == 1) {
                this.g.setColor(Color.gray);
                this.g.drawRect((int)x - 1, (int)y - 1, 2, 2);
            }
            boolean isBranch = false;
            for (int i = 0; i < waves.size(); ++i) {
                SurfWave otherWave = waves.get(i);
                boolean isHit = false;
                if (otherWave.isMeleeWave) {
                    isHit = otherWave.distance(x, y) - otherWave.getDistanceTraveled(simTime) <= otherWave.bulletVelocity / 1.5 && otherWave.distance(x, y) - otherWave.getDistanceTraveled(simTime) >= -otherWave.bulletVelocity / 1.5;
                } else {
                    boolean bl = isHit = otherWave.distance(x, y) - otherWave.getDistanceTraveled(simTime) < 18.0 && otherWave.distance(x, y) - otherWave.getDistanceTraveled(simTime) > -25.455599999999997 - otherWave.bulletVelocity;
                }
                if (isHit) {
                    double timeToImpact;
                    double currentDistanceToWave;
                    double currentDistanceToWaveSource;
                    double bandwidth = Math.asin(36.0 / otherWave.distance(x, y));
                    double hitAngle = LUtils.absoluteBearing(otherWave.x, otherWave.y, x, y);
                    ++hitCount;
                    double currentRisk = 0.0;
                    double waveRisk = this.getDangerScoreWithShadow(otherWave, hitAngle, bandwidth);
                    if (!otherWave.isRamWave) {
                        waveRisk = otherWave.isMeleeWave ? (waveRisk *= Rules.getBulletDamage((double)otherWave.bulletPower)) : (waveRisk *= Rules.getBulletDamage((double)otherWave.bulletPower));
                    }
                    if (this.MELEE_BOTDANGER_MODE) {
                        waveRisk += 1.0;
                        waveRisk = Math.pow(waveRisk, 2.5);
                        if (otherWave.isMyWave) {
                            waveRisk *= 2.0;
                        }
                    }
                    this.waveRiskCount += 1.0;
                    this.sumWaveRisk += waveRisk;
                    if (this.MELEE_BOTDANGER_MODE) {
                        currentDistanceToWaveSource = otherWave.distance(x, y);
                        currentDistanceToWave = currentDistanceToWaveSource - otherWave.getDistanceTraveled(simTime);
                        timeToImpact = Math.max(1.0, currentDistanceToWave / otherWave.bulletVelocity);
                        waveRisk /= timeToImpact;
                        double waveWeight = this._others * 2 + 1;
                        waveWeight = 1.0;
                        if (otherWave.isMeleeWave && otherWave.isRamWave) {
                            waveWeight = 0.0;
                        }
                        currentRisk = waveWeight * waveRisk;
                    } else {
                        currentRisk = waveRisk;
                    }
                    if (this.MELEE_BOTDANGER_MODE) {
                        currentDistanceToWaveSource = otherWave.distance(x, y);
                        currentDistanceToWave = currentDistanceToWaveSource - otherWave.getDistanceTraveled(simTime);
                        timeToImpact = Math.max(1.0, currentDistanceToWave / otherWave.bulletVelocity);
                        currentRisk /= timeToImpact;
                        double firstDistanceToWaveSource = otherWave.distance(firstX, firstY);
                        currentRisk /= Math.pow(currentDistanceToWaveSource / firstDistanceToWaveSource, 3.0);
                    }
                    risk += currentRisk;
                    if (this.PATH_DRAW_MODE) {
                        SurfPathPos pathPos = new SurfPathPos().setX(x).setY(y).setSize(3.0);
                        if (surfWave.isMyWave) {
                            pathPos.color = Color.cyan;
                        }
                        drawPathDest.add(pathPos);
                    }
                } else if (surfWave == otherWave || otherWave.distance(x, y) - otherWave.getDistanceTraveled(simTime) <= -25.455599999999997 - otherWave.bulletVelocity) {
                    // empty if block
                }
                if (!this.MELEE_SURF_MODE) {
                    if (!(surfWave.distance(x, y) - surfWave.getDistanceTraveled(simTime) < -18.0 + surfWave.bulletVelocity / 2.0)) continue;
                    isBranch = true;
                    continue;
                }
                if (!Double.isNaN(destX) && !Double.isNaN(destY) && Point2D.Double.distance(x, y, destX, destY) <= 8.0) {
                    isBranch = true;
                }
                if (simTime - this._time > 75L) {
                    isBranch = true;
                }
                if (!this.isContainingMyWave) continue;
            }
            if (!isBranch) continue;
            if (this.PATH_DRAW_MODE) {
                SurfPathPos pos = new SurfPathPos().setX(x).setY(y).setSize(18.0);
                pos.isConnected = false;
                if (!LConstants.roundRect.contains(x, y)) {
                    pos.color = Color.red;
                }
                drawPathDest.add(pos);
            }
            if (surfWave.isMeleeWave) {
                risk /= (double)Math.max(1, hitCount);
            }
            if (depth > 0) {
                if (risk > minimum) {
                    ++this.cutNodes;
                    return risk;
                }
                double bestSecondRisk = Double.POSITIVE_INFINITY;
                ArrayList<SurfPathPos> bestSecondPaths = null;
                if (!this.MELEE_SURF_MODE) {
                    double nextRisk;
                    ArrayList<SurfPathPos> secondPaths = null;
                    if (this.PATH_DRAW_MODE) {
                        secondPaths = new ArrayList<SurfPathPos>();
                    }
                    if ((nextRisk = this.simulate(waves, x, y, heading, velocity, 8.0, depth - 1, goAngle, 9, simTime, secondPaths)) < bestSecondRisk) {
                        bestSecondRisk = nextRisk;
                        bestSecondPaths = secondPaths;
                    }
                    secondPaths = null;
                    if (this.PATH_DRAW_MODE) {
                        secondPaths = new ArrayList();
                    }
                    if ((nextRisk = this.simulate(waves, x, y, heading, velocity, 8.0, depth - 1, goAngle, 10, simTime, secondPaths)) < bestSecondRisk) {
                        bestSecondRisk = nextRisk;
                        bestSecondPaths = secondPaths;
                    }
                    if (!surfWave.isRamWave && surfWave.distanceSq(this._myPos) > 62500.0) {
                        secondPaths = null;
                        if (this.PATH_DRAW_MODE) {
                            secondPaths = new ArrayList();
                        }
                        if ((nextRisk = this.simulate(waves, x, y, heading, velocity, 0.0, depth - 1, goAngle, 9, simTime, secondPaths)) < bestSecondRisk) {
                            bestSecondRisk = nextRisk;
                            bestSecondPaths = secondPaths;
                        }
                    }
                    risk += bestSecondRisk;
                } else {
                    ArrayList<SurfPathPos> secondPaths = null;
                    int direction = DIRECTIONS;
                    for (int i = 0; i < direction; ++i) {
                        if (this.PATH_DRAW_MODE) {
                            secondPaths = new ArrayList<SurfPathPos>();
                        }
                        double dirAngle = heading + Math.toRadians((double)i * (360.0 / (double)direction));
                        dirAngle = this.meleePreciseSmooth(dirAngle);
                        double dist2 = 150.0;
                        double nextDestX = x + Math.sin(dirAngle) * dist2;
                        double nextDestY = y + Math.cos(dirAngle) * dist2;
                        int margin = 20;
                        double nextRisk = this.simulate(waves, x, y, heading, velocity, 8.0, depth - 1, dirAngle, -1, simTime, secondPaths, nextDestX = LUtils.limit((double)margin, nextDestX, LConstants.fieldWidth - (double)margin), nextDestY = LUtils.limit((double)margin, nextDestY, LConstants.fieldHeight - (double)margin), 8.0, bestSecondRisk + risk);
                        if (!(bestSecondRisk > nextRisk)) continue;
                        bestSecondPaths = secondPaths;
                        bestSecondRisk = nextRisk;
                        double bestDestX = nextDestX;
                        double d = nextDestY;
                    }
                    risk += bestSecondRisk;
                }
                if (this.PATH_DRAW_MODE && bestSecondPaths != null) {
                    drawPathDest.addAll(bestSecondPaths);
                }
            }
            if (this.MELEE_BOTDANGER_MODE) {
                double nextY;
                double botRisk = this.getBotRisk(x, y, heading);
                this.sumBotRisk += botRisk;
                this.botRiskCount += 1.0;
                double posWeight = LUtils.limit(1.0E-5, (double)(this._others - 1), 5.0);
                double posMul = 5.0;
                posMul = this._others <= 3 ? 4.0 : (this._others <= 5 ? 5.0 : 6.0);
                posWeight *= posMul;
                posWeight = 1.0;
                double nextX = x + Math.sin(heading) * velocity;
                if (!LConstants.roundRect.contains(nextX, nextY = y + Math.cos(heading) * velocity)) {
                    risk += 1000000.0;
                }
                risk += botRisk * posWeight;
            }
            return risk;
        }
        if (this.MELEE_BOTDANGER_MODE) {
            risk /= (double)Math.max(hitCount, 1);
            double botRisk = this.getBotRisk(x, y, heading);
            this.sumBotRisk += botRisk;
            this.botRiskCount += 1.0;
            double posWeight = LUtils.limit(1.0E-5, (double)(this._others - 1), 5.0);
            double posMul = 5.0;
            posMul = this._others <= 3 ? 4.0 : (this._others <= 5 ? 5.0 : 6.0);
            posWeight *= posMul;
            posWeight = 1.0;
            risk += botRisk * posWeight;
        }
        return risk;
    }

    public double getBotRisk(double x, double y, double heading) {
        double risk = 0.0;
        ++this.riskCalled;
        double count = 0.0;
        for (Bot bot : Radar.enemies.values()) {
            BotState state;
            if (!bot.isAlive || bot.currentState == null) continue;
            if (!(bot.name.equals("aaa.r.ScalarR 0.005h.053") || bot.name.equals("aaa.r.ScalarR 0.005h.047") || bot.name.equals("eem.IWillFireNoBullet v2.8"))) {
                count += 1.0;
                state = bot.currentState;
                double energyRatio = LUtils.limit(0.25, state.energy / this._energy, 2.0);
                double dist = state.distance(x, y) + 1.0;
                double sui = Math.abs(Math.cos(LUtils.absoluteBearing(state.x, state.y, x, y) - heading)) * 0.25 + 1.0;
                if (bot.nearestBotName.equals(Radar.myName)) {
                    energyRatio *= 1.75;
                } else if (bot.myBotDist + 100.0 < bot.nearestBotDist) {
                    energyRatio *= 1.25;
                }
                double pointDistance = Point2D.distance(x, y, state.x, state.y);
                int closer = Radar.botsCloser(pointDistance * pointDistance * 0.8);
                energyRatio = energyRatio * 3.0 + 8.0;
                if (closer <= 1) {
                    energyRatio *= sui;
                }
                risk += energyRatio / (Math.pow(pointDistance, 2.0) * (double)closer + 1.0);
                continue;
            }
            state = bot.currentState;
            double pointDistance = Point2D.distance(x, y, state.x, state.y);
            risk += -1.0E-4 / (Math.pow(pointDistance, 2.0) + 1.0);
        }
        return Math.pow(risk + 1.0, 7.5) * 75000.0 / 1.0 / count;
    }

    public double getDangerScoreWithShadow(SurfWave w, double hitAngle, double hitBandwidth) {
        double danger = this.getDangerScore(w, hitAngle, hitBandwidth);
        if (!w.isMeleeWave) {
            double factor = LUtils.limit(0.0, 1.0 - w.coveredWidthByShadow(hitAngle, hitBandwidth), 1.0);
            danger *= factor;
        }
        return danger;
    }

    public double getDangerScore(SurfWave w, double hitAngle, double hitBandwidth) {
        long then = System.nanoTime();
        if (w.isRamWave) {
            return this.ramDanger(w, hitAngle, hitBandwidth) / 3.0;
        }
        int totalEnableSize = 0;
        double totalDanger = 0.0;
        double totalScanWeight = 0.0;
        totalEnableSize += w.allNearestNeighbors.size();
        for (KNNResultWithWave knnResultWithWave : w.allNearestNeighbors) {
            KNNData<GFData> gfData = knnResultWithWave.neighbor;
            double density = 0.0;
            double viewScanWeight = 0.0;
            double scanWeight = ((GFData)gfData.data).weight * gfData.treeWeight;
            if (w.isMeleeWave) {
                scanWeight *= knnResultWithWave.distanceWeight;
            }
            double xFiringAngle = LUtils.normalizeAngle(w.firingAngle(knnResultWithWave.waveData, ((GFData)gfData.data).guessFactor), hitAngle);
            double ux = (xFiringAngle - hitAngle) / hitBandwidth;
            totalScanWeight += (viewScanWeight += scanWeight);
            totalDanger += (density += (scanWeight /= Math.sqrt(gfData.distance + 1.0)) * Math.exp(-0.5 * (ux * ux)));
        }
        long millis = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - then);
        this.dangerTime += millis;
        ++this.dangerCalled;
        if (totalEnableSize == 0) {
            return this.defaultDanger(w, hitAngle, hitBandwidth);
        }
        return totalDanger / totalScanWeight;
    }

    private double ramDanger(SurfWave w, double hitAngle, double hitBandwidth) {
        double[] guessFactors = new double[]{0.0};
        double[] weights = new double[]{1.0};
        double danger = 0.0;
        for (SurfWave.WaveData waveData : w.waveDataArrayList) {
            for (int x = 0; x < guessFactors.length; ++x) {
                double firingAngle = waveData.directAngle + guessFactors[x] * (double)waveData.direction * w.maxEscapeAngle();
                double ux = (firingAngle - LUtils.normalizeAngle(hitAngle, firingAngle)) / hitBandwidth;
                danger += weights[x] * Math.exp(-0.5 * (ux * ux));
            }
        }
        return danger;
    }

    private double defaultDanger(SurfWave w, double hitAngle, double hitBandwidth) {
        double[] guessFactors = new double[]{0.0};
        double[] weights = new double[]{1.0};
        double totalDanger = 0.0;
        double totalWeight = 0.0;
        for (SurfWave.WaveData waveData : w.waveDataArrayList) {
            double danger = 0.0;
            double weight = 0.0;
            for (int x = 0; x < guessFactors.length; ++x) {
                double firingAngle = waveData.directAngle + guessFactors[x] * (double)waveData.direction * w.maxEscapeAngle();
                double ux = (firingAngle - LUtils.normalizeAngle(hitAngle, firingAngle)) / hitBandwidth;
                danger += weights[x] * Math.exp(-0.5 * (ux * ux));
                weight += weights[x];
            }
            if (!w.isMeleeWave) {
                double firingAngle = waveData.directAngle + Math.asin(waveData.targetGunData.youLatVel / w.bulletVelocity);
                double ux = (firingAngle - LUtils.normalizeAngle(hitAngle, firingAngle)) / hitBandwidth;
                danger += 1.0 * Math.exp(-0.5 * (ux * ux));
                weight += 1.0;
            }
            totalDanger += danger;
            totalWeight += weight;
        }
        return totalDanger / totalWeight;
    }

    public double wallSmoothing(double x, double y, double startAngle, int orientation, int smoothTowardEnemy) {
        double angle = startAngle;
        double testX = x + Math.sin(angle += Math.PI * 4) * (double)WALL_STICK;
        double testY = y + Math.cos(angle) * (double)WALL_STICK;
        double extra = 18.5;
        double wallDistanceX = Math.min(x - extra, LConstants.fieldWidth - x - extra);
        double wallDistanceY = Math.min(y - extra, LConstants.fieldHeight - y - extra);
        double testDistanceX = Math.min(testX - extra, LConstants.fieldWidth - testX - extra);
        double testDistanceY = Math.min(testY - extra, LConstants.fieldHeight - testY - extra);
        double adjacent = 0.0;
        int g = 0;
        while (!LConstants.safeField.contains(testX, testY) && g++ < 25) {
            if (testDistanceY < 0.0 && testDistanceY < testDistanceX) {
                angle = (double)((int)((angle + 1.5707963267948966) / Math.PI)) * Math.PI;
                adjacent = Math.abs(wallDistanceY);
            } else if (testDistanceX < 0.0 && testDistanceX <= testDistanceY) {
                angle = (double)((int)(angle / Math.PI)) * Math.PI + 1.5707963267948966;
                adjacent = Math.abs(wallDistanceX);
            }
            testX = x + Math.sin(angle += (double)(smoothTowardEnemy * orientation) * (Math.abs(Math.acos(adjacent / (double)WALL_STICK)) + 0.005)) * (double)WALL_STICK;
            testY = y + Math.cos(angle) * (double)WALL_STICK;
            testDistanceX = Math.min(testX - extra, LConstants.fieldWidth - testX - extra);
            testDistanceY = Math.min(testY - extra, LConstants.fieldHeight - testY - extra);
            if (smoothTowardEnemy != -1) continue;
        }
        return angle;
    }

    public void updateWaves() {
        Graphics2D g = this._robot.getGraphics();
        ArrayList<ShadowBullet> realBullets = LambdaGun.realBullets;
        for (int i = 0; i < realBullets.size(); ++i) {
            ShadowBullet bullet = realBullets.get(i);
            if (this.PATH_DRAW_MODE) {
                Point2D.Double cur = bullet.simulatePos(this._time);
                Point2D.Double next = bullet.simulatePos(this._time + 1L);
                g.setColor(Color.white);
                g.drawLine((int)cur.x, (int)cur.y, (int)next.x, (int)next.y);
            }
            if (LConstants.field.contains(bullet.simulatePos(this._time))) continue;
            realBullets.remove(i);
            --i;
        }
        for (int x = 0; x < _waves.size(); ++x) {
            SurfWave w = _waves.get(x);
            Bot bot = Radar.getBot(w.sourceName);
            this.setShadows(w);
            if (w.getDistanceTraveled(this._time) > this._myPos.distance(w) + w.bulletVelocity * 1.0 + 18.0) {
                if (bot != null) {
                    for (SurfWave.WaveData waveData : w.waveDataArrayList) {
                        GFData data = new GFData();
                        data.guessFactor = w.guessFactor(waveData, this._myPos);
                        data.weight = 1.0;
                        if (w.isMeleeWave) continue;
                        if (bot.FLATTENER_LOG) {
                            for (SurfKNNModel surfKNNModel : bot.surfWaveFlattenerKNNModels.get(waveData.name)) {
                                surfKNNModel.addPoint(w, waveData, data);
                            }
                        }
                        if (!bot.FLATTENER_ENABLE && !FLATTENER_ONLY_MODE) continue;
                        for (SurfWave surfWave : _waves) {
                            this.updateNearestNeighbors(surfWave);
                        }
                    }
                }
                _waves.remove(x);
                --x;
                continue;
            }
            if (w.isRamWave && this._time - w.fireTime > 1L) {
                _waves.remove(x);
                --x;
                continue;
            }
            if (w.hasNeighbors) continue;
            this.updateNearestNeighbors(w);
        }
    }

    public void setShadows(SurfWave w) {
        boolean updated = false;
        block0: for (ShadowBullet bullet : LambdaGun.realBullets) {
            long startTime = Math.max(w.fireTime, bullet.fireTime);
            if (w.processedBullets.containsKey(bullet) || !(w.distanceSq(bullet.simulatePos(startTime)) > LUtils.square(w.getDistanceTraveled(startTime)))) continue;
            long time = startTime;
            do {
                if (!(w.distanceSq(bullet.simulatePos(++time)) < LUtils.square(w.getDistanceTraveled(time))) || time >= 1500L) continue;
                w.addBulletShadows(bullet, time);
                updated = true;
                continue block0;
            } while (LConstants.field.contains(bullet.simulatePos(time)));
        }
        if (updated) {
            this.updateNearestNeighbors(w);
        }
    }

    public void updateNearestNeighbors(SurfWave w) {
        w.hasNeighbors = true;
        w.allNearestNeighbors = new ArrayList();
        Bot bot = Radar.getBot(w.sourceName);
        for (SurfWave.WaveData waveData : w.waveDataArrayList) {
            ArrayList<KNNData<GFData>> nearestNeighbors = new ArrayList<KNNData<GFData>>();
            if (!w.isMeleeWave) {
                if (FLATTENER_ONLY_MODE) {
                    for (SurfKNNModel<GFData> surfKNNModel : bot.surfWaveFlattenerKNNModels.get(waveData.name)) {
                        nearestNeighbors.addAll(surfKNNModel.getNearestNeighborsList(w, waveData));
                    }
                } else {
                    for (SurfKNNModel<GFData> surfKNNModel : bot.surfKNNModels.get(waveData.name)) {
                        nearestNeighbors.addAll(surfKNNModel.getNearestNeighborsList(w, waveData, surfKNNModel.kDivisor));
                    }
                    if (bot.FLATTENER_ENABLE) {
                        for (SurfKNNModel<GFData> surfKNNModel : bot.surfWaveFlattenerKNNModels.get(waveData.name)) {
                            nearestNeighbors.addAll(surfKNNModel.getNearestNeighborsList(w, waveData));
                        }
                    }
                }
            } else {
                for (SurfKNNModel<GFData> surfKNNModel : bot.surfMeleeKNNModels.get(waveData.name)) {
                    nearestNeighbors.addAll(surfKNNModel.getNearestNeighborsList(w, waveData));
                }
            }
            waveData.nearestNeighbors = nearestNeighbors;
            for (KNNData kNNData : nearestNeighbors) {
                double dist = w.distance(waveData.targetState.x, waveData.targetState.y);
                w.allNearestNeighbors.add(new KNNResultWithWave(kNNData, waveData).setDistanceWeight(1.0 / dist * dist));
            }
        }
    }

    public SurfWave getClosestSurfableWave(ArrayList<SurfWave> waves, double x, double y, long currentTime) {
        double closestBFT = Double.POSITIVE_INFINITY;
        SurfWave surfWave = null;
        int size = waves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return waves.get(0);
        }
        for (SurfWave ew : waves) {
            if (surfWave == null) {
                surfWave = ew;
            }
            double distance = ew.distance(x, y) - ew.getDistanceTraveled(currentTime);
            double bft = distance / ew.bulletVelocity;
            if (!(distance > -18.0) || !(bft < closestBFT)) continue;
            surfWave = ew;
            closestBFT = bft;
        }
        return surfWave;
    }

    public void logHit(SurfWave w, Point2D.Double hitPos) {
        System.out.println("[" + this._robot.getTime() + "] log");
        Bot bot = Radar.getBot(w.sourceName);
        if (bot != null) {
            for (SurfWave.WaveData waveData : w.waveDataArrayList) {
                double gf = w.guessFactor(waveData, hitPos);
                double botwidth = Math.asin(36.0 / w.distance(hitPos.x, hitPos.y));
                if (!(gf >= -w.maxEscapeAngle() - botwidth && gf <= w.maxEscapeAngle() + botwidth) && w.isMeleeWave) continue;
                GFData data = new GFData();
                data.guessFactor = gf;
                data.weight = 1.0;
                if (!w.isMeleeWave) {
                    for (SurfKNNModel<GFData> tree : bot.surfKNNModels.get(waveData.name)) {
                        tree.addPoint(w, waveData, data);
                    }
                    continue;
                }
                for (SurfKNNModel<GFData> tree : bot.surfMeleeKNNModels.get(waveData.name)) {
                    tree.addPoint(w, waveData, data);
                }
            }
            for (SurfWave ew : _waves) {
                this.updateNearestNeighbors(ew);
            }
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this._others <= 1) {
            this.duelHitLost += Rules.getBulletDamage((double)e.getPower());
        } else {
            this.meleeHitLost += Rules.getBulletDamage((double)e.getPower());
        }
        Bot bot = Radar.getBot(e.getName());
        if (bot != null && !_waves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            SurfWave hitWave = null;
            SurfWave nearestWave = null;
            double bestDist = Double.POSITIVE_INFINITY;
            for (int x = 0; x < _waves.size(); ++x) {
                SurfWave w = _waves.get(x);
                if (Math.abs(w.getDistanceTraveled(e.getTime()) - hitBulletLocation.distance(w)) < 50.0 && Math.abs(Rules.getBulletSpeed((double)e.getBullet().getPower()) - w.bulletVelocity) < 0.001 && Objects.equals(e.getBullet().getName(), w.sourceName)) {
                    hitWave = w;
                    break;
                }
                if (!(this._myPos.distance(w) - w.getDistanceTraveled(e.getTime()) < bestDist)) continue;
                nearestWave = w;
                bestDist = this._myPos.distance(w) - w.getDistanceTraveled(e.getTime());
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                if (!hitWave.isMeleeWave) {
                    _waves.remove(hitWave);
                }
            } else if (nearestWave != null) {
                this.logHit(nearestWave, hitBulletLocation);
                System.out.println("In \"onHitByBullet\" the nearest wave was recorded instead of the actual wave.");
            }
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Bot bot = Radar.getBot(e.getHitBullet().getName());
        if (bot != null && !_waves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            SurfWave hitWave = null;
            SurfWave nearestWave = null;
            double bestDist = Double.POSITIVE_INFINITY;
            double bestScore = Double.POSITIVE_INFINITY;
            for (int x = 0; x < _waves.size(); ++x) {
                SurfWave w = _waves.get(x);
                if (Math.abs(w.getDistanceTraveled(e.getTime()) - hitBulletLocation.distance(w)) < bestScore && e.getHitBullet().getName().equals(w.sourceName)) {
                    hitWave = w;
                    bestScore = Math.abs(w.getDistanceTraveled(e.getTime()) - hitBulletLocation.distance(w));
                }
                if (!(this._myPos.distance(w) - w.getDistanceTraveled(e.getTime()) < bestDist)) continue;
                nearestWave = w;
                bestDist = this._myPos.distance(w) - w.getDistanceTraveled(e.getTime());
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                if (!hitWave.isMeleeWave) {
                    _waves.remove(hitWave);
                }
            } else if (nearestWave != null) {
                this.logHit(nearestWave, hitBulletLocation);
                System.out.println("In \"onBulletHitBullet\" the nearest wave was recorded instead of the actual wave.");
            }
        }
    }

    public void endTask() {
        System.out.println();
        System.out.println("duel pain: " + this.duelHitLost);
        System.out.println("melee pain: " + this.meleeHitLost);
        System.out.println();
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        System.out.println("***** skipped turn[" + e.getSkippedTurn() + "] *****");
        System.out.println("isProcessing?:" + this.isProcessing);
        System.out.println("node:" + this.nodes);
        System.out.println("cutNodes:" + this.cutNodes);
        System.out.println("riskCalled: " + this.riskCalled);
        System.out.println("loop:" + this.loops);
        System.out.println("check danger called:" + this.dangerCalled);
        System.out.println("danger time:" + this.dangerTime);
        System.out.println("*************************");
    }

    public void onPaint(Graphics2D g) {
        this.g = g;
        this.drawListener = true;
        g.setColor(Color.yellow);
        g.draw(LConstants.roundRect);
        g.setColor(Color.white);
        if (Radar.nearestBot != null && Radar.nearestBot.currentState != null) {
            g.drawString("distance:" + Radar.nearestBot.currentState.distance(this._myPos.x, this._myPos.y), 30, 30);
        }
        double vel = this._robot.getVelocity();
        double heading = this._robot.getHeadingRadians();
        Point2D.Double dangerLocation = new Point2D.Double();
        Point2D.Double oldDrawLocation = new Point2D.Double();
        Point2D.Double drawLocation = new Point2D.Double();
        Point2D.Double lengthLocation = new Point2D.Double();
        Point2D.Double drawLocationBuffer = null;
        SurfWave nearestWave = this.getClosestSurfableWave(_waves, this._myPos.x, this._myPos.y, this._time);
        for (SurfWave enemyWave : _waves) {
            int numBins = 270;
            if (!enemyWave.isMeleeWave) {
                numBins = 720;
            }
            double halfBins = (double)(numBins - 1) / 2.0;
            double[] gfDangers = new double[numBins];
            double[] gfShadowed = new double[numBins];
            double mea = Math.PI;
            g.setColor(Color.gray);
            if (enemyWave.isMyWave) {
                g.setColor(Color.white);
            }
            if (nearestWave == enemyWave) {
                g.setColor(Color.red);
            }
            int radius = (int)enemyWave.getDistanceTraveled(this._time);
            g.drawOval((int)(enemyWave.x - (double)radius), (int)(enemyWave.y - (double)radius), radius * 2, radius * 2);
            double minDanger = Double.POSITIVE_INFINITY;
            double maxDanger = Double.NEGATIVE_INFINITY;
            double maxPointDanger = Double.NEGATIVE_INFINITY;
            Point2D.Double maxDangerPos = null;
            double totalDanger = 0.0;
            for (int x = 0; x <= numBins - 1; ++x) {
                double gf = ((double)x - halfBins) / halfBins;
                double bearingOffset = gf * mea;
                double absFiringAngle = 0.0 + bearingOffset;
                LUtils.projectWithCache(enemyWave, absFiringAngle, enemyWave.getDistanceTraveled(this._time) + enemyWave.bulletVelocity, dangerLocation);
                if (enemyWave.hasNeighbors) {
                    gfDangers[x] = this.getDangerScoreWithShadow(enemyWave, LUtils.absoluteBearing(enemyWave, dangerLocation), Math.asin(36.0 / enemyWave.distance(dangerLocation)));
                    totalDanger += gfDangers[x];
                }
                if (gfDangers[x] < minDanger) {
                    minDanger = gfDangers[x];
                }
                if (!(gfDangers[x] > maxDanger)) continue;
                maxDanger = gfDangers[x];
                maxDangerPos = dangerLocation;
            }
            totalDanger /= (double)numBins;
            Stroke cache = g.getStroke();
            g.setStroke(this.bs);
            for (int x = 0; x <= numBins - 1; ++x) {
                double gf = ((double)x - halfBins) / halfBins;
                double bearingOffset = gf * mea;
                LUtils.projectWithCache(enemyWave, 0.0 + bearingOffset, enemyWave.getDistanceTraveled(this._time) - 10.0 + enemyWave.bulletVelocity, drawLocation);
                if (maxPointDanger < gfDangers[x]) {
                    maxPointDanger = gfDangers[x];
                }
                if (enemyWave.isMeleeWave && gfDangers[x] / maxDanger > totalDanger / maxDanger + 0.5) {
                    Color binColor = this.getRedBlueColor(LUtils.limit(0.0, Math.pow(Math.max(0.0, gfDangers[x] - totalDanger) / (maxDanger - totalDanger), 2.0), 1.0));
                    g.setColor(binColor);
                    g.fillOval((int)drawLocation.x, (int)drawLocation.y, 7, 7);
                } else if (!enemyWave.isMeleeWave && gfDangers[x] / maxDanger > 0.075) {
                    Color binColor = this.getRedBlueColor(gfDangers[x] / maxDanger);
                    g.setColor(binColor);
                    g.fillOval((int)drawLocation.x, (int)drawLocation.y, 8, 8);
                }
                if (!enemyWave.isMeleeWave) {
                    double length = 25.0 * (gfDangers[x] / maxDanger);
                    LUtils.projectWithCache(enemyWave, 0.0 + bearingOffset, enemyWave.getDistanceTraveled(this._time) - 10.0 + enemyWave.bulletVelocity + length, lengthLocation);
                    g.drawLine((int)drawLocation.x, (int)drawLocation.y, (int)lengthLocation.x, (int)lengthLocation.y);
                }
                drawLocationBuffer = oldDrawLocation;
                oldDrawLocation = drawLocation;
                drawLocation = drawLocationBuffer;
            }
            g.setStroke(cache);
            cache = g.getStroke();
            g.setStroke(this.bs);
            for (SurfWave.BulletShadow shadow : enemyWave.shadows) {
                Point2D.Double p1 = LUtils.project(enemyWave, shadow.minAngle, enemyWave.getDistanceTraveled(this._time) - 2.0);
                Point2D.Double p2 = LUtils.project(enemyWave, shadow.maxAngle, enemyWave.getDistanceTraveled(this._time) - 2.0);
                g.setColor(Color.green);
                g.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
            }
            g.setStroke(cache);
            for (SurfWave.WaveData waveData : enemyWave.waveDataArrayList) {
                for (KNNData<GFData> data : waveData.nearestNeighbors) {
                    g.setColor(data.color);
                    double bearingOffset = (double)waveData.direction * (((GFData)data.data).guessFactor * LUtils.maxEscapeAngle(enemyWave.bulletVelocity));
                    Point2D.Double pos = LUtils.project(enemyWave, waveData.directAngle + bearingOffset, enemyWave.getDistanceTraveled(this._time) - enemyWave.bulletVelocity);
                    int size = (int)(5.0 / Math.sqrt(data.order));
                    g.fillOval((int)pos.x - size, (int)pos.y - size, size * 2, size * 2);
                }
            }
        }
    }

    public Color getRedBlueColor(double d) {
        double colorAmp = 1.8;
        return new Color(Color.HSBtoRGB((float)(0.5 + Math.min(1.0, colorAmp * d / 3.6)), 1.0f, 1.0f));
    }

    public Color getColorForHitRate(double d) {
        return new Color((float)LUtils.limit(0.0, d, 1.0), (float)LUtils.limit(0, 0, 1), (float)LUtils.limit(0.0, 1.0 - d, 1.0));
    }

    static {
        nextMyPos = new Point2D.Double();
    }

    private static class DistanceController {
        private DistanceController() {
        }

        public double surfAttackAngle(double currentDistance) {
            if (currentDistance < 150.0) {
                return this.attackAngle(currentDistance, 1.65);
            }
            if (currentDistance < 250.0) {
                return this.attackAngle(currentDistance, 1.0);
            }
            return this.attackAngle(currentDistance, 0.6);
        }

        public double surfEscapeFromRamAngle(double currentDistance) {
            if (currentDistance < 150.0) {
                return this.attackAngle(currentDistance, 1.0);
            }
            if (currentDistance < 250.0) {
                return this.attackAngle(currentDistance, 1.5);
            }
            return this.attackAngle(currentDistance, 1.0);
        }

        public double orbitAttackAngle(double currentDistance) {
            return this.attackAngle(currentDistance, 1.65);
        }

        private double attackAngle(double currentDistance, double offsetMultiplier) {
            double distanceFactor = (currentDistance - DESIRED_DISTANCE) / DESIRED_DISTANCE;
            return LUtils.limit(-MAX_ATTACK_ANGLE, distanceFactor * offsetMultiplier, MAX_ATTACK_ANGLE);
        }
    }
}

