/*
 * Decompiled with CFR 0.152.
 */
package kid.data.pattern;

import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import kid.data.pattern.Foldable;
import kid.data.pattern.FoldedEntry;

public class FoldedLinkedList<E extends Foldable>
extends AbstractSequentialList<E>
implements List<E>,
Queue<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -239556682937205295L;
    private LinkedList<FoldedEntry<E>> list = new LinkedList();
    private HashMap<Character, LinkedList<FoldedEntry<E>>> foldedList = new HashMap();

    @Override
    public boolean add(E o) {
        char fold = o.getFold();
        FoldedEntry<E> prev = null;
        FoldedEntry<E> prevFold = null;
        if (this.list.size() > 0) {
            prev = this.list.getLast();
        }
        if (!this.foldedList.containsKey(Character.valueOf(fold))) {
            this.foldedList.put(Character.valueOf(fold), new LinkedList());
        } else {
            prevFold = this.foldedList.get(Character.valueOf(fold)).getLast();
        }
        FoldedEntry<E> entry = new FoldedEntry<E>(o, this.list.size(), prev, prevFold);
        return this.list.add(entry) && this.foldedList.get(Character.valueOf(fold)).add(entry);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean answer = true;
        for (Foldable e : c) {
            boolean bl = answer = answer && this.add((E)e);
        }
        return answer;
    }

    @Override
    public void clear() {
        this.list.clear();
        for (LinkedList<FoldedEntry<E>> l : this.foldedList.values()) {
            l.clear();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public E element() {
        return this.list.element().item;
    }

    public E element(char fold) {
        this.element();
        return this.foldedList.get((Object)Character.valueOf((char)fold)).element().item;
    }

    @Override
    public E get(int index) {
        return this.list.get((int)index).item;
    }

    public LinkedList<FoldedEntry<E>> getFold(char fold) {
        return this.foldedList.get(Character.valueOf(fold));
    }

    public HashMap<Character, LinkedList<FoldedEntry<E>>> getFolds() {
        return this.foldedList;
    }

    public E get(int index, char fold) {
        return this.foldedList.get((Object)Character.valueOf((char)fold)).get((int)index).item;
    }

    @Override
    public E getFirst() {
        return this.list.getFirst().item;
    }

    public E getFirst(char fold) {
        return this.foldedList.get((Object)Character.valueOf((char)fold)).getFirst().item;
    }

    @Override
    public E getLast() {
        return this.list.getLast().item;
    }

    public E getLast(char fold) {
        return this.foldedList.get((Object)Character.valueOf((char)fold)).getLast().item;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public int size(char fold) {
        return this.foldedList.get(Character.valueOf(fold)).size();
    }

    @Override
    public boolean offer(E o) {
        return false;
    }

    public boolean offer(E o, char fold) {
        return false;
    }

    @Override
    public E peek() {
        return this.list.peek().item;
    }

    public E peek(char fold) {
        this.peek();
        return this.foldedList.get((Object)Character.valueOf((char)fold)).peek().item;
    }

    @Override
    public E poll() {
        return this.foldedList.get((Object)Character.valueOf((char)this.list.poll().item.getFold())).poll().item;
    }

    public E poll(char fold) {
        this.remove(this.foldedList.get((Object)Character.valueOf((char)fold)).poll().item);
        return this.foldedList.get((Object)Character.valueOf((char)fold)).poll().item;
    }

    @Override
    public E remove() {
        return this.list.remove().item;
    }

    @Override
    public E remove(int index) {
        return null;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListItr(index);
    }

    public void print() {
        String str = "";
        for (FoldedEntry foldedEntry : this.list) {
            str = String.valueOf(str) + foldedEntry.item.getFold() + " - ";
        }
        str = String.valueOf(str) + "\n\n";
        Iterator<Object> iterator = this.foldedList.keySet().iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            LinkedList<FoldedEntry<E>> list = this.foldedList.get(Character.valueOf(c));
            str = String.valueOf(str) + c + ": ";
            for (FoldedEntry foldedEntry : list) {
                str = String.valueOf(str) + foldedEntry.index + " - ";
            }
            str = String.valueOf(str) + "\n";
        }
        str = String.valueOf(str) + "\n";
        System.out.print(str);
    }

    private class ListItr
    implements ListIterator<E> {
        private ListIterator<FoldedEntry<E>> iter;

        ListItr(int index) {
            this.iter = FoldedLinkedList.this.list.listIterator(index);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            return this.iter.next().item;
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public E previous() {
            return this.iter.previous().item;
        }

        @Override
        public int nextIndex() {
            return this.iter.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iter.previousIndex();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        @Override
        public void set(E e) {
        }

        @Override
        public void add(E e) {
        }
    }
}

