/*
 * Decompiled with CFR 0.152.
 */
package kid.management;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kid.communication.BulletMessage;
import kid.data.Drawable;
import kid.data.Printable;
import kid.graphics.RGraphics;
import kid.management.RobotManager;
import kid.robot.RobotData;
import kid.targeting.Targeting;
import kid.virtual.VirtualBullet;
import kid.virtual.VirtualGun;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Condition;
import robocode.Event;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;

public class TargetingManager
implements Drawable,
Printable {
    private AdvancedRobot robot;
    private RobotManager robots;
    private RobotData target;
    private static HashMap<String, List<VirtualGun>> virtualGunTable = null;
    private static List<Targeting> targetings = null;
    private List<Bullet> bullets;

    public TargetingManager(AdvancedRobot myRobot) {
        this.init(myRobot);
    }

    public TargetingManager(AdvancedRobot myRobot, Targeting[] guns) {
        this.init(myRobot);
        if (targetings == null) {
            targetings = new LinkedList<Targeting>();
            Targeting[] targetingArray = guns;
            int n = guns.length;
            int n2 = 0;
            while (n2 < n) {
                Targeting element = targetingArray[n2];
                targetings.add(element);
                ++n2;
            }
        }
    }

    private void init(AdvancedRobot r) {
        this.robot = r;
        this.robots = new RobotManager((Robot)r);
        this.target = new RobotData();
        this.bullets = new ArrayList<Bullet>();
        r.addCustomEvent((Condition)new BulletWatcher(r.getTime()));
        if (virtualGunTable == null) {
            virtualGunTable = new HashMap(r.getOthers());
        } else {
            Set<String> keys = virtualGunTable.keySet();
            for (String s : keys) {
                List<VirtualGun> guns = virtualGunTable.get(s);
                for (VirtualGun g : guns) {
                    g.update(this.robot);
                }
            }
        }
    }

    public void add(Targeting[] newTargetings) {
        if (newTargetings != null) {
            RobotData[] robots = this.robots.getRobots();
            Printable[] printableArray = robots;
            int n = robots.length;
            int n2 = 0;
            while (n2 < n) {
                RobotData r = printableArray[n2];
                List<VirtualGun> guns = virtualGunTable.get(r.getName());
                Targeting[] targetingArray = newTargetings;
                int n3 = newTargetings.length;
                int n4 = 0;
                while (n4 < n3) {
                    Targeting t = targetingArray[n4];
                    guns.add(new VirtualGun(this.robot, r, t));
                    ++n4;
                }
                ++n2;
            }
            printableArray = newTargetings;
            n = newTargetings.length;
            n2 = 0;
            while (n2 < n) {
                Printable t = printableArray[n2];
                targetings.add((Targeting)t);
                ++n2;
            }
        }
    }

    public void add(Targeting t) {
        if (t != null) {
            RobotData[] robots;
            RobotData[] robotDataArray = robots = this.robots.getRobots();
            int n = robots.length;
            int n2 = 0;
            while (n2 < n) {
                RobotData r = robotDataArray[n2];
                virtualGunTable.get(r.getName()).add(new VirtualGun(this.robot, r, t));
                ++n2;
            }
            targetings.add(t);
        }
    }

    public void inEvent(Event e) {
        this.robots.inEvent(e);
        if (e instanceof ScannedRobotEvent) {
            this.handleScannedRobot((ScannedRobotEvent)e);
        }
    }

    private void handleScannedRobot(ScannedRobotEvent event) {
        if (!virtualGunTable.containsKey(event.getName())) {
            virtualGunTable.put(event.getName(), new LinkedList());
            if (targetings != null) {
                List<VirtualGun> guns = virtualGunTable.get(event.getName());
                for (Targeting t : targetings) {
                    guns.add(new VirtualGun(this.robot, this.robots.getRobot(event.getName()), t));
                }
            }
        }
    }

    public Bullet fire(RobotData target, double firePower) {
        return this.fire(target, this.getBestGun(target).getTargeting(), firePower);
    }

    public Bullet fire(RobotData target, Targeting targeting, double firePower) {
        Bullet bullet = this.robot.setFireBullet(firePower);
        if (bullet != null) {
            this.bullets.add(bullet);
            if (virtualGunTable.containsKey(target.getName())) {
                ListIterator<VirtualGun> iterator = virtualGunTable.get(target.getName()).listIterator();
                while (iterator.hasNext()) {
                    VirtualGun gun = iterator.next();
                    gun.fire(bullet.getPower());
                    if (gun.getTargeting() != targeting) continue;
                    gun.fire(bullet);
                }
            }
        }
        return bullet;
    }

    public VirtualBullet[] getBullets() {
        VirtualBullet[] vbullets = new VirtualBullet[this.bullets.size()];
        long time = this.robot.getTime();
        int i = 0;
        while (i < vbullets.length) {
            vbullets[i] = new VirtualBullet(this.bullets.get(i), time);
            ++i;
        }
        return vbullets;
    }

    public void broadcastBullets() {
        if (this.robot instanceof TeamRobot) {
            TeamRobot teamrobot = (TeamRobot)this.robot;
            try {
                teamrobot.broadcastMessage((Serializable)new BulletMessage(this.getBullets(), (Robot)this.robot));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public VirtualGun getBestGun(RobotData target) {
        VirtualGun bestGun = new VirtualGun(this.robot);
        List<VirtualGun> virtualGuns = virtualGunTable.get(target.getName());
        if (virtualGuns != null) {
            double bestHitRate = bestGun.getHitRate();
            for (VirtualGun gun : virtualGuns) {
                double hitRate = gun.getHitRate();
                if (!(hitRate > bestHitRate)) continue;
                bestGun = gun;
                bestHitRate = hitRate;
            }
        }
        return bestGun;
    }

    public VirtualGun[] getVirtualGuns(RobotData target) {
        VirtualGun[] guns = new VirtualGun[]{};
        if (virtualGunTable.containsKey(target.getName())) {
            guns = virtualGunTable.get(target.getName()).toArray(guns);
        }
        return guns;
    }

    @Override
    public void draw(RGraphics grid) {
        Printable[] printableArray = this.robots.getRobots();
        int n = printableArray.length;
        int n2 = 0;
        while (n2 < n) {
            RobotData r = printableArray[n2];
            VirtualGun[] virtualGunArray = this.getVirtualGuns(r);
            int n3 = virtualGunArray.length;
            int n4 = 0;
            while (n4 < n3) {
                VirtualGun g = virtualGunArray[n4];
                g.draw(grid);
                ++n4;
            }
            ++n2;
        }
        printableArray = this.getVirtualGuns(this.target);
        n = printableArray.length;
        n2 = 0;
        while (n2 < n) {
            Printable g = printableArray[n2];
            ((VirtualGun)g).drawGunStats(grid);
            ++n2;
        }
    }

    @Override
    public void print(PrintStream console) {
        RobotData[] robotDataArray = this.robots.getRobots();
        int n = robotDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            RobotData r = robotDataArray[n2];
            VirtualGun[] virtualGunArray = this.getVirtualGuns(r);
            int n3 = virtualGunArray.length;
            int n4 = 0;
            while (n4 < n3) {
                VirtualGun g = virtualGunArray[n4];
                g.print(console);
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
        RobotData[] robotDataArray = this.robots.getRobots();
        int n = robotDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            RobotData r = robotDataArray[n2];
            VirtualGun[] virtualGunArray = this.getVirtualGuns(r);
            int n3 = virtualGunArray.length;
            int n4 = 0;
            while (n4 < n3) {
                VirtualGun g = virtualGunArray[n4];
                g.print(output);
                ++n4;
            }
            ++n2;
        }
    }

    private class BulletWatcher
    extends Condition {
        private long time;

        public BulletWatcher(long curTime) {
            this.time = curTime;
        }

        public boolean test() {
            int i = 0;
            while (i < TargetingManager.this.bullets.size()) {
                Bullet b = (Bullet)TargetingManager.this.bullets.get(i);
                if (!b.isActive()) {
                    TargetingManager.this.bullets.remove(i--);
                }
                ++i;
            }
            ++this.time;
            return false;
        }
    }
}

