/*
 * Decompiled with CFR 0.152.
 */
package kid.movement;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import kid.cluster.Comparison;
import kid.cluster.Space;
import kid.data.Data;
import kid.data.Drawable;
import kid.data.Printable;
import kid.data.factor.GuessFactor;
import kid.graphics.DrawMenu;
import kid.graphics.RGraphics;
import kid.info.RobotInfo;
import kid.robot.EnemyData;
import kid.robot.RobotData;
import kid.segmentation.Segmentable;
import kid.utils.Utils;
import kid.virtual.DataWave;
import kid.virtual.VirtualWave;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class MovementProfiler
implements Drawable,
Printable {
    public static final int PROFILE_VEIWS = 5;
    public static final int ENEMY_LAG = -2;
    private AdvancedRobot robot;
    private RobotInfo info;
    private static boolean flattener = false;
    private RobotData[] profiles;
    private int profiles_position;
    private GuessFactor[] latest;
    private int latestPosition;
    private GuessFactor[] latestHits;
    private int latestHitsPosition;
    private RobotData enemy;
    private ArrayList<DataWave<GuessFactor, RobotData, RobotData>> enemyWaves;
    private ArrayList<DataWave<GuessFactor, RobotData, RobotData>> enemyWavesCF;
    private static HashMap<String, Space<GuessFactor, RobotData, RobotData>> hitSpace = null;
    private static HashMap<String, Space<GuessFactor, RobotData, RobotData>> allSpace = null;
    private Comparison[] comparisons = null;
    private int dataPerWave = 10;

    public MovementProfiler(AdvancedRobot myRobot, Comparison[] comparisons) {
        this.init(myRobot, comparisons, -1);
    }

    public MovementProfiler(AdvancedRobot myRobot, Comparison[] comparisons, int dataPerWave) {
        this.init(myRobot, comparisons, dataPerWave);
    }

    private void init(AdvancedRobot r, Comparison[] c, int d) {
        this.robot = r;
        this.info = new RobotInfo((Robot)this.robot);
        this.profiles = new RobotData[5];
        this.profiles[0] = new RobotData((Robot)this.robot);
        this.profiles_position = 1;
        this.latest = new GuessFactor[2];
        this.latestPosition = 0;
        this.latestHits = new GuessFactor[1];
        this.latestHitsPosition = 0;
        this.enemy = null;
        this.enemyWaves = new ArrayList();
        this.enemyWavesCF = new ArrayList();
        this.robot.addCustomEvent((Condition)new WaveTracker());
        this.comparisons = c;
        if (d > 0) {
            this.dataPerWave = d;
        }
        if (hitSpace == null) {
            hitSpace = new HashMap();
            allSpace = new HashMap();
        }
    }

    public void inEvent(Event event) {
        if (this.info.getOthers() <= 1) {
            if (event instanceof ScannedRobotEvent) {
                this.handleScannedRobot((ScannedRobotEvent)event);
            } else if (event instanceof DeathEvent) {
                this.handleDeathEvent((DeathEvent)event);
            } else if (event instanceof WinEvent) {
                this.handleWinEvent((WinEvent)event);
            } else if (event instanceof RobotDeathEvent) {
                this.handleRobotDeathEvent((RobotDeathEvent)event);
            } else if (event instanceof HitByBulletEvent) {
                this.handleHitByBullet((HitByBulletEvent)event);
            } else if (event instanceof BulletHitBulletEvent) {
                this.handleBulletHitBullet((BulletHitBulletEvent)event);
            }
        }
    }

    public ArrayList<DataWave<GuessFactor, RobotData, RobotData>> getWaves() {
        if (flattener) {
            return this.enemyWavesCF;
        }
        return this.enemyWaves;
    }

    public boolean isFlattening() {
        return flattener;
    }

    public GuessFactor[] getLatest() {
        if (flattener) {
            return new GuessFactor[0];
        }
        return this.latest;
    }

    public GuessFactor[] getLatestHits() {
        if (flattener) {
            return new GuessFactor[0];
        }
        return this.latestHits;
    }

    private final void handleDeathEvent(DeathEvent event) {
        this.enemy = null;
    }

    private final void handleWinEvent(WinEvent event) {
        this.enemy = null;
    }

    private final void handleRobotDeathEvent(RobotDeathEvent event) {
        this.enemy = null;
    }

    private final void handleScannedRobot(ScannedRobotEvent event) {
        if (this.enemy == null) {
            this.enemy = new EnemyData(event, (Robot)this.robot);
            if (!hitSpace.containsKey(this.enemy.getName())) {
                hitSpace.put(this.enemy.getName(), new Space(this.comparisons));
                allSpace.put(this.enemy.getName(), new Space(this.comparisons));
            }
        } else {
            double deltaEnergy = event.getEnergy() - this.enemy.getEnergy();
            double deltaVelocity = event.getVelocity() - this.enemy.getVelocity();
            if (this.enemy.getDeltaEnergy() == 0.1 && deltaEnergy == 0.1) {
                this.enemyWaves.remove(this.enemyWaves.size() - 1);
                this.enemyWavesCF.remove(this.enemyWavesCF.size() - 1);
            } else if (Utils.limit(-3.000001, deltaEnergy, -0.099999) == deltaEnergy && Math.abs(deltaVelocity) <= Math.max(1.0, 2.0) && Math.abs(this.enemy.getDeltaVelocity()) <= Math.max(1.0, 2.0) && deltaEnergy != this.enemy.getDeltaEnergy()) {
                RobotData seenRobot = this.getProfile(-2);
                Data[] hitData = hitSpace.get(this.enemy.getName()).getCluster(seenRobot, this.enemy, this.dataPerWave).toArray(new GuessFactor[0]);
                Data[] allData = allSpace.get(this.enemy.getName()).getCluster(seenRobot, this.enemy, this.dataPerWave).toArray(new GuessFactor[0]);
                DataWave wave = new DataWave(this.enemy, seenRobot, Math.abs(deltaEnergy), hitData, (Segmentable)seenRobot, (Segmentable)this.enemy.copy());
                DataWave waveCF = new DataWave(this.enemy, seenRobot, Math.abs(deltaEnergy), allData, (Segmentable)seenRobot, (Segmentable)this.enemy.copy());
                this.enemyWaves.add(wave);
                this.enemyWavesCF.add(waveCF);
            }
            this.enemy.update(event, (Robot)this.robot);
        }
    }

    private final void handleHitByBullet(HitByBulletEvent event) {
        this.handleBulletEvent(event.getBullet());
    }

    private final void handleBulletHitBullet(BulletHitBulletEvent event) {
        this.handleBulletEvent(event.getHitBullet());
    }

    private final void handleBulletEvent(Bullet b) {
        DataWave<GuessFactor, RobotData, RobotData> wave;
        if (this.enemy != null && !this.enemy.isDummy() && (wave = Utils.findWaveMatch(this.enemyWaves, b, this.robot.getTime())) != null) {
            boolean temp;
            this.enemyWaves.remove(wave);
            GuessFactor gf = new GuessFactor(Utils.getGuessFactor(wave, wave.getView(), b));
            hitSpace.get(this.enemy.getName()).add(gf, wave.getView(), wave.getReference());
            this.latestHits[this.latestHitsPosition % this.latestHits.length] = gf;
            ++this.latestHitsPosition;
            double[] bins = this.getBins(wave, 51);
            double max = 1.0;
            double[] dArray = bins;
            int n = bins.length;
            int n2 = 0;
            while (n2 < n) {
                double i = dArray[n2];
                max = Math.max(max, i);
                ++n2;
            }
            flattener = temp = bins[Utils.getIndex(gf.getGuessFactor(), 51)] / max < 0.5;
        }
    }

    private double[] getBins(DataWave<GuessFactor, RobotData, RobotData> wave, int numOfBins) {
        int i;
        GuessFactor gf;
        double[] bins = new double[numOfBins];
        GuessFactor[] guessFactorArray = (GuessFactor[])wave.getData();
        int n = guessFactorArray.length;
        int n2 = 0;
        while (n2 < n) {
            gf = guessFactorArray[n2];
            i = 0;
            while (i < numOfBins) {
                int n3 = i;
                bins[n3] = bins[n3] + Utils.limit(0.0, 10.0 / (50.0 * Utils.sqr(Utils.getGuessFactor(i, numOfBins) - gf.getGuessFactor()) + 1.0) - 4.95, 5.0);
                ++i;
            }
            ++n2;
        }
        guessFactorArray = this.getLatest();
        n = guessFactorArray.length;
        n2 = 0;
        while (n2 < n) {
            gf = guessFactorArray[n2];
            if (gf != null) {
                i = 0;
                while (i < numOfBins) {
                    int n4 = i;
                    bins[n4] = bins[n4] + Utils.limit(0.0, 10.0 / (50.0 * Utils.sqr(Utils.getGuessFactor(i, numOfBins) - gf.getGuessFactor()) + 1.0) - 4.95, 5.0);
                    ++i;
                }
            }
            ++n2;
        }
        guessFactorArray = this.getLatestHits();
        n = guessFactorArray.length;
        n2 = 0;
        while (n2 < n) {
            gf = guessFactorArray[n2];
            if (gf != null) {
                i = 0;
                while (i < numOfBins) {
                    int n5 = i;
                    bins[n5] = bins[n5] + Utils.limit(0.0, 10.0 / (50.0 * Utils.sqr(Utils.getGuessFactor(i, numOfBins) - gf.getGuessFactor()) + 1.0) - 4.95, 5.0);
                    ++i;
                }
            }
            ++n2;
        }
        return bins;
    }

    private int getProfilesPosition(int difference) {
        return (this.profiles_position + difference) % this.profiles.length;
    }

    private RobotData getProfile(int difference) {
        return this.profiles[this.getProfilesPosition(difference)];
    }

    @Override
    public void print(PrintStream console) {
        hitSpace.get(this.enemy.getName()).print(console);
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
        hitSpace.get(this.enemy.getName()).print(output);
    }

    @Override
    public void draw(RGraphics grid) {
        this.drawEnemyWaves(grid);
    }

    public void drawEnemyWaves(RGraphics grid) {
        if (DrawMenu.getValue("Enemy Waves", "Profile", true)) {
            for (DataWave<GuessFactor, RobotData, RobotData> w : this.getWaves()) {
                double dist = w.getDist(grid.getTime()) - 5.0;
                double[] bins = this.getBins(w, 51);
                double max = 1.0;
                double[] dArray = bins;
                int n = bins.length;
                int n2 = 0;
                while (n2 < n) {
                    double i = dArray[n2];
                    max = Math.max(max, i);
                    ++n2;
                }
                grid.setStroke(new BasicStroke(1.5f));
                float hue = 0.0f;
                double heading = w.getHeading();
                double x = w.getStartX();
                double y = w.getStartY();
                RobotData view = w.getView();
                double d = Utils.getDirection(view.getHeading(), view.getVelocity(), Utils.angle(x, y, view.getX(), view.getY()));
                double angle = d * Utils.getMaxEscapeAngle(w.getFirePower());
                double angleGF = heading + angle * Utils.getGuessFactor(0, bins.length);
                double prevX = Utils.getX(x, dist, angleGF);
                double prevY = Utils.getY(y, dist, angleGF);
                int i = 1;
                while (i < bins.length) {
                    float brightness = (float)(0.1 + 0.9 * bins[i] / max);
                    grid.setColor(Color.getHSBColor(hue, 1.0f, brightness));
                    angleGF = heading + angle * Utils.getGuessFactor(i, bins.length);
                    double d2 = prevX;
                    double d3 = prevY;
                    prevX = Utils.getX(x, dist, angleGF);
                    prevY = Utils.getY(y, dist, angleGF);
                    grid.drawLine(d2, d3, prevX, prevY);
                    ++i;
                }
            }
        }
    }

    private class WaveTracker
    extends Condition {
        private WaveTracker() {
        }

        public boolean test() {
            DataWave w;
            int i = 0;
            while (i < MovementProfiler.this.enemyWaves.size()) {
                w = (DataWave)MovementProfiler.this.enemyWaves.get(i);
                if (w.testHit(MovementProfiler.this.robot.getX(), MovementProfiler.this.robot.getY(), MovementProfiler.this.robot.getTime() - 1L) || !w.active(MovementProfiler.this.robot.getTime())) {
                    MovementProfiler.this.enemyWaves.remove(i);
                    --i;
                }
                ++i;
            }
            i = 0;
            while (i < MovementProfiler.this.enemyWavesCF.size()) {
                w = (DataWave)MovementProfiler.this.enemyWavesCF.get(i);
                if (w.testHit(MovementProfiler.this.robot.getX(), MovementProfiler.this.robot.getY(), MovementProfiler.this.robot.getTime() - 1L) || !w.active(MovementProfiler.this.robot.getTime())) {
                    RobotData newRobot = MovementProfiler.this.getProfile(-1).copy();
                    GuessFactor gf = new GuessFactor(Utils.getGuessFactor((VirtualWave)w, (RobotData)w.getView(), newRobot));
                    if (MovementProfiler.this.enemy != null) {
                        ((Space)allSpace.get(MovementProfiler.this.enemy.getName())).add(gf, (RobotData)w.getView(), (RobotData)w.getReference());
                    }
                    ((MovementProfiler)MovementProfiler.this).latest[((MovementProfiler)MovementProfiler.this).latestPosition % ((MovementProfiler)MovementProfiler.this).latest.length] = gf;
                    MovementProfiler movementProfiler = MovementProfiler.this;
                    movementProfiler.latestPosition = movementProfiler.latestPosition + 1;
                    MovementProfiler.this.enemyWavesCF.remove(i);
                    --i;
                }
                ++i;
            }
            RobotData newRobot = MovementProfiler.this.getProfile(-1).copy();
            newRobot.update((Robot)MovementProfiler.this.robot);
            ((MovementProfiler)MovementProfiler.this).profiles[((MovementProfiler)MovementProfiler.this).getProfilesPosition((int)0)] = newRobot;
            MovementProfiler movementProfiler = MovementProfiler.this;
            movementProfiler.profiles_position = movementProfiler.profiles_position + 1;
            return false;
        }
    }
}

