/*
 * Decompiled with CFR 0.152.
 */
package brainfade.melee;

import brainfade.melee.utils.Enemy;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Dusk
extends AdvancedRobot {
    static Hashtable targets;
    static Enemy target;
    final double pi = Math.PI;
    double firePower = 3.0;
    Point2D whereToGo;
    double bulletSpeed;
    Point2D position = new Point2D.Double();
    Point2D lastPosition = new Point2D.Double();
    Point2D middle;
    double wallRisk;
    double movementLateralAngle = 0.2;
    Point2D lastDest;
    Point2D lastLastDest;
    Point2D dest;
    static double hits;
    static long time;

    public Dusk() {
        this.position = new Point2D.Double();
        this.whereToGo = new Point2D.Double();
        this.lastDest = new Point2D.Double();
        this.lastLastDest = new Point2D.Double();
    }

    public void run() {
        if (targets == null) {
            targets = new Hashtable();
        }
        Dusk.target.distance = 1000.0;
        this.setColors(Color.yellow, Color.black, Color.white);
        this.position = this.middle = new Point2D.Double(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.turnRadarRightRadians(Math.PI * 2);
        while (true) {
            if (this.getTime() % 25L == 0L) {
                this.lastLastDest = new Point2D.Double(this.getX(), this.getY());
            }
            this.position.setLocation(this.getX(), this.getY());
            if (this.getOthers() < 2) {
                this.doMove();
            }
            if (this.getEnergy() - this.firePower > 0.1 || Dusk.target.energy == 0.0) {
                this.setFire(this.firePower);
            }
            this.doGun();
            this.doRadar();
            this.execute();
        }
    }

    public void doGun() {
        this.firePower = Math.max(Math.min(Math.max((20.0 - Dusk.target.distance / 23.0) / 3.0, 400.0 / Dusk.target.distance), 3.0), 0.1);
        long time = 0L;
        Point2D.Double p = new Point2D.Double(Dusk.target.position.getX(), Dusk.target.position.getY());
        for (int i = 0; i < 10; ++i) {
            long nextTime = (int)Math.round(this.getrange(this.getX(), this.getY(), p.x, p.y) / (20.0 - 3.0 * this.firePower));
            time = this.getTime() + nextTime;
            p = target.guessPosition(time);
        }
        if (p.x < 0.0) {
            p.x = 0.0;
        }
        if (p.y < 0.0) {
            p.y = 0.0;
        }
        if (p.x > this.getBattleFieldWidth()) {
            p.x = this.getBattleFieldWidth();
        }
        if (p.y > this.getBattleFieldHeight()) {
            p.y = this.getBattleFieldHeight();
        }
        double gunOffset = this.getGunHeadingRadians() - (1.5707963267948966 - Math.atan2(p.y - this.getY(), p.x - this.getX()));
        this.setTurnGunLeftRadians(Utils.normalRelativeAngle((double)gunOffset));
    }

    public double getrange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public void doMove() {
        if (this.getOthers() < 2) {
            this.considerChangingDirection();
            Point2D robotDestination = null;
            double tries = 0.0;
            do {
                robotDestination = this.vectorToLocation(this.absoluteBearing(Dusk.target.position, this.position) + this.movementLateralAngle, Dusk.target.distance * (1.1 - tries / 100.0), Dusk.target.position);
            } while ((tries += 1.0) < 100.0 && !this.fieldRectangle(35.0).contains(robotDestination));
            if (target.getMyAdvancingVelocity(this.position, robotDestination) > 0.75) {
                this.movementLateralAngle *= -1.0;
            }
            this.goTo(robotDestination);
        } else {
            double initDistance;
            double currDistance;
            double bestDistance = currDistance = (initDistance = Math.max(50.0, 0.5 * Dusk.target.distance));
            double bestBearing = this.absoluteBearing(this.position, this.middle);
            double bestRisk = 1000.0;
            for (double i = 0.0; i < 360.0; i += 6.0) {
                double currentBearing = Math.toRadians(i);
                boolean tries = false;
                double thisDist = currDistance;
                Point2D destination = this.vectorToLocation(currentBearing, thisDist, this.position);
                double currentRisk = this.getRisk(destination);
                if (currentRisk < bestRisk) {
                    bestBearing = currentBearing;
                    bestDistance = thisDist;
                    bestRisk = currentRisk;
                }
                currDistance = initDistance;
            }
            this.wallRisk = bestRisk;
            this.lastDest = this.dest = this.vectorToLocation(bestBearing, bestDistance, this.position);
            this.goTo(this.dest);
        }
    }

    public double getRisk(Point2D destination) {
        if (!this.fieldRectangle(35.0).contains(destination)) {
            return Double.POSITIVE_INFINITY;
        }
        Line2D.Double path = new Line2D.Double(this.position, destination);
        double moveDist = destination.distance(this.position);
        double risk = 1.0;
        Enumeration e = targets.elements();
        double myEnergy = this.getEnergy();
        long currentTime = this.getTime();
        double distance = 1.0;
        double bots = 1.0E-11;
        while (true) {
            double thisRisk = 1.0;
            if (!e.hasMoreElements()) break;
            Enemy temp = (Enemy)e.nextElement();
            Point2D enPos = temp.position;
            double threat = temp.energy / myEnergy;
            thisRisk *= threat;
            if (temp.whosClosest(targets) || this.getTime() - Dusk.target.firetime < 250L) {
                thisRisk *= 2.0 + Math.abs(temp.getMyAdvancingVelocity(this.position, destination));
            }
            thisRisk *= 3.0 + 2.0 * temp.getTheirAdvancingVelocity(destination);
            thisRisk /= destination.distanceSq(enPos);
            if (!temp.isAlive) continue;
            risk += thisRisk;
        }
        risk += 0.5 / destination.distanceSq(this.lastLastDest);
        risk += 0.1 / destination.distanceSq(this.middle);
        if (this.changeDirection(distance / bots)) {
            this.lastLastDest = this.lastDest;
        }
        return risk;
    }

    void considerChangingDirection() {
        double factor = 11.9 / Dusk.target.distance;
        double flattenerFactor = Math.pow(factor, factor);
        if (Math.random() > flattenerFactor) {
            this.movementLateralAngle *= -1.0;
        }
    }

    boolean changeDirection(double dist) {
        return this.getTime() % (long)((int)(dist / (Math.max(0.1, Dusk.target.bulletVelocity) * 1.5))) == 0L;
    }

    void goTo(Point2D destination) {
        double angle = Utils.normalRelativeAngle((double)(this.absoluteBearing(this.position, destination) - this.getHeadingRadians()));
        double turnAngle = Math.atan(Math.tan(angle));
        this.setTurnRightRadians(turnAngle);
        this.setAhead(this.position.distance(destination) * (double)(angle == turnAngle ? 1 : -1));
    }

    public void doRadar() {
        this.setTurnRadarRightRadians(Math.PI * 2);
        if ((this.getOthers() == 1 || this.getGunHeat() < 0.7) && Dusk.target.isAlive && this.getTime() - Dusk.target.scantime < 15L) {
            this.setTurnRadarRightRadians(Math.sin(Dusk.target.bearing - this.getRadarHeadingRadians()) * 1.5);
        }
    }

    public Rectangle2D fieldRectangle(double margin) {
        return new Rectangle2D.Double(margin, margin, this.getBattleFieldWidth() - margin * 2.0, this.getBattleFieldHeight() - margin * 2.0);
    }

    public Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    public double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public int sign(double value) {
        return value >= 0.0 ? 1 : -1;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy en;
        if (targets.containsKey(e.getName())) {
            en = (Enemy)targets.get(e.getName());
        } else {
            en = new Enemy();
            targets.put(e.getName(), en);
        }
        en.update(e, this);
        en.isAlive = true;
        double gunTurnTime = Math.abs(Utils.normalRelativeAngle((double)(this.absoluteBearing(this.position, en.position) - this.getGunHeadingRadians()))) / Math.toRadians(20.0);
        if (!Dusk.target.isAlive || Dusk.target.distance * 0.9 > en.distance) {
            target = en;
        }
        if (this.getOthers() > 1) {
            this.doMove();
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Enemy en = (Enemy)targets.get(e.getName());
        en.bulletVelocity = e.getVelocity();
        en.firepower = e.getPower();
        en.firetime = this.getTime();
        hits += e.getPower();
        ++time;
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Enemy en = (Enemy)targets.get(e.getName());
        en.isAlive = false;
        this.log(e.getName() + " has died");
    }

    public void log(String message) {
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        this.out.println("skipped");
    }

    public void onWin(WinEvent e) {
        this.atEnd();
    }

    public void onDeath(DeathEvent e) {
        this.atEnd();
    }

    public void atEnd() {
        this.log("Position: " + (this.getOthers() + 1));
        this.out.println("Time:       " + time);
        this.out.println("Hits:       " + hits);
        this.out.println("Hit Average " + hits / (double)time);
    }

    static {
        target = new Enemy();
        hits = 0.0;
    }
}

