/*
 * Decompiled with CFR 0.152.
 */
package mb.movement;

import java.awt.Graphics2D;
import mb.MBRobot;
import mb.core.Coordinates;
import mb.movement.Movement;
import mb.utils.MathUtils;
import mb.utils.PaintUtils;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;

public class WallSmoother
extends Movement {
    private PaintUtils paintUtils;

    public WallSmoother(MBRobot me) {
        super(me);
        movedirection = 1;
        this.minDistanceToWall = 24.0;
        this.paintUtils = new PaintUtils(me.getGraphics());
    }

    @Override
    public void onHitRobot(HitRobotEvent event) {
        this.toggleDirection();
        super.onHitRobot(event);
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        this.paintBattleField();
        int closingIn = 2;
        if (event.getDistance() < this.battleFieldHeight / 2.0) {
            closingIn = 4;
        }
        if (event.getDistance() > this.battleFieldHeight * 3.0 / 4.0) {
            closingIn = -2;
        }
        if (event.getDistance() > this.battleFieldHeight * 6.0 / 8.0) {
            // empty if block
        }
        closingIn = -4;
        double lastBearing = event.getBearing() + 90.0 + (double)(movedirection * closingIn);
        double angle = (this.getHeading() + lastBearing) % 360.0;
        Coordinates myCoords = this.getMyCoordinates();
        Coordinates moveTo = MathUtils.getCoordinates(myCoords, angle, 36 * movedirection);
        int i = 1;
        while (!this.isInsideBattleField(moveTo)) {
            angle = (this.getHeading() + (lastBearing -= (double)(movedirection * 2))) % 360.0;
            moveTo = MathUtils.getCoordinates(myCoords, angle, 36 * movedirection);
            if (++i > 20) {
                this.toggleDirection();
                i = 1;
                break;
            }
            this.paintUtils.paintVector(myCoords, angle, 100 * movedirection);
        }
        this.paintUtils.paintVector(myCoords, angle, 100 * movedirection);
        this.getRobot().setAdjustRadarForGunTurn(true);
        this.getRobot().setAdjustRadarForRobotTurn(true);
        this.setTurnRight(lastBearing);
        this.setAhead(100 * movedirection);
    }

    public String toString() {
        return "WallSmoother [minDistanceToWall=" + this.minDistanceToWall + "]";
    }

    private void paintBattleField() {
        Graphics2D graphic = this.getRobot().getGraphics();
        graphic.drawRect((int)this.minDistanceToWall, (int)this.minDistanceToWall, (int)(this.battleFieldWidth - 2.0 * this.minDistanceToWall), (int)(this.battleFieldHeight - 2.0 * this.minDistanceToWall));
    }
}

