/*
 * Decompiled with CFR 0.152.
 */
package catcat20.atom.move.surf.models;

import catcat20.atom.robot.BotState;
import catcat20.atom.utils.HUtils;
import catcat20.atom.utils.Wave;
import catcat20.atom.utils.knn.DataPointMaker;

public class SimpleModel
extends DataPointMaker {
    public SimpleModel() {
        this.weights = new double[]{1.0, 8.0, 2.0};
    }

    @Override
    public double[] dataPointFromWave(Wave w) {
        BotState previousMyState = w.prevMyState;
        BotState myState = w.myState;
        double latVel = myState.getVelocity() * Math.sin(myState.getHeading() - w.directAngle);
        double accel = HUtils.limit(-2.0, HUtils.accel(myState.getVelocity(), previousMyState.getVelocity()), 1.0);
        return new double[]{myState.getPosition().distance(w) / 1300.0, (latVel + 8.0) / 16.0, (accel / (accel < 0.0 ? 2.0 : 1.0) + 1.0) / 2.0};
    }
}

