/*
 * Decompiled with CFR 0.152.
 */
package cb.ml;

import cb.ml.Features;
import cb.ml.Movement;
import cb.ml.ObservationType;
import cb.util.BattleFieldUtils;
import cb.util.KdTree;
import java.util.List;

public class BaselineMovement
implements Movement {
    private static final int BINS = 31;
    private KdTree<Double> tree = new KdTree.Manhattan<Double>(4, 500);

    @Override
    public void addPoint(Features features, double guessFactor, ObservationType observationType) {
        if (observationType != ObservationType.MISS) {
            this.tree.addPoint(this.getLocation(features), guessFactor);
        }
    }

    @Override
    public double getProbability(Features features, double minGuessFactor, double maxGuessFactor) {
        List<KdTree.Entry<Double>> entries = this.tree.nearestNeighbor(this.getLocation(features), 13, false);
        double[] c = new double[31];
        for (KdTree.Entry<Double> entry : entries) {
            int index = (int)Math.round(15.0 * ((Double)entry.value + 1.0));
            for (int i = 0; i < 31; ++i) {
                int n = i;
                c[n] = c[n] + 1.0 / (1.0 + Math.pow(i - index, 2.0)) / (1.0 + entry.distance);
            }
        }
        double min = BattleFieldUtils.limit(-1.0, minGuessFactor, 1.0);
        double max = BattleFieldUtils.limit(-1.0, maxGuessFactor, 1.0);
        int minIndex = (int)Math.floor(15.0 * (min + 1.0));
        int maxIndex = (int)Math.ceil(15.0 * (max + 1.0));
        double sum = 0.0;
        int n = 0;
        for (int i = minIndex; i <= maxIndex; ++i) {
            sum += c[i];
            ++n;
        }
        double total = 0.0;
        for (int i = 0; i < 31; ++i) {
            total += c[i];
        }
        return sum / total / (double)n * 0.5 * (max - min);
    }

    private double[] getLocation(Features features) {
        double[] location = new double[]{features.getFeature("myAdvancingVelocity") / 16.0, features.getFeature("enemyBulletPower") / 3.0, 1.0 / (1.0 + features.getFeature("distance") / 160.0), features.getFeature("myLateralVelocity") / 8.0};
        return location;
    }
}

