/*
 * Decompiled with CFR 0.152.
 */
package fnc.bandit2002;

import fnc.bandit2002.Force;
import fnc.bandit2002.Path;
import fnc.bandit2002.Position;
import fnc.bandit2002.Util;
import java.io.PrintStream;
import java.util.Random;
import robocode.BulletHitEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Attractor {
    String name;
    Path path;
    PrintStream output;
    final int maxpositions = 60;
    Random rand;
    public int headcount;
    double width;
    double height;
    double d;
    Force force;
    Position position;
    Position save_position;
    Position position_robot_when_fired;
    Position fire_position;
    boolean fired;
    int fire_watchdog;
    int hit_watchdog;
    int ram_watchdog;
    boolean is_target;
    int number_of_hits_taken;
    int number_of_bullets_fired_on;
    double hit_ratio;
    double energy;

    public long getScanTime() {
        return (long)this.position.t;
    }

    public void countZero() {
        if (this.hit_watchdog > 0) {
            --this.hit_watchdog;
        }
        if (this.fire_watchdog > 0) {
            --this.fire_watchdog;
        }
        if (this.ram_watchdog > 0) {
            --this.ram_watchdog;
        }
    }

    public void hasHit(Position arg_p) {
    }

    public void deathStatistics(PrintStream o) {
        o.println("# fired on:   " + this.number_of_bullets_fired_on);
        o.println("# hits taken: " + this.number_of_hits_taken);
        if (this.number_of_bullets_fired_on > 0) {
            o.println("ratio " + this.hit_ratio);
        }
    }

    public void hit(BulletHitEvent arg_e, long arg_time, Position arg_p) {
        this.energy = arg_e.getEnergy();
        ++this.number_of_hits_taken;
        if ((double)arg_time - this.fire_position.t > 10.0) {
            this.fire_position.t = this.position.t;
            this.fire_position.x = this.position.x;
            this.fire_position.y = this.position.y;
            this.position_robot_when_fired.x = arg_p.x;
            this.position_robot_when_fired.y = arg_p.y;
            this.fired = true;
        }
        if (this.number_of_bullets_fired_on > 0) {
            this.hit_ratio = (double)this.number_of_hits_taken / (double)this.number_of_bullets_fired_on;
        }
        if (this.hit_ratio > 1.0) {
            this.output.println("Ough  hitratio > 1");
        }
    }

    public void firedOn() {
        ++this.number_of_bullets_fired_on;
        this.hit_ratio = (double)this.number_of_hits_taken / (double)this.number_of_bullets_fired_on;
    }

    public void istarget() {
        this.is_target = true;
    }

    public void untarget() {
        this.is_target = false;
    }

    public void analyse() {
        this.path.analyse();
        if (this.headcount <= 10) {
            this.path.analyseJiggle();
        }
    }

    public void update(ScannedRobotEvent e, double arg_x, double arg_y, long arg_time, Position arg_p) {
        this.position.t = arg_time;
        this.position.x = arg_x;
        this.position.y = arg_y;
        this.position.h = e.getHeadingRadians();
        this.path.add(this.position);
        if (e.getEnergy() < this.energy) {
            this.fire_position.t = this.position.t;
            this.fire_position.x = this.position.x;
            this.fire_position.y = this.position.y;
            this.position_robot_when_fired.x = arg_p.x;
            this.position_robot_when_fired.y = arg_p.y;
            this.fired = true;
        }
        this.energy = e.getEnergy();
    }

    public String getName() {
        return this.name;
    }

    public Position getPosition() {
        return new Position(this.position);
    }

    public void dump(PrintStream o) {
        o.println(this.name + ' ' + this.position);
        this.path.analyse();
        this.path.dumpAnalysis(o);
    }

    public double gunOffset(Position arg_p, double arg_gunheading, double arg_firePower, double arg_curtime) {
        double impact_time = this.impactTime(arg_p, 1.0, 10.0, arg_firePower, arg_curtime);
        Position predicted_position = this.path.predictPosition(impact_time, arg_curtime);
        double bearing = arg_p.bearing(predicted_position);
        double offset = Util.offset(arg_gunheading, bearing);
        return offset;
    }

    double impactTime(Position arg_p, double arg_t0, double arg_t1, double arg_firePower, double arg_curtime) {
        double x = arg_t1;
        double prev_x = arg_t0;
        int iteration_count = 0;
        double prev_fx = this.f(arg_p, prev_x, arg_firePower, arg_curtime);
        double fx = 0.0;
        while (Math.abs(x - prev_x) > 0.05 && iteration_count < 15) {
            ++iteration_count;
            fx = this.f(arg_p, x, arg_firePower, arg_curtime);
            Double t2 = new Double(fx);
            if (fx - prev_fx == 0.0) break;
            double next_x = x - fx * (x - prev_x) / (fx - prev_fx);
            prev_x = x;
            x = next_x;
            prev_fx = fx;
        }
        return x;
    }

    double f(Position arg_p, double arg_t, double arg_firePower, double arg_curtime) {
        double bulletspeed = 20.0 - (double)3 * arg_firePower;
        Position predicted_position = this.path.predictPosition(arg_t, arg_curtime);
        return arg_p.distance(predicted_position) - bulletspeed * arg_t;
    }

    public final void rammed(Position arg_p, HitRobotEvent arg_e) {
        this.energy = arg_e.getEnergy();
        this.ram_watchdog = 20;
    }

    public final Force force(Position arg_p, long arg_time) {
        double distance = this.position.distance(arg_p);
        double strength = 0.0;
        if (this.ram_watchdog > 0) {
            this.force.setForce(this.position, arg_p, -1.0);
        } else if (this.headcount > 2) {
            if (distance < 200.0) {
                this.force.setForce(this.position, arg_p, -2.0);
            } else if (distance < 0.2 * this.d) {
                this.force.setForce(this.position, arg_p, -1.0);
            }
            if (distance > 0.3 * this.d) {
                this.force.setForce(this.position, arg_p, 0.1);
            }
        } else if (this.headcount >= 1) {
            if ((double)arg_time - this.fire_position.t < 15.0) {
                if (this.fired) {
                    int i = this.rand.nextInt(2);
                    if (i == 8) {
                        this.save_position.x = this.rand.nextInt((int)this.width);
                        this.save_position.y = this.rand.nextInt((int)this.height);
                        this.force.setForce(this.fire_position, this.position_robot_when_fired, 1.0);
                    } else {
                        if (distance < 0.2 * this.width) {
                            this.force.setForce(this.fire_position, this.position_robot_when_fired, -1.0);
                        } else {
                            this.force.setForce(this.fire_position, this.position_robot_when_fired, 1.0);
                        }
                        i = this.rand.nextInt(2);
                        if (i == 1) {
                            this.force.rotate(1.2566370614359172);
                        } else {
                            this.force.rotate(-1.2566370614359172);
                        }
                    }
                    this.fired = false;
                }
            } else {
                if (distance < 0.1 * this.width) {
                    this.force.setForce(this.position, arg_p, -1.0);
                    this.force.rotate(1.2566370614359172);
                }
                if (distance > 0.2 * this.width) {
                    this.force.setForce(this.position, arg_p, 1.0);
                    this.force.rotate(1.2566370614359172);
                }
            }
        }
        return this.force;
    }

    public double firePower(Position arg_p) {
        double distance = this.position.distance(arg_p);
        double power = this.headcount > 2 ? (double)3 : (double)2 + this.hit_ratio;
        if (distance < 200.0) {
            power = 3;
        }
        if (this.ram_watchdog > 0) {
            power = 3;
        }
        return power;
    }

    public double bounty(double arg_min_distance, Position arg_position, double arg_heading) {
        double bounty = 0.5 * arg_min_distance / this.position.distance(arg_position);
        return bounty;
    }

    private final /* synthetic */ void this() {
        this.maxpositions = 60;
    }

    public Attractor(String arg_name, Position arg_p, double arg_energy, double arg_w, double arg_h, PrintStream arg_output) {
        this.this();
        this.width = arg_w;
        this.height = arg_h;
        this.d = Math.sqrt(this.width * this.width + this.height * this.height);
        this.output = arg_output;
        this.name = arg_name;
        this.energy = arg_energy;
        this.position = new Position(arg_p);
        this.save_position = new Position(arg_p);
        this.position_robot_when_fired = new Position(arg_p);
        this.path = new Path(arg_p, arg_w, arg_h, arg_output);
        this.force = new Force();
        this.hit_watchdog = 0;
        this.ram_watchdog = 0;
        this.headcount = 0;
        this.rand = new Random();
        this.fired = false;
        this.is_target = false;
        this.number_of_hits_taken = 0;
        this.number_of_bullets_fired_on = 0;
        this.hit_ratio = 0.0;
        this.fire_position = new Position(arg_p);
    }
}

