/*
 * Decompiled with CFR 0.152.
 */
package vuen.fractal;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import vuen.fractal.data.Events;
import vuen.fractal.data.Memory;
import vuen.fractal.gun.Gunner;
import vuen.fractal.move.Mover;
import vuen.fractal.util.BotMath;
import vuen.fractal.util.HUD;
import vuen.fractal.util.Misc;

public class FractalE {
    public boolean move = true;
    public boolean gun = true;
    public AdvancedRobot robot;
    public static Memory memory;
    public static Events events;
    public static Mover mover;
    public static Gunner gunner;
    public static HUD hud;
    public static Object renderer;
    public static boolean gl;
    public static boolean glhud;
    public static boolean glgraph;
    public static boolean glroll;
    public static boolean glzone;
    public static boolean glvec;
    public static boolean glwave;
    public long radartick = 0L;
    double theta = 0.0;

    public FractalE(AdvancedRobot robot) {
        this.robot = robot;
    }

    public void run() {
        if (this.getRoundNum() == 0) {
            this.setColors(Color.black, new Color(255, 191, 0), new Color(255, 159, 0));
            BotMath.arenawidth = this.getBattleFieldWidth();
            BotMath.arenaheight = this.getBattleFieldHeight();
            Misc.getGL(this);
            renderer = gl ? HUD.getInstance() : null;
            memory = new Memory(this);
            mover = new Mover(this, memory);
            gunner = new Gunner(this, memory);
            events = new Events(this, memory);
            if (glhud) {
                hud = new HUD(this, memory);
            }
        }
        memory.init();
        gunner.init();
        events.init();
        mover.init();
        if (glhud) {
            hud.init();
        }
        this.robot.setAdjustGunForRobotTurn(true);
        this.robot.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        while (true) {
            memory.go();
            events.go();
            if (this.move) {
                mover.go();
            }
            if (this.gun) {
                gunner.go();
            }
            this.doBotchRadarFix();
            if (glhud) {
                hud.go();
            }
            this.robot.scan();
        }
    }

    public void println(int a) {
        this.println(Integer.toString(a));
    }

    public void println(double a) {
        this.println(Double.toString(a));
    }

    public void println(String a) {
        this.robot.out.println("[" + this.getTime() + "] " + a);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        events.handleEvents((Event)e);
        this.doBotchRadar(e);
    }

    public void doBotchRadarFix() {
        if (this.getTime() > this.radartick + 3L) {
            this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        }
    }

    public void doBotchRadar(ScannedRobotEvent e) {
        this.radartick = this.getTime();
        double bla = BotMath.normalRelativeAngle(e.getBearing() + this.getHeading() - this.getRadarHeading());
        if (this.getOthers() == 1) {
            this.setTurnRadarRight(bla + bla / Math.abs(bla) * 15.0);
        }
    }

    public void doBotchGun(ScannedRobotEvent e) {
        this.setTurnGunRight(BotMath.normalRelativeAngle(e.getBearing() + this.getHeading() - this.getGunHeading() + this.theta));
        if (this.getGunHeat() == 0.0) {
            double bla = 3.0;
            if (this.getEnergy() > bla + 3.0) {
                this.setFire(bla);
            }
            this.theta = Math.random() * 60.0 - 30.0;
        }
    }

    public void crash(String e) {
        throw new RuntimeException(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        events.handleEvents((Event)e);
    }

    public void onHitWall(HitWallEvent e) {
        events.handleEvents((Event)e);
    }

    public void onHitRobot(HitRobotEvent e) {
        events.handleEvents((Event)e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        events.handleEvents((Event)e);
    }

    public void onBulletHit(BulletHitEvent e) {
        events.handleEvents((Event)e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        events.handleEvents((Event)e);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        events.handleEvents((Event)e);
    }

    public void onWin(WinEvent e) {
        events.handleEvents((Event)e);
        this.robot.stop();
        double timeforquarteroscillation = 30.0;
        double time = this.getTime();
        while (true) {
            this.setTurnRadarRight(BotMath.normalRelativeAngle(this.getGunHeading() - this.getRadarHeading() + 60.0 * Math.sin(((double)this.getTime() - time) * Math.PI / 2.0 / timeforquarteroscillation)));
            this.robot.execute();
        }
    }

    public void onDeath(DeathEvent e) {
        events.handleEvents((Event)e);
    }

    public double getBattleFieldWidth() {
        return this.robot.getBattleFieldWidth();
    }

    public double getBattleFieldHeight() {
        return this.robot.getBattleFieldHeight();
    }

    public double getHeading() {
        return this.robot.getHeading();
    }

    public double getVelocity() {
        return this.robot.getVelocity();
    }

    public double getEnergy() {
        return this.robot.getEnergy();
    }

    public double getDistanceRemaining() {
        return this.robot.getDistanceRemaining();
    }

    public double getTurnRemaining() {
        return this.robot.getTurnRemaining();
    }

    public double getGunTurnRemaining() {
        return this.robot.getGunTurnRemaining();
    }

    public double getRadarTurnRemaining() {
        return this.robot.getRadarTurnRemaining();
    }

    public double getX() {
        return this.robot.getX();
    }

    public double getY() {
        return this.robot.getY();
    }

    public double getGunCoolingRate() {
        return this.robot.getGunCoolingRate();
    }

    public double getGunHeading() {
        return this.robot.getGunHeading();
    }

    public double getGunHeat() {
        return this.robot.getGunHeat();
    }

    public double getRadarHeading() {
        return this.robot.getRadarHeading();
    }

    public File getDataFile(String filename) throws IOException {
        return this.robot.getDataFile(filename);
    }

    public String getName() {
        return this.robot.getName();
    }

    public int getNumRounds() {
        return this.robot.getNumRounds();
    }

    public int getRoundNum() {
        return this.robot.getRoundNum();
    }

    public int getOthers() {
        return this.robot.getOthers();
    }

    public long getTime() {
        return this.robot.getTime();
    }

    public void setColors(Color a, Color b, Color c) {
        this.robot.setColors(a, b, c);
    }

    public void setAhead(double distance) {
        this.robot.setAhead(distance);
    }

    public void setTurnRight(double angle) {
        this.robot.setTurnRight(angle);
    }

    public void setTurnGunRight(double angle) {
        this.robot.setTurnGunRight(angle);
    }

    public void setTurnRadarRight(double angle) {
        this.robot.setTurnRadarRight(angle);
    }

    public void setTurnRadarLeft(double angle) {
        this.robot.setTurnRadarLeft(angle);
    }

    public void setFire(double power) {
        this.robot.setFire(power);
    }
}

