/*
 * Decompiled with CFR 0.152.
 */
package jekl.navigation.movement;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import jekl.Jekyl;
import jekl.intelligence.Enemy;
import jekl.navigation.movement.AbstractMovement;
import jekl.navigation.movement.Movement;
import robocode.util.Utils;

public class OrbitMovement
extends AbstractMovement
implements Movement {
    private static final double STAND_OFF_DISTANCE = 600.0;
    private static final double WALL_AVOIDANCE_FACTOR = 50.0;
    private static final double MOVEMENT_DISTANCE = 40.0;
    private static final double CLOSE_DISTANCE = -1.0;
    private static final double OPEN_DISTANCE = 1.0;
    private static final int CLOCKWISE = 1;
    private static final int ANTI_CLOCKWISE = -1;
    public static final int GUESS_FACTORS = 31;
    private ArrayList waves;
    private static int[][] hits = new int[11][31];
    private static String[] directions = new String[]{"NOT_POS", "LEFT", "BOTTOM", "BOTTOM_LEFT", "RIGHT", "NOT_POS", "BOTTOM_RIGHT", "NOT_POS", "TOP", "TOP_LEFT", "NOT_POS", "NOT_POS", "TOP_RIGHT", "UNK_13"};
    Jekyl ar;
    Rectangle2D.Double field;
    private int direction = 1;
    private double eLastEnergy = 100.0;
    private double eDelta = 0.0;
    private long nextTime = 0L;
    private double lastVelocity = 0.0;
    private Point2D.Double lastEnemyLocation;
    private Point2D.Double lastJekylLocation;

    public OrbitMovement(Jekyl _ar) {
        super(_ar);
        this.ar = _ar;
        this.field = new Rectangle2D.Double(18.0, 18.0, this.ar.getBattleFieldWidth() - 36.0, this.ar.getBattleFieldHeight() - 36.0);
        this.waves = new ArrayList();
    }

    public void doMovement() {
        if (this.lastEnemyLocation == null) {
            this.lastEnemyLocation = this.ar.getTarget().getCurrentLoc();
        }
        if (this.lastJekylLocation == null) {
            this.lastJekylLocation = this.ar.getCurrentLoc();
        }
        Enemy target = this.ar.getTarget();
        this.eDelta = this.eLastEnergy - target.getEnergy();
        this.doStats();
        double curVelocity = Math.abs(this.ar.getVelocity());
        double accelDiff = Math.round(Math.abs(curVelocity) - Math.abs(this.lastVelocity));
        this.lastVelocity = curVelocity;
        if (this.eDelta >= 0.1 && this.eDelta <= 3.0) {
            this.addWave(this.eDelta);
            if (this.ar.getTime() > this.nextTime) {
                this.ar.setMaxVelocity(1.0 + Math.random() * 15.0);
                double d = Math.random();
                double d2 = this.getWorstIndex() > 20 || this.getWorstIndex() < 10 ? 0.4 : 0.6;
                if (d > d2) {
                    this.direction *= -1;
                }
                this.nextTime = this.ar.getTime() + (long)(target.getDistance() / (20.0 - 3.0 * this.eDelta) * 0.6);
            }
        }
        if (this.out(this.ar.getX(), this.ar.getY(), this.ar.getHeadingRadians(), 40.0 * (double)this.direction)) {
            this.direction *= -1;
            this.nextTime = this.ar.getTime() + (long)(target.getDistance() / (20.0 - 3.0 * this.eDelta) * 0.5);
            this.ar.setMaxVelocity(1.0 + Math.random() * 15.0);
        }
        this.lastEnemyLocation = this.ar.getTarget().getCurrentLoc();
        this.lastJekylLocation = this.ar.getCurrentLoc();
        this.eLastEnergy = target.getEnergy();
        this.ar.setAhead(40.0 * (double)this.direction);
        this.ar.setTurnRightRadians(Utils.normalRelativeAngle((double)this.getTurnAngle(target)));
    }

    private boolean nearWall(double x, double y, double dist) {
        return dist > Math.min(Math.min(x - 18.0, this.ar.getBattleFieldWidth() - 36.0 - x), Math.min(y - 18.0, this.ar.getBattleFieldHeight() - 36.0 - y));
    }

    private double getTurnAngle(Enemy target) {
        double retVal = target.getBearing() + 1.5707963267948966 + 0.2618 * (double)this.direction * (target.getDistance() > 600.0 || this.distanceFromCorner() < 200.0 || this.nearWall(this.ar.getX(), this.ar.getY(), 50.0) ? -1.0 : 1.0);
        double heading = this.ar.getHeadingRadians();
        boolean smoothing = false;
        return retVal;
    }

    private int getDirection() {
        double bearingToCenter = Math.atan2(this.ar.getX() - this.ar.getBattleFieldWidth() / 2.0, this.ar.getY() - this.ar.getBattleFieldHeight() / 2.0);
        double latVel = this.ar.getVelocity() * Math.sin(this.ar.getHeadingRadians() - bearingToCenter);
        return latVel > 0.0 ? 1 : -1;
    }

    private int getWorstIndex() {
        int[] buffer = hits[Math.min(10, (int)(this.ar.getTarget().getDistance() / 100.0))];
        int worstIndex = 0;
        int i = 0;
        while (i < buffer.length) {
            if (buffer[i] > buffer[worstIndex]) {
                worstIndex = i;
            }
            ++i;
        }
        return worstIndex;
    }

    private boolean out(double x, double y, double angle, double c) {
        return !this.field.contains(Math.sin(angle) * c + x, Math.cos(angle) * c + y);
    }

    private double distanceFromCorner() {
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        do {
            min = Math.min(min, Point2D.distance(this.ar.getX(), this.ar.getY(), (double)(i & true) * this.ar.getBattleFieldWidth(), (double)(i >> 1) * this.ar.getBattleFieldHeight()));
        } while (++i < 4);
        return min;
    }

    private void addWave(double shotPower) {
        double lastBearing = this.absoluteBearing(this.lastEnemyLocation, this.lastJekylLocation);
        double currentBearing = this.absoluteBearing(this.lastEnemyLocation, this.ar.getCurrentLoc());
        double diffAngle = lastBearing - currentBearing;
        Wave w = new Wave();
        w.shotOrigin = this.ar.getTarget().getCurrentLoc();
        w.initialTargetLocation = this.ar.getCurrentLoc();
        w.shotPower = shotPower;
        w.shotVelocity = 20.0 - 3.0 * w.shotPower;
        w.startingAbsTargetBearing = this.absoluteBearing(w.shotOrigin, w.initialTargetLocation);
        w.maxAnglePossible = Math.asin(8.0 / (20.0 - 3.0 * shotPower));
        w.eventTime = this.ar.getTime() - 1L;
        w.wDirection = (int)(Math.abs(diffAngle) / diffAngle);
        w.distIndex = (int)Math.min(10.0, this.ar.getTarget().getDistance() / 100.0);
        this.waves.add(w);
    }

    public void notifyOfHit() {
    }

    public void doStats() {
        Iterator it = ((AbstractList)this.waves).iterator();
        long timeNow = this.ar.getTime();
        double dist = 10000.0;
        while (it.hasNext()) {
            Wave w = (Wave)it.next();
            if (!w.hasReached(timeNow)) continue;
            int[] nArray = hits[w.distIndex];
            int n = w.getGuessIndex();
            nArray[n] = nArray[n] + 1;
            it.remove();
        }
    }

    public double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public class Wave {
        public Point2D.Double shotOrigin;
        public Point2D.Double initialTargetLocation;
        public double shotPower;
        public double shotVelocity;
        public double startingAbsTargetBearing;
        public double maxAnglePossible;
        public long eventTime;
        public int wDirection;
        public int distIndex;

        public boolean hasReached(long timeNow) {
            long flightTime = timeNow - this.eventTime;
            return (double)flightTime * this.shotVelocity >= this.shotOrigin.distance(OrbitMovement.this.ar.getCurrentLoc());
        }

        public int getGuessIndex() {
            double currentAbsBearingFromShotOrigin = OrbitMovement.this.absoluteBearing(this.shotOrigin, OrbitMovement.this.ar.getCurrentLoc());
            int retVal = Math.max(0, Math.min(30, (int)Math.round(Utils.normalRelativeAngle((double)(currentAbsBearingFromShotOrigin - this.startingAbsTargetBearing)) * (double)OrbitMovement.this.direction / this.maxAnglePossible * 15.0 + 15.0)));
            return retVal;
        }

        public double getDistanceTraveled(long timeNow) {
            long flighTime = timeNow - this.eventTime;
            return this.shotVelocity * (double)flighTime;
        }

        public double getDistanceToTarget(long timeNow) {
            long flightTime = timeNow - this.eventTime;
            return (double)flightTime * this.shotVelocity - Math.abs(this.shotOrigin.distance(OrbitMovement.this.ar.getCurrentLoc()));
        }
    }
}

