/*
 * Decompiled with CFR 0.152.
 */
package florent;

import florent.Wave;

public class WaveCommand {
    protected double[] bin;

    public WaveCommand() {
    }

    public WaveCommand(double[] bin) {
        this.bin = bin;
    }

    public double[] getBin() {
        return this.bin;
    }

    public void doOnArrival(Wave wave) {
    }

    public void doOnHit(Wave wave) {
    }

    public void doOnHitBullet(Wave wave) {
    }

    public void doWhileNotArrived(Wave wave) {
    }

    public void doOnPassed(Wave wave) {
    }

    public int getBestIndex(double distance) {
        if (this.bin == null) {
            return -1;
        }
        return this.getBestGF(this.bin, distance);
    }

    public int getBestGF(double[] gfs, double distance) {
        int bestGF = (this.bin.length - 1) / 2;
        int GF_ONE = this.bin.length - 1;
        double bestVal = 0.0;
        int halfWidth = (int)Math.floor(Math.atan(18.0 / distance) * (double)GF_ONE);
        int gf = GF_ONE;
        while (gf > 0) {
            double tmp = 0.0;
            int i = Math.max(1, gf - halfWidth);
            while (i <= Math.min(gf + halfWidth, GF_ONE)) {
                if ((tmp += gfs[i]) > bestVal) {
                    bestGF = gf;
                    bestVal = tmp;
                }
                ++i;
            }
            --gf;
        }
        return bestGF;
    }
}

