/*
 * Decompiled with CFR 0.152.
 */
package krillr.mega.utils;

import krillr.mega.utils.KrillrRobot;
import krillr.mega.utils.Message;
import krillr.mega.utils.Point2d;
import krillr.mega.utils.Predictor;
import krillr.mega.utils.Vector2d;
import robocode.ScannedRobotEvent;

public class UnitInfo {
    public double energy;
    public double oldenergy;
    public Point2d location;
    public Vector2d vector;
    public Vector2d relativeVector;

    public UnitInfo(ScannedRobotEvent e, KrillrRobot bot) {
        if (this.oldenergy == 0.0) {
            this.oldenergy = this.energy = e.getEnergy();
        } else {
            this.oldenergy = this.energy;
            this.energy = e.getEnergy();
        }
        this.location = new Point2d(bot.getX() + e.getDistance() * Math.sin(e.getBearingRadians() + bot.getHeadingRadians()), bot.getY() + e.getDistance() * Math.cos(e.getBearingRadians() + bot.getHeadingRadians()));
        this.vector = new Vector2d(e.getVelocity(), e.getHeadingRadians());
        this.relativeVector = new Vector2d(e.getVelocity(), bot.getHeadingRadians() - this.bearing(bot.location()));
    }

    public UnitInfo(Message m, KrillrRobot bot) {
        if (this.oldenergy == 0.0) {
            this.oldenergy = this.energy = ((Double)m.data.get("energy")).doubleValue();
        } else {
            this.oldenergy = this.energy;
            this.energy = (Double)m.data.get("energy");
        }
        double velocity = (Double)m.data.get("velocity");
        double heading = (Double)m.data.get("heading");
        double x = (Double)m.data.get("x");
        double y = (Double)m.data.get("y");
        this.location = new Point2d(x, y);
        this.vector = new Vector2d(velocity, heading);
        this.relativeVector = new Vector2d(velocity, bot.getHeadingRadians() - this.bearing(bot.location()));
    }

    public UnitInfo(KrillrRobot bot) {
        if (this.oldenergy == 0.0) {
            this.oldenergy = this.energy = bot.getEnergy();
        } else {
            this.oldenergy = this.energy;
            this.energy = bot.getEnergy();
        }
        this.location = bot.location();
        this.vector = bot.vector();
        this.relativeVector = bot.currentTarget != null ? new Vector2d(bot.getVelocity(), bot.currentTarget.info().heading() - this.bearing(bot.currentTarget.info().location)) : new Vector2d(0.0, 0.0);
    }

    public UnitInfo(Predictor p) {
        UnitInfo oldInfo = p.parentUnit.info();
        if (oldInfo == null) {
            return;
        }
        this.vector = new Vector2d(oldInfo.velocity(), p.predictBearing());
        this.location = p.parentUnit.info().location.applyVector(this.vector);
        this.vector = new Vector2d(oldInfo.velocity(), oldInfo.heading());
        this.relativeVector = new Vector2d(oldInfo.velocity(), p.bot.getHeadingRadians() - this.bearing(p.bot.location()));
    }

    public double distance(double x, double y) {
        return this.distance(new Point2d(x, y));
    }

    public double distance(Point2d p) {
        return this.location.distance(p);
    }

    public double bearing(double x, double y) {
        return this.bearing(new Point2d(x, y));
    }

    public double bearing(Point2d p) {
        return p.bearing(this.location);
    }

    public double velocity() {
        return this.vector.magnitude();
    }

    public double heading() {
        return this.vector.angle();
    }
}

