/*
 * Decompiled with CFR 0.152.
 */
package nosteel.Modules.Targeting;

import java.awt.Graphics2D;
import nosteel.Basics.Draw;
import nosteel.Basics.Vector;
import nosteel.Modules.Aiming;
import nosteel.Modules.Data.FiredBullet;
import nosteel.Modules.Data.ScanData;
import nosteel.Modules.DataList;
import nosteel.Modules.Targeting.Aim;

public class LinearTargeting
extends Aim {
    private ScanData scan;
    private double timeDiff;
    private Vector hisMovementInThisLoop;
    private Vector hisPositionInThisLoop;
    private Vector hisDirectionInThisLoop;
    private double alpha;
    private double betta;
    private double gamma;
    private double timeToTarget;
    private Vector hisExpectedMovement;
    private Vector hisExpectedFinalPos;
    private Vector bullDist;
    private Vector enemyDist;

    public LinearTargeting(DataList scans_) {
        super(scans_);
    }

    public boolean isClockwise() {
        double expected = this.scan.vDirToHim.add(this.scan.vHisMovement).getDirection();
        double diff = this.scan.vDirToHim.getDirection() - expected;
        boolean clockwise = diff < 0.0;
        return clockwise;
    }

    public void calcCurrentTargetPosition(double time) {
        this.timeDiff = time - (double)this.scan.time;
        this.hisMovementInThisLoop = this.scan.vHisMovement.multiply(this.timeDiff);
        this.hisPositionInThisLoop = this.scan.vHisPos.add(this.hisMovementInThisLoop);
    }

    public void calcAlpha() {
        this.hisDirectionInThisLoop = this.hisPositionInThisLoop.substract(this.getMyCurPos());
        this.alpha = Math.PI - this.hisDirectionInThisLoop.getAngelBetween(this.scan.vHisMovement);
    }

    public void calcTimeToTarget() {
        double tP2 = this.scan.velocity * this.hisDirectionInThisLoop.getLength() * Math.cos(this.alpha);
        double tP3 = Math.pow(this.scan.velocity, 2.0) - Math.pow(this.getBulletVelocity(), 2.0);
        double tP = -tP2 / tP3;
        double tQ2 = Math.pow(this.hisDirectionInThisLoop.getLength(), 2.0);
        double tQ4 = Math.pow(this.scan.velocity, 2.0) - Math.pow(this.getBulletVelocity(), 2.0);
        double tQ = tQ2 / tQ4;
        double y1 = -tP + Math.sqrt(Math.pow(tP, 2.0) - tQ);
        double y2 = -tP - Math.sqrt(Math.pow(tP, 2.0) - tQ);
        this.timeToTarget = y1;
    }

    public void calcBetta() {
        if (Double.isNaN(this.timeToTarget)) {
            this.hisExpectedMovement = new Vector();
            this.hisExpectedFinalPos = this.hisPositionInThisLoop;
        } else {
            this.hisExpectedMovement = this.scan.vHisMovement.multiply(this.timeToTarget);
            this.hisExpectedFinalPos = this.hisPositionInThisLoop.add(this.hisExpectedMovement);
        }
        this.bullDist = this.hisExpectedFinalPos.substract(this.getMyCurPos());
        this.enemyDist = this.hisExpectedFinalPos.substract(this.hisPositionInThisLoop);
        this.betta = Math.asin(this.enemyDist.getLength() / this.bullDist.getLength() * Math.sin(this.alpha));
        this.gamma = Math.asin(this.hisDirectionInThisLoop.getLength() / this.bullDist.getLength() * Math.sin(this.alpha));
    }

    public void checkBattlefielBorders() {
        boolean recalc = false;
        if (this.hisExpectedFinalPos.x < 18.0) {
            this.hisExpectedFinalPos.x = 18.0;
            recalc = true;
        } else if (this.hisExpectedFinalPos.x > this.battleSize.x - 18.0) {
            this.hisExpectedFinalPos.x = this.battleSize.x - 18.0;
            recalc = true;
        }
        if (this.hisExpectedFinalPos.y < 18.0) {
            this.hisExpectedFinalPos.y = 18.0;
            recalc = true;
        } else if (this.hisExpectedFinalPos.y > this.battleSize.y - 18.0) {
            this.hisExpectedFinalPos.y = this.battleSize.y - 18.0;
            recalc = true;
        }
        if (recalc) {
            this.bullDist = this.hisExpectedFinalPos.substract(this.getMyCurPos());
            this.enemyDist = this.hisExpectedFinalPos.substract(this.hisPositionInThisLoop);
            this.betta = Math.asin(this.enemyDist.getLength() / this.bullDist.getLength() * Math.sin(this.alpha));
            this.gamma = Math.asin(this.hisDirectionInThisLoop.getLength() / this.bullDist.getLength() * Math.sin(this.alpha));
            this.hisExpectedMovement = this.hisExpectedFinalPos.substract(this.hisPositionInThisLoop);
        }
    }

    public void checkClockwise() {
        this.firedData = new FiredBullet();
        this.firedData.targetDirection = this.hisDirectionInThisLoop.getDirection();
        this.firedData.aimingAlgo = Aiming.INDEX_LinearTargeting;
        this.firedData.expectedPos = this.hisExpectedFinalPos;
        this.firedData.targetName = this.getTargetName();
        if (this.scan.vHisMovement.getLength() != 0.0) {
            this.firedData.targetDirection = this.isClockwise() ? (this.firedData.targetDirection += this.betta) : (this.firedData.targetDirection -= this.betta);
        }
    }

    @Override
    public void drawTargeting(Graphics2D g) {
        if (this.scan == null) {
            return;
        }
        Draw.drawPoint(g, this.scan.vMyPos, 6);
        Draw.drawPoint(g, this.scan.vHisPos, 6);
        Draw.drawVectorAtPosition(g, this.getMyCurPos(), this.hisDirectionInThisLoop);
        Draw.drawVectorAtPosition(g, this.getMyCurPos(), this.bullDist);
        Draw.drawVectorAtPosition(g, this.hisPositionInThisLoop, this.enemyDist);
    }

    @Override
    public void printAimingData(long time) {
        System.out.println(String.format("EXPECT time: %d timeDiff %.1f Hit: %.1f", time, this.timeDiff, (double)time + this.timeToTarget));
        this.getMyCurPos().print("- myCurPos");
        this.scan.vHisPos.print("- HisPos");
        System.out.println(String.format("- this.getBulletVelocity(): %.1f", this.getBulletVelocity()));
        this.scan.vHisMovement.print("- scan.vHisMovement");
        System.out.println(String.format("- scan.heading: %.1f", this.scan.heading * 360.0 / 2.0 / Math.PI));
        System.out.println(String.format("- scan.velocity: %.1f", this.scan.velocity));
        this.hisMovementInThisLoop.print("- hisMovementInThisLoop");
        this.hisPositionInThisLoop.print("- hisPositionInThisLoop");
        this.hisDirectionInThisLoop.print("- hisDirectionInThisLoop");
        System.out.println(String.format("- alpha: %.1f", this.alpha * 360.0 / 2.0 / Math.PI));
        System.out.println(String.format("- timeToTarget: %.1f", this.timeToTarget));
        this.hisExpectedFinalPos.print("- hisExpectedFinalPos");
        System.out.println(String.format("- bullDist.getLength(): %.1f", this.bullDist.getLength()));
        System.out.println(String.format("- enemyDist.getLength(): %.1f", this.enemyDist.getLength()));
        System.out.println(String.format("- hisDirectionInThisLoop.getLength(): %.1f", this.hisDirectionInThisLoop.getLength()));
        System.out.println(String.format("- hisDirectionInThisLoop.getDirection(): %.1f", this.hisDirectionInThisLoop.getDirection() * 360.0 / 2.0 / Math.PI));
        System.out.println(String.format("- scan.vHisMovement.getDirection(): %.1f", this.scan.vHisMovement.getDirection() * 360.0 / 2.0 / Math.PI));
        System.out.println(String.format("- betta: %.1f", this.betta * 360.0 / 2.0 / Math.PI));
        System.out.println(String.format("- gamma: %.1f", this.gamma * 360.0 / 2.0 / Math.PI));
        System.out.println(String.format("- all: %.1f", this.gamma * 360.0 / 2.0 / Math.PI + this.betta * 360.0 / 2.0 / Math.PI + this.alpha * 360.0 / 2.0 / Math.PI));
    }

    @Override
    public boolean processAiming(Vector myCurPos, double firePower, long time) {
        this.firedData = null;
        if (this.getTargetName() == null) {
            return false;
        }
        this.scan = this.scans.getEnemyData(this.getTargetName()).getLastScan();
        if (this.scan == null) {
            return false;
        }
        this.setMyCurPos(myCurPos);
        this.setFirepower(firePower);
        this.calcCurrentTargetPosition(time);
        this.calcAlpha();
        this.calcTimeToTarget();
        this.calcBetta();
        this.checkBattlefielBorders();
        this.checkClockwise();
        return true;
    }
}

