/*
 * Decompiled with CFR 0.152.
 */
package ahr.ice.Math;

import ahr.ice.AHRBot;
import ahr.ice.Math.Enemy;
import ahr.ice.Math.math;
import ahr.ice.RobotState;
import ahr.ice.VirtualBullet;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import robocode.annotation.SafeStatic;

public class PointEvaluator {
    @SafeStatic
    public static AHRBot r;

    public double pointEval(RobotState me, Vector vB, String name, Point2D.Double ran, Hashtable targets, Point2D.Double averagePosition) {
        double totalEnemyDistance = 0.0;
        double bulletDanger = 0.0;
        if (r.getBattleField().contains(ran)) {
            Enemy e;
            Enumeration n = targets.elements();
            Line2D.Double mTr = new Line2D.Double(me, ran);
            totalEnemyDistance -= me.distance(AHRBot.middle);
            totalEnemyDistance += Math.pow(me.distance(AHRBot.middle), 2.0);
            while (n.hasMoreElements() && targets.contains(e = (Enemy)n.nextElement())) {
                if (!e.live) continue;
                Point2D.Double p = e.coords;
                double enemyDistance = mTr.ptLineDist(p);
                if (e.danger > 0.0) {
                    enemyDistance -= e.danger;
                }
                totalEnemyDistance += enemyDistance / e.energy;
                Rectangle2D.Double enBox = new Rectangle2D.Double(p.x - 50.0, p.y - 50.0, 100.0, 100.0);
                if (mTr.intersects(enBox) && !enBox.contains(me)) {
                    totalEnemyDistance -= 1000.0;
                }
                if (!enBox.contains(ran) || enBox.contains(me)) continue;
                totalEnemyDistance -= 1000.0;
            }
            for (VirtualBullet virtualBullet : vB) {
                if (virtualBullet.shooter.equals("me")) continue;
                Line2D.Double virtualBulletLine = new Line2D.Double(virtualBullet.x, virtualBullet.y, virtualBullet.getX() + Math.sin(virtualBullet.heading) * 50.0, virtualBullet.getY() + Math.cos(virtualBullet.heading) * 50.0);
                double meLineDistance = virtualBulletLine.ptLineDist(me);
                double hTs = math.calculateBearingToXYRadians(me.x, me.y, me.heading, ran.x, ran.y);
                Point2D.Double iB = new Point2D.Double(me.getX() + Math.sin(hTs) * meLineDistance, me.getY() + Math.cos(hTs) * meLineDistance);
                Point2D.Double vBatI = new Point2D.Double(virtualBullet.getX() + Math.sin(virtualBullet.heading) * virtualBullet.velocity * meLineDistance / 8.0, virtualBullet.getY() + Math.cos(virtualBullet.heading) * virtualBullet.velocity * meLineDistance / 8.0);
                if (vBatI.distance(iB) < 50.0) {
                    if (virtualBullet.gunUsed.getName().equals("Head on")) {
                        bulletDanger -= Math.pow(totalEnemyDistance, 3.0);
                    }
                    bulletDanger -= 2000.0;
                }
                bulletDanger += virtualBulletLine.ptLineDist(me);
                if (mTr.intersectsLine(virtualBulletLine)) {
                    bulletDanger -= 100.0;
                }
                bulletDanger += me.distance(virtualBullet);
            }
            bulletDanger += averagePosition.distance(ran) * (double)r.getOthers() / 2.0;
        } else {
            totalEnemyDistance -= Math.pow(100.0, 100.0);
        }
        return totalEnemyDistance += Math.pow(bulletDanger, 1 / r.getOthers());
    }

    public PointEvaluator(AHRBot r) {
        PointEvaluator.r = r;
    }

    public Point2D.Double averagePosition(Point2D.Double me, Point2D.Double aP) {
        if (aP.x == 0.0 && aP.y == 0.0) {
            aP.x = me.getX();
            aP.y = me.getY();
        } else {
            aP.x = (aP.x + me.getX()) / 2.0;
            aP.y = (aP.y + me.getY()) / 2.0;
        }
        return aP;
    }
}

