/*
 * Decompiled with CFR 0.152.
 */
package eem.frame.bot;

import eem.config.fighterBotConfig;
import eem.frame.bot.InfoBot;
import eem.frame.bot.botStatPoint;
import eem.frame.event.botListener;
import eem.frame.event.waveListener;
import eem.frame.gameInfo.gameInfo;
import eem.frame.gun.baseGun;
import eem.frame.gun.firingSolution;
import eem.frame.gun.gunManager;
import eem.frame.gun.unknownGun;
import eem.frame.misc.graphics;
import eem.frame.misc.logger;
import eem.frame.misc.physics;
import eem.frame.motion.basicMotion;
import eem.frame.radar.baseRadar;
import eem.frame.wave.wave;
import eem.frame.wave.waveWithBullets;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.LinkedList;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class fighterBot
extends fighterBotConfig
implements waveListener,
botListener {
    protected InfoBot fBot;
    protected gameInfo _gameinfo;
    protected long latestWaveHitTime = 0L;
    protected double scheduledEdrop = 0.0;
    protected int firedCount = 0;
    protected int hitCount = 0;
    public LinkedList<waveWithBullets> enemyWaves = new LinkedList();
    public LinkedList<waveWithBullets> myWaves = new LinkedList();
    public HashMap<String, fighterBot> enemyBots = new HashMap();
    public HashMap<String, fighterBot> allKnownEnemyBots = new HashMap();

    public fighterBot(InfoBot infoBot, gameInfo gameInfo2) {
        this.fBot = infoBot;
        this._gameinfo = gameInfo2;
        this._gameinfo._wavesManager.addWaveListener(this);
        this._gameinfo._botsmanager.addBotListener(this);
        this.setDrivers(this, this._gameinfo, this.isItMasterBotDriver());
    }

    public boolean isItMasterBotDriver() {
        return this.getName().equals(this._gameinfo.getMasterBot().getName());
    }

    public InfoBot getInfoBot() {
        return this.fBot;
    }

    public String getName() {
        return this.fBot.getName();
    }

    public long getTime() {
        return this._gameinfo.getTime();
    }

    public double getEnergy() {
        return this.fBot.getEnergy();
    }

    public double getDanger(long l, Point2D.Double double_) {
        double d = 1.0;
        double d2 = 100.0;
        double d3 = 0.0;
        double d4 = 0.0;
        d = 1.0 * this.getEnergy() / 100.0;
        d4 = double_.distance(this.getPositionClosestToTime(l));
        return d3 += d * Math.exp(-d4 / d2);
    }

    public Point2D.Double getPosition() {
        return this.fBot.getPosition();
    }

    public Point2D.Double getPositionClosestToTime(long l) {
        return this.fBot.getPositionClosestToTime(l);
    }

    public botStatPoint getStatClosestToTime(long l) {
        return this.fBot.getStatClosestToTime(l);
    }

    public double getHeadingDegrees() {
        return this.fBot.getHeadingDegrees();
    }

    public int getNumEnemyAlive() {
        return this._gameinfo.getNumEnemyAlive();
    }

    public long getLastSeenTime() {
        return this.fBot.getLast().getTime();
    }

    public gameInfo getGameInfo() {
        return this._gameinfo;
    }

    public LinkedList<fighterBot> getEnemyBots() {
        return new LinkedList<fighterBot>(this.enemyBots.values());
    }

    public LinkedList<fighterBot> getAllKnownEnemyBots() {
        return new LinkedList<fighterBot>(this.allKnownEnemyBots.values());
    }

    public LinkedList<waveWithBullets> getEnemyWaves() {
        return this.enemyWaves;
    }

    public LinkedList<waveWithBullets> getMyWaves() {
        return this.myWaves;
    }

    public void initTic() {
        this._gunManager.initTic();
        this.processScheduledEnergyDrop();
        this._motion.initTic();
    }

    protected void processScheduledEnergyDrop() {
        double d;
        double d2 = this.scheduledEdrop;
        if (!this.isItMasterBotDriver() && d2 >= 0.1 - (d = 0.02)) {
            d2 = Math.min(d2, 3.0);
            wave wave2 = new wave(this.getInfoBot(), this.getTime() - 1L, d2);
            this._gameinfo._wavesManager.add(wave2);
        }
        this.scheduledEdrop = 0.0;
    }

    public void manage() {
        this._radar.manage();
        this._motion.manage();
        this._gunManager.manage();
    }

    public basicMotion getMotion() {
        return this._motion;
    }

    public gunManager getGunManager() {
        return this._gunManager;
    }

    public baseRadar getRadar() {
        return this._radar;
    }

    public LinkedList<firingSolution> getFiringSolutions(InfoBot infoBot, long l, double d) {
        double d2;
        LinkedList<firingSolution> linkedList = new LinkedList<firingSolution>();
        LinkedList<baseGun> linkedList2 = this._gunManager.getGunList();
        if (!infoBot.getName().equals(this.getGunManager().getClosestTarget().getName()) && this.getGameInfo().getNumEnemyAlive() >= 4) {
            return linkedList;
        }
        Object var8_6 = null;
        linkedList = this._gunManager.getFiringSolutions(this._gameinfo.getFighterBot(infoBot.getName()), l, d);
        double d3 = -1000000.0;
        for (firingSolution firingSolution2 : linkedList) {
            d2 = Math.abs(firingSolution2.getQualityOfSolution());
            if (!(d2 > d3)) continue;
            d3 = d2;
        }
        for (firingSolution firingSolution2 : linkedList) {
            d2 = firingSolution2.getQualityOfSolution() / d3;
            firingSolution2.setQualityOfSolution(d2);
        }
        return linkedList;
    }

    public boolean isItMyWave(wave wave2) {
        return this.fBot.getName().equals(wave2.firedBot.getName());
    }

    @Override
    public void waveAdded(wave wave2) {
        if (!this.isItMyWave(wave2)) {
            String string = wave2.firedBot.getName();
            fighterBot fighterBot2 = this.enemyBots.get(string);
            logger.noise("bot " + this.fBot.getName() + " added enemy wave from " + string);
            this._gunManager.incrFiredByEnemy(string);
            if (fighterBot2.isItMasterBotDriver()) {
                return;
            }
            waveWithBullets waveWithBullets2 = new waveWithBullets(wave2);
            LinkedList<firingSolution> linkedList = fighterBot2.getFiringSolutions(this.fBot, wave2.getFiredTime(), wave2.getBulletEnergy());
            for (firingSolution firingSolution2 : linkedList) {
                waveWithBullets2.addFiringSolution(firingSolution2);
                fighterBot2.getGunManager().incrFiredAtEnemyByGun(firingSolution2);
            }
            fighterBot2.getGunManager().incrFiredAtEnemyByGun(new unknownGun(), this.fBot);
            if (linkedList.size() == 0) {
                return;
            }
            this.enemyWaves.add(waveWithBullets2);
            long l = (long)((double)wave2.getFiredTime() + wave2.getTimeToReach(this.fBot.getPosition()));
            long l2 = 5L;
            long l3 = (l += l2) - this.getTime();
            if (l3 > 0L) {
                if (l > this.latestWaveHitTime) {
                    this.latestWaveHitTime = l;
                }
                this._motion.needToRecalculate = true;
                this._motion.predictionEndTime = l;
            }
        } else {
            ++this.firedCount;
            this._gunManager.incrFiredCount();
        }
    }

    public void reportStats() {
        logger.routine("--- bot " + this.getName() + " stats:");
        if (this.isItMasterBotDriver()) {
            this._motion.reportStats();
        }
        this._gunManager.reportStats();
    }

    @Override
    public void waveRemoved(wave wave2) {
        if (!this.isItMyWave(wave2)) {
            for (waveWithBullets waveWithBullets2 : this.enemyWaves) {
                if (!waveWithBullets2.equals(wave2)) continue;
                this.enemyWaves.remove(waveWithBullets2);
                logger.noise(this.fBot.getName() + ": Enemy( " + waveWithBullets2.getFiredBot().getName() + ")  wave is removed");
                break;
            }
        } else {
            for (waveWithBullets waveWithBullets3 : this.myWaves) {
                if (!waveWithBullets3.equals(wave2)) continue;
                this.myWaves.remove(waveWithBullets3);
                logger.noise(this.fBot.getName() + ": my wave is removed");
                break;
            }
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this._radar.onScannedRobot(scannedRobotEvent);
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        this._radar.onRobotDeath(robotDeathEvent);
    }

    @Override
    public void onScannedRobot(InfoBot infoBot) {
        if (!this.getName().equals(infoBot.getName())) {
            logger.noise("Fighter bot " + this.getName() + " scanned " + infoBot.getName());
            this.enemyBots.put(infoBot.getName(), gameInfo.liveBots.get(infoBot.getName()));
            this.allKnownEnemyBots.put(infoBot.getName(), gameInfo.liveBots.get(infoBot.getName()));
        } else {
            double d = infoBot.energyDrop();
            this.scheduledEdrop += d;
        }
    }

    @Override
    public void onRobotDeath(InfoBot infoBot) {
        this.enemyBots.remove(infoBot.getName());
    }

    public void removeEnemyWaveWithBullet(fighterBot fighterBot2, Bullet bullet) {
        Point2D.Double double_ = new Point2D.Double(bullet.getX(), bullet.getY());
        for (waveWithBullets waveWithBullets2 : this.enemyWaves) {
            if (!waveWithBullets2.getFiredBot().getName().equals(bullet.getName())) continue;
            double d = waveWithBullets2.getTimeToReach(double_);
            long l = this.getTime() - waveWithBullets2.getFiredTime();
            if (!(Math.abs((double)l - d) <= 1.01)) continue;
            this.enemyWaves.remove(waveWithBullets2);
            break;
        }
    }

    public void onBulletHitBullet(fighterBot fighterBot2, BulletHitBulletEvent bulletHitBulletEvent) {
        this._gunManager.onBulletHitBullet(fighterBot2);
        Bullet bullet = null;
        bullet = this.isItMasterBotDriver() ? bulletHitBulletEvent.getHitBullet() : bulletHitBulletEvent.getBullet();
        this.removeEnemyWaveWithBullet(fighterBot2, bullet);
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        this._gunManager.onHitByBullet(hitByBulletEvent);
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        if (this.getName().equals(bulletHitEvent.getName())) {
            double d = bulletHitEvent.getBullet().getPower();
            this.scheduledEdrop -= physics.bulletDamageByEnergy(d);
        }
        this._gunManager.onBulletHit(bulletHitEvent);
    }

    public void onWavePassingOverBot(wave wave2, InfoBot infoBot) {
        if (wave2.getFiredBot().getName().equals(this.getName())) {
            this._gunManager.onMyWavePassingOverBot(wave2, infoBot);
        }
        if (infoBot.getName().equals(this.getName())) {
            this._gunManager.onWavePassingOverMe(wave2);
        }
        if (infoBot.getName().equals(this.getName()) || !wave2.getFiredBot().getName().equals(this.getName())) {
            // empty if block
        }
    }

    public void drawThisBot(Graphics2D graphics2D, long l) {
        double d = 40.0;
        Point2D.Double double_ = this.fBot.getPositionClosestToTime(l);
        if (double_ != null) {
            graphics2D.setColor(new Color(0, 0, 255, 128));
            graphics.drawSquare(graphics2D, double_, d);
        }
    }

    public void drawEnemyBot(Graphics2D graphics2D, long l, fighterBot fighterBot2) {
        double d = 40.0;
        Point2D.Double double_ = fighterBot2.fBot.getPositionClosestToTime(l);
        if (double_ != null) {
            graphics2D.setColor(new Color(255, 0, 0, 128));
            graphics.drawSquare(graphics2D, double_, d);
        }
    }

    public void onPaint(Graphics2D graphics2D, long l) {
        if (this.isItMasterBotDriver()) {
            this.drawThisBot(graphics2D, l);
            for (waveWithBullets object : this.enemyWaves) {
                object.onPaint(graphics2D, l);
            }
            for (waveWithBullets waveWithBullets2 : this.myWaves) {
                waveWithBullets2.onPaint(graphics2D, l);
            }
            for (fighterBot fighterBot2 : this.getEnemyBots()) {
                this.drawEnemyBot(graphics2D, l, fighterBot2);
            }
            this._motion.onPaint(graphics2D);
            this._gunManager.onPaint(graphics2D);
        }
    }
}

