/*
 * Decompiled with CFR 0.152.
 */
package eem.frame.gun;

import eem.frame.gun.baseGun;
import eem.frame.misc.graphics;
import eem.frame.misc.logger;
import eem.frame.misc.math;
import eem.frame.misc.physics;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class firingSolution {
    public double firingAngle;
    public long firedTime;
    public double bulletEnergy;
    public String firingBotName = "";
    public String targetBotName = "";
    public Point2D.Double firingPosition;
    public Point2D.Double targetPosition;
    public String gunName = "";
    public boolean activeFlag = true;
    public Color color = new Color(0, 0, 0, 255);
    public double qualityOfSolution = 0.0;

    public firingSolution() {
        this.firingAngle = Double.NaN;
        this.firingPosition = null;
        this.targetPosition = null;
    }

    public firingSolution(Point2D.Double double_, double d, long l, double d2) {
        this.firingAngle = d;
        this.firingPosition = (Point2D.Double)double_.clone();
        this.firedTime = l;
        this.targetPosition = null;
        this.bulletEnergy = d2;
    }

    public firingSolution(Point2D.Double double_, Point2D.Double double_2, long l, double d) {
        this.firingAngle = math.angle2pt(double_, double_2);
        this.firingPosition = (Point2D.Double)double_.clone();
        this.firedTime = l;
        this.targetPosition = (Point2D.Double)double_2.clone();
        this.bulletEnergy = d;
    }

    public firingSolution(baseGun baseGun2, Point2D.Double double_, Point2D.Double double_2, long l, double d) {
        this(double_, double_2, l, d);
        this.setGunName(baseGun2.getName());
        this.setColor(baseGun2.getColor());
    }

    public firingSolution(baseGun baseGun2, Point2D.Double double_, double d, long l, double d2) {
        this(double_, d, l, d2);
        this.setGunName(baseGun2.getName());
        this.setColor(baseGun2.getColor());
    }

    public void offsetFiringAngle(double d) {
        this.firingAngle += d;
    }

    public void setFiringBotName(String string) {
        this.firingBotName = string;
    }

    public String getFiringBotName() {
        return this.firingBotName;
    }

    public void setTargetBotName(String string) {
        this.targetBotName = string;
    }

    public String getTargetBotName() {
        return this.targetBotName;
    }

    public boolean isActive() {
        return this.activeFlag;
    }

    public void setActiveFlag(boolean bl) {
        this.activeFlag = bl;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setGunName(String string) {
        this.gunName = string;
    }

    public String getGunName() {
        return this.gunName;
    }

    public double smallestDistanceToBulletPath(Point2D.Double double_) {
        double d = math.game_angles2cortesian(this.firingAngle);
        double d2 = Math.cos(Math.toRadians(d));
        double d3 = Math.sin(Math.toRadians(d));
        double d4 = double_.x - this.firingPosition.x;
        double d5 = double_.y - this.firingPosition.y;
        double d6 = Math.abs(d2 * d5 - d3 * d4);
        return d6;
    }

    public double getDanger(long l, Point2D.Double double_) {
        double d = 0.0;
        double d2 = physics.robotHalfSize;
        double d3 = 1.0 * this.qualityOfSolution;
        double d4 = this.getLocationAt(l).distance(double_);
        if (d4 <= Math.sqrt(2.0) * (double)physics.robotHalfSize) {
            d += d3;
        }
        return d += d3 * Math.exp(-d4 / d2);
    }

    public double getDistanceTraveledAtTime(long l) {
        double d = l - this.firedTime;
        double d2 = d * physics.bulletSpeed(this.bulletEnergy);
        return d2;
    }

    public void setQualityOfSolution(double d) {
        this.qualityOfSolution = d;
    }

    public double getQualityOfSolution() {
        return this.qualityOfSolution;
    }

    public Point2D.Double getLocationAt(long l) {
        double d = this.getDistanceTraveledAtTime(l);
        double d2 = math.game_angles2cortesian(this.firingAngle);
        double d3 = d * Math.cos(Math.toRadians(d2));
        double d4 = d * Math.sin(Math.toRadians(d2));
        Point2D.Double double_ = new Point2D.Double(this.firingPosition.x + d3, this.firingPosition.y + d4);
        return double_;
    }

    public boolean didItHitBotAtPos(Point2D.Double double_, long l) {
        Point2D.Double double_2 = this.getLocationAt(l);
        return double_.distance(double_2) <= physics.robotHalfDiagonal;
    }

    public String toString() {
        String string = "";
        string = string + "Firing solultion at time: " + this.firedTime + "\n";
        string = string + "qualityOfSolution " + this.qualityOfSolution + "\n";
        string = string + "firingPosition " + this.firingPosition + ":\n";
        string = string + "firingAngle " + this.firingAngle + ":\n";
        if (this.targetPosition != null) {
            string = string + "targerPosition " + this.targetPosition + ":\n";
        }
        return string;
    }

    public void drawFiringPositon(Graphics2D graphics2D, long l) {
        if (this.firingPosition == null) {
            logger.error("This should not happen: the firing solution does not have firingPosition");
        } else {
            graphics2D.setColor(this.color);
            graphics.drawRect(graphics2D, this.firingPosition, 20.0, 20.0);
        }
    }

    public void drawTargetPositon(Graphics2D graphics2D, long l) {
        if (this.targetPosition != null) {
            graphics2D.setColor(this.color);
            graphics.drawRect(graphics2D, this.targetPosition, 20.0, 20.0);
        }
    }

    public void drawBulletPath(Graphics2D graphics2D, long l) {
        if (this.firingAngle == Double.NaN) {
            logger.error("This should not happen: the firing solution does not have firingAngle");
        } else {
            graphics2D.setColor(this.color);
            Point2D.Double double_ = this.getLocationAt(l);
            graphics.drawLine(graphics2D, this.firingPosition, double_);
        }
    }

    public void drawBulletLocation(Graphics2D graphics2D, long l) {
        if (this.firingAngle == Double.NaN) {
            logger.error("This should not happen: the firing solution does not have firingAngle");
        } else {
            graphics2D.setColor(this.color);
            Point2D.Double double_ = this.getLocationAt(l);
            double d = 4.0;
            graphics.drawCircle(graphics2D, double_, d);
        }
    }

    public void drawBulletDanger(Graphics2D graphics2D, long l) {
        if (this.firingAngle == Double.NaN) {
            logger.error("This should not happen: the firing solution does not have firingAngle");
        } else {
            double d;
            graphics2D.setColor(this.color);
            double d2 = math.game_angles2cortesian(this.firingAngle);
            double d3 = d = 5.0;
            double d4 = d3 * Math.cos(Math.toRadians(d2));
            double d5 = d3 * Math.sin(Math.toRadians(d2));
            Point2D.Double double_ = this.getLocationAt(l);
            double_.x += d4;
            double_.y += d5;
            d3 = 20.0 * this.qualityOfSolution;
            d4 = d3 * Math.cos(Math.toRadians(d2));
            d5 = d3 * Math.sin(Math.toRadians(d2));
            Point2D.Double double_2 = new Point2D.Double(double_.x + d4, double_.y + d5);
            graphics.drawLine(graphics2D, double_, double_2);
        }
    }

    public void onPaint(Graphics2D graphics2D, long l) {
        this.drawBulletLocation(graphics2D, l);
        this.drawBulletDanger(graphics2D, l);
    }

    public void onPaint(Graphics2D graphics2D) {
        logger.dbg("This should not happen: the firing solution does not have firingPosition");
        if (this.firingPosition == null) {
            logger.error("This should not happen: the firing solution does not have firingPosition");
        } else {
            graphics2D.setColor(this.color);
            graphics.drawRect(graphics2D, this.firingPosition, 20.0, 20.0);
        }
        if (this.targetPosition != null) {
            graphics2D.setColor(this.color);
            graphics.drawRect(graphics2D, this.targetPosition, 20.0, 20.0);
        }
        if (this.firingAngle == Double.NaN) {
            logger.error("This should not happen: the firing solution does not have firingAngle");
        } else {
            graphics2D.setColor(this.color);
            if (this.targetPosition != null) {
                graphics.drawLine(graphics2D, this.firingPosition, this.targetPosition);
            } else {
                double d = 30.0;
                double d2 = math.game_angles2cortesian(this.firingAngle);
                double d3 = Math.cos(Math.toRadians(d2));
                double d4 = Math.sin(Math.toDegrees(d2));
                Point2D.Double double_ = new Point2D.Double(this.firingPosition.x + d3, this.firingPosition.y + d4);
                graphics.drawLine(graphics2D, this.firingPosition, double_);
            }
        }
    }
}

