/*
 * Decompiled with CFR 0.152.
 */
package ds;

import ds.IEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class ListenerDelegate {
    private ArrayList<IEventListener> _listeners = new ArrayList();
    private static HashMap<Class<? extends IEventListener>, ListenerInvoker> _invokers = new HashMap();

    static {
        _invokers.put(IEventListener.Death.class, new ListenerInvoker<IEventListener.Death, DeathEvent>(){

            @Override
            protected Class<DeathEvent> eventClass() {
                return DeathEvent.class;
            }

            @Override
            protected void invokeListener(IEventListener.Death listener, DeathEvent event) {
                listener.OnDeath(event);
            }
        });
        _invokers.put(IEventListener.BattleEnded.class, new ListenerInvoker<IEventListener.BattleEnded, BattleEndedEvent>(){

            @Override
            protected Class<BattleEndedEvent> eventClass() {
                return BattleEndedEvent.class;
            }

            @Override
            protected void invokeListener(IEventListener.BattleEnded listener, BattleEndedEvent event) {
                listener.onBattleEnded(event);
            }
        });
        _invokers.put(IEventListener.Win.class, new ListenerInvoker<IEventListener.Win, WinEvent>(){

            @Override
            protected Class<WinEvent> eventClass() {
                return WinEvent.class;
            }

            @Override
            protected void invokeListener(IEventListener.Win listener, WinEvent event) {
                listener.OnWin(event);
            }
        });
        _invokers.put(IEventListener.SkippedTurn.class, new ListenerInvoker<IEventListener.SkippedTurn, SkippedTurnEvent>(){

            @Override
            protected Class<SkippedTurnEvent> eventClass() {
                return SkippedTurnEvent.class;
            }

            @Override
            protected void invokeListener(IEventListener.SkippedTurn listener, SkippedTurnEvent event) {
                listener.OnSkippedTurn(event);
            }
        });
        _invokers.put(IEventListener.ScannedRobot.class, new ListenerInvoker<IEventListener.ScannedRobot, ScannedRobotEvent>(){

            @Override
            protected Class<ScannedRobotEvent> eventClass() {
                return ScannedRobotEvent.class;
            }

            @Override
            protected void invokeListener(IEventListener.ScannedRobot listener, ScannedRobotEvent event) {
                listener.OnScannedRobot(event);
            }
        });
        _invokers.put(IEventListener.HitByBullet.class, new ListenerInvoker<IEventListener.HitByBullet, HitByBulletEvent>(){

            @Override
            protected Class<HitByBulletEvent> eventClass() {
                return HitByBulletEvent.class;
            }

            @Override
            protected void invokeListener(IEventListener.HitByBullet listener, HitByBulletEvent event) {
                listener.OnHitByBullet(event);
            }
        });
        _invokers.put(IEventListener.BulletHit.class, new ListenerInvoker<IEventListener.BulletHit, BulletHitEvent>(){

            @Override
            protected Class<BulletHitEvent> eventClass() {
                return BulletHitEvent.class;
            }

            @Override
            protected void invokeListener(IEventListener.BulletHit listener, BulletHitEvent event) {
                listener.OnBulletHit(event);
            }
        });
        _invokers.put(IEventListener.BulletHitBullet.class, new ListenerInvoker<IEventListener.BulletHitBullet, BulletHitBulletEvent>(){

            @Override
            protected Class<BulletHitBulletEvent> eventClass() {
                return BulletHitBulletEvent.class;
            }

            @Override
            protected void invokeListener(IEventListener.BulletHitBullet listener, BulletHitBulletEvent event) {
                listener.OnBulletHitBullet(event);
            }
        });
        _invokers.put(IEventListener.BulletMissed.class, new ListenerInvoker<IEventListener.BulletMissed, BulletMissedEvent>(){

            @Override
            protected Class<BulletMissedEvent> eventClass() {
                return BulletMissedEvent.class;
            }

            @Override
            protected void invokeListener(IEventListener.BulletMissed listener, BulletMissedEvent event) {
                listener.OnBulletMissed(event);
            }
        });
        _invokers.put(IEventListener.HitRobot.class, new ListenerInvoker<IEventListener.HitRobot, HitRobotEvent>(){

            @Override
            protected Class<HitRobotEvent> eventClass() {
                return HitRobotEvent.class;
            }

            @Override
            protected void invokeListener(IEventListener.HitRobot listener, HitRobotEvent event) {
                listener.OnHitRobot(event);
            }
        });
        _invokers.put(IEventListener.HitWall.class, new ListenerInvoker<IEventListener.HitWall, HitWallEvent>(){

            @Override
            protected Class<HitWallEvent> eventClass() {
                return HitWallEvent.class;
            }

            @Override
            protected void invokeListener(IEventListener.HitWall listener, HitWallEvent event) {
                listener.OnHitWall(event);
            }
        });
        _invokers.put(IEventListener.RobotDeath.class, new ListenerInvoker<IEventListener.RobotDeath, RobotDeathEvent>(){

            @Override
            protected Class<RobotDeathEvent> eventClass() {
                return RobotDeathEvent.class;
            }

            @Override
            protected void invokeListener(IEventListener.RobotDeath listener, RobotDeathEvent event) {
                listener.OnRobotDeath(event);
            }
        });
    }

    public void register(IEventListener listener) {
        this._listeners.add(listener);
    }

    public void processEvents(Vector<Event> events) {
        for (IEventListener listener : this._listeners) {
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = listener.getClass().getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                if (IEventListener.class.isAssignableFrom(iface)) {
                    ListenerInvoker invoker = _invokers.get(iface);
                    Class eventClass = invoker.eventClass();
                    for (Event event : events) {
                        if (!eventClass.isAssignableFrom(event.getClass())) continue;
                        invoker.invokeListener(listener, event);
                    }
                }
                ++n2;
            }
        }
    }

    private static abstract class ListenerInvoker<K extends IEventListener, V extends Event> {
        private ListenerInvoker() {
        }

        protected abstract Class<V> eventClass();

        protected abstract void invokeListener(K var1, V var2);
    }
}

