/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import java.util.List;
import java.util.Random;
import morbid.FieldAwareObject;
import morbid.IMotionManager;
import morbid.IMotionStrategy;
import morbid.IRobotController;
import morbid.Utils;
import robocode.Event;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;

class MotionManager
extends FieldAwareObject
implements IMotionManager {
    private final Random m_random = new Random();
    private final double[] m_destination = new double[2];
    private long m_destinationTime;
    private int m_destinationState = 2;
    private int m_noiseVPeriod;
    private int m_noiseHPeriod;
    private double m_noiseVThreshold;
    private double m_noiseHLevel;
    private long m_noisePeriodPoint;
    private double m_headingNoise;
    private static final int NOT_REACHED = 0;
    private static final int STOPPED = 1;
    private static final int REACHED = 2;
    private static final boolean TURN_BEFORE_MOVE = false;
    private static final boolean DEBUG = false;

    public void update() {
        long time = this.m_robot.getTime();
        List eventQueue = this.m_controller.getEventQueue();
        int e = 0;
        int queueLength = eventQueue.size();
        while (e < queueLength) {
            Event _event = (Event)eventQueue.get(e);
            if (_event instanceof HitRobotEvent || _event instanceof HitWallEvent) {
                if (this.m_robot.getVelocity() != 0.0) break;
                this.m_destinationState = 1;
                break;
            }
            ++e;
        }
    }

    public void act() {
        IMotionStrategy motionStrategy = this.m_controller.getMotionStrategy();
        long time = this.m_robot.getTime();
        this.goTo(motionStrategy.getGoToX(), motionStrategy.getGoToY());
        switch (this.m_destinationState) {
            default: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                double advance_distance = Utils.relativeDistance(this.m_robot.getX(), this.m_robot.getY(), this.m_destination[0], this.m_destination[1]);
                if (advance_distance < 1.0) {
                    this.m_destinationState = 2;
                    break;
                }
                double absVelocity = Math.abs(this.m_robot.getVelocity());
                double relative_heading = Utils.relativeHeading(this.m_robot.getX(), this.m_robot.getY(), this.m_destination[0], this.m_destination[1]);
                double robot_heading = this.m_robot.getHeadingRadians();
                if (this.m_noiseHPeriod > 0 && time % (long)this.m_noiseHPeriod == 0L && this.m_noiseHLevel > 0.0) {
                    this.m_headingNoise = (0.2 + 0.8 * this.m_random.nextDouble()) * Math.min(this.m_noiseHLevel, (double)this.m_noiseHPeriod * Utils.velocityToMaxTurnRate(absVelocity));
                    if (this.m_random.nextBoolean()) {
                        this.m_headingNoise = -this.m_headingNoise;
                    }
                }
                double headingdelta1A = Utils.deltaPhi(relative_heading, robot_heading);
                double headingdelta1B = Utils.deltaPhi(relative_heading, Utils.reversePhi(robot_heading));
                boolean needToTurn = false;
                if (Math.abs(headingdelta1A) < Math.abs(headingdelta1B)) {
                    if (Math.abs(headingdelta1A) > 1.0E-8) {
                        needToTurn = true;
                        this.setTurnRobot(headingdelta1A + this.m_headingNoise);
                    }
                    if (this.m_noiseVPeriod <= 0 || time != this.m_noisePeriodPoint || absVelocity < this.m_noiseVThreshold) {
                        this.setMoveRobot(advance_distance);
                    } else {
                        this.setMoveRobot(2.0);
                        this.m_noisePeriodPoint += (long)this.m_noiseVPeriod;
                    }
                } else {
                    if (Math.abs(headingdelta1B) > 1.0E-8) {
                        needToTurn = true;
                        this.setTurnRobot(headingdelta1B + this.m_headingNoise);
                    }
                    if (this.m_noiseVPeriod <= 0 || time != this.m_noisePeriodPoint || absVelocity < this.m_noiseVThreshold) {
                        this.setMoveRobot(-advance_distance);
                    } else {
                        this.setMoveRobot(-2.0);
                        this.m_noisePeriodPoint += (long)this.m_noiseVPeriod;
                    }
                }
                ++this.m_destinationTime;
            }
        }
    }

    public double distanceToDestination() {
        return Utils.relativeDistance(this.m_robot.getX(), this.m_robot.getY(), this.m_destination[0], this.m_destination[1]);
    }

    public long onRouteTime() {
        return this.m_destinationTime;
    }

    public boolean isStationary() {
        return this.m_destinationState == 2 || this.m_destinationState == 1;
    }

    public void setNoiseLevel(int vPeriod, double vThreshold, int hPeriod, double hLevel) {
        this.m_noiseVPeriod = vPeriod;
        this.m_noiseVThreshold = vThreshold;
        this.m_noiseHPeriod = hPeriod;
        this.m_noiseHLevel = hLevel;
        if (vPeriod <= 0) {
            this.setNextNoisePoint(0L);
        }
    }

    public void setNextNoisePoint(long time) {
        this.m_noisePeriodPoint = time;
    }

    MotionManager(IRobotController controller) {
        super(controller);
        this.m_destination[0] = this.m_robot.getX();
        this.m_destination[1] = this.m_robot.getY();
        this.m_noiseVPeriod = -1;
        this.m_noiseHPeriod = -1;
    }

    private void setMoveRobot(double distance) {
        if (distance > 0.0) {
            this.m_robot.setAhead(distance);
        } else if (distance < 0.0) {
            this.m_robot.setBack(-distance);
        }
    }

    private void setTurnRobot(double phi) {
        if (phi > 0.0) {
            this.m_robot.setTurnRightRadians(phi);
        } else if (phi < 0.0) {
            this.m_robot.setTurnLeftRadians(-phi);
        }
    }

    private void goTo(double x, double y) {
        this.m_destinationTime = 0L;
        this.m_destinationState = 0;
        this.m_destination[0] = x;
        this.m_destination[1] = y;
    }
}

