/*
 * Decompiled with CFR 0.152.
 */
package bing2;

import bing2.MathUtils;
import bing2.Position;
import robocode.AdvancedRobot;

public class Enemy {
    public String name;
    public long time;
    public double bearing;
    public double heading;
    public double distance;
    public double velocity;
    public double energy;
    public double deltaBearing;
    public double deltaHeading;
    public double deltaDistance;
    public double deltaVelocity;
    public double deltaEnergy;
    public double deltaTime;
    public Position deltaPos;
    public double xVelocity;
    public double yVelocity;
    public Position pos = null;

    public String toString() {
        return "Time [ " + this.time + " ]  Name: " + this.name + "\n-bearing: " + MathUtils.toDegrees(this.bearing) + "\n-heading: " + MathUtils.toDegrees(this.heading) + "\n-distance: " + this.distance + "\n-velocity: " + this.velocity + "\n-energy: " + this.energy;
    }

    public Enemy(long l, String string, double d, double d2, double d3, double d4, double d5, AdvancedRobot advancedRobot, Enemy enemy) {
        this.time = l;
        this.name = string;
        this.bearing = d;
        this.heading = d2;
        this.distance = d3;
        this.velocity = d4;
        this.energy = d5;
        this.pos = MathUtils.absolutePosition(new Position(advancedRobot.getX(), advancedRobot.getY()), this.bearing, this.distance);
        this.xVelocity = Math.sin(this.heading) * this.velocity;
        this.yVelocity = -Math.cos(this.heading) * this.velocity;
        if (enemy != null) {
            this.deltaTime = this.time - enemy.time;
            this.deltaBearing = this.bearing - enemy.bearing;
            this.deltaHeading = this.heading - enemy.heading;
            this.deltaVelocity = this.velocity - enemy.velocity;
            this.deltaEnergy = this.energy - enemy.energy;
            this.deltaDistance = this.distance - enemy.distance;
            this.deltaPos = MathUtils.relativePosition(this.pos, enemy.pos);
        }
    }

    public String getName() {
        return this.name;
    }

    public long getTime() {
        return this.time;
    }

    public double getBearing() {
        return this.bearing;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean disabled() {
        return this.energy <= 2.0;
    }

    public Position getPosition() {
        return this.pos;
    }

    public Position getRelativePosition() {
        return new Position(this.distance * Math.sin(this.bearing), this.distance * Math.cos(this.bearing));
    }

    public double getXVelocity() {
        return this.xVelocity;
    }

    public double getYVelocity() {
        return this.yVelocity;
    }

    public int getDirection() {
        return MathUtils.sign(this.velocity * Math.sin(this.heading - this.bearing));
    }

    public int getDirectionZ() {
        return MathUtils.signZ(this.velocity * Math.sin(this.heading - this.bearing));
    }
}

