/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.stat;

import dmonner.xlbp.Target;
import dmonner.xlbp.stat.AbstractStat;
import dmonner.xlbp.stat.FractionStat;
import dmonner.xlbp.stat.Stat;
import dmonner.xlbp.stat.TargetSetStat;
import dmonner.xlbp.stat.TargetStat;
import dmonner.xlbp.trial.Step;
import dmonner.xlbp.util.CSVWriter;
import java.io.IOException;
import java.util.Map;

public class StepStat
extends AbstractStat {
    private final Step step;
    private final TargetSetStat targets;
    private final FractionStat correct;

    public StepStat(Step step) {
        this.step = step;
        this.targets = new TargetSetStat();
        this.correct = new FractionStat("Step");
        this.analyze();
    }

    @Override
    public void add(Stat that) {
        throw new IllegalArgumentException("Can only get data directly from a Step.");
    }

    @Override
    public void addTo(String prefix, Map<String, Object> map) {
        this.targets.addTo(prefix, map);
        this.correct.addTo(prefix, map);
    }

    @Override
    public void analyze() {
        for (Target target : this.step.getTargets()) {
            TargetStat stat = new TargetStat(target.getLayer());
            stat.compare(target.getValue());
            stat.analyze();
            this.targets.add(stat);
        }
        this.targets.analyze();
        int possible = this.targets.size() > 0 ? 1 : 0;
        int actual = this.targets.getCorrect().getFraction() == 1.0f ? possible : 0;
        this.correct.add(actual, possible);
        this.correct.analyze();
    }

    @Override
    public void clear() {
        this.targets.clear();
        this.correct.clear();
    }

    public FractionStat getCorrect() {
        return this.correct;
    }

    public Step getStep() {
        return this.step;
    }

    public TargetSetStat getTargets() {
        return this.targets;
    }

    @Override
    public void saveData(CSVWriter out) throws IOException {
        this.correct.saveData(out);
        this.targets.saveData(out);
    }

    @Override
    public void saveHeader(String prefix, CSVWriter out) throws IOException {
        this.correct.saveHeader(prefix, out);
        this.targets.saveHeader(prefix, out);
    }

    @Override
    public String toString(String prefix) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.correct.toString(prefix));
        sb.append(this.targets.toString(prefix));
        return sb.toString();
    }
}

