/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.trial;

import dmonner.xlbp.stat.Optimizer;
import dmonner.xlbp.stat.SetStat;
import dmonner.xlbp.stat.TestStat;
import dmonner.xlbp.trial.TrainingBreaker;

public class ValidationBreaker
implements TrainingBreaker {
    private final int maxEpochsWithoutImprovement;
    private final Optimizer optimizer;
    private int epochsWithoutImprovement;
    private SetStat bestValid;

    public ValidationBreaker() {
        this(10);
    }

    public ValidationBreaker(int maxEpochsWithoutImprovement) {
        this(maxEpochsWithoutImprovement, Optimizer.defaultOptimizer);
    }

    public ValidationBreaker(int maxEpochsWithoutImprovement, Optimizer optimizer) {
        this.maxEpochsWithoutImprovement = maxEpochsWithoutImprovement;
        this.optimizer = optimizer;
    }

    @Override
    public boolean isBreakTime(TestStat stat) {
        SetStat newest = stat.getBestValid();
        if (this.optimizer.betterThan(newest, this.bestValid)) {
            this.bestValid = newest;
            this.epochsWithoutImprovement = 0;
        } else {
            ++this.epochsWithoutImprovement;
        }
        return this.epochsWithoutImprovement >= this.maxEpochsWithoutImprovement;
    }

    @Override
    public void reset() {
        this.bestValid = null;
        this.epochsWithoutImprovement = 0;
    }
}

