/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.mirror;

import java.awt.geom.Rectangle2D;
import robocode.ScannedRobotEvent;
import xander.core.Resources;
import xander.core.RobotEvents;
import xander.core.event.RoundBeginListener;
import xander.core.event.ScannedRobotListener;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.paint.Paintable;

public class MirrorDetector
implements RoundBeginListener,
ScannedRobotListener,
Paintable {
    private static final Log log = Logger.getLog(MirrorDetector.class);
    private static final double BOX_SIZE = 50.0;
    private boolean[][] mirrorHits;
    private Rectangle2D.Double mirrorBounds;
    private Rectangle2D.Double battlefieldBounds;
    private SnapshotHistory snapshotHistory = Resources.getSnapshotHistory();
    private int scanIndex;
    private double mirrorThreshold = 0.75;
    private int scannedTicks;
    private float maxHitPercent;
    private int maxHitPercentTicksAgo;
    private long lastMirrorDetectionTick;
    private long mirrorDetectionHits;

    public MirrorDetector(int scanDepth, int scannedTicks) {
        if (scannedTicks > this.snapshotHistory.getHistorySize()) {
            scannedTicks = this.snapshotHistory.getHistorySize();
            log.warn("Robot histories are not long enough for requested scan ticks; reducing scan ticks to " + scannedTicks);
        }
        this.scannedTicks = scannedTicks;
        this.mirrorHits = new boolean[scannedTicks][scanDepth];
        this.battlefieldBounds = Resources.getRobotProxy().getBattleFieldSize();
        this.mirrorBounds = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        RobotEvents robotEvents = Resources.getRobotEvents();
        robotEvents.addScannedRobotListener(this);
        robotEvents.addRoundBeginListener(this);
    }

    @Override
    public void onRoundBegin() {
        int i = 0;
        while (i < this.mirrorHits.length) {
            int j = 0;
            while (j < this.mirrorHits[i].length) {
                this.mirrorHits[i][j] = false;
                ++j;
            }
            ++i;
        }
        this.mirrorDetectionHits = 0L;
        this.lastMirrorDetectionTick = -1L;
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        Snapshot opp = this.snapshotHistory.getSnapshot(event.getName(), event.getTime(), false);
        if (opp != null) {
            int i = 0;
            while (i < this.scannedTicks) {
                Snapshot me = this.snapshotHistory.getMySnapshot(Math.max(0L, event.getTime() - (long)i), false);
                if (me != null) {
                    double x = this.battlefieldBounds.getMaxX() - me.getX() - 25.0;
                    double y = this.battlefieldBounds.getMaxY() - me.getY() - 25.0;
                    this.mirrorBounds.setRect(x, y, 50.0, 50.0);
                    this.mirrorHits[i][this.scanIndex] = this.mirrorBounds.contains(opp.getLocation());
                }
                ++i;
            }
        }
        ++this.scanIndex;
        if (this.scanIndex == this.mirrorHits[0].length) {
            this.scanIndex = 0;
        }
    }

    public boolean isMirrorDetected() {
        boolean mirrorDetected = false;
        this.maxHitPercent = 0.0f;
        int i = 0;
        while (i < this.scannedTicks) {
            int hitCount = 0;
            boolean[] blArray = this.mirrorHits[i];
            int n = blArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean mirrorHit = blArray[n2];
                if (mirrorHit) {
                    ++hitCount;
                }
                ++n2;
            }
            float hitPercent = (float)hitCount / (float)this.mirrorHits[0].length;
            if ((double)hitPercent > this.mirrorThreshold && hitPercent > this.maxHitPercent) {
                mirrorDetected = true;
                this.maxHitPercent = hitPercent;
                this.maxHitPercentTicksAgo = i;
            }
            ++i;
        }
        if (mirrorDetected) {
            ++this.mirrorDetectionHits;
            this.lastMirrorDetectionTick = Resources.getRobotProxy().getTime();
        }
        return mirrorDetected;
    }

    public long getLastMirrorDetectionTime() {
        return this.lastMirrorDetectionTick;
    }

    public int getMirrorDetectedTicksAgo() {
        return this.maxHitPercentTicksAgo;
    }

    public long getMirrorDetectionHitsThisRound() {
        return this.mirrorDetectionHits;
    }

    public double getMirrorDetectionPercentThisRound() {
        long time = Resources.getRobotProxy().getTime();
        if (time <= 0L) {
            return 0.0;
        }
        return (double)this.mirrorDetectionHits / (double)time;
    }

    @Override
    public String getPainterName() {
        return null;
    }
}

