/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.ram;

import xander.core.Resources;
import xander.core.math.LinearEquation;
import xander.core.track.DriveStats;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;

public class RamDetector {
    private double engageDistance;
    private double disengageDistance;
    private boolean engaged;
    private LinearEquation growthEq;
    private String ramEscapeDriveName;
    private SnapshotHistory snapshotHistory;
    private DriveStats driveStats;

    public RamDetector(String ramEscapeDriveName, double engageDistance, double disengageDistance) {
        this.ramEscapeDriveName = ramEscapeDriveName;
        this.snapshotHistory = Resources.getSnapshotHistory();
        this.engageDistance = engageDistance;
        this.disengageDistance = disengageDistance;
        this.growthEq = new LinearEquation(0.0, 1.0, 1.0, 3.0);
        this.driveStats = Resources.getDriveStats();
    }

    public void setUtilizationMultiplier(double multiplierAtFullUtilization) {
        this.growthEq = new LinearEquation(0.0, 1.0, 1.0, multiplierAtFullUtilization);
    }

    public boolean isOpponentRamming() {
        Snapshot opponentSnapshot = this.snapshotHistory.getLastOpponentScanned();
        if (opponentSnapshot == null) {
            this.engaged = false;
        } else {
            double driveUtilization = this.driveStats.getDriveUsagePercent(this.ramEscapeDriveName);
            double mult = this.growthEq.getY(driveUtilization);
            if (!this.engaged && opponentSnapshot.getDistance() <= this.engageDistance * mult) {
                this.engaged = true;
            } else if (this.engaged && opponentSnapshot.getDistance() >= this.disengageDistance * mult) {
                this.engaged = false;
            }
        }
        return this.engaged;
    }
}

